/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.JuifeUtils;
import org.jsampler.view.fantasia.DevicesPane;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.InstrumentsDbPane;
import org.jsampler.view.fantasia.basic.FantasiaPanel;
import org.jsampler.view.fantasia.basic.FantasiaSubPanel;
import org.jsampler.view.fantasia.basic.FantasiaTabbedPane;

public class RightSidePane
extends FantasiaPanel {
    private FantasiaTabbedPane tabbedPane = new FantasiaTabbedPane();
    private InstrumentsDbPane instrumentsDbPane = null;
    private final DevicesPane devicesPane = new DevicesPane();
    private final JScrollPane spDevicesPane = new JScrollPane();
    private final JPanel mainPane = new FantasiaSubPanel(false, true);
    private final EventHandler eventHandler = new EventHandler();

    public RightSidePane() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.tabbedPane.getMainPane().setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.spDevicesPane.setOpaque(false);
        this.spDevicesPane.getViewport().setOpaque(false);
        this.spDevicesPane.setViewportView(this.devicesPane);
        this.spDevicesPane.setBorder(BorderFactory.createEmptyBorder());
        int n = this.spDevicesPane.getMinimumSize().height;
        this.spDevicesPane.setMinimumSize(new Dimension(200, n));
        this.setTabbedView(FantasiaPrefs.preferences().getBoolProperty("rightSidePane.showInstrumentsDb"));
        FantasiaPrefs.preferences().addPropertyChangeListener("rightSidePane.showInstrumentsDb", this.getHandler());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 3));
    }

    public DevicesPane getDevicesPane() {
        return this.devicesPane;
    }

    private void setTabbedView(boolean bl) {
        this.remove(this.mainPane);
        this.remove(this.tabbedPane);
        this.tabbedPane.removeChangeListener(this.getHandler());
        this.tabbedPane.removeAll();
        if (bl) {
            if (this.instrumentsDbPane == null) {
                this.instrumentsDbPane = new InstrumentsDbPane();
            }
            FantasiaTabbedPane fantasiaTabbedPane = this.tabbedPane;
            fantasiaTabbedPane.addTab(FantasiaI18n.i18n.getLabel("RightSidePane.tabDevices"), this.spDevicesPane);
            fantasiaTabbedPane.addTab(FantasiaI18n.i18n.getLabel("RightSidePane.tabInstrumentsDb"), this.instrumentsDbPane);
            fantasiaTabbedPane.addChangeListener(this.getHandler());
            Dimension dimension = JuifeUtils.getUnionSize((Component)fantasiaTabbedPane.getTabButton(0), fantasiaTabbedPane.getTabButton(1));
            fantasiaTabbedPane.getTabButton(0).setPreferredSize(dimension);
            fantasiaTabbedPane.getTabButton(1).setPreferredSize(dimension);
            fantasiaTabbedPane.getTabButton(0).setMinimumSize(dimension);
            fantasiaTabbedPane.getTabButton(1).setMinimumSize(dimension);
            this.add(this.tabbedPane);
            int n = FantasiaPrefs.preferences().getIntProperty("rightSidePane.tabIndex", 0);
            if (this.tabbedPane.getTabCount() > n) {
                this.tabbedPane.setSelectedIndex(n);
            }
        } else {
            this.mainPane.add(this.spDevicesPane);
            this.add(this.mainPane);
        }
        this.validate();
    }

    protected void savePreferences() {
        if (this.instrumentsDbPane != null) {
            this.instrumentsDbPane.savePreferences();
        }
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    private class EventHandler
    implements ChangeListener,
    PropertyChangeListener {
        private EventHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = RightSidePane.this.tabbedPane.getSelectedIndex();
            if (n == -1) {
                return;
            }
            FantasiaPrefs.preferences().setIntProperty("rightSidePane.tabIndex", n);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            RightSidePane.this.setTabbedView(FantasiaPrefs.preferences().getBoolProperty("rightSidePane.showInstrumentsDb"));
        }
    }
}

