/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.persister;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.server.share.persister.PartitionInfoData;
import org.apache.kafka.server.share.persister.TopicData;

public class GroupTopicPartitionData<P extends PartitionInfoData> {
    private final String groupId;
    private final List<TopicData<P>> topicsData;

    public GroupTopicPartitionData(String groupId, List<TopicData<P>> topicsData) {
        this.groupId = groupId;
        this.topicsData = topicsData;
    }

    public String groupId() {
        return this.groupId;
    }

    public List<TopicData<P>> topicsData() {
        return this.topicsData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupTopicPartitionData that = (GroupTopicPartitionData)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.topicsData, that.topicsData);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.topicsData);
    }

    public String toString() {
        return "GroupTopicPartitionData(groupId=" + this.groupId + ", topicsData=" + String.valueOf(this.topicsData) + ")";
    }

    public static class Builder<P extends PartitionInfoData> {
        private String groupId;
        private List<TopicData<P>> topicsData;

        public Builder<P> setGroupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Builder<P> setTopicsData(List<TopicData<P>> topicsData) {
            this.topicsData = topicsData;
            return this;
        }

        public Builder<P> setGroupTopicPartition(GroupTopicPartitionData<P> groupTopicPartitionData) {
            this.groupId = groupTopicPartitionData.groupId();
            this.topicsData = groupTopicPartitionData.topicsData();
            return this;
        }

        public GroupTopicPartitionData<P> build() {
            return new GroupTopicPartitionData<P>(this.groupId, this.topicsData);
        }
    }
}

