/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.udf.udaf;

import com.tdunning.math.stats.MergingDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.type.SqlTypeName;
import org.opensearch.sql.calcite.udf.UserDefinedAggFunction;

public class PercentileApproxFunction
implements UserDefinedAggFunction<PencentileApproAccumulator> {
    SqlTypeName returnType;
    private double compression;
    double percentile;

    @Override
    public PencentileApproAccumulator init() {
        this.returnType = SqlTypeName.DOUBLE;
        this.compression = 100.0;
        this.percentile = 1.0;
        return new PencentileApproAccumulator();
    }

    @Override
    public PencentileApproAccumulator add(PencentileApproAccumulator acc, Object ... values) {
        Object targetValue = values[0];
        if (Objects.isNull(targetValue)) {
            return acc;
        }
        this.percentile = (double)((Number)values[1]).intValue() / 100.0;
        this.returnType = (SqlTypeName)values[values.length - 1];
        if (values.length > 3) {
            this.compression = ((Number)values[values.length - 2]).doubleValue();
        }
        acc.evaluate(((Number)targetValue).doubleValue());
        return acc;
    }

    @Override
    public Object result(PencentileApproAccumulator acc) {
        if (acc.size() == 0) {
            return null;
        }
        double retValue = (Double)acc.value(this.compression, this.percentile);
        switch (this.returnType) {
            case INTEGER: {
                int intRet = (int)retValue;
                return intRet;
            }
            case BIGINT: {
                long longRet = (long)retValue;
                return longRet;
            }
            case FLOAT: {
                float floatRet = (float)retValue;
                return Float.valueOf(floatRet);
            }
        }
        return retValue;
    }

    public static class PencentileApproAccumulator
    implements UserDefinedAggFunction.Accumulator {
        private List<Number> candidate = new ArrayList<Number>();

        public int size() {
            return this.candidate.size();
        }

        public void evaluate(double value) {
            this.candidate.add(value);
        }

        @Override
        public Object value(Object ... argList) {
            double percent = (Double)argList[1];
            double compression = (Double)argList[0];
            MergingDigest tree = new MergingDigest(compression);
            for (Number num : this.candidate) {
                tree.add(num.doubleValue());
            }
            return tree.quantile(percent);
        }
    }
}

