function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _inherits(t, e) { if ("function" != typeof e && null !== e) throw new TypeError("Super expression must either be null or a function"); t.prototype = Object.create(e && e.prototype, { constructor: { value: t, writable: !0, configurable: !0 } }), Object.defineProperty(t, "prototype", { writable: !1 }), e && _setPrototypeOf(t, e); }
function _setPrototypeOf(t, e) { return _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function (t, e) { return t.__proto__ = e, t; }, _setPrototypeOf(t, e); }
function _createSuper(t) { var r = _isNativeReflectConstruct(); return function () { var e, o = _getPrototypeOf(t); if (r) { var s = _getPrototypeOf(this).constructor; e = Reflect.construct(o, arguments, s); } else e = o.apply(this, arguments); return _possibleConstructorReturn(this, e); }; }
function _possibleConstructorReturn(t, e) { if (e && ("object" == _typeof(e) || "function" == typeof e)) return e; if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined"); return _assertThisInitialized(t); }
function _assertThisInitialized(e) { if (void 0 === e) throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); return e; }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
function _getPrototypeOf(t) { return _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function (t) { return t.__proto__ || Object.getPrototypeOf(t); }, _getPrototypeOf(t); }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { Component } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keysOf } from '../common';
import { OuiIcon } from '../icon';
import { OuiLoadingSpinner } from '../loading';
import { OuiResizeObserver } from '../observer/resize_observer';
import { OuiI18n } from '../i18n';
import { htmlIdGenerator } from '../../services';
var paddingSizeToClassNameMap = {
  none: '',
  xs: 'ouiAccordion__padding--xs',
  s: 'ouiAccordion__padding--s',
  m: 'ouiAccordion__padding--m',
  l: 'ouiAccordion__padding--l',
  xl: 'ouiAccordion__padding--xl'
};
export var PADDING_SIZES = keysOf(paddingSizeToClassNameMap);
export var OuiAccordion = /*#__PURE__*/function (_Component) {
  _inherits(OuiAccordion, _Component);
  var _super = _createSuper(OuiAccordion);
  function OuiAccordion() {
    var _this;
    _classCallCheck(this, OuiAccordion);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "childContent", null);
    _defineProperty(_assertThisInitialized(_this), "childWrapper", null);
    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: _this.props.forceState ? _this.props.forceState === 'open' : _this.props.initialIsOpen
    });
    _defineProperty(_assertThisInitialized(_this), "setChildContentHeight", function () {
      var forceState = _this.props.forceState;
      requestAnimationFrame(function () {
        var height = _this.childContent && (forceState ? forceState === 'open' : _this.state.isOpen) ? _this.childContent.clientHeight : 0;
        _this.childWrapper && _this.childWrapper.setAttribute('style', "height: ".concat(height, "px"));
      });
    });
    _defineProperty(_assertThisInitialized(_this), "onToggle", function () {
      var forceState = _this.props.forceState;
      if (forceState) {
        _this.props.onToggle && _this.props.onToggle(forceState === 'open' ? false : true);
      } else {
        _this.setState(function (prevState) {
          return {
            isOpen: !prevState.isOpen
          };
        }, function () {
          if (_this.state.isOpen && _this.childWrapper) {
            _this.childWrapper.focus();
          }
          _this.props.onToggle && _this.props.onToggle(_this.state.isOpen);
        });
      }
    });
    _defineProperty(_assertThisInitialized(_this), "setChildContentRef", function (node) {
      _this.childContent = node;
    });
    return _this;
  }
  _createClass(OuiAccordion, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setChildContentHeight();
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.setChildContentHeight();
    }
  }, {
    key: "render",
    value: function render() {
      var _buttonProps$id,
        _this2 = this;
      var _this$props = this.props,
        children = _this$props.children,
        buttonContent = _this$props.buttonContent,
        className = _this$props.className,
        id = _this$props.id,
        buttonClassName = _this$props.buttonClassName,
        buttonContentClassName = _this$props.buttonContentClassName,
        extraAction = _this$props.extraAction,
        paddingSize = _this$props.paddingSize,
        initialIsOpen = _this$props.initialIsOpen,
        arrowDisplay = _this$props.arrowDisplay,
        forceState = _this$props.forceState,
        isLoading = _this$props.isLoading,
        isLoadingMessage = _this$props.isLoadingMessage,
        buttonProps = _this$props.buttonProps,
        rest = _objectWithoutProperties(_this$props, ["children", "buttonContent", "className", "id", "buttonClassName", "buttonContentClassName", "extraAction", "paddingSize", "initialIsOpen", "arrowDisplay", "forceState", "isLoading", "isLoadingMessage", "buttonProps"]);
      var isOpen = forceState ? forceState === 'open' : this.state.isOpen;
      var classes = classNames('ouiAccordion', {
        'ouiAccordion-isOpen': isOpen
      }, className);
      var paddingClass = paddingSize ? classNames(paddingSizeToClassNameMap[paddingSize]) : undefined;
      var childrenClasses = classNames(paddingClass, {
        'ouiAccordion__children-isLoading': isLoading
      });
      var buttonClasses = classNames('ouiAccordion__button', {
        ouiAccordion__buttonReverse: !extraAction && arrowDisplay === 'right'
      }, buttonClassName, buttonProps === null || buttonProps === void 0 ? void 0 : buttonProps.className);
      var iconClasses = classNames('ouiAccordion__icon', {
        'ouiAccordion__icon-isOpen': isOpen
      });
      var iconWrapperClasses = classNames('ouiAccordion__iconWrapper', {
        ouiAccordion__iconButton: extraAction && arrowDisplay === 'right'
      });
      var baseIcon;
      if (arrowDisplay !== 'none') {
        baseIcon = /*#__PURE__*/React.createElement(OuiIcon, {
          className: iconClasses,
          type: "arrowRight",
          size: "m"
        });
      }
      var icon;
      var iconButton;
      var buttonId = (_buttonProps$id = buttonProps === null || buttonProps === void 0 ? void 0 : buttonProps.id) !== null && _buttonProps$id !== void 0 ? _buttonProps$id : htmlIdGenerator()();
      if (extraAction && arrowDisplay === 'right') {
        iconButton = /*#__PURE__*/React.createElement("button", {
          "aria-controls": id,
          "aria-expanded": isOpen,
          "aria-labelledby": buttonId,
          tabIndex: -1,
          className: iconWrapperClasses,
          onClick: this.onToggle
        }, baseIcon);
      } else if (arrowDisplay !== 'none') {
        icon = /*#__PURE__*/React.createElement("span", {
          className: iconWrapperClasses
        }, baseIcon);
      }
      var optionalAction = null;
      if (extraAction && !isLoading) {
        optionalAction = /*#__PURE__*/React.createElement("div", {
          className: "ouiAccordion__optionalAction"
        }, extraAction);
      } else if (isLoading) {
        optionalAction = /*#__PURE__*/React.createElement("div", {
          className: "ouiAccordion__optionalAction"
        }, /*#__PURE__*/React.createElement(OuiLoadingSpinner, null));
      }
      var childrenContent;
      if (isLoading && isLoadingMessage) {
        childrenContent = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(OuiLoadingSpinner, {
          className: "ouiAccordion__spinner"
        }), /*#__PURE__*/React.createElement("span", null, isLoadingMessage && isLoadingMessage !== true ? isLoadingMessage : /*#__PURE__*/React.createElement(OuiI18n, {
          token: "ouiAccordion.isLoading",
          default: "Loading"
        })));
      } else {
        childrenContent = children;
      }
      return /*#__PURE__*/React.createElement("div", _extends({
        className: classes
      }, rest), /*#__PURE__*/React.createElement("div", {
        className: "ouiAccordion__triggerWrapper"
      }, /*#__PURE__*/React.createElement("button", _extends({}, buttonProps, {
        id: buttonId,
        "aria-controls": id,
        "aria-expanded": isOpen,
        onClick: this.onToggle,
        className: buttonClasses,
        type: "button"
      }), icon, /*#__PURE__*/React.createElement("span", {
        className: classNames('ouiIEFlexWrapFix', buttonContentClassName)
      }, buttonContent)), optionalAction, iconButton), /*#__PURE__*/React.createElement("div", {
        className: "ouiAccordion__childWrapper",
        ref: function ref(node) {
          _this2.childWrapper = node;
        },
        tabIndex: -1,
        role: "region",
        "aria-labelledby": buttonId,
        id: id
      }, /*#__PURE__*/React.createElement(OuiResizeObserver, {
        onResize: this.setChildContentHeight
      }, function (resizeRef) {
        return /*#__PURE__*/React.createElement("div", {
          ref: function ref(_ref) {
            _this2.setChildContentRef(_ref);
            resizeRef(_ref);
          }
        }, /*#__PURE__*/React.createElement("div", {
          className: childrenClasses
        }, childrenContent));
      })));
    }
  }]);
  return OuiAccordion;
}(Component);

/* OUI -> EUI Aliases: Build-Time */
_defineProperty(OuiAccordion, "defaultProps", {
  initialIsOpen: false,
  paddingSize: 'none',
  arrowDisplay: 'left',
  isLoading: false,
  isLoadingMessage: false
});
OuiAccordion.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  id: PropTypes.string.isRequired,
  /**
       * Class that will apply to the trigger for the accordion.
       */
  buttonClassName: PropTypes.string,
  /**
       * Apply more props to the triggering button
       */
  buttonProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }),
  /**
       * Class that will apply to the trigger content for the accordion.
       */
  buttonContentClassName: PropTypes.string,
  /**
       * The content of the clickable trigger
       */
  buttonContent: PropTypes.node,
  /**
       * Will appear right aligned against the button. Useful for separate actions like deletions.
       */
  extraAction: PropTypes.node,
  /**
       * The accordion will start in the open state.
       */
  initialIsOpen: PropTypes.bool.isRequired,
  /**
       * Optional callback method called on open and close with a single `isOpen` parameter
       */
  onToggle: PropTypes.func,
  /**
       * The padding around the exposed accordion content.
       */
  paddingSize: PropTypes.oneOf(["none", "xs", "s", "m", "l", "xl"]),
  /**
       * Placement of the arrow indicator, or 'none' to hide it.
       */
  arrowDisplay: PropTypes.oneOf(["left", "right", "none"]),
  /**
       * Control the opening of accordion via prop
       */
  forceState: PropTypes.oneOf(["closed", "open"]),
  /**
       * Change `extraAction` and children into a loading spinner
       */
  isLoading: PropTypes.bool,
  /**
       * Choose whether the loading message replaces the content. Customize the message by passing a node
       */
  isLoadingMessage: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.node.isRequired])
};
/* OUI -> EUI Aliases: Build-Time */export { EuiAccordion } from '../../eui_components/accordion/accordion';