/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.knn;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.knn.GraphMergeStats;
import org.opensearch.client.opensearch.knn.GraphRefreshStats;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GraphStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GraphStats> {
    @Nullable
    private final GraphMergeStats merge;
    @Nullable
    private final GraphRefreshStats refresh;
    public static final JsonpDeserializer<GraphStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GraphStats::setupGraphStatsDeserializer);

    private GraphStats(Builder builder) {
        this.merge = builder.merge;
        this.refresh = builder.refresh;
    }

    public static GraphStats of(Function<Builder, ObjectBuilder<GraphStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final GraphMergeStats merge() {
        return this.merge;
    }

    @Nullable
    public final GraphRefreshStats refresh() {
        return this.refresh;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.merge != null) {
            generator.writeKey("merge");
            this.merge.serialize(generator, mapper);
        }
        if (this.refresh != null) {
            generator.writeKey("refresh");
            this.refresh.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGraphStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::merge, GraphMergeStats._DESERIALIZER, "merge");
        op.add(Builder::refresh, GraphRefreshStats._DESERIALIZER, "refresh");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.merge);
        result = 31 * result + Objects.hashCode(this.refresh);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphStats other = (GraphStats)o;
        return Objects.equals(this.merge, other.merge) && Objects.equals(this.refresh, other.refresh);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GraphStats> {
        @Nullable
        private GraphMergeStats merge;
        @Nullable
        private GraphRefreshStats refresh;

        public Builder() {
        }

        private Builder(GraphStats o) {
            this.merge = o.merge;
            this.refresh = o.refresh;
        }

        private Builder(Builder o) {
            this.merge = o.merge;
            this.refresh = o.refresh;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder merge(@Nullable GraphMergeStats value) {
            this.merge = value;
            return this;
        }

        @Nonnull
        public final Builder merge(Function<GraphMergeStats.Builder, ObjectBuilder<GraphMergeStats>> fn) {
            return this.merge(fn.apply(new GraphMergeStats.Builder()).build());
        }

        @Nonnull
        public final Builder refresh(@Nullable GraphRefreshStats value) {
            this.refresh = value;
            return this;
        }

        @Nonnull
        public final Builder refresh(Function<GraphRefreshStats.Builder, ObjectBuilder<GraphRefreshStats>> fn) {
            return this.refresh(fn.apply(new GraphRefreshStats.Builder()).build());
        }

        @Override
        @Nonnull
        public GraphStats build() {
            this._checkSingleUse();
            return new GraphStats(this);
        }
    }
}

