local mkutils = require "mkutils"
local log = logging.new("mathjaxnode")
-- other possible value is page2svg
local mathnodepath = "mjpage"
-- options for MathJax command
local options = "--output CommonHTML"
-- math fonts position
-- don't alter fonts if not set
local fontdir = nil
-- if we copy fonts 
local fontdest = nil
local fontformat = "woff"
local cssfilename =  "mathjax-chtml.css"

local function compile(text)
  local tmpfile = os.tmpname()
  log:info("Compile using MathJax")
  local command =  mathnodepath .. " ".. options .. " > " .. tmpfile
  log:info(command)
  local commandhandle = io.popen(command,"w") 
  commandhandle:write(text)
  commandhandle:close()
  log:info("Result written to: ".. tmpfile)
  local f = io.open(tmpfile)
  local content = f:read("*all")
  f:close()
  os.remove(tmpfile)
  return content
end

-- save the css code from the html page generated by MathJax
local function extract_css(contents)
  local css = ""
  local filename = cssfilename
  contents = contents:gsub('<style [^>]+>(.-)</style>', function(style)
    -- replace only the style for mathjax
    if style:match "%.mjx%-math" then
      css = style
      return '<link rel="stylesheet" type="text/css" href="'..filename ..'" />'
    end
  end)
  -- local x = assert(io.open(file, "w"))
  -- x:write(contents)
  -- x:close()
  return filename, contents, css
end

-- Update the paths to fonts to use the local versions
local function use_fonts(css)
  local family_pattern = "font%-family:%s*(.-);.-%/([^%/]+)%.".. fontformat
  local family_build = "@font-face {font-family: %s; src: url('%s/%s.%s') format('%s')}"
  local fontdir = fontdir:gsub("/$","")
  css = css:gsub("(@font%-face%s*{.-})", function(face)
    if not face:match("url%(") then return face end
    -- print(face)
    local family, filename = face:match(family_pattern)
    log:info("use font: ",family, filename)
    local newfile = string.format("%s/%s.%s", fontdir, filename, fontformat)
    Make:add_file(newfile)
    return family_build:format(family, fontdir, filename, fontformat, fontformat)
    -- return face
  end)
  return css
end


local function save_css(filename, css)
  local f = io.open(filename, "w")
  f:write(css)
  f:close()
end

return function(text, arguments)
  -- if arguments.prg then mathnodepath = arguments.prg end
  local extoptions = mkutils.get_filter_settings "mathjaxnode" or {}
  local arguments = arguments or {}
  mathnodepath = arguments.prg or extoptions.prg or  mathnodepath
  options      = arguments.options or extoptions.options or options
  fontdir      = arguments.fontdir or extoptions.fontdir or fontdir
  -- the following ne is unused ATM
  fontdest     = arguments.fontdest or extoptions.fontdest or fontdest
  fontformat   = arguments.fontformat or extoptions.fontformat or fontformat
  cssfilename  = arguments.cssfilename or extoptions.cssfilename or cssfilename
  local newtext = compile(text)
  local cssfile, newtext,  css = extract_css(newtext)
  -- use local font files if fontdir is present
  if fontdir then
    css = use_fonts(css)
  end
  save_css(cssfile, css)
  Make:add_file(cssfile)
  -- print(css)
  log:info("CSS file: " .. cssfile)
  return newtext
end
