/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.ForgeRenderTypes;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.ForgeFaceData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public class ItemLayerModel
implements IUnbakedGeometry<ItemLayerModel> {
    @Nullable
    private ImmutableList<Material> textures;
    private final Int2ObjectMap<ResourceLocation> renderTypeNames;
    private final Int2ObjectMap<ResourceLocation> renderTypeFastNames;

    private ItemLayerModel(@Nullable ImmutableList<Material> textures, Int2ObjectMap<ResourceLocation> renderTypeNames) {
        this(textures, renderTypeNames, (Int2ObjectMap<ResourceLocation>)new Int2ObjectOpenHashMap());
    }

    private ItemLayerModel(@Nullable ImmutableList<Material> textures, Int2ObjectMap<ResourceLocation> renderTypeNames, Int2ObjectMap<ResourceLocation> renderTypeFastNames) {
        this.textures = textures;
        this.renderTypeNames = renderTypeNames;
        this.renderTypeFastNames = renderTypeFastNames;
    }

    @Override
    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, TextureSlots spriteGetter, ModelState modelState) {
        if (this.textures == null) {
            Material material;
            ImmutableList.Builder builder = ImmutableList.builder();
            int i = 0;
            while ((material = spriteGetter.getMaterial("layer" + i++)) != null) {
                builder.add((Object)material);
            }
            this.textures = builder.build();
        }
        Material particleMaterial = spriteGetter.getMaterial("particle");
        TextureAtlasSprite particle = baker.sprites().get(particleMaterial == null ? (Material)this.textures.get(0) : particleMaterial);
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = UnbakedGeometryHelper.composeRootTransformIntoModelState(modelState, rootTransform);
        }
        RenderTypeGroup normalRenderTypes = new RenderTypeGroup(RenderType.translucent(), ForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
        CompositeModel.Baked.Builder builder = CompositeModel.Baked.builder(context, particle, context.getTransforms());
        for (int i = 0; i < this.textures.size(); ++i) {
            TextureAtlasSprite sprite = baker.sprites().get((Material)this.textures.get(i));
            List<BlockElement> unbaked = UnbakedGeometryHelper.createUnbakedItemElements(i, sprite.contents());
            List<BakedQuad> quads = UnbakedGeometryHelper.bakeElements(unbaked, $ -> sprite, modelState);
            ResourceLocation renderTypeName = (ResourceLocation)this.renderTypeNames.get(i);
            RenderTypeGroup renderTypes = renderTypeName != null ? context.getRenderType(renderTypeName) : null;
            ResourceLocation renderTypeFastName = (ResourceLocation)this.renderTypeFastNames.get(i);
            RenderTypeGroup renderTypesFast = renderTypeFastName != null ? context.getRenderType(renderTypeFastName) : null;
            builder.addQuads(renderTypes != null ? renderTypes : normalRenderTypes, renderTypesFast != null ? renderTypesFast : RenderTypeGroup.EMPTY, quads);
        }
        return builder.build();
    }

    public static final class Loader
    implements IGeometryLoader<ItemLayerModel> {
        public static final Loader INSTANCE = new Loader();

        @Override
        public ItemLayerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            Int2ObjectMap<ResourceLocation> renderTypeNames = Loader.readRenderTypeNames(jsonObject, "render_types");
            Int2ObjectMap<ResourceLocation> renderTypeFastNames = Loader.readRenderTypeNames(jsonObject, "render_types_fast");
            return new ItemLayerModel(null, renderTypeNames, renderTypeFastNames);
        }

        private static Int2ObjectMap<ResourceLocation> readRenderTypeNames(JsonObject jsonObject, String key) {
            Int2ObjectOpenHashMap renderTypeNames = new Int2ObjectOpenHashMap();
            if (jsonObject.has(key)) {
                JsonObject renderTypes = jsonObject.getAsJsonObject(key);
                for (Map.Entry entry : renderTypes.entrySet()) {
                    ResourceLocation renderType = ResourceLocation.parse((String)((String)entry.getKey()));
                    for (JsonElement layer : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (renderTypeNames.put(layer.getAsInt(), (Object)renderType) == null) continue;
                        throw new JsonParseException("Registered duplicate " + key + " for layer " + String.valueOf(layer));
                    }
                }
            }
            return renderTypeNames;
        }

        @Deprecated(forRemoval=true, since="1.21.4")
        protected void readLayerData(JsonObject jsonObject, String name, Int2ObjectOpenHashMap<ResourceLocation> renderTypeNames, Int2ObjectMap<ForgeFaceData> layerData, boolean logWarning) {
            if (!jsonObject.has(name)) {
                return;
            }
            JsonObject fullbrightLayers = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : fullbrightLayers.entrySet()) {
                int layer = Integer.parseInt((String)entry.getKey());
                ForgeFaceData data = ForgeFaceData.read((JsonElement)entry.getValue(), ForgeFaceData.DEFAULT);
                layerData.put(layer, (Object)data);
            }
        }
    }
}

