/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.geometry;

import com.mojang.math.Transformation;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class BlockGeometryBakingContext
implements IGeometryBakingContext {
    public final BlockModel owner;
    public final VisibilityData visibilityData = new VisibilityData();
    @Nullable
    private IUnbakedGeometry<?> customGeometry;
    @Nullable
    private Transformation rootTransform;
    @Nullable
    private ResourceLocation renderTypeHint;
    @Nullable
    private ResourceLocation renderTypeFastHint;
    private boolean gui3d = true;

    @ApiStatus.Internal
    public BlockGeometryBakingContext(BlockModel owner) {
        this.owner = owner;
    }

    public boolean hasCustomGeometry() {
        return this.getCustomGeometry() != null;
    }

    private BlockGeometryBakingContext parentContext() {
        BlockGeometryBakingContext blockGeometryBakingContext;
        UnbakedModel unbakedModel = this.owner.parent;
        if (unbakedModel instanceof BlockModel) {
            BlockModel block = (BlockModel)unbakedModel;
            blockGeometryBakingContext = block.customData;
        } else {
            blockGeometryBakingContext = null;
        }
        return blockGeometryBakingContext;
    }

    @Nullable
    public IUnbakedGeometry<?> getCustomGeometry() {
        if (this.customGeometry != null) {
            return this.customGeometry;
        }
        BlockGeometryBakingContext pctx = this.parentContext();
        return pctx == null ? null : pctx.getCustomGeometry();
    }

    public void setCustomGeometry(IUnbakedGeometry<?> geometry) {
        this.customGeometry = geometry;
    }

    @Override
    public boolean isComponentVisible(String part, boolean fallback) {
        BlockGeometryBakingContext pctx = this.parentContext();
        if (pctx == null || this.visibilityData.hasCustomVisibility(part)) {
            return this.visibilityData.isVisible(part, fallback);
        }
        return pctx.isComponentVisible(part, fallback);
    }

    @Override
    public boolean isGui3d() {
        return this.gui3d;
    }

    @Override
    public boolean useBlockLight() {
        return this.owner.getGuiLight().lightLikeBlock();
    }

    @Override
    public boolean useAmbientOcclusion() {
        return this.owner.getAmbientOcclusion();
    }

    @Override
    public ItemTransforms getTransforms() {
        return this.owner.getTransforms();
    }

    @Override
    public Transformation getRootTransform() {
        if (this.rootTransform != null) {
            return this.rootTransform;
        }
        BlockGeometryBakingContext pctx = this.parentContext();
        return pctx == null ? Transformation.identity() : pctx.getRootTransform();
    }

    public void setRootTransform(Transformation rootTransform) {
        this.rootTransform = rootTransform;
    }

    @Override
    @Nullable
    public ResourceLocation getRenderTypeHint() {
        if (this.renderTypeHint != null) {
            return this.renderTypeHint;
        }
        BlockGeometryBakingContext pctx = this.parentContext();
        return pctx == null ? null : pctx.getRenderTypeHint();
    }

    @Override
    @Nullable
    public ResourceLocation getRenderTypeFastHint() {
        if (this.renderTypeFastHint != null) {
            return this.renderTypeFastHint;
        }
        BlockGeometryBakingContext pctx = this.parentContext();
        return pctx == null ? null : pctx.getRenderTypeFastHint();
    }

    public void setRenderTypeHint(ResourceLocation renderTypeHint) {
        this.renderTypeHint = renderTypeHint;
    }

    public void setRenderTypeFastHint(ResourceLocation renderTypeFastHint) {
        this.renderTypeFastHint = renderTypeFastHint;
    }

    public void setGui3d(boolean gui3d) {
        this.gui3d = gui3d;
    }

    public void copyFrom(BlockGeometryBakingContext other) {
        this.customGeometry = other.customGeometry;
        this.rootTransform = other.rootTransform;
        this.visibilityData.copyFrom(other.visibilityData);
        this.renderTypeHint = other.renderTypeHint;
        this.renderTypeFastHint = other.renderTypeFastHint;
        this.gui3d = other.gui3d;
    }

    public BakedModel bake(ModelBaker baker, TextureSlots textures, ModelState modelTransform) {
        IUnbakedGeometry<?> geometry = this.getCustomGeometry();
        if (geometry == null) {
            throw new IllegalStateException("Can not use custom baking without custom geometry");
        }
        return geometry.bake(this, baker, textures, modelTransform);
    }

    public static class VisibilityData {
        private final Map<String, Boolean> data = new HashMap<String, Boolean>();

        public boolean hasCustomVisibility(String part) {
            return this.data.containsKey(part);
        }

        public boolean isVisible(String part, boolean fallback) {
            return this.data.getOrDefault(part, fallback);
        }

        public void setVisibilityState(String partName, boolean type) {
            this.data.put(partName, type);
        }

        public void copyFrom(VisibilityData visibilityData) {
            this.data.clear();
            this.data.putAll(visibilityData.data);
        }
    }
}

