/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventListener;
import org.jetbrains.annotations.Nullable;

public class ListenerList {
    private static final List<ListenerList> allLists = new ArrayList<ListenerList>();
    private static int maxSize = 0;
    @Nullable
    private final ListenerList parent;
    private ListenerListInst[] lists = new ListenerListInst[0];

    public ListenerList() {
        this(null);
    }

    public ListenerList(@Nullable ListenerList parent) {
        this.parent = parent;
        ListenerList.extendMasterList(this);
        this.resizeLists(maxSize);
    }

    private static synchronized void extendMasterList(ListenerList inst) {
        allLists.add(inst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void resize(int max) {
        if (max <= maxSize) return;
        Class<ListenerList> clazz = ListenerList.class;
        synchronized (ListenerList.class) {
            if (max <= maxSize) return;
            allLists.forEach(list -> list.resizeLists(max));
            maxSize = max;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private synchronized void resizeLists(int max) {
        int x;
        if (this.parent != null) {
            this.parent.resizeLists(max);
        }
        if (this.lists.length >= max) {
            return;
        }
        ListenerListInst[] newList = new ListenerListInst[max];
        for (x = 0; x < this.lists.length; ++x) {
            newList[x] = this.lists[x];
        }
        while (x < max) {
            newList[x] = this.parent != null ? new ListenerListInst(this.parent.getInstance(x)) : new ListenerListInst();
            ++x;
        }
        this.lists = newList;
    }

    public static synchronized void clearBusID(int id) {
        for (ListenerList list : allLists) {
            list.lists[id].dispose();
        }
    }

    protected ListenerListInst getInstance(int id) {
        return this.lists[id];
    }

    public IEventListener[] getListeners(int id) {
        return this.lists[id].getListeners();
    }

    public void register(int id, EventPriority priority, IEventListener listener) {
        this.lists[id].register(priority, listener);
    }

    public void unregister(int id, IEventListener listener) {
        this.lists[id].unregister(listener);
    }

    public static synchronized void unregisterAll(int id, IEventListener listener) {
        for (ListenerList list : allLists) {
            list.unregister(id, listener);
        }
    }

    private static class ListenerListInst {
        private static final EventPriority[] EVENT_PRIORITY_VALUES = EventPriority.values();
        private static final IEventListener[] NO_LISTENERS = new IEventListener[0];
        @Nullable
        private volatile IEventListener[] listeners = NO_LISTENERS;
        @Nullable
        private final ArrayList<IEventListener>[] priorities = new ArrayList[EVENT_PRIORITY_VALUES.length];
        private ListenerListInst parent;
        private List<ListenerListInst> children;
        private final Semaphore writeLock = new Semaphore(1, true);

        private ListenerListInst() {
        }

        private ListenerListInst(ListenerListInst parent) {
            this.parent = parent;
            this.parent.addChild(this);
            if (this.parent.listeners != NO_LISTENERS) {
                this.listeners = null;
            }
        }

        public void dispose() {
            this.writeLock.acquireUninterruptibly();
            for (int i = 0; i < this.priorities.length; ++i) {
                @Nullable ArrayList<IEventListener> priority = this.priorities[i];
                if (priority == null) continue;
                priority.clear();
                this.priorities[i] = null;
            }
            this.writeLock.release();
            this.parent = null;
            this.listeners = NO_LISTENERS;
            if (this.children != null) {
                this.children.clear();
            }
        }

        public ArrayList<IEventListener> getListeners(EventPriority priority) {
            this.writeLock.acquireUninterruptibly();
            ArrayList<IEventListener> ret = new ArrayList<IEventListener>(this.getListenersForPriority(priority));
            this.writeLock.release();
            if (this.parent != null) {
                ret.addAll(this.parent.getListeners(priority));
            }
            return ret;
        }

        public IEventListener[] getListeners() {
            IEventListener[] listeners = this.listeners;
            if (listeners != null) {
                return listeners;
            }
            return this.buildCache();
        }

        protected boolean shouldRebuild() {
            return this.listeners == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void forceRebuild() {
            this.listeners = null;
            if (this.children != null) {
                List<ListenerListInst> list = this.children;
                synchronized (list) {
                    for (ListenerListInst child : this.children) {
                        child.forceRebuild();
                    }
                }
            }
        }

        private void addChild(ListenerListInst child) {
            if (this.children == null) {
                this.children = Collections.synchronizedList(new ArrayList(2));
            }
            this.children.add(child);
        }

        private IEventListener[] buildCache() {
            if (this.parent != null && this.parent.shouldRebuild()) {
                this.parent.buildCache();
            }
            ArrayList<IEventListener> ret = new ArrayList<IEventListener>();
            for (EventPriority value : EVENT_PRIORITY_VALUES) {
                ArrayList<IEventListener> listeners = this.getListeners(value);
                if (listeners.isEmpty()) continue;
                ret.add(value);
                ret.addAll(listeners);
            }
            IEventListener[] retArray = ret.isEmpty() ? NO_LISTENERS : ret.toArray(new IEventListener[0]);
            this.listeners = retArray;
            return retArray;
        }

        public void register(EventPriority priority, IEventListener listener) {
            if (listener == null) {
                return;
            }
            this.writeLock.acquireUninterruptibly();
            this.getListenersForPriority(priority).add(listener);
            this.writeLock.release();
            this.forceRebuild();
        }

        public void unregister(IEventListener listener) {
            this.writeLock.acquireUninterruptibly();
            boolean needsRebuild = false;
            for (ArrayList<IEventListener> list : this.priorities) {
                if (list == null) continue;
                needsRebuild |= list.remove(listener);
            }
            if (needsRebuild) {
                this.forceRebuild();
            }
            this.writeLock.release();
        }

        private ArrayList<IEventListener> getListenersForPriority(EventPriority priority) {
            ArrayList<IEventListener> listenersForPriority = this.priorities[priority.ordinal()];
            if (listenersForPriority == null) {
                ArrayList arrayList = new ArrayList();
                this.priorities[priority.ordinal()] = arrayList;
                listenersForPriority = arrayList;
            }
            return listenersForPriority;
        }
    }
}

