/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.gametest.framework.GameTestBatch;
import net.minecraft.gametest.framework.GameTestBatchFactory;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestInfo;
import net.minecraft.gametest.framework.GameTestListener;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.GameTestRunner;
import net.minecraft.gametest.framework.GameTestTicker;
import net.minecraft.gametest.framework.MultipleTestTracker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureBlockPosFinder;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestClassNameArgument;
import net.minecraft.gametest.framework.TestFinder;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.gametest.framework.TestFunctionArgument;
import net.minecraft.gametest.framework.TestFunctionFinder;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class TestCommand {
    public static final int STRUCTURE_BLOCK_NEARBY_SEARCH_RADIUS = 15;
    public static final int STRUCTURE_BLOCK_FULL_SEARCH_RADIUS = 200;
    public static final int VERIFY_TEST_GRID_AXIS_SIZE = 10;
    public static final int VERIFY_TEST_BATCH_SIZE = 100;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_CLEAR_RADIUS = 200;
    private static final int MAX_CLEAR_RADIUS = 1024;
    private static final int TEST_POS_Z_OFFSET_FROM_PLAYER = 3;
    private static final int SHOW_POS_DURATION_MS = 10000;
    private static final int DEFAULT_X_SIZE = 5;
    private static final int DEFAULT_Y_SIZE = 5;
    private static final int DEFAULT_Z_SIZE = 5;
    private static final String STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND = "Structure block entity could not be found";
    private static final TestFinder.Builder<Runner> testFinder = new TestFinder.Builder<Runner>(Runner::new);

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptions(ArgumentBuilder<CommandSourceStack, ?> $$0, Function<CommandContext<CommandSourceStack>, Runner> $$12, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> $$2) {
        return $$0.executes($$1 -> ((Runner)$$12.apply($$1)).run()).then(((RequiredArgumentBuilder)Commands.argument("numberOfTimes", IntegerArgumentType.integer((int)0)).executes($$1 -> ((Runner)$$12.apply($$1)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)$$1, (String)"numberOfTimes"), false)))).then($$2.apply(Commands.argument("untilFailed", BoolArgumentType.bool()).executes($$1 -> ((Runner)$$12.apply($$1)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)$$1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)$$1, (String)"untilFailed")))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptions(ArgumentBuilder<CommandSourceStack, ?> $$02, Function<CommandContext<CommandSourceStack>, Runner> $$1) {
        return TestCommand.runWithRetryOptions($$02, $$1, $$0 -> $$0);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> runWithRetryOptionsAndBuildInfo(ArgumentBuilder<CommandSourceStack, ?> $$0, Function<CommandContext<CommandSourceStack>, Runner> $$1) {
        return TestCommand.runWithRetryOptions($$0, $$1, $$12 -> $$12.then(((RequiredArgumentBuilder)Commands.argument("rotationSteps", IntegerArgumentType.integer()).executes($$1 -> ((Runner)$$1.apply($$1)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)$$1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)$$1, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)$$1, (String)"rotationSteps")))).then(Commands.argument("testsPerRow", IntegerArgumentType.integer()).executes($$1 -> ((Runner)$$1.apply($$1)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)$$1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)$$1, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)$$1, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)$$1, (String)"testsPerRow"))))));
    }

    public static void register(CommandDispatcher<CommandSourceStack> $$02) {
        ArgumentBuilder<CommandSourceStack, ?> $$1 = TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("onlyRequiredTests", BoolArgumentType.bool()), $$0 -> testFinder.failedTests((CommandContext<CommandSourceStack>)$$0, BoolArgumentType.getBool((CommandContext)$$0, (String)"onlyRequiredTests")));
        ArgumentBuilder<CommandSourceStack, ?> $$2 = TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("testClassName", TestClassNameArgument.testClassName()), $$0 -> testFinder.allTestsInClass((CommandContext<CommandSourceStack>)$$0, TestClassNameArgument.getTestClassName((CommandContext<CommandSourceStack>)$$0, "testClassName")));
        $$02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("test").then(Commands.literal("run").then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.argument("testName", TestFunctionArgument.testFunctionArgument()), $$0 -> testFinder.byArgument((CommandContext<CommandSourceStack>)$$0, "testName"))))).then(Commands.literal("runmultiple").then(((RequiredArgumentBuilder)Commands.argument("testName", TestFunctionArgument.testFunctionArgument()).executes($$0 -> testFinder.byArgument((CommandContext<CommandSourceStack>)$$0, "testName").run())).then(Commands.argument("amount", IntegerArgumentType.integer()).executes($$0 -> testFinder.createMultipleCopies(IntegerArgumentType.getInteger((CommandContext)$$0, (String)"amount")).byArgument((CommandContext<CommandSourceStack>)$$0, "testName").run()))))).then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.literal("runall").then($$2), testFinder::allTests))).then(TestCommand.runWithRetryOptions(Commands.literal("runthese"), testFinder::allNearby))).then(TestCommand.runWithRetryOptions(Commands.literal("runclosest"), testFinder::nearest))).then(TestCommand.runWithRetryOptions(Commands.literal("runthat"), testFinder::lookedAt))).then(TestCommand.runWithRetryOptionsAndBuildInfo(Commands.literal("runfailed").then($$1), testFinder::failedTests))).then(Commands.literal("verify").then(Commands.argument("testName", TestFunctionArgument.testFunctionArgument()).executes($$0 -> testFinder.byArgument((CommandContext<CommandSourceStack>)$$0, "testName").verify())))).then(Commands.literal("verifyclass").then(Commands.argument("testClassName", TestClassNameArgument.testClassName()).executes($$0 -> testFinder.allTestsInClass((CommandContext<CommandSourceStack>)$$0, TestClassNameArgument.getTestClassName((CommandContext<CommandSourceStack>)$$0, "testClassName")).verify())))).then(Commands.literal("locate").then(Commands.argument("testName", TestFunctionArgument.testFunctionArgument()).executes($$0 -> testFinder.locateByName((CommandContext<CommandSourceStack>)$$0, "minecraft:" + TestFunctionArgument.getTestFunction((CommandContext<CommandSourceStack>)$$0, "testName").structureName()).locate())))).then(Commands.literal("resetclosest").executes($$0 -> testFinder.nearest((CommandContext<CommandSourceStack>)$$0).reset()))).then(Commands.literal("resetthese").executes($$0 -> testFinder.allNearby((CommandContext<CommandSourceStack>)$$0).reset()))).then(Commands.literal("resetthat").executes($$0 -> testFinder.lookedAt((CommandContext<CommandSourceStack>)$$0).reset()))).then(Commands.literal("export").then(Commands.argument("testName", StringArgumentType.word()).executes($$0 -> TestCommand.exportTestStructure((CommandSourceStack)$$0.getSource(), "minecraft:" + StringArgumentType.getString((CommandContext)$$0, (String)"testName")))))).then(Commands.literal("exportclosest").executes($$0 -> testFinder.nearest((CommandContext<CommandSourceStack>)$$0).export()))).then(Commands.literal("exportthese").executes($$0 -> testFinder.allNearby((CommandContext<CommandSourceStack>)$$0).export()))).then(Commands.literal("exportthat").executes($$0 -> testFinder.lookedAt((CommandContext<CommandSourceStack>)$$0).export()))).then(Commands.literal("clearthat").executes($$0 -> testFinder.lookedAt((CommandContext<CommandSourceStack>)$$0).clear()))).then(Commands.literal("clearthese").executes($$0 -> testFinder.allNearby((CommandContext<CommandSourceStack>)$$0).clear()))).then(((LiteralArgumentBuilder)Commands.literal("clearall").executes($$0 -> testFinder.radius((CommandContext<CommandSourceStack>)$$0, 200).clear())).then(Commands.argument("radius", IntegerArgumentType.integer()).executes($$0 -> testFinder.radius((CommandContext<CommandSourceStack>)$$0, Mth.clamp(IntegerArgumentType.getInteger((CommandContext)$$0, (String)"radius"), 0, 1024)).clear())))).then(Commands.literal("import").then(Commands.argument("testName", StringArgumentType.word()).executes($$0 -> TestCommand.importTestStructure((CommandSourceStack)$$0.getSource(), StringArgumentType.getString((CommandContext)$$0, (String)"testName")))))).then(Commands.literal("stop").executes($$0 -> TestCommand.stopTests()))).then(((LiteralArgumentBuilder)Commands.literal("pos").executes($$0 -> TestCommand.showPos((CommandSourceStack)$$0.getSource(), "pos"))).then(Commands.argument("var", StringArgumentType.word()).executes($$0 -> TestCommand.showPos((CommandSourceStack)$$0.getSource(), StringArgumentType.getString((CommandContext)$$0, (String)"var")))))).then(Commands.literal("create").then(((RequiredArgumentBuilder)Commands.argument("testName", StringArgumentType.word()).suggests(TestFunctionArgument::suggestTestFunction).executes($$0 -> TestCommand.createNewStructure((CommandSourceStack)$$0.getSource(), StringArgumentType.getString((CommandContext)$$0, (String)"testName"), 5, 5, 5))).then(((RequiredArgumentBuilder)Commands.argument("width", IntegerArgumentType.integer()).executes($$0 -> TestCommand.createNewStructure((CommandSourceStack)$$0.getSource(), StringArgumentType.getString((CommandContext)$$0, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)$$0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)$$0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)$$0, (String)"width")))).then(Commands.argument("height", IntegerArgumentType.integer()).then(Commands.argument("depth", IntegerArgumentType.integer()).executes($$0 -> TestCommand.createNewStructure((CommandSourceStack)$$0.getSource(), StringArgumentType.getString((CommandContext)$$0, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)$$0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)$$0, (String)"height"), IntegerArgumentType.getInteger((CommandContext)$$0, (String)"depth")))))))));
    }

    private static int resetGameTestInfo(GameTestInfo $$02) {
        $$02.getLevel().getEntities(null, $$02.getStructureBounds()).stream().forEach($$0 -> $$0.remove(Entity.RemovalReason.DISCARDED));
        $$02.getStructureBlockEntity().placeStructure($$02.getLevel());
        StructureUtils.removeBarriers($$02.getStructureBounds(), $$02.getLevel());
        TestCommand.say($$02.getLevel(), "Reset succeded for: " + $$02.getTestName(), ChatFormatting.GREEN);
        return 1;
    }

    static Stream<GameTestInfo> toGameTestInfos(CommandSourceStack $$0, RetryOptions $$1, StructureBlockPosFinder $$22) {
        return $$22.findStructureBlockPos().map($$2 -> TestCommand.createGameTestInfo($$2, $$0.getLevel(), $$1)).flatMap(Optional::stream);
    }

    static Stream<GameTestInfo> toGameTestInfo(CommandSourceStack $$0, RetryOptions $$12, TestFunctionFinder $$2, int $$32) {
        return $$2.findTestFunctions().filter($$1 -> TestCommand.verifyStructureExists($$0.getLevel(), $$1.structureName())).map($$3 -> new GameTestInfo((TestFunction)$$3, StructureUtils.getRotationForRotationSteps($$32), $$0.getLevel(), $$12));
    }

    private static Optional<GameTestInfo> createGameTestInfo(BlockPos $$0, ServerLevel $$1, RetryOptions $$2) {
        StructureBlockEntity $$3 = (StructureBlockEntity)$$1.getBlockEntity($$0);
        if ($$3 == null) {
            TestCommand.say($$1, STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, ChatFormatting.RED);
            return Optional.empty();
        }
        String $$4 = $$3.getMetaData();
        Optional<TestFunction> $$5 = GameTestRegistry.findTestFunction($$4);
        if ($$5.isEmpty()) {
            TestCommand.say($$1, "Test function for test " + $$4 + " could not be found", ChatFormatting.RED);
            return Optional.empty();
        }
        TestFunction $$6 = $$5.get();
        GameTestInfo $$7 = new GameTestInfo($$6, $$3.getRotation(), $$1, $$2);
        $$7.setStructureBlockPos($$0);
        if (!TestCommand.verifyStructureExists($$1, $$7.getStructureName())) {
            return Optional.empty();
        }
        return Optional.of($$7);
    }

    private static int createNewStructure(CommandSourceStack $$0, String $$12, int $$2, int $$3, int $$4) {
        if ($$2 > 48 || $$3 > 48 || $$4 > 48) {
            throw new IllegalArgumentException("The structure must be less than 48 blocks big in each axis");
        }
        ServerLevel $$5 = $$0.getLevel();
        BlockPos $$6 = TestCommand.createTestPositionAround($$0).below();
        StructureUtils.createNewEmptyStructureBlock($$12.toLowerCase(), $$6, new Vec3i($$2, $$3, $$4), Rotation.NONE, $$5);
        BlockPos $$7 = $$6.above();
        BlockPos $$8 = $$7.offset($$2 - 1, 0, $$4 - 1);
        BlockPos.betweenClosedStream($$7, $$8).forEach($$1 -> $$5.setBlockAndUpdate((BlockPos)$$1, Blocks.BEDROCK.defaultBlockState()));
        StructureUtils.addCommandBlockAndButtonToStartTest($$6, new BlockPos(1, 0, -1), Rotation.NONE, $$5);
        return 0;
    }

    private static int showPos(CommandSourceStack $$0, String $$1) throws CommandSyntaxException {
        ServerLevel $$4;
        BlockHitResult $$2 = (BlockHitResult)$$0.getPlayerOrException().pick(10.0, 1.0f, false);
        BlockPos $$3 = $$2.getBlockPos();
        Optional<BlockPos> $$5 = StructureUtils.findStructureBlockContainingPos($$3, 15, $$4 = $$0.getLevel());
        if ($$5.isEmpty()) {
            $$5 = StructureUtils.findStructureBlockContainingPos($$3, 200, $$4);
        }
        if ($$5.isEmpty()) {
            $$0.sendFailure(Component.literal("Can't find a structure block that contains the targeted pos " + String.valueOf($$3)));
            return 0;
        }
        StructureBlockEntity $$6 = (StructureBlockEntity)$$4.getBlockEntity($$5.get());
        if ($$6 == null) {
            TestCommand.say($$4, STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, ChatFormatting.RED);
            return 0;
        }
        BlockPos $$7 = $$3.subtract($$5.get());
        String $$8 = $$7.getX() + ", " + $$7.getY() + ", " + $$7.getZ();
        String $$9 = $$6.getMetaData();
        MutableComponent $$10 = Component.literal($$8).setStyle(Style.EMPTY.withBold(true).withColor(ChatFormatting.GREEN).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, Component.literal("Click to copy to clipboard"))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, "final BlockPos " + $$1 + " = new BlockPos(" + $$8 + ");")));
        $$0.sendSuccess(() -> Component.literal("Position relative to " + $$9 + ": ").append($$10), false);
        DebugPackets.sendGameTestAddMarker($$4, new BlockPos($$3), $$8, -2147418368, 10000);
        return 1;
    }

    static int stopTests() {
        GameTestTicker.SINGLETON.clear();
        return 1;
    }

    static int trackAndStartRunner(CommandSourceStack $$02, ServerLevel $$1, GameTestRunner $$2) {
        $$2.addListener(new TestBatchSummaryDisplayer($$02));
        MultipleTestTracker $$3 = new MultipleTestTracker($$2.getTestInfos());
        $$3.addListener(new TestSummaryDisplayer($$1, $$3));
        $$3.addFailureListener($$0 -> GameTestRegistry.rememberFailedTest($$0.getTestFunction()));
        $$2.start();
        return 1;
    }

    static int saveAndExportTestStructure(CommandSourceStack $$0, StructureBlockEntity $$1) {
        String $$2 = $$1.getStructureName();
        if (!$$1.saveStructure(true)) {
            TestCommand.say($$0, "Failed to save structure " + $$2);
        }
        return TestCommand.exportTestStructure($$0, $$2);
    }

    private static int exportTestStructure(CommandSourceStack $$0, String $$1) {
        Path $$2 = Paths.get(StructureUtils.testStructuresDir, new String[0]);
        ResourceLocation $$3 = ResourceLocation.parse($$1);
        Path $$4 = $$0.getLevel().getStructureManager().createAndValidatePathToGeneratedStructure($$3, ".nbt");
        Path $$5 = NbtToSnbt.convertStructure(CachedOutput.NO_CACHE, $$4, $$3.getPath(), $$2);
        if ($$5 == null) {
            TestCommand.say($$0, "Failed to export " + String.valueOf($$4));
            return 1;
        }
        try {
            FileUtil.createDirectoriesSafe($$5.getParent());
        }
        catch (IOException $$6) {
            TestCommand.say($$0, "Could not create folder " + String.valueOf($$5.getParent()));
            LOGGER.error("Could not create export folder", (Throwable)$$6);
            return 1;
        }
        TestCommand.say($$0, "Exported " + $$1 + " to " + String.valueOf($$5.toAbsolutePath()));
        return 0;
    }

    private static boolean verifyStructureExists(ServerLevel $$0, String $$1) {
        if ($$0.getStructureManager().get(ResourceLocation.parse($$1)).isEmpty()) {
            TestCommand.say($$0, "Test structure " + $$1 + " could not be found", ChatFormatting.RED);
            return false;
        }
        return true;
    }

    static BlockPos createTestPositionAround(CommandSourceStack $$0) {
        BlockPos $$1 = BlockPos.containing($$0.getPosition());
        int $$2 = $$0.getLevel().getHeightmapPos(Heightmap.Types.WORLD_SURFACE, $$1).getY();
        return new BlockPos($$1.getX(), $$2 + 1, $$1.getZ() + 3);
    }

    static void say(CommandSourceStack $$0, String $$1) {
        $$0.sendSuccess(() -> Component.literal($$1), false);
    }

    private static int importTestStructure(CommandSourceStack $$0, String $$1) {
        Path $$2 = Paths.get(StructureUtils.testStructuresDir, $$1 + ".snbt");
        ResourceLocation $$3 = ResourceLocation.withDefaultNamespace($$1);
        Path $$4 = $$0.getLevel().getStructureManager().createAndValidatePathToGeneratedStructure($$3, ".nbt");
        try {
            BufferedReader $$5 = Files.newBufferedReader($$2);
            String $$6 = IOUtils.toString((Reader)$$5);
            Files.createDirectories($$4.getParent(), new FileAttribute[0]);
            try (OutputStream $$7 = Files.newOutputStream($$4, new OpenOption[0]);){
                NbtIo.writeCompressed(NbtUtils.snbtToStructure($$6), $$7);
            }
            $$0.getLevel().getStructureManager().remove($$3);
            TestCommand.say($$0, "Imported to " + String.valueOf($$4.toAbsolutePath()));
            return 0;
        }
        catch (CommandSyntaxException | IOException $$8) {
            LOGGER.error("Failed to load structure {}", (Object)$$1, (Object)$$8);
            return 1;
        }
    }

    static void say(ServerLevel $$02, String $$1, ChatFormatting $$22) {
        $$02.getPlayers($$0 -> true).forEach($$2 -> $$2.sendSystemMessage(Component.literal($$1).withStyle($$22)));
    }

    record TestBatchSummaryDisplayer(CommandSourceStack source) implements GameTestBatchListener
    {
        @Override
        public void testBatchStarting(GameTestBatch $$0) {
            TestCommand.say(this.source, "Starting batch: " + $$0.name());
        }

        @Override
        public void testBatchFinished(GameTestBatch $$0) {
        }
    }

    public record TestSummaryDisplayer(ServerLevel level, MultipleTestTracker tracker) implements GameTestListener
    {
        @Override
        public void testStructureLoaded(GameTestInfo $$0) {
        }

        @Override
        public void testPassed(GameTestInfo $$0, GameTestRunner $$1) {
            TestSummaryDisplayer.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        @Override
        public void testFailed(GameTestInfo $$0, GameTestRunner $$1) {
            TestSummaryDisplayer.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        @Override
        public void testAddedForRerun(GameTestInfo $$0, GameTestInfo $$1, GameTestRunner $$2) {
            this.tracker.addTestToTrack($$1);
        }

        private static void showTestSummaryIfAllDone(ServerLevel $$0, MultipleTestTracker $$1) {
            if ($$1.isDone()) {
                TestCommand.say($$0, "GameTest done! " + $$1.getTotalCount() + " tests were run", ChatFormatting.WHITE);
                if ($$1.hasFailedRequired()) {
                    TestCommand.say($$0, $$1.getFailedRequiredCount() + " required tests failed :(", ChatFormatting.RED);
                } else {
                    TestCommand.say($$0, "All required tests passed :)", ChatFormatting.GREEN);
                }
                if ($$1.hasFailedOptional()) {
                    TestCommand.say($$0, $$1.getFailedOptionalCount() + " optional tests failed", ChatFormatting.GRAY);
                }
            }
        }
    }

    public static class Runner {
        private final TestFinder<Runner> finder;

        public Runner(TestFinder<Runner> $$0) {
            this.finder = $$0;
        }

        public int reset() {
            TestCommand.stopTests();
            return TestCommand.toGameTestInfos(this.finder.source(), RetryOptions.noRetries(), this.finder).map(TestCommand::resetGameTestInfo).toList().isEmpty() ? 0 : 1;
        }

        private <T> void logAndRun(Stream<T> $$0, ToIntFunction<T> $$1, Runnable $$2, Consumer<Integer> $$3) {
            int $$4 = $$0.mapToInt($$1).sum();
            if ($$4 == 0) {
                $$2.run();
            } else {
                $$3.accept($$4);
            }
        }

        public int clear() {
            TestCommand.stopTests();
            CommandSourceStack $$0 = this.finder.source();
            ServerLevel $$12 = $$0.getLevel();
            GameTestRunner.clearMarkers($$12);
            this.logAndRun(this.finder.findStructureBlockPos(), $$1 -> {
                StructureBlockEntity $$2 = (StructureBlockEntity)$$12.getBlockEntity((BlockPos)$$1);
                if ($$2 == null) {
                    return 0;
                }
                BoundingBox $$3 = StructureUtils.getStructureBoundingBox($$2);
                StructureUtils.clearSpaceForStructure($$3, $$12);
                return 1;
            }, () -> TestCommand.say($$12, "Could not find any structures to clear", ChatFormatting.RED), $$1 -> TestCommand.say($$0, "Cleared " + $$1 + " structures"));
            return 1;
        }

        public int export() {
            MutableBoolean $$0 = new MutableBoolean(true);
            CommandSourceStack $$12 = this.finder.source();
            ServerLevel $$2 = $$12.getLevel();
            this.logAndRun(this.finder.findStructureBlockPos(), $$3 -> {
                StructureBlockEntity $$4 = (StructureBlockEntity)$$2.getBlockEntity((BlockPos)$$3);
                if ($$4 == null) {
                    TestCommand.say($$2, TestCommand.STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, ChatFormatting.RED);
                    $$0.setFalse();
                    return 0;
                }
                if (TestCommand.saveAndExportTestStructure($$12, $$4) != 0) {
                    $$0.setFalse();
                }
                return 1;
            }, () -> TestCommand.say($$2, "Could not find any structures to export", ChatFormatting.RED), $$1 -> TestCommand.say($$12, "Exported " + $$1 + " structures"));
            return $$0.getValue() != false ? 0 : 1;
        }

        int verify() {
            TestCommand.stopTests();
            CommandSourceStack $$0 = this.finder.source();
            ServerLevel $$1 = $$0.getLevel();
            BlockPos $$2 = TestCommand.createTestPositionAround($$0);
            List<GameTestInfo> $$3 = Stream.concat(TestCommand.toGameTestInfos($$0, RetryOptions.noRetries(), this.finder), TestCommand.toGameTestInfo($$0, RetryOptions.noRetries(), this.finder, 0)).toList();
            GameTestRunner.clearMarkers($$1);
            GameTestRegistry.forgetFailedTests();
            ArrayList<GameTestBatch> $$4 = new ArrayList<GameTestBatch>();
            for (GameTestInfo $$5 : $$3) {
                for (Rotation $$6 : Rotation.values()) {
                    ArrayList<GameTestInfo> $$7 = new ArrayList<GameTestInfo>();
                    for (int $$8 = 0; $$8 < 100; ++$$8) {
                        GameTestInfo $$9 = new GameTestInfo($$5.getTestFunction(), $$6, $$1, new RetryOptions(1, true));
                        $$7.add($$9);
                    }
                    GameTestBatch $$10 = GameTestBatchFactory.toGameTestBatch($$7, $$5.getTestFunction().batchName(), $$6.ordinal());
                    $$4.add($$10);
                }
            }
            StructureGridSpawner $$11 = new StructureGridSpawner($$2, 10, true);
            GameTestRunner $$12 = GameTestRunner.Builder.fromBatches($$4, $$1).batcher(GameTestBatchFactory.fromGameTestInfo(100)).newStructureSpawner($$11).existingStructureSpawner($$11).haltOnError(true).build();
            return TestCommand.trackAndStartRunner($$0, $$1, $$12);
        }

        public int run(RetryOptions $$0, int $$1, int $$2) {
            TestCommand.stopTests();
            CommandSourceStack $$3 = this.finder.source();
            ServerLevel $$4 = $$3.getLevel();
            BlockPos $$5 = TestCommand.createTestPositionAround($$3);
            List<GameTestInfo> $$6 = Stream.concat(TestCommand.toGameTestInfos($$3, $$0, this.finder), TestCommand.toGameTestInfo($$3, $$0, this.finder, $$1)).toList();
            if ($$6.isEmpty()) {
                TestCommand.say($$3, "No tests found");
                return 0;
            }
            GameTestRunner.clearMarkers($$4);
            GameTestRegistry.forgetFailedTests();
            TestCommand.say($$3, "Running " + $$6.size() + " tests...");
            GameTestRunner $$7 = GameTestRunner.Builder.fromInfo($$6, $$4).newStructureSpawner(new StructureGridSpawner($$5, $$2, false)).build();
            return TestCommand.trackAndStartRunner($$3, $$4, $$7);
        }

        public int run(int $$0, int $$1) {
            return this.run(RetryOptions.noRetries(), $$0, $$1);
        }

        public int run(int $$0) {
            return this.run(RetryOptions.noRetries(), $$0, 8);
        }

        public int run(RetryOptions $$0, int $$1) {
            return this.run($$0, $$1, 8);
        }

        public int run(RetryOptions $$0) {
            return this.run($$0, 0, 8);
        }

        public int run() {
            return this.run(RetryOptions.noRetries());
        }

        public int locate() {
            TestCommand.say(this.finder.source(), "Started locating test structures, this might take a while..");
            MutableInt $$0 = new MutableInt(0);
            BlockPos $$1 = BlockPos.containing(this.finder.source().getPosition());
            this.finder.findStructureBlockPos().forEach($$2 -> {
                StructureBlockEntity $$3 = (StructureBlockEntity)this.finder.source().getLevel().getBlockEntity((BlockPos)$$2);
                if ($$3 == null) {
                    return;
                }
                Direction $$4 = $$3.getRotation().rotate(Direction.NORTH);
                BlockPos $$5 = $$3.getBlockPos().relative($$4, 2);
                int $$6 = (int)$$4.getOpposite().toYRot();
                String $$7 = String.format("/tp @s %d %d %d %d 0", $$5.getX(), $$5.getY(), $$5.getZ(), $$6);
                int $$8 = $$1.getX() - $$2.getX();
                int $$9 = $$1.getZ() - $$2.getZ();
                int $$10 = Mth.floor(Mth.sqrt($$8 * $$8 + $$9 * $$9));
                MutableComponent $$11 = ComponentUtils.wrapInSquareBrackets(Component.translatable("chat.coordinates", $$2.getX(), $$2.getY(), $$2.getZ())).withStyle($$1 -> $$1.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, $$7)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, Component.translatable("chat.coordinates.tooltip"))));
                MutableComponent $$122 = Component.literal("Found structure at: ").append($$11).append(" (distance: " + $$10 + ")");
                this.finder.source().sendSuccess(() -> $$122, false);
                $$0.increment();
            });
            int $$22 = $$0.intValue();
            if ($$22 == 0) {
                TestCommand.say(this.finder.source().getLevel(), "No such test structure found", ChatFormatting.RED);
                return 0;
            }
            TestCommand.say(this.finder.source().getLevel(), "Finished locating, found " + $$22 + " structure(s)", ChatFormatting.GREEN);
            return 1;
        }
    }
}

