/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.context.CommandContext;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestRegistry;
import net.minecraft.gametest.framework.StructureBlockPosFinder;
import net.minecraft.gametest.framework.StructureUtils;
import net.minecraft.gametest.framework.TestFunction;
import net.minecraft.gametest.framework.TestFunctionArgument;
import net.minecraft.gametest.framework.TestFunctionFinder;

public class TestFinder<T>
implements StructureBlockPosFinder,
TestFunctionFinder {
    static final TestFunctionFinder NO_FUNCTIONS = Stream::empty;
    static final StructureBlockPosFinder NO_STRUCTURES = Stream::empty;
    private final TestFunctionFinder testFunctionFinder;
    private final StructureBlockPosFinder structureBlockPosFinder;
    private final CommandSourceStack source;
    private final Function<TestFinder<T>, T> contextProvider;

    @Override
    public Stream<BlockPos> findStructureBlockPos() {
        return this.structureBlockPosFinder.findStructureBlockPos();
    }

    TestFinder(CommandSourceStack $$0, Function<TestFinder<T>, T> $$1, TestFunctionFinder $$2, StructureBlockPosFinder $$3) {
        this.source = $$0;
        this.contextProvider = $$1;
        this.testFunctionFinder = $$2;
        this.structureBlockPosFinder = $$3;
    }

    T get() {
        return this.contextProvider.apply(this);
    }

    public CommandSourceStack source() {
        return this.source;
    }

    @Override
    public Stream<TestFunction> findTestFunctions() {
        return this.testFunctionFinder.findTestFunctions();
    }

    public static class Builder<T> {
        private final Function<TestFinder<T>, T> contextProvider;
        private final UnaryOperator<Supplier<Stream<TestFunction>>> testFunctionFinderWrapper;
        private final UnaryOperator<Supplier<Stream<BlockPos>>> structureBlockPosFinderWrapper;

        public Builder(Function<TestFinder<T>, T> $$02) {
            this.contextProvider = $$02;
            this.testFunctionFinderWrapper = $$0 -> $$0;
            this.structureBlockPosFinderWrapper = $$0 -> $$0;
        }

        private Builder(Function<TestFinder<T>, T> $$0, UnaryOperator<Supplier<Stream<TestFunction>>> $$1, UnaryOperator<Supplier<Stream<BlockPos>>> $$2) {
            this.contextProvider = $$0;
            this.testFunctionFinderWrapper = $$1;
            this.structureBlockPosFinderWrapper = $$2;
        }

        public Builder<T> createMultipleCopies(int $$0) {
            return new Builder<T>(this.contextProvider, Builder.createCopies($$0), Builder.createCopies($$0));
        }

        private static <Q> UnaryOperator<Supplier<Stream<Q>>> createCopies(int $$0) {
            return $$1 -> {
                LinkedList $$2 = new LinkedList();
                List $$3 = ((Stream)$$1.get()).toList();
                for (int $$4 = 0; $$4 < $$0; ++$$4) {
                    $$2.addAll($$3);
                }
                return $$2::stream;
            };
        }

        private T build(CommandSourceStack $$0, TestFunctionFinder $$1, StructureBlockPosFinder $$2) {
            return new TestFinder<T>($$0, this.contextProvider, ((Supplier)((Supplier)this.testFunctionFinderWrapper.apply($$1::findTestFunctions)))::get, ((Supplier)((Supplier)this.structureBlockPosFinderWrapper.apply($$2::findStructureBlockPos)))::get).get();
        }

        public T radius(CommandContext<CommandSourceStack> $$0, int $$1) {
            CommandSourceStack $$2 = (CommandSourceStack)$$0.getSource();
            BlockPos $$3 = BlockPos.containing($$2.getPosition());
            return this.build($$2, NO_FUNCTIONS, () -> StructureUtils.findStructureBlocks($$3, $$1, $$2.getLevel()));
        }

        public T nearest(CommandContext<CommandSourceStack> $$0) {
            CommandSourceStack $$1 = (CommandSourceStack)$$0.getSource();
            BlockPos $$2 = BlockPos.containing($$1.getPosition());
            return this.build($$1, NO_FUNCTIONS, () -> StructureUtils.findNearestStructureBlock($$2, 15, $$1.getLevel()).stream());
        }

        public T allNearby(CommandContext<CommandSourceStack> $$0) {
            CommandSourceStack $$1 = (CommandSourceStack)$$0.getSource();
            BlockPos $$2 = BlockPos.containing($$1.getPosition());
            return this.build($$1, NO_FUNCTIONS, () -> StructureUtils.findStructureBlocks($$2, 200, $$1.getLevel()));
        }

        public T lookedAt(CommandContext<CommandSourceStack> $$0) {
            CommandSourceStack $$1 = (CommandSourceStack)$$0.getSource();
            return this.build($$1, NO_FUNCTIONS, () -> StructureUtils.lookedAtStructureBlockPos(BlockPos.containing($$1.getPosition()), $$1.getPlayer().getCamera(), $$1.getLevel()));
        }

        public T allTests(CommandContext<CommandSourceStack> $$0) {
            return this.build((CommandSourceStack)$$0.getSource(), () -> GameTestRegistry.getAllTestFunctions().stream().filter($$0 -> !$$0.manualOnly()), NO_STRUCTURES);
        }

        public T allTestsInClass(CommandContext<CommandSourceStack> $$0, String $$1) {
            return this.build((CommandSourceStack)$$0.getSource(), () -> GameTestRegistry.getTestFunctionsForClassName($$1).filter($$0 -> !$$0.manualOnly()), NO_STRUCTURES);
        }

        public T failedTests(CommandContext<CommandSourceStack> $$0, boolean $$1) {
            return this.build((CommandSourceStack)$$0.getSource(), () -> GameTestRegistry.getLastFailedTests().filter($$1 -> !$$1 || $$1.required()), NO_STRUCTURES);
        }

        public T byArgument(CommandContext<CommandSourceStack> $$0, String $$1) {
            return this.build((CommandSourceStack)$$0.getSource(), () -> Stream.of(TestFunctionArgument.getTestFunction($$0, $$1)), NO_STRUCTURES);
        }

        public T locateByName(CommandContext<CommandSourceStack> $$0, String $$1) {
            CommandSourceStack $$2 = (CommandSourceStack)$$0.getSource();
            BlockPos $$3 = BlockPos.containing($$2.getPosition());
            return this.build($$2, NO_FUNCTIONS, () -> StructureUtils.findStructureByTestFunction($$3, 1024, $$2.getLevel(), $$1));
        }

        public T failedTests(CommandContext<CommandSourceStack> $$0) {
            return this.failedTests($$0, false);
        }
    }
}

