/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.TagTypes;
import net.minecraft.nbt.TagVisitor;

public class CompoundTag
implements Tag {
    public static final Codec<CompoundTag> CODEC = Codec.PASSTHROUGH.comapFlatMap($$0 -> {
        Tag $$1 = (Tag)$$0.convert((DynamicOps)NbtOps.INSTANCE).getValue();
        if ($$1 instanceof CompoundTag) {
            CompoundTag $$2 = (CompoundTag)$$1;
            return DataResult.success((Object)($$2 == $$0.getValue() ? $$2.copy() : $$2));
        }
        return DataResult.error(() -> "Not a compound tag: " + String.valueOf($$1));
    }, $$0 -> new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)$$0.copy()));
    private static final int SELF_SIZE_IN_BYTES = 48;
    private static final int MAP_ENTRY_SIZE_IN_BYTES = 32;
    public static final TagType<CompoundTag> TYPE = new TagType.VariableSize<CompoundTag>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompoundTag load(DataInput $$0, NbtAccounter $$1) throws IOException {
            $$1.pushDepth();
            try {
                CompoundTag compoundTag = 1.loadCompound($$0, $$1);
                return compoundTag;
            }
            finally {
                $$1.popDepth();
            }
        }

        private static CompoundTag loadCompound(DataInput $$0, NbtAccounter $$1) throws IOException {
            byte $$3;
            $$1.accountBytes(48L);
            HashMap $$2 = Maps.newHashMap();
            while (($$3 = $$0.readByte()) != 0) {
                Tag $$5;
                String $$4 = 1.readString($$0, $$1);
                if ($$2.put($$4, $$5 = CompoundTag.readNamedTagData(TagTypes.getType($$3), $$4, $$0, $$1)) != null) continue;
                $$1.accountBytes(36L);
            }
            return new CompoundTag($$2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StreamTagVisitor.ValueResult parse(DataInput $$0, StreamTagVisitor $$1, NbtAccounter $$2) throws IOException {
            $$2.pushDepth();
            try {
                StreamTagVisitor.ValueResult valueResult = 1.parseCompound($$0, $$1, $$2);
                return valueResult;
            }
            finally {
                $$2.popDepth();
            }
        }

        private static StreamTagVisitor.ValueResult parseCompound(DataInput $$0, StreamTagVisitor $$1, NbtAccounter $$2) throws IOException {
            byte $$3;
            $$2.accountBytes(48L);
            block13: while (($$3 = $$0.readByte()) != 0) {
                TagType<?> $$4 = TagTypes.getType($$3);
                switch ($$1.visitEntry($$4)) {
                    case HALT: {
                        return StreamTagVisitor.ValueResult.HALT;
                    }
                    case BREAK: {
                        StringTag.skipString($$0);
                        $$4.skip($$0, $$2);
                        break block13;
                    }
                    case SKIP: {
                        StringTag.skipString($$0);
                        $$4.skip($$0, $$2);
                        continue block13;
                    }
                    default: {
                        String $$5 = 1.readString($$0, $$2);
                        switch ($$1.visitEntry($$4, $$5)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                            case BREAK: {
                                $$4.skip($$0, $$2);
                                break block13;
                            }
                            case SKIP: {
                                $$4.skip($$0, $$2);
                                continue block13;
                            }
                        }
                        $$2.accountBytes(36L);
                        switch ($$4.parse($$0, $$1, $$2)) {
                            case HALT: {
                                return StreamTagVisitor.ValueResult.HALT;
                            }
                        }
                        continue block13;
                    }
                }
            }
            if ($$3 != 0) {
                while (($$3 = $$0.readByte()) != 0) {
                    StringTag.skipString($$0);
                    TagTypes.getType($$3).skip($$0, $$2);
                }
            }
            return $$1.visitContainerEnd();
        }

        private static String readString(DataInput $$0, NbtAccounter $$1) throws IOException {
            String $$2 = $$0.readUTF();
            $$1.accountBytes(28L);
            $$1.accountBytes(2L, $$2.length());
            return $$2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void skip(DataInput $$0, NbtAccounter $$1) throws IOException {
            $$1.pushDepth();
            try {
                byte $$2;
                while (($$2 = $$0.readByte()) != 0) {
                    StringTag.skipString($$0);
                    TagTypes.getType($$2).skip($$0, $$1);
                }
            }
            finally {
                $$1.popDepth();
            }
        }

        @Override
        public String getName() {
            return "COMPOUND";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Compound";
        }

        @Override
        public /* synthetic */ Tag load(DataInput dataInput, NbtAccounter nbtAccounter) throws IOException {
            return this.load(dataInput, nbtAccounter);
        }
    };
    private final Map<String, Tag> tags;

    protected CompoundTag(Map<String, Tag> $$0) {
        this.tags = $$0;
    }

    public CompoundTag() {
        this(Maps.newHashMap());
    }

    @Override
    public void write(DataOutput $$0) throws IOException {
        for (String $$1 : this.tags.keySet()) {
            Tag $$2 = this.tags.get($$1);
            CompoundTag.writeNamedTag($$1, $$2, $$0);
        }
        $$0.writeByte(0);
    }

    @Override
    public int sizeInBytes() {
        int $$0 = 48;
        for (Map.Entry<String, Tag> $$1 : this.tags.entrySet()) {
            $$0 += 28 + 2 * $$1.getKey().length();
            $$0 += 36;
            $$0 += $$1.getValue().sizeInBytes();
        }
        return $$0;
    }

    public Set<String> getAllKeys() {
        return this.tags.keySet();
    }

    @Override
    public byte getId() {
        return 10;
    }

    public TagType<CompoundTag> getType() {
        return TYPE;
    }

    public int size() {
        return this.tags.size();
    }

    @Nullable
    public Tag put(String $$0, Tag $$1) {
        return this.tags.put($$0, $$1);
    }

    public void putByte(String $$0, byte $$1) {
        this.tags.put($$0, ByteTag.valueOf($$1));
    }

    public void putShort(String $$0, short $$1) {
        this.tags.put($$0, ShortTag.valueOf($$1));
    }

    public void putInt(String $$0, int $$1) {
        this.tags.put($$0, IntTag.valueOf($$1));
    }

    public void putLong(String $$0, long $$1) {
        this.tags.put($$0, LongTag.valueOf($$1));
    }

    public void putUUID(String $$0, UUID $$1) {
        this.tags.put($$0, NbtUtils.createUUID($$1));
    }

    public UUID getUUID(String $$0) {
        return NbtUtils.loadUUID(this.get($$0));
    }

    public boolean hasUUID(String $$0) {
        Tag $$1 = this.get($$0);
        return $$1 != null && $$1.getType() == IntArrayTag.TYPE && ((IntArrayTag)$$1).getAsIntArray().length == 4;
    }

    public void putFloat(String $$0, float $$1) {
        this.tags.put($$0, FloatTag.valueOf($$1));
    }

    public void putDouble(String $$0, double $$1) {
        this.tags.put($$0, DoubleTag.valueOf($$1));
    }

    public void putString(String $$0, String $$1) {
        this.tags.put($$0, StringTag.valueOf($$1));
    }

    public void putByteArray(String $$0, byte[] $$1) {
        this.tags.put($$0, new ByteArrayTag($$1));
    }

    public void putByteArray(String $$0, List<Byte> $$1) {
        this.tags.put($$0, new ByteArrayTag($$1));
    }

    public void putIntArray(String $$0, int[] $$1) {
        this.tags.put($$0, new IntArrayTag($$1));
    }

    public void putIntArray(String $$0, List<Integer> $$1) {
        this.tags.put($$0, new IntArrayTag($$1));
    }

    public void putLongArray(String $$0, long[] $$1) {
        this.tags.put($$0, new LongArrayTag($$1));
    }

    public void putLongArray(String $$0, List<Long> $$1) {
        this.tags.put($$0, new LongArrayTag($$1));
    }

    public void putBoolean(String $$0, boolean $$1) {
        this.tags.put($$0, ByteTag.valueOf($$1));
    }

    @Nullable
    public Tag get(String $$0) {
        return this.tags.get($$0);
    }

    public byte getTagType(String $$0) {
        Tag $$1 = this.tags.get($$0);
        if ($$1 == null) {
            return 0;
        }
        return $$1.getId();
    }

    public boolean contains(String $$0) {
        return this.tags.containsKey($$0);
    }

    public boolean contains(String $$0, int $$1) {
        byte $$2 = this.getTagType($$0);
        if ($$2 == $$1) {
            return true;
        }
        if ($$1 == 99) {
            return $$2 == 1 || $$2 == 2 || $$2 == 3 || $$2 == 4 || $$2 == 5 || $$2 == 6;
        }
        return false;
    }

    public byte getByte(String $$0) {
        try {
            if (this.contains($$0, 99)) {
                return ((NumericTag)this.tags.get($$0)).getAsByte();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public short getShort(String $$0) {
        try {
            if (this.contains($$0, 99)) {
                return ((NumericTag)this.tags.get($$0)).getAsShort();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public int getInt(String $$0) {
        try {
            if (this.contains($$0, 99)) {
                return ((NumericTag)this.tags.get($$0)).getAsInt();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0;
    }

    public long getLong(String $$0) {
        try {
            if (this.contains($$0, 99)) {
                return ((NumericTag)this.tags.get($$0)).getAsLong();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0L;
    }

    public float getFloat(String $$0) {
        try {
            if (this.contains($$0, 99)) {
                return ((NumericTag)this.tags.get($$0)).getAsFloat();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0f;
    }

    public double getDouble(String $$0) {
        try {
            if (this.contains($$0, 99)) {
                return ((NumericTag)this.tags.get($$0)).getAsDouble();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return 0.0;
    }

    public String getString(String $$0) {
        try {
            if (this.contains($$0, 8)) {
                return this.tags.get($$0).getAsString();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return "";
    }

    public byte[] getByteArray(String $$0) {
        try {
            if (this.contains($$0, 7)) {
                return ((ByteArrayTag)this.tags.get($$0)).getAsByteArray();
            }
        }
        catch (ClassCastException $$1) {
            throw new ReportedException(this.createReport($$0, ByteArrayTag.TYPE, $$1));
        }
        return new byte[0];
    }

    public int[] getIntArray(String $$0) {
        try {
            if (this.contains($$0, 11)) {
                return ((IntArrayTag)this.tags.get($$0)).getAsIntArray();
            }
        }
        catch (ClassCastException $$1) {
            throw new ReportedException(this.createReport($$0, IntArrayTag.TYPE, $$1));
        }
        return new int[0];
    }

    public long[] getLongArray(String $$0) {
        try {
            if (this.contains($$0, 12)) {
                return ((LongArrayTag)this.tags.get($$0)).getAsLongArray();
            }
        }
        catch (ClassCastException $$1) {
            throw new ReportedException(this.createReport($$0, LongArrayTag.TYPE, $$1));
        }
        return new long[0];
    }

    public CompoundTag getCompound(String $$0) {
        try {
            if (this.contains($$0, 10)) {
                return (CompoundTag)this.tags.get($$0);
            }
        }
        catch (ClassCastException $$1) {
            throw new ReportedException(this.createReport($$0, TYPE, $$1));
        }
        return new CompoundTag();
    }

    public ListTag getList(String $$0, int $$1) {
        try {
            if (this.getTagType($$0) == 9) {
                ListTag $$2 = (ListTag)this.tags.get($$0);
                if ($$2.isEmpty() || $$2.getElementType() == $$1) {
                    return $$2;
                }
                return new ListTag();
            }
        }
        catch (ClassCastException $$3) {
            throw new ReportedException(this.createReport($$0, ListTag.TYPE, $$3));
        }
        return new ListTag();
    }

    public boolean getBoolean(String $$0) {
        return this.getByte($$0) != 0;
    }

    public void remove(String $$0) {
        this.tags.remove($$0);
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    public boolean isEmpty() {
        return this.tags.isEmpty();
    }

    private CrashReport createReport(String $$0, TagType<?> $$1, ClassCastException $$2) {
        CrashReport $$3 = CrashReport.forThrowable($$2, "Reading NBT data");
        CrashReportCategory $$4 = $$3.addCategory("Corrupt NBT tag", 1);
        $$4.setDetail("Tag type found", () -> this.tags.get($$0).getType().getName());
        $$4.setDetail("Tag type expected", $$1::getName);
        $$4.setDetail("Tag name", $$0);
        return $$3;
    }

    protected CompoundTag shallowCopy() {
        return new CompoundTag(new HashMap<String, Tag>(this.tags));
    }

    @Override
    public CompoundTag copy() {
        HashMap $$0 = Maps.newHashMap((Map)Maps.transformValues(this.tags, Tag::copy));
        return new CompoundTag($$0);
    }

    public boolean equals(Object $$0) {
        if (this == $$0) {
            return true;
        }
        return $$0 instanceof CompoundTag && Objects.equals(this.tags, ((CompoundTag)$$0).tags);
    }

    public int hashCode() {
        return this.tags.hashCode();
    }

    private static void writeNamedTag(String $$0, Tag $$1, DataOutput $$2) throws IOException {
        $$2.writeByte($$1.getId());
        if ($$1.getId() == 0) {
            return;
        }
        $$2.writeUTF($$0);
        $$1.write($$2);
    }

    static Tag readNamedTagData(TagType<?> $$0, String $$1, DataInput $$2, NbtAccounter $$3) {
        try {
            return $$0.load($$2, $$3);
        }
        catch (IOException $$4) {
            CrashReport $$5 = CrashReport.forThrowable($$4, "Loading NBT data");
            CrashReportCategory $$6 = $$5.addCategory("NBT Tag");
            $$6.setDetail("Tag name", $$1);
            $$6.setDetail("Tag type", $$0.getName());
            throw new ReportedNbtException($$5);
        }
    }

    public CompoundTag merge(CompoundTag $$0) {
        for (String $$1 : $$0.tags.keySet()) {
            Tag $$2 = $$0.tags.get($$1);
            if ($$2.getId() == 10) {
                if (this.contains($$1, 10)) {
                    CompoundTag $$3 = this.getCompound($$1);
                    $$3.merge((CompoundTag)$$2);
                    continue;
                }
                this.put($$1, $$2.copy());
                continue;
            }
            this.put($$1, $$2.copy());
        }
        return this;
    }

    @Override
    public void accept(TagVisitor $$0) {
        $$0.visitCompound(this);
    }

    protected Set<Map.Entry<String, Tag>> entrySet() {
        return this.tags.entrySet();
    }

    @Override
    public StreamTagVisitor.ValueResult accept(StreamTagVisitor $$0) {
        block14: for (Map.Entry<String, Tag> $$1 : this.tags.entrySet()) {
            Tag $$2 = $$1.getValue();
            TagType<?> $$3 = $$2.getType();
            StreamTagVisitor.EntryResult $$4 = $$0.visitEntry($$3);
            switch ($$4) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return $$0.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            $$4 = $$0.visitEntry($$3, $$1.getKey());
            switch ($$4) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return $$0.visitContainerEnd();
                }
                case SKIP: {
                    continue block14;
                }
            }
            StreamTagVisitor.ValueResult $$5 = $$2.accept($$0);
            switch ($$5) {
                case HALT: {
                    return StreamTagVisitor.ValueResult.HALT;
                }
                case BREAK: {
                    return $$0.visitContainerEnd();
                }
            }
        }
        return $$0.visitContainerEnd();
    }

    @Override
    public /* synthetic */ Tag copy() {
        return this.copy();
    }
}

