/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.StringRepresentable;

public class ClickEvent {
    public static final Codec<ClickEvent> CODEC = RecordCodecBuilder.create($$02 -> $$02.group((App)Action.CODEC.forGetter($$0 -> $$0.action), (App)Codec.STRING.fieldOf("value").forGetter($$0 -> $$0.value)).apply((Applicative)$$02, ClickEvent::new));
    private final Action action;
    private final String value;

    public ClickEvent(Action $$0, String $$1) {
        this.action = $$0;
        this.value = $$1;
    }

    public Action getAction() {
        return this.action;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object $$0) {
        if (this == $$0) {
            return true;
        }
        if ($$0 == null || this.getClass() != $$0.getClass()) {
            return false;
        }
        ClickEvent $$1 = (ClickEvent)$$0;
        return this.action == $$1.action && this.value.equals($$1.value);
    }

    public String toString() {
        return "ClickEvent{action=" + String.valueOf(this.action) + ", value='" + this.value + "'}";
    }

    public int hashCode() {
        int $$0 = this.action.hashCode();
        $$0 = 31 * $$0 + this.value.hashCode();
        return $$0;
    }

    public static enum Action implements StringRepresentable
    {
        OPEN_URL("open_url", true),
        OPEN_FILE("open_file", false),
        RUN_COMMAND("run_command", true),
        SUGGEST_COMMAND("suggest_command", true),
        CHANGE_PAGE("change_page", true),
        COPY_TO_CLIPBOARD("copy_to_clipboard", true);

        public static final MapCodec<Action> UNSAFE_CODEC;
        public static final MapCodec<Action> CODEC;
        private final boolean allowFromServer;
        private final String name;

        private Action(String $$0, boolean $$1) {
            this.name = $$0;
            this.allowFromServer = $$1;
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static DataResult<Action> filterForSerialization(Action $$0) {
            if (!$$0.isAllowedFromServer()) {
                return DataResult.error(() -> "Action not allowed: " + String.valueOf($$0));
            }
            return DataResult.success((Object)$$0, (Lifecycle)Lifecycle.stable());
        }

        static {
            UNSAFE_CODEC = StringRepresentable.fromEnum(Action::values).fieldOf("action");
            CODEC = UNSAFE_CODEC.validate(Action::filterForSerialization);
        }
    }
}

