/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class MushroomCow
extends Cow
implements Shearable,
VariantHolder<Variant> {
    private static final EntityDataAccessor<String> DATA_TYPE = SynchedEntityData.defineId(MushroomCow.class, EntityDataSerializers.STRING);
    private static final int MUTATE_CHANCE = 1024;
    private static final String TAG_STEW_EFFECTS = "stew_effects";
    @Nullable
    private SuspiciousStewEffects stewEffects;
    @Nullable
    private UUID lastLightningBoltUUID;

    public MushroomCow(EntityType<? extends MushroomCow> $$0, Level $$1) {
        super((EntityType<? extends Cow>)$$0, $$1);
    }

    @Override
    public float getWalkTargetValue(BlockPos $$0, LevelReader $$1) {
        if ($$1.getBlockState($$0.below()).is(Blocks.MYCELIUM)) {
            return 10.0f;
        }
        return $$1.getPathfindingCostFromLightLevels($$0);
    }

    public static boolean checkMushroomSpawnRules(EntityType<MushroomCow> $$0, LevelAccessor $$1, EntitySpawnReason $$2, BlockPos $$3, RandomSource $$4) {
        return $$1.getBlockState($$3.below()).is(BlockTags.MOOSHROOMS_SPAWNABLE_ON) && MushroomCow.isBrightEnoughToSpawn($$1, $$3);
    }

    @Override
    public void thunderHit(ServerLevel $$0, LightningBolt $$1) {
        UUID $$2 = $$1.getUUID();
        if (!$$2.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == Variant.RED ? Variant.BROWN : Variant.RED);
            this.lastLightningBoltUUID = $$2;
            this.playSound(SoundEvents.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder $$0) {
        super.defineSynchedData($$0);
        $$0.define(DATA_TYPE, Variant.RED.type);
    }

    @Override
    public InteractionResult mobInteract(Player $$0, InteractionHand $$1) {
        ItemStack $$2 = $$0.getItemInHand($$1);
        if ($$2.is(Items.BOWL) && !this.isBaby()) {
            SoundEvent $$8;
            ItemStack $$5;
            boolean $$3 = false;
            if (this.stewEffects != null) {
                $$3 = true;
                ItemStack $$4 = new ItemStack(Items.SUSPICIOUS_STEW);
                $$4.set(DataComponents.SUSPICIOUS_STEW_EFFECTS, this.stewEffects);
                this.stewEffects = null;
            } else {
                $$5 = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack $$6 = ItemUtils.createFilledResult($$2, $$0, $$5, false);
            $$0.setItemInHand($$1, $$6);
            if ($$3) {
                SoundEvent $$7 = SoundEvents.MOOSHROOM_MILK_SUSPICIOUSLY;
            } else {
                $$8 = SoundEvents.MOOSHROOM_MILK;
            }
            this.playSound($$8, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if ($$2.is(Items.SHEARS) && this.readyForShearing()) {
            Level $$3 = this.level();
            if ($$3 instanceof ServerLevel) {
                ServerLevel $$9 = (ServerLevel)$$3;
                this.shear($$9, SoundSource.PLAYERS, $$2);
                this.gameEvent(GameEvent.SHEAR, $$0);
                $$2.hurtAndBreak(1, $$0, MushroomCow.getSlotForHand($$1));
            }
            return InteractionResult.SUCCESS;
        }
        if (this.getVariant() == Variant.BROWN) {
            Optional<SuspiciousStewEffects> $$10 = this.getEffectsFromItemStack($$2);
            if ($$10.isEmpty()) {
                return super.mobInteract($$0, $$1);
            }
            if (this.stewEffects != null) {
                for (int $$11 = 0; $$11 < 2; ++$$11) {
                    this.level().addParticle(ParticleTypes.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                $$2.consume(1, $$0);
                for (int $$12 = 0; $$12 < 4; ++$$12) {
                    this.level().addParticle(ParticleTypes.EFFECT, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.stewEffects = $$10.get();
                this.playSound(SoundEvents.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract($$0, $$1);
    }

    @Override
    public void shear(ServerLevel $$0, SoundSource $$1, ItemStack $$22) {
        $$0.playSound(null, this, SoundEvents.MOOSHROOM_SHEAR, $$1, 1.0f, 1.0f);
        this.convertTo(EntityType.COW, ConversionParams.single(this, false, false), $$2 -> {
            $$0.sendParticles(ParticleTypes.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.dropFromShearingLootTable($$0, BuiltInLootTables.SHEAR_MOOSHROOM, $$22, ($$0, $$1) -> {
                for (Mob $$2 = 0; $$2 < $$1.getCount(); ++$$2) {
                    $$0.addFreshEntity(new ItemEntity(this.level(), this.getX(), this.getY(1.0), this.getZ(), $$1.copyWithCount(1)));
                }
            });
        });
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(CompoundTag $$0) {
        super.addAdditionalSaveData($$0);
        $$0.putString("Type", this.getVariant().getSerializedName());
        if (this.stewEffects != null) {
            SuspiciousStewEffects.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.stewEffects).ifSuccess($$1 -> $$0.put(TAG_STEW_EFFECTS, (Tag)$$1));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag $$02) {
        super.readAdditionalSaveData($$02);
        this.setVariant(Variant.byName($$02.getString("Type")));
        if ($$02.contains(TAG_STEW_EFFECTS, 9)) {
            SuspiciousStewEffects.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$02.get(TAG_STEW_EFFECTS)).ifSuccess($$0 -> {
                this.stewEffects = $$0;
            });
        }
    }

    private Optional<SuspiciousStewEffects> getEffectsFromItemStack(ItemStack $$0) {
        SuspiciousEffectHolder $$1 = SuspiciousEffectHolder.tryGet($$0.getItem());
        if ($$1 != null) {
            return Optional.of($$1.getSuspiciousEffects());
        }
        return Optional.empty();
    }

    @Override
    public void setVariant(Variant $$0) {
        this.entityData.set(DATA_TYPE, $$0.type);
    }

    @Override
    public Variant getVariant() {
        return Variant.byName(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public MushroomCow getBreedOffspring(ServerLevel $$0, AgeableMob $$1) {
        MushroomCow $$2 = EntityType.MOOSHROOM.create($$0, EntitySpawnReason.BREEDING);
        if ($$2 != null) {
            $$2.setVariant(this.getOffspringVariant((MushroomCow)$$1));
        }
        return $$2;
    }

    private Variant getOffspringVariant(MushroomCow $$0) {
        Variant $$4;
        Variant $$2;
        Variant $$1 = this.getVariant();
        if ($$1 == ($$2 = $$0.getVariant()) && this.random.nextInt(1024) == 0) {
            Variant $$3 = $$1 == Variant.BROWN ? Variant.RED : Variant.BROWN;
        } else {
            $$4 = this.random.nextBoolean() ? $$1 : $$2;
        }
        return $$4;
    }

    @Override
    @Nullable
    public /* synthetic */ Cow getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }

    @Override
    @Nullable
    public /* synthetic */ AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.getBreedOffspring(serverLevel, ageableMob);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    public static enum Variant implements StringRepresentable
    {
        RED("red", Blocks.RED_MUSHROOM.defaultBlockState()),
        BROWN("brown", Blocks.BROWN_MUSHROOM.defaultBlockState());

        public static final StringRepresentable.EnumCodec<Variant> CODEC;
        final String type;
        private final BlockState blockState;

        private Variant(String $$0, BlockState $$1) {
            this.type = $$0;
            this.blockState = $$1;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        static Variant byName(String $$0) {
            return CODEC.byName($$0, RED);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Variant::values);
        }
    }
}

