/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SmithingRecipeDisplay;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.item.equipment.trim.TrimPattern;
import net.minecraft.world.item.equipment.trim.TrimPatterns;

public class SmithingTrimRecipe
implements SmithingRecipe {
    final Optional<Ingredient> template;
    final Optional<Ingredient> base;
    final Optional<Ingredient> addition;
    @Nullable
    private PlacementInfo placementInfo;

    public SmithingTrimRecipe(Optional<Ingredient> $$0, Optional<Ingredient> $$1, Optional<Ingredient> $$2) {
        this.template = $$0;
        this.base = $$1;
        this.addition = $$2;
    }

    @Override
    public ItemStack assemble(SmithingRecipeInput $$0, HolderLookup.Provider $$1) {
        return SmithingTrimRecipe.applyTrim($$1, $$0.base(), $$0.addition(), $$0.template());
    }

    public static ItemStack applyTrim(HolderLookup.Provider $$0, ItemStack $$1, ItemStack $$2, ItemStack $$3) {
        Optional<Holder.Reference<TrimMaterial>> $$4 = TrimMaterials.getFromIngredient($$0, $$2);
        Optional<Holder.Reference<TrimPattern>> $$5 = TrimPatterns.getFromTemplate($$0, $$3);
        if ($$4.isPresent() && $$5.isPresent()) {
            ArmorTrim $$6 = $$1.get(DataComponents.TRIM);
            if ($$6 != null && $$6.hasPatternAndMaterial((Holder<TrimPattern>)$$5.get(), (Holder<TrimMaterial>)$$4.get())) {
                return ItemStack.EMPTY;
            }
            ItemStack $$7 = $$1.copyWithCount(1);
            $$7.set(DataComponents.TRIM, new ArmorTrim((Holder<TrimMaterial>)$$4.get(), (Holder<TrimPattern>)$$5.get()));
            return $$7;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Optional<Ingredient> templateIngredient() {
        return this.template;
    }

    @Override
    public Optional<Ingredient> baseIngredient() {
        return this.base;
    }

    @Override
    public Optional<Ingredient> additionIngredient() {
        return this.addition;
    }

    @Override
    public RecipeSerializer<SmithingTrimRecipe> getSerializer() {
        return RecipeSerializer.SMITHING_TRIM;
    }

    @Override
    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.createFromOptionals(List.of(this.template, this.base, this.addition));
        }
        return this.placementInfo;
    }

    @Override
    public List<RecipeDisplay> display() {
        SlotDisplay $$0 = Ingredient.optionalIngredientToDisplay(this.base);
        SlotDisplay $$1 = Ingredient.optionalIngredientToDisplay(this.addition);
        SlotDisplay $$2 = Ingredient.optionalIngredientToDisplay(this.template);
        return List.of(new SmithingRecipeDisplay($$2, $$0, $$1, new SlotDisplay.SmithingTrimDemoSlotDisplay($$0, $$1, $$2), new SlotDisplay.ItemSlotDisplay(Items.SMITHING_TABLE)));
    }

    public static class Serializer
    implements RecipeSerializer<SmithingTrimRecipe> {
        private static final MapCodec<SmithingTrimRecipe> CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)Ingredient.CODEC.optionalFieldOf("template").forGetter($$0 -> $$0.template), (App)Ingredient.CODEC.optionalFieldOf("base").forGetter($$0 -> $$0.base), (App)Ingredient.CODEC.optionalFieldOf("addition").forGetter($$0 -> $$0.addition)).apply((Applicative)$$02, SmithingTrimRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> STREAM_CODEC = StreamCodec.composite(Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, $$0 -> $$0.template, Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, $$0 -> $$0.base, Ingredient.OPTIONAL_CONTENTS_STREAM_CODEC, $$0 -> $$0.addition, SmithingTrimRecipe::new);

        @Override
        public MapCodec<SmithingTrimRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SmithingTrimRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

