/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public record PotDecorations(Optional<Item> back, Optional<Item> left, Optional<Item> right, Optional<Item> front) {
    public static final PotDecorations EMPTY = new PotDecorations(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    public static final Codec<PotDecorations> CODEC = BuiltInRegistries.ITEM.byNameCodec().sizeLimitedListOf(4).xmap(PotDecorations::new, PotDecorations::ordered);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotDecorations> STREAM_CODEC = ByteBufCodecs.registry(Registries.ITEM).apply(ByteBufCodecs.list(4)).map(PotDecorations::new, PotDecorations::ordered);

    private PotDecorations(List<Item> $$0) {
        this(PotDecorations.getItem($$0, 0), PotDecorations.getItem($$0, 1), PotDecorations.getItem($$0, 2), PotDecorations.getItem($$0, 3));
    }

    public PotDecorations(Item $$0, Item $$1, Item $$2, Item $$3) {
        this(List.of($$0, $$1, $$2, $$3));
    }

    private static Optional<Item> getItem(List<Item> $$0, int $$1) {
        if ($$1 >= $$0.size()) {
            return Optional.empty();
        }
        Item $$2 = $$0.get($$1);
        return $$2 == Items.BRICK ? Optional.empty() : Optional.of($$2);
    }

    public CompoundTag save(CompoundTag $$0) {
        if (this.equals(EMPTY)) {
            return $$0;
        }
        $$0.put("sherds", (Tag)CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this).getOrThrow());
        return $$0;
    }

    public List<Item> ordered() {
        return Stream.of(this.back, this.left, this.right, this.front).map($$0 -> $$0.orElse(Items.BRICK)).toList();
    }

    public static PotDecorations load(@Nullable CompoundTag $$0) {
        if ($$0 == null || !$$0.contains("sherds")) {
            return EMPTY;
        }
        return CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)$$0.get("sherds")).result().orElse(EMPTY);
    }
}

