/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.Iterables;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.FastBufferedInputStream;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.slf4j.Logger;

public class DimensionDataStorage
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, Optional<SavedData>> cache = new HashMap<String, Optional<SavedData>>();
    private final DataFixer fixerUpper;
    private final HolderLookup.Provider registries;
    private final Path dataFolder;
    private CompletableFuture<?> pendingWriteFuture = CompletableFuture.completedFuture(null);

    public DimensionDataStorage(Path $$0, DataFixer $$1, HolderLookup.Provider $$2) {
        this.fixerUpper = $$1;
        this.dataFolder = $$0;
        this.registries = $$2;
    }

    private Path getDataFile(String $$0) {
        return this.dataFolder.resolve($$0 + ".dat");
    }

    public <T extends SavedData> T computeIfAbsent(SavedData.Factory<T> $$0, String $$1) {
        T $$2 = this.get($$0, $$1);
        if ($$2 != null) {
            return $$2;
        }
        SavedData $$3 = (SavedData)$$0.constructor().get();
        this.set($$1, $$3);
        return (T)$$3;
    }

    @Nullable
    public <T extends SavedData> T get(SavedData.Factory<T> $$0, String $$1) {
        Optional<SavedData> $$2 = this.cache.get($$1);
        if ($$2 == null) {
            $$2 = Optional.ofNullable(this.readSavedData($$0.deserializer(), $$0.type(), $$1));
            this.cache.put($$1, $$2);
        }
        return (T)((SavedData)$$2.orElse(null));
    }

    @Nullable
    private <T extends SavedData> T readSavedData(BiFunction<CompoundTag, HolderLookup.Provider, T> $$0, DataFixTypes $$1, String $$2) {
        try {
            Path $$3 = this.getDataFile($$2);
            if (Files.exists($$3, new LinkOption[0])) {
                CompoundTag $$4 = this.readTagFromDisk($$2, $$1, SharedConstants.getCurrentVersion().getDataVersion().getVersion());
                return (T)((SavedData)$$0.apply($$4.getCompound("data"), this.registries));
            }
        }
        catch (Exception $$5) {
            LOGGER.error("Error loading saved data: {}", (Object)$$2, (Object)$$5);
        }
        return null;
    }

    public void set(String $$0, SavedData $$1) {
        this.cache.put($$0, Optional.of($$1));
        $$1.setDirty();
    }

    /*
     * WARNING - void declaration
     */
    public CompoundTag readTagFromDisk(String $$0, DataFixTypes $$1, int $$2) throws IOException {
        try (InputStream $$3 = Files.newInputStream(this.getDataFile($$0), new OpenOption[0]);){
            CompoundTag compoundTag;
            try (PushbackInputStream $$4 = new PushbackInputStream(new FastBufferedInputStream($$3), 2);){
                void $$8;
                if (this.isGzip($$4)) {
                    CompoundTag $$5 = NbtIo.readCompressed($$4, NbtAccounter.unlimitedHeap());
                } else {
                    try (DataInputStream $$6 = new DataInputStream($$4);){
                        CompoundTag $$7 = NbtIo.read($$6);
                    }
                }
                int $$9 = NbtUtils.getDataVersion((CompoundTag)$$8, 1343);
                compoundTag = $$1.update(this.fixerUpper, (CompoundTag)$$8, $$9, $$2);
            }
            return compoundTag;
        }
    }

    private boolean isGzip(PushbackInputStream $$0) throws IOException {
        int $$4;
        byte[] $$1 = new byte[2];
        boolean $$2 = false;
        int $$3 = $$0.read($$1, 0, 2);
        if ($$3 == 2 && ($$4 = ($$1[1] & 0xFF) << 8 | $$1[0] & 0xFF) == 35615) {
            $$2 = true;
        }
        if ($$3 != 0) {
            $$0.unread($$1, 0, $$3);
        }
        return $$2;
    }

    public CompletableFuture<?> scheduleSave() {
        Map<Path, CompoundTag> $$0 = this.collectDirtyTagsToSave();
        if ($$0.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        int $$12 = Util.maxAllowedExecutorThreads();
        int $$2 = $$0.size();
        this.pendingWriteFuture = $$2 > $$12 ? this.pendingWriteFuture.thenCompose($$3 -> {
            ArrayList<CompletableFuture<Void>> $$4 = new ArrayList<CompletableFuture<Void>>($$12);
            int $$5 = Mth.positiveCeilDiv($$2, $$12);
            for (List $$6 : Iterables.partition($$0.entrySet(), (int)$$5)) {
                $$4.add(CompletableFuture.runAsync(() -> {
                    for (Map.Entry $$1 : $$6) {
                        DimensionDataStorage.tryWrite((Path)$$1.getKey(), (CompoundTag)$$1.getValue());
                    }
                }, Util.ioPool()));
            }
            return CompletableFuture.allOf((CompletableFuture[])$$4.toArray(CompletableFuture[]::new));
        }) : this.pendingWriteFuture.thenCompose($$1 -> CompletableFuture.allOf((CompletableFuture[])$$0.entrySet().stream().map($$0 -> CompletableFuture.runAsync(() -> DimensionDataStorage.tryWrite((Path)$$0.getKey(), (CompoundTag)$$0.getValue()), Util.ioPool())).toArray(CompletableFuture[]::new)));
        return this.pendingWriteFuture;
    }

    private Map<Path, CompoundTag> collectDirtyTagsToSave() {
        Object2ObjectArrayMap $$0 = new Object2ObjectArrayMap();
        this.cache.forEach((arg_0, arg_1) -> this.lambda$collectDirtyTagsToSave$8((Map)$$0, arg_0, arg_1));
        return $$0;
    }

    private static void tryWrite(Path $$0, CompoundTag $$1) {
        try {
            NbtIo.writeCompressed($$1, $$0);
        }
        catch (IOException $$2) {
            LOGGER.error("Could not save data to {}", (Object)$$0.getFileName(), (Object)$$2);
        }
    }

    public void saveAndJoin() {
        this.scheduleSave().join();
    }

    @Override
    public void close() {
        this.saveAndJoin();
    }

    private /* synthetic */ void lambda$collectDirtyTagsToSave$8(Map $$0, String $$1, Optional $$22) {
        $$22.filter(SavedData::isDirty).ifPresent($$2 -> $$0.put(this.getDataFile($$1), $$2.save(this.registries)));
    }
}

