/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.Team;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import org.slf4j.Logger;

public class ScoreboardSaveData
extends SavedData {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String FILE_ID = "scoreboard";
    private final Scoreboard scoreboard;

    public ScoreboardSaveData(Scoreboard $$0) {
        this.scoreboard = $$0;
    }

    public ScoreboardSaveData load(CompoundTag $$0, HolderLookup.Provider $$1) {
        this.loadObjectives($$0.getList("Objectives", 10), $$1);
        this.scoreboard.loadPlayerScores($$0.getList("PlayerScores", 10), $$1);
        if ($$0.contains("DisplaySlots", 10)) {
            this.loadDisplaySlots($$0.getCompound("DisplaySlots"));
        }
        if ($$0.contains("Teams", 9)) {
            this.loadTeams($$0.getList("Teams", 10), $$1);
        }
        return this;
    }

    private void loadTeams(ListTag $$0, HolderLookup.Provider $$1) {
        for (int $$2 = 0; $$2 < $$0.size(); ++$$2) {
            Team.CollisionRule $$11;
            Team.Visibility $$10;
            Team.Visibility $$9;
            MutableComponent $$8;
            MutableComponent $$7;
            CompoundTag $$3 = $$0.getCompound($$2);
            String $$4 = $$3.getString("Name");
            PlayerTeam $$5 = this.scoreboard.addPlayerTeam($$4);
            MutableComponent $$6 = Component.Serializer.fromJson($$3.getString("DisplayName"), $$1);
            if ($$6 != null) {
                $$5.setDisplayName($$6);
            }
            if ($$3.contains("TeamColor", 8)) {
                $$5.setColor(ChatFormatting.getByName($$3.getString("TeamColor")));
            }
            if ($$3.contains("AllowFriendlyFire", 99)) {
                $$5.setAllowFriendlyFire($$3.getBoolean("AllowFriendlyFire"));
            }
            if ($$3.contains("SeeFriendlyInvisibles", 99)) {
                $$5.setSeeFriendlyInvisibles($$3.getBoolean("SeeFriendlyInvisibles"));
            }
            if ($$3.contains("MemberNamePrefix", 8) && ($$7 = Component.Serializer.fromJson($$3.getString("MemberNamePrefix"), $$1)) != null) {
                $$5.setPlayerPrefix($$7);
            }
            if ($$3.contains("MemberNameSuffix", 8) && ($$8 = Component.Serializer.fromJson($$3.getString("MemberNameSuffix"), $$1)) != null) {
                $$5.setPlayerSuffix($$8);
            }
            if ($$3.contains("NameTagVisibility", 8) && ($$9 = Team.Visibility.byName($$3.getString("NameTagVisibility"))) != null) {
                $$5.setNameTagVisibility($$9);
            }
            if ($$3.contains("DeathMessageVisibility", 8) && ($$10 = Team.Visibility.byName($$3.getString("DeathMessageVisibility"))) != null) {
                $$5.setDeathMessageVisibility($$10);
            }
            if ($$3.contains("CollisionRule", 8) && ($$11 = Team.CollisionRule.byName($$3.getString("CollisionRule"))) != null) {
                $$5.setCollisionRule($$11);
            }
            this.loadTeamPlayers($$5, $$3.getList("Players", 8));
        }
    }

    private void loadTeamPlayers(PlayerTeam $$0, ListTag $$1) {
        for (int $$2 = 0; $$2 < $$1.size(); ++$$2) {
            this.scoreboard.addPlayerToTeam($$1.getString($$2), $$0);
        }
    }

    private void loadDisplaySlots(CompoundTag $$0) {
        for (String $$1 : $$0.getAllKeys()) {
            DisplaySlot $$2 = DisplaySlot.CODEC.byName($$1);
            if ($$2 == null) continue;
            String $$3 = $$0.getString($$1);
            Objective $$4 = this.scoreboard.getObjective($$3);
            this.scoreboard.setDisplayObjective($$2, $$4);
        }
    }

    private void loadObjectives(ListTag $$0, HolderLookup.Provider $$1) {
        for (int $$2 = 0; $$2 < $$0.size(); ++$$2) {
            CompoundTag $$3 = $$0.getCompound($$2);
            String $$4 = $$3.getString("CriteriaName");
            ObjectiveCriteria $$5 = ObjectiveCriteria.byName($$4).orElseGet(() -> {
                LOGGER.warn("Unknown scoreboard criteria {}, replacing with {}", (Object)$$4, (Object)ObjectiveCriteria.DUMMY.getName());
                return ObjectiveCriteria.DUMMY;
            });
            String $$6 = $$3.getString("Name");
            MutableComponent $$7 = Component.Serializer.fromJson($$3.getString("DisplayName"), $$1);
            ObjectiveCriteria.RenderType $$8 = ObjectiveCriteria.RenderType.byId($$3.getString("RenderType"));
            boolean $$9 = $$3.getBoolean("display_auto_update");
            NumberFormat $$10 = NumberFormatTypes.CODEC.parse($$1.createSerializationContext(NbtOps.INSTANCE), (Object)$$3.get("format")).result().orElse(null);
            this.scoreboard.addObjective($$6, $$5, $$7, $$8, $$9, $$10);
        }
    }

    @Override
    public CompoundTag save(CompoundTag $$0, HolderLookup.Provider $$1) {
        $$0.put("Objectives", this.saveObjectives($$1));
        $$0.put("PlayerScores", this.scoreboard.savePlayerScores($$1));
        $$0.put("Teams", this.saveTeams($$1));
        this.saveDisplaySlots($$0);
        return $$0;
    }

    private ListTag saveTeams(HolderLookup.Provider $$0) {
        ListTag $$1 = new ListTag();
        Collection<PlayerTeam> $$2 = this.scoreboard.getPlayerTeams();
        for (PlayerTeam $$3 : $$2) {
            CompoundTag $$4 = new CompoundTag();
            $$4.putString("Name", $$3.getName());
            $$4.putString("DisplayName", Component.Serializer.toJson($$3.getDisplayName(), $$0));
            if ($$3.getColor().getId() >= 0) {
                $$4.putString("TeamColor", $$3.getColor().getName());
            }
            $$4.putBoolean("AllowFriendlyFire", $$3.isAllowFriendlyFire());
            $$4.putBoolean("SeeFriendlyInvisibles", $$3.canSeeFriendlyInvisibles());
            $$4.putString("MemberNamePrefix", Component.Serializer.toJson($$3.getPlayerPrefix(), $$0));
            $$4.putString("MemberNameSuffix", Component.Serializer.toJson($$3.getPlayerSuffix(), $$0));
            $$4.putString("NameTagVisibility", $$3.getNameTagVisibility().name);
            $$4.putString("DeathMessageVisibility", $$3.getDeathMessageVisibility().name);
            $$4.putString("CollisionRule", $$3.getCollisionRule().name);
            ListTag $$5 = new ListTag();
            for (String $$6 : $$3.getPlayers()) {
                $$5.add(StringTag.valueOf($$6));
            }
            $$4.put("Players", $$5);
            $$1.add($$4);
        }
        return $$1;
    }

    private void saveDisplaySlots(CompoundTag $$0) {
        CompoundTag $$1 = new CompoundTag();
        for (DisplaySlot $$2 : DisplaySlot.values()) {
            Objective $$3 = this.scoreboard.getDisplayObjective($$2);
            if ($$3 == null) continue;
            $$1.putString($$2.getSerializedName(), $$3.getName());
        }
        if (!$$1.isEmpty()) {
            $$0.put("DisplaySlots", $$1);
        }
    }

    private ListTag saveObjectives(HolderLookup.Provider $$0) {
        ListTag $$12 = new ListTag();
        Collection<Objective> $$2 = this.scoreboard.getObjectives();
        for (Objective $$3 : $$2) {
            CompoundTag $$4 = new CompoundTag();
            $$4.putString("Name", $$3.getName());
            $$4.putString("CriteriaName", $$3.getCriteria().getName());
            $$4.putString("DisplayName", Component.Serializer.toJson($$3.getDisplayName(), $$0));
            $$4.putString("RenderType", $$3.getRenderType().getId());
            $$4.putBoolean("display_auto_update", $$3.displayAutoUpdate());
            NumberFormat $$5 = $$3.numberFormat();
            if ($$5 != null) {
                NumberFormatTypes.CODEC.encodeStart($$0.createSerializationContext(NbtOps.INSTANCE), (Object)$$5).ifSuccess($$1 -> $$4.put("format", (Tag)$$1));
            }
            $$12.add($$4);
        }
        return $$12;
    }
}

