/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.color.item.ItemTintSources;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BlockModelWrapper
implements ItemModel {
    public final BakedModel model;
    private final List<ItemTintSource> tints;

    BlockModelWrapper(BakedModel p_378436_, List<ItemTintSource> p_377381_) {
        this.model = p_378436_;
        this.tints = p_377381_;
    }

    public void update(ItemStackRenderState p_377049_, ItemStack p_378482_, ItemModelResolver p_377214_, ItemDisplayContext p_375691_, @Nullable ClientLevel p_376532_, @Nullable LivingEntity p_376906_, int p_377340_) {
        ItemStackRenderState.LayerRenderState itemstackrenderstate$layerrenderstate = p_377049_.newLayer();
        if (p_378482_.hasFoil()) {
            itemstackrenderstate$layerrenderstate.setFoilType(BlockModelWrapper.hasSpecialAnimatedTexture(p_378482_) ? ItemStackRenderState.FoilType.SPECIAL : ItemStackRenderState.FoilType.STANDARD);
        }
        int i = this.tints.size();
        int[] aint = itemstackrenderstate$layerrenderstate.prepareTintLayers(i);
        for (int j = 0; j < i; ++j) {
            aint[j] = this.tints.get(j).calculate(p_378482_, p_376532_, p_376906_);
        }
        RenderType rendertype = ItemBlockRenderTypes.getRenderType(p_378482_);
        itemstackrenderstate$layerrenderstate.setupBlockModel(this.model, rendertype);
    }

    private static boolean hasSpecialAnimatedTexture(ItemStack p_377482_) {
        return p_377482_.is(ItemTags.COMPASSES) || p_377482_.is(Items.CLOCK);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(ResourceLocation model, List<ItemTintSource> tints) implements ItemModel.Unbaked
    {
        public static final MapCodec<Unbaked> MAP_CODEC = RecordCodecBuilder.mapCodec(p_376987_ -> p_376987_.group((App)ResourceLocation.CODEC.fieldOf("model").forGetter(Unbaked::model), (App)ItemTintSources.CODEC.listOf().optionalFieldOf("tints", List.of()).forGetter(Unbaked::tints)).apply((Applicative)p_376987_, Unbaked::new));

        public void resolveDependencies(ResolvableModel.Resolver p_375708_) {
            p_375708_.resolve(this.model);
        }

        public ItemModel bake(ItemModel.BakingContext p_375857_) {
            BakedModel bakedmodel = p_375857_.bake(this.model);
            return new BlockModelWrapper(bakedmodel, this.tints);
        }

        public MapCodec<Unbaked> type() {
            return MAP_CODEC;
        }
    }
}

