/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.model;

import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.block.model.TextureSlots;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelDebugName;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.ResolvableModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface UnbakedModel
extends ResolvableModel {
    public static final boolean DEFAULT_AMBIENT_OCCLUSION = true;
    public static final GuiLight DEFAULT_GUI_LIGHT = GuiLight.SIDE;

    default public BakedModel bake(TextureSlots textures, ModelBaker baker, ModelState state) {
        return this.bake(textures, baker, state, this.getAmbientOcclusion(), this.getGuiLight().lightLikeBlock(), this.getTransforms());
    }

    public BakedModel bake(TextureSlots var1, ModelBaker var2, ModelState var3, boolean var4, boolean var5, ItemTransforms var6);

    @Nullable
    default public Boolean getAmbientOcclusion() {
        return null;
    }

    @Nullable
    default public GuiLight getGuiLight() {
        return null;
    }

    @Nullable
    default public ItemTransforms getTransforms() {
        return null;
    }

    default public TextureSlots.Data getTextureSlots() {
        return TextureSlots.Data.EMPTY;
    }

    @Nullable
    default public UnbakedModel getParent() {
        return null;
    }

    public static BakedModel bakeWithTopModelValues(UnbakedModel p_377580_, ModelBaker p_375760_, ModelState p_377199_) {
        TextureSlots textureslots = UnbakedModel.getTopTextureSlots(p_377580_, p_375760_.rootName());
        boolean flag = UnbakedModel.getTopAmbientOcclusion(p_377580_);
        boolean flag1 = UnbakedModel.getTopGuiLight(p_377580_).lightLikeBlock();
        ItemTransforms itemtransforms = UnbakedModel.getTopTransforms(p_377580_);
        return p_377580_.bake(textureslots, p_375760_, p_377199_, flag, flag1, itemtransforms);
    }

    public static TextureSlots getTopTextureSlots(UnbakedModel p_375427_, ModelDebugName p_378400_) {
        TextureSlots.Resolver textureslots$resolver = new TextureSlots.Resolver();
        while (p_375427_ != null) {
            textureslots$resolver.addLast(p_375427_.getTextureSlots());
            p_375427_ = p_375427_.getParent();
        }
        return textureslots$resolver.resolve(p_378400_);
    }

    public static boolean getTopAmbientOcclusion(UnbakedModel p_377158_) {
        while (p_377158_ != null) {
            Boolean obool = p_377158_.getAmbientOcclusion();
            if (obool != null) {
                return obool;
            }
            p_377158_ = p_377158_.getParent();
        }
        return true;
    }

    public static GuiLight getTopGuiLight(UnbakedModel p_375581_) {
        while (p_375581_ != null) {
            GuiLight unbakedmodel$guilight = p_375581_.getGuiLight();
            if (unbakedmodel$guilight != null) {
                return unbakedmodel$guilight;
            }
            p_375581_ = p_375581_.getParent();
        }
        return DEFAULT_GUI_LIGHT;
    }

    public static ItemTransform getTopTransform(UnbakedModel p_377137_, ItemDisplayContext p_376495_) {
        while (p_377137_ != null) {
            ItemTransform itemtransform;
            ItemTransforms itemtransforms = p_377137_.getTransforms();
            if (itemtransforms != null && (itemtransform = itemtransforms.getTransform(p_376495_)) != ItemTransform.NO_TRANSFORM) {
                return itemtransform;
            }
            p_377137_ = p_377137_.getParent();
        }
        return ItemTransform.NO_TRANSFORM;
    }

    public static ItemTransforms getTopTransforms(UnbakedModel p_377896_) {
        ItemTransform itemtransform = UnbakedModel.getTopTransform(p_377896_, ItemDisplayContext.THIRD_PERSON_LEFT_HAND);
        ItemTransform itemtransform1 = UnbakedModel.getTopTransform(p_377896_, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND);
        ItemTransform itemtransform2 = UnbakedModel.getTopTransform(p_377896_, ItemDisplayContext.FIRST_PERSON_LEFT_HAND);
        ItemTransform itemtransform3 = UnbakedModel.getTopTransform(p_377896_, ItemDisplayContext.FIRST_PERSON_RIGHT_HAND);
        ItemTransform itemtransform4 = UnbakedModel.getTopTransform(p_377896_, ItemDisplayContext.HEAD);
        ItemTransform itemtransform5 = UnbakedModel.getTopTransform(p_377896_, ItemDisplayContext.GUI);
        ItemTransform itemtransform6 = UnbakedModel.getTopTransform(p_377896_, ItemDisplayContext.GROUND);
        ItemTransform itemtransform7 = UnbakedModel.getTopTransform(p_377896_, ItemDisplayContext.FIXED);
        return new ItemTransforms(itemtransform, itemtransform1, itemtransform2, itemtransform3, itemtransform4, itemtransform5, itemtransform6, itemtransform7);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum GuiLight {
        FRONT("front"),
        SIDE("side");

        private final String name;

        private GuiLight(String p_377886_) {
            this.name = p_377886_;
        }

        public static GuiLight getByName(String p_378162_) {
            for (GuiLight unbakedmodel$guilight : GuiLight.values()) {
                if (!unbakedmodel$guilight.name.equals(p_378162_)) continue;
                return unbakedmodel$guilight;
            }
            throw new IllegalArgumentException("Invalid gui light: " + p_378162_);
        }

        public boolean lightLikeBlock() {
            return this == SIDE;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

