/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.gson.JsonParser;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class HoverEvent {
    public static final Codec<HoverEvent> CODEC = Codec.withAlternative((Codec)TypedHoverEvent.CODEC.codec(), (Codec)TypedHoverEvent.LEGACY_CODEC.codec()).xmap(HoverEvent::new, $$0 -> $$0.event);
    private final TypedHoverEvent<?> event;

    public <T> HoverEvent(Action<T> $$0, T $$1) {
        this(new TypedHoverEvent<T>($$0, $$1));
    }

    private HoverEvent(TypedHoverEvent<?> $$0) {
        this.event = $$0;
    }

    public Action<?> getAction() {
        return this.event.action;
    }

    @Nullable
    public <T> T getValue(Action<T> $$0) {
        if (this.event.action == $$0) {
            return $$0.cast(this.event.value);
        }
        return null;
    }

    public boolean equals(Object $$0) {
        if (this == $$0) {
            return true;
        }
        if ($$0 == null || this.getClass() != $$0.getClass()) {
            return false;
        }
        return ((HoverEvent)$$0).event.equals(this.event);
    }

    public String toString() {
        return this.event.toString();
    }

    public int hashCode() {
        return this.event.hashCode();
    }

    record TypedHoverEvent<T>(Action<T> action, T value) {
        public static final MapCodec<TypedHoverEvent<?>> CODEC = Action.CODEC.dispatchMap("action", TypedHoverEvent::action, $$0 -> $$0.codec);
        public static final MapCodec<TypedHoverEvent<?>> LEGACY_CODEC = Action.CODEC.dispatchMap("action", TypedHoverEvent::action, $$0 -> $$0.legacyCodec);
    }

    public static class Action<T>
    implements StringRepresentable {
        public static final Action<Component> SHOW_TEXT = new Action<Component>("show_text", true, ComponentSerialization.CODEC, ($$0, $$1) -> DataResult.success((Object)$$0));
        public static final Action<ItemStackInfo> SHOW_ITEM = new Action<ItemStackInfo>("show_item", true, ItemStackInfo.CODEC, ItemStackInfo::legacyCreate);
        public static final Action<EntityTooltipInfo> SHOW_ENTITY = new Action<EntityTooltipInfo>("show_entity", true, EntityTooltipInfo.CODEC, EntityTooltipInfo::legacyCreate);
        public static final Codec<Action<?>> UNSAFE_CODEC = StringRepresentable.fromValues(() -> new Action[]{SHOW_TEXT, SHOW_ITEM, SHOW_ENTITY});
        public static final Codec<Action<?>> CODEC = UNSAFE_CODEC.validate(Action::filterForSerialization);
        private final String name;
        private final boolean allowFromServer;
        final MapCodec<TypedHoverEvent<T>> codec;
        final MapCodec<TypedHoverEvent<T>> legacyCodec;

        public Action(String $$02, boolean $$1, Codec<T> $$2, final LegacyConverter<T> $$3) {
            this.name = $$02;
            this.allowFromServer = $$1;
            this.codec = $$2.xmap($$0 -> new TypedHoverEvent<Object>(this, $$0), $$0 -> $$0.value).fieldOf("contents");
            this.legacyCodec = new Codec<TypedHoverEvent<T>>(){

                public <D> DataResult<Pair<TypedHoverEvent<T>, D>> decode(DynamicOps<D> $$0, D $$1) {
                    return ComponentSerialization.CODEC.decode($$0, $$1).flatMap($$2 -> {
                        DataResult $$5;
                        if ($$0 instanceof RegistryOps) {
                            RegistryOps $$32 = (RegistryOps)$$0;
                            DataResult $$4 = $$3.parse((Component)$$2.getFirst(), $$32);
                        } else {
                            $$5 = $$3.parse((Component)$$2.getFirst(), null);
                        }
                        return $$5.map($$1 -> Pair.of(new TypedHoverEvent<Object>(this, $$1), (Object)$$2.getSecond()));
                    });
                }

                public <D> DataResult<D> encode(TypedHoverEvent<T> $$0, DynamicOps<D> $$1, D $$2) {
                    return DataResult.error(() -> "Can't encode in legacy format");
                }

                public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
                    return this.encode((TypedHoverEvent)object, dynamicOps, object2);
                }
            }.fieldOf("value");
        }

        public boolean isAllowedFromServer() {
            return this.allowFromServer;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        T cast(Object $$0) {
            return (T)$$0;
        }

        public String toString() {
            return "<action " + this.name + ">";
        }

        private static DataResult<Action<?>> filterForSerialization(@Nullable Action<?> $$0) {
            if ($$0 == null) {
                return DataResult.error(() -> "Unknown action");
            }
            if (!$$0.isAllowedFromServer()) {
                return DataResult.error(() -> "Action not allowed: " + String.valueOf($$0));
            }
            return DataResult.success($$0, (Lifecycle)Lifecycle.stable());
        }
    }

    public static interface LegacyConverter<T> {
        public DataResult<T> parse(Component var1, @Nullable RegistryOps<?> var2);
    }

    public static class ItemStackInfo {
        public static final Codec<ItemStackInfo> FULL_CODEC = ItemStack.CODEC.xmap(ItemStackInfo::new, ItemStackInfo::getItemStack);
        private static final Codec<ItemStackInfo> SIMPLE_CODEC = ItemStack.SIMPLE_ITEM_CODEC.xmap(ItemStackInfo::new, ItemStackInfo::getItemStack);
        public static final Codec<ItemStackInfo> CODEC = Codec.withAlternative(FULL_CODEC, SIMPLE_CODEC);
        private final Holder<Item> item;
        private final int count;
        private final DataComponentPatch components;
        @Nullable
        private ItemStack itemStack;

        ItemStackInfo(Holder<Item> $$0, int $$1, DataComponentPatch $$2) {
            this.item = $$0;
            this.count = $$1;
            this.components = $$2;
        }

        public ItemStackInfo(ItemStack $$0) {
            this($$0.getItemHolder(), $$0.getCount(), $$0.getComponentsPatch());
        }

        public boolean equals(Object $$0) {
            if (this == $$0) {
                return true;
            }
            if ($$0 == null || this.getClass() != $$0.getClass()) {
                return false;
            }
            ItemStackInfo $$1 = (ItemStackInfo)$$0;
            return this.count == $$1.count && this.item.equals($$1.item) && this.components.equals($$1.components);
        }

        public int hashCode() {
            int $$0 = this.item.hashCode();
            $$0 = 31 * $$0 + this.count;
            $$0 = 31 * $$0 + this.components.hashCode();
            return $$0;
        }

        public ItemStack getItemStack() {
            if (this.itemStack == null) {
                this.itemStack = new ItemStack(this.item, this.count, this.components);
            }
            return this.itemStack;
        }

        private static DataResult<ItemStackInfo> legacyCreate(Component $$0, @Nullable RegistryOps<?> $$1) {
            try {
                CompoundTag $$2 = TagParser.parseTag($$0.getString());
                NbtOps $$3 = $$1 != null ? $$1.withParent(NbtOps.INSTANCE) : NbtOps.INSTANCE;
                return ItemStack.CODEC.parse((DynamicOps)$$3, (Object)$$2).map(ItemStackInfo::new);
            }
            catch (CommandSyntaxException $$4) {
                return DataResult.error(() -> "Failed to parse item tag: " + $$4.getMessage());
            }
        }
    }

    public static class EntityTooltipInfo {
        public static final Codec<EntityTooltipInfo> CODEC = RecordCodecBuilder.create($$02 -> $$02.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("type").forGetter($$0 -> $$0.type), (App)UUIDUtil.LENIENT_CODEC.fieldOf("id").forGetter($$0 -> $$0.id), (App)ComponentSerialization.CODEC.lenientOptionalFieldOf("name").forGetter($$0 -> $$0.name)).apply((Applicative)$$02, EntityTooltipInfo::new));
        public final EntityType<?> type;
        public final UUID id;
        public final Optional<Component> name;
        @Nullable
        private List<Component> linesCache;

        public EntityTooltipInfo(EntityType<?> $$0, UUID $$1, @Nullable Component $$2) {
            this($$0, $$1, Optional.ofNullable($$2));
        }

        public EntityTooltipInfo(EntityType<?> $$0, UUID $$1, Optional<Component> $$2) {
            this.type = $$0;
            this.id = $$1;
            this.name = $$2;
        }

        public static DataResult<EntityTooltipInfo> legacyCreate(Component $$0, @Nullable RegistryOps<?> $$1) {
            try {
                CompoundTag $$22 = TagParser.parseTag($$0.getString());
                JsonOps $$3 = $$1 != null ? $$1.withParent(JsonOps.INSTANCE) : JsonOps.INSTANCE;
                DataResult $$4 = ComponentSerialization.CODEC.parse((DynamicOps)$$3, (Object)JsonParser.parseString((String)$$22.getString("name")));
                EntityType<?> $$5 = BuiltInRegistries.ENTITY_TYPE.getValue(ResourceLocation.parse($$22.getString("type")));
                UUID $$6 = UUID.fromString($$22.getString("id"));
                return $$4.map($$2 -> new EntityTooltipInfo($$5, $$6, (Component)$$2));
            }
            catch (Exception $$7) {
                return DataResult.error(() -> "Failed to parse tooltip: " + $$7.getMessage());
            }
        }

        public List<Component> getTooltipLines() {
            if (this.linesCache == null) {
                this.linesCache = new ArrayList<Component>();
                this.name.ifPresent(this.linesCache::add);
                this.linesCache.add(Component.translatable("gui.entity_tooltip.type", this.type.getDescription()));
                this.linesCache.add(Component.literal(this.id.toString()));
            }
            return this.linesCache;
        }

        public boolean equals(Object $$0) {
            if (this == $$0) {
                return true;
            }
            if ($$0 == null || this.getClass() != $$0.getClass()) {
                return false;
            }
            EntityTooltipInfo $$1 = (EntityTooltipInfo)$$0;
            return this.type.equals($$1.type) && this.id.equals($$1.id) && this.name.equals($$1.name);
        }

        public int hashCode() {
            int $$0 = this.type.hashCode();
            $$0 = 31 * $$0 + this.id.hashCode();
            $$0 = 31 * $$0 + this.name.hashCode();
            return $$0;
        }
    }
}

