/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.RecipeBookType;

public final class RecipeBookSettings {
    public static final StreamCodec<FriendlyByteBuf, RecipeBookSettings> STREAM_CODEC = StreamCodec.ofMember(RecipeBookSettings::write, RecipeBookSettings::read);
    private static final Map<RecipeBookType, Pair<String, String>> TAG_FIELDS = new HashMap<RecipeBookType, Pair<String, String>>((Map<RecipeBookType, Pair<String, String>>)ImmutableMap.of((Object)((Object)RecipeBookType.CRAFTING), (Object)Pair.of((Object)"isGuiOpen", (Object)"isFilteringCraftable"), (Object)((Object)RecipeBookType.FURNACE), (Object)Pair.of((Object)"isFurnaceGuiOpen", (Object)"isFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.BLAST_FURNACE), (Object)Pair.of((Object)"isBlastingFurnaceGuiOpen", (Object)"isBlastingFurnaceFilteringCraftable"), (Object)((Object)RecipeBookType.SMOKER), (Object)Pair.of((Object)"isSmokerGuiOpen", (Object)"isSmokerFilteringCraftable")));
    private final Map<RecipeBookType, TypeSettings> states;

    private RecipeBookSettings(Map<RecipeBookType, TypeSettings> p_12730_) {
        this.states = p_12730_;
    }

    public RecipeBookSettings() {
        this(new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class));
    }

    private TypeSettings getSettings(RecipeBookType p_361337_) {
        return this.states.getOrDefault((Object)p_361337_, TypeSettings.DEFAULT);
    }

    private void updateSettings(RecipeBookType p_363317_, UnaryOperator<TypeSettings> p_364138_) {
        this.states.compute(p_363317_, (p_358767_, p_358768_) -> {
            if (p_358768_ == null) {
                p_358768_ = TypeSettings.DEFAULT;
            }
            if ((p_358768_ = (TypeSettings)p_364138_.apply((TypeSettings)p_358768_)).equals(TypeSettings.DEFAULT)) {
                p_358768_ = null;
            }
            return p_358768_;
        });
    }

    public boolean isOpen(RecipeBookType p_12735_) {
        return this.getSettings((RecipeBookType)p_12735_).open;
    }

    public void setOpen(RecipeBookType p_12737_, boolean p_12738_) {
        this.updateSettings(p_12737_, p_358758_ -> p_358758_.setOpen(p_12738_));
    }

    public boolean isFiltering(RecipeBookType p_12755_) {
        return this.getSettings((RecipeBookType)p_12755_).filtering;
    }

    public void setFiltering(RecipeBookType p_12757_, boolean p_12758_) {
        this.updateSettings(p_12757_, p_358756_ -> p_358756_.setFiltering(p_12758_));
    }

    private static RecipeBookSettings read(FriendlyByteBuf p_12753_) {
        EnumMap<RecipeBookType, TypeSettings> map = new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class);
        for (RecipeBookType recipebooktype : RecipeBookType.values()) {
            boolean flag = p_12753_.readBoolean();
            boolean flag1 = p_12753_.readBoolean();
            if (!flag && !flag1) continue;
            map.put(recipebooktype, new TypeSettings(flag, flag1));
        }
        return new RecipeBookSettings(map);
    }

    private void write(FriendlyByteBuf p_12762_) {
        for (RecipeBookType recipebooktype : RecipeBookType.values()) {
            TypeSettings recipebooksettings$typesettings = this.states.getOrDefault((Object)recipebooktype, TypeSettings.DEFAULT);
            p_12762_.writeBoolean(recipebooksettings$typesettings.open);
            p_12762_.writeBoolean(recipebooksettings$typesettings.filtering);
        }
    }

    public static RecipeBookSettings read(CompoundTag p_12742_) {
        EnumMap<RecipeBookType, TypeSettings> map = new EnumMap<RecipeBookType, TypeSettings>(RecipeBookType.class);
        TAG_FIELDS.forEach((p_358764_, p_358765_) -> {
            boolean flag = p_12742_.getBoolean((String)p_358765_.getFirst());
            boolean flag1 = p_12742_.getBoolean((String)p_358765_.getSecond());
            if (flag || flag1) {
                map.put((RecipeBookType)((Object)p_358764_), new TypeSettings(flag, flag1));
            }
        });
        return new RecipeBookSettings(map);
    }

    public void write(CompoundTag p_12760_) {
        TAG_FIELDS.forEach((p_358760_, p_358761_) -> {
            TypeSettings recipebooksettings$typesettings = this.states.getOrDefault(p_358760_, TypeSettings.DEFAULT);
            p_12760_.putBoolean((String)p_358761_.getFirst(), recipebooksettings$typesettings.open);
            p_12760_.putBoolean((String)p_358761_.getSecond(), recipebooksettings$typesettings.filtering);
        });
    }

    public RecipeBookSettings copy() {
        return new RecipeBookSettings(new EnumMap<RecipeBookType, TypeSettings>(this.states));
    }

    public void replaceFrom(RecipeBookSettings p_12733_) {
        this.states.clear();
        this.states.putAll(p_12733_.states);
    }

    public boolean equals(Object p_12764_) {
        return this == p_12764_ || p_12764_ instanceof RecipeBookSettings && this.states.equals(((RecipeBookSettings)p_12764_).states);
    }

    public int hashCode() {
        return this.states.hashCode();
    }

    public static void addTagsForType(RecipeBookType type, String openTag, String filteringTag) {
        TAG_FIELDS.put(type, (Pair<String, String>)Pair.of((Object)openTag, (Object)filteringTag));
    }

    record TypeSettings(boolean open, boolean filtering) {
        public static final TypeSettings DEFAULT = new TypeSettings(false, false);

        @Override
        public String toString() {
            return "[open=" + this.open + ", filtering=" + this.filtering + "]";
        }

        public TypeSettings setOpen(boolean p_363040_) {
            return new TypeSettings(p_363040_, this.filtering);
        }

        public TypeSettings setFiltering(boolean p_366242_) {
            return new TypeSettings(this.open, p_366242_);
        }
    }
}

