/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.ErrorCollector;
import net.minecraft.util.parsing.packrat.Rule;

public abstract class ParseState<S> {
    private final Map<CacheKey<?>, CacheEntry<?>> ruleCache = new HashMap();
    private final Dictionary<S> dictionary;
    private final ErrorCollector<S> errorCollector;

    protected ParseState(Dictionary<S> $$0, ErrorCollector<S> $$1) {
        this.dictionary = $$0;
        this.errorCollector = $$1;
    }

    public ErrorCollector<S> errorCollector() {
        return this.errorCollector;
    }

    public <T> Optional<T> parseTopRule(Atom<T> $$0) {
        Optional<T> $$1 = this.parse($$0);
        if ($$1.isPresent()) {
            this.errorCollector.finish(this.mark());
        }
        return $$1;
    }

    public <T> Optional<T> parse(Atom<T> $$0) {
        CacheKey<T> $$1 = new CacheKey<T>($$0, this.mark());
        CacheEntry<T> $$2 = this.lookupInCache($$1);
        if ($$2 != null) {
            this.restore($$2.mark());
            return $$2.value;
        }
        Rule<S, T> $$3 = this.dictionary.get($$0);
        if ($$3 == null) {
            throw new IllegalStateException("No symbol " + String.valueOf($$0));
        }
        Optional<T> $$4 = $$3.parse(this);
        this.storeInCache($$1, $$4);
        return $$4;
    }

    @Nullable
    private <T> CacheEntry<T> lookupInCache(CacheKey<T> $$0) {
        return this.ruleCache.get($$0);
    }

    private <T> void storeInCache(CacheKey<T> $$0, Optional<T> $$1) {
        this.ruleCache.put($$0, new CacheEntry<T>($$1, this.mark()));
    }

    public abstract S input();

    public abstract int mark();

    public abstract void restore(int var1);

    record CacheKey<T>(Atom<T> name, int mark) {
    }

    record CacheEntry<T>(Optional<T> value, int mark) {
    }
}

