/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;

public class PlayerEnderChestContainer
extends SimpleContainer {
    @Nullable
    private EnderChestBlockEntity activeChest;

    public PlayerEnderChestContainer() {
        super(27);
    }

    public void setActiveChest(EnderChestBlockEntity $$0) {
        this.activeChest = $$0;
    }

    public boolean isActiveChest(EnderChestBlockEntity $$0) {
        return this.activeChest == $$0;
    }

    @Override
    public void fromTag(ListTag $$0, HolderLookup.Provider $$1) {
        for (int $$2 = 0; $$2 < this.getContainerSize(); ++$$2) {
            this.setItem($$2, ItemStack.EMPTY);
        }
        for (int $$3 = 0; $$3 < $$0.size(); ++$$3) {
            CompoundTag $$4 = $$0.getCompound($$3);
            int $$5 = $$4.getByte("Slot") & 0xFF;
            if ($$5 < 0 || $$5 >= this.getContainerSize()) continue;
            this.setItem($$5, ItemStack.parse($$1, $$4).orElse(ItemStack.EMPTY));
        }
    }

    @Override
    public ListTag createTag(HolderLookup.Provider $$0) {
        ListTag $$1 = new ListTag();
        for (int $$2 = 0; $$2 < this.getContainerSize(); ++$$2) {
            ItemStack $$3 = this.getItem($$2);
            if ($$3.isEmpty()) continue;
            CompoundTag $$4 = new CompoundTag();
            $$4.putByte("Slot", (byte)$$2);
            $$1.add($$3.save($$0, $$4));
        }
        return $$1;
    }

    @Override
    public boolean stillValid(Player $$0) {
        if (this.activeChest != null && !this.activeChest.stillValid($$0)) {
            return false;
        }
        return super.stillValid($$0);
    }

    @Override
    public void startOpen(Player $$0) {
        if (this.activeChest != null) {
            this.activeChest.startOpen($$0);
        }
        super.startOpen($$0);
    }

    @Override
    public void stopOpen(Player $$0) {
        if (this.activeChest != null) {
            this.activeChest.stopOpen($$0);
        }
        super.stopOpen($$0);
        this.activeChest = null;
    }
}

