/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.math.Fraction;

public class BundleItem
extends Item {
    public static final int MAX_SHOWN_GRID_ITEMS_X = 4;
    public static final int MAX_SHOWN_GRID_ITEMS_Y = 3;
    public static final int MAX_SHOWN_GRID_ITEMS = 12;
    public static final int OVERFLOWING_MAX_SHOWN_GRID_ITEMS = 11;
    private static final int FULL_BAR_COLOR = ARGB.colorFromFloat(1.0f, 1.0f, 0.33f, 0.33f);
    private static final int BAR_COLOR = ARGB.colorFromFloat(1.0f, 0.44f, 0.53f, 1.0f);
    private static final int TICKS_AFTER_FIRST_THROW = 10;
    private static final int TICKS_BETWEEN_THROWS = 2;
    private static final int TICKS_MAX_THROW_DURATION = 200;

    public BundleItem(Item.Properties p_150726_) {
        super(p_150726_);
    }

    public static float getFullnessDisplay(ItemStack p_150767_) {
        BundleContents bundlecontents = (BundleContents)p_150767_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundlecontents.weight().floatValue();
    }

    @Override
    public boolean overrideStackedOnOther(ItemStack p_150733_, Slot p_150734_, ClickAction p_150735_, Player p_150736_) {
        BundleContents bundlecontents = (BundleContents)p_150733_.get(DataComponents.BUNDLE_CONTENTS);
        if (bundlecontents == null) {
            return false;
        }
        ItemStack itemstack = p_150734_.getItem();
        BundleContents.Mutable bundlecontents$mutable = new BundleContents.Mutable(bundlecontents);
        if (p_150735_ == ClickAction.PRIMARY && !itemstack.isEmpty()) {
            if (bundlecontents$mutable.tryTransfer(p_150734_, p_150736_) > 0) {
                BundleItem.playInsertSound(p_150736_);
            } else {
                BundleItem.playInsertFailSound(p_150736_);
            }
            p_150733_.set(DataComponents.BUNDLE_CONTENTS, bundlecontents$mutable.toImmutable());
            this.broadcastChangesOnContainerMenu(p_150736_);
            return true;
        }
        if (p_150735_ == ClickAction.SECONDARY && itemstack.isEmpty()) {
            ItemStack itemstack1 = bundlecontents$mutable.removeOne();
            if (itemstack1 != null) {
                ItemStack itemstack2 = p_150734_.safeInsert(itemstack1);
                if (itemstack2.getCount() > 0) {
                    bundlecontents$mutable.tryInsert(itemstack2);
                } else {
                    BundleItem.playRemoveOneSound(p_150736_);
                }
            }
            p_150733_.set(DataComponents.BUNDLE_CONTENTS, bundlecontents$mutable.toImmutable());
            this.broadcastChangesOnContainerMenu(p_150736_);
            return true;
        }
        return false;
    }

    @Override
    public boolean overrideOtherStackedOnMe(ItemStack p_150742_, ItemStack p_150743_, Slot p_150744_, ClickAction p_150745_, Player p_150746_, SlotAccess p_150747_) {
        if (p_150742_.getCount() != 1) {
            return false;
        }
        if (p_150745_ == ClickAction.PRIMARY && p_150743_.isEmpty()) {
            BundleItem.toggleSelectedItem(p_150742_, -1);
            return false;
        }
        BundleContents bundlecontents = (BundleContents)p_150742_.get(DataComponents.BUNDLE_CONTENTS);
        if (bundlecontents == null) {
            return false;
        }
        BundleContents.Mutable bundlecontents$mutable = new BundleContents.Mutable(bundlecontents);
        if (p_150745_ == ClickAction.PRIMARY && !p_150743_.isEmpty()) {
            if (p_150744_.allowModification(p_150746_) && bundlecontents$mutable.tryInsert(p_150743_) > 0) {
                BundleItem.playInsertSound(p_150746_);
            } else {
                BundleItem.playInsertFailSound(p_150746_);
            }
            p_150742_.set(DataComponents.BUNDLE_CONTENTS, bundlecontents$mutable.toImmutable());
            this.broadcastChangesOnContainerMenu(p_150746_);
            return true;
        }
        if (p_150745_ == ClickAction.SECONDARY && p_150743_.isEmpty()) {
            ItemStack itemstack;
            if (p_150744_.allowModification(p_150746_) && (itemstack = bundlecontents$mutable.removeOne()) != null) {
                BundleItem.playRemoveOneSound(p_150746_);
                p_150747_.set(itemstack);
            }
            p_150742_.set(DataComponents.BUNDLE_CONTENTS, bundlecontents$mutable.toImmutable());
            this.broadcastChangesOnContainerMenu(p_150746_);
            return true;
        }
        BundleItem.toggleSelectedItem(p_150742_, -1);
        return false;
    }

    @Override
    public InteractionResult use(Level p_150760_, Player p_150761_, InteractionHand p_150762_) {
        p_150761_.startUsingItem(p_150762_);
        return InteractionResult.SUCCESS;
    }

    private void dropContent(Level p_369525_, Player p_369321_, ItemStack p_365964_) {
        if (this.dropContent(p_365964_, p_369321_)) {
            BundleItem.playDropContentsSound(p_369525_, p_369321_);
            p_369321_.awardStat(Stats.ITEM_USED.get(this));
        }
    }

    @Override
    public boolean isBarVisible(ItemStack p_150769_) {
        BundleContents bundlecontents = (BundleContents)p_150769_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundlecontents.weight().compareTo(Fraction.ZERO) > 0;
    }

    @Override
    public int getBarWidth(ItemStack p_150771_) {
        BundleContents bundlecontents = (BundleContents)p_150771_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate(bundlecontents.weight(), 12), 13);
    }

    @Override
    public int getBarColor(ItemStack p_150773_) {
        BundleContents bundlecontents = (BundleContents)p_150773_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundlecontents.weight().compareTo(Fraction.ONE) >= 0 ? FULL_BAR_COLOR : BAR_COLOR;
    }

    public static void toggleSelectedItem(ItemStack p_369957_, int p_362067_) {
        BundleContents bundlecontents = (BundleContents)p_369957_.get(DataComponents.BUNDLE_CONTENTS);
        if (bundlecontents != null) {
            BundleContents.Mutable bundlecontents$mutable = new BundleContents.Mutable(bundlecontents);
            bundlecontents$mutable.toggleSelectedItem(p_362067_);
            p_369957_.set(DataComponents.BUNDLE_CONTENTS, bundlecontents$mutable.toImmutable());
        }
    }

    public static boolean hasSelectedItem(ItemStack p_369004_) {
        BundleContents bundlecontents = (BundleContents)p_369004_.get(DataComponents.BUNDLE_CONTENTS);
        return bundlecontents != null && bundlecontents.getSelectedItem() != -1;
    }

    public static int getSelectedItem(ItemStack p_368122_) {
        BundleContents bundlecontents = (BundleContents)p_368122_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundlecontents.getSelectedItem();
    }

    public static ItemStack getSelectedItemStack(ItemStack p_363510_) {
        BundleContents bundlecontents = (BundleContents)p_363510_.get(DataComponents.BUNDLE_CONTENTS);
        return bundlecontents != null && bundlecontents.getSelectedItem() != -1 ? bundlecontents.getItemUnsafe(bundlecontents.getSelectedItem()) : ItemStack.EMPTY;
    }

    public static int getNumberOfItemsToShow(ItemStack p_363807_) {
        BundleContents bundlecontents = (BundleContents)p_363807_.getOrDefault(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
        return bundlecontents.getNumberOfItemsToShow();
    }

    private boolean dropContent(ItemStack p_366961_, Player p_369586_) {
        BundleContents bundlecontents = (BundleContents)p_366961_.get(DataComponents.BUNDLE_CONTENTS);
        if (bundlecontents != null && !bundlecontents.isEmpty()) {
            Optional<ItemStack> optional = BundleItem.removeOneItemFromBundle(p_366961_, p_369586_, bundlecontents);
            if (optional.isPresent()) {
                p_369586_.drop(optional.get(), true);
                return true;
            }
            return false;
        }
        return false;
    }

    private static Optional<ItemStack> removeOneItemFromBundle(ItemStack p_366514_, Player p_363747_, BundleContents p_363035_) {
        BundleContents.Mutable bundlecontents$mutable = new BundleContents.Mutable(p_363035_);
        ItemStack itemstack = bundlecontents$mutable.removeOne();
        if (itemstack != null) {
            BundleItem.playRemoveOneSound(p_363747_);
            p_366514_.set(DataComponents.BUNDLE_CONTENTS, bundlecontents$mutable.toImmutable());
            return Optional.of(itemstack);
        }
        return Optional.empty();
    }

    @Override
    public void onUseTick(Level p_369274_, LivingEntity p_365864_, ItemStack p_364728_, int p_366618_) {
        if (p_365864_ instanceof Player) {
            boolean flag;
            Player player = (Player)p_365864_;
            int i = this.getUseDuration(p_364728_, p_365864_);
            boolean bl = flag = p_366618_ == i;
            if (flag || p_366618_ < i - 10 && p_366618_ % 2 == 0) {
                this.dropContent(p_369274_, player, p_364728_);
            }
        }
    }

    @Override
    public int getUseDuration(ItemStack p_363914_, LivingEntity p_368133_) {
        return 200;
    }

    @Override
    public ItemUseAnimation getUseAnimation(ItemStack p_376256_) {
        return ItemUseAnimation.BUNDLE;
    }

    @Override
    public Optional<TooltipComponent> getTooltipImage(ItemStack p_150775_) {
        return !p_150775_.has(DataComponents.HIDE_TOOLTIP) && !p_150775_.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((BundleContents)p_150775_.get(DataComponents.BUNDLE_CONTENTS)).map(BundleTooltip::new) : Optional.empty();
    }

    @Override
    public void onDestroyed(ItemEntity p_150728_) {
        BundleContents bundlecontents = (BundleContents)p_150728_.getItem().get(DataComponents.BUNDLE_CONTENTS);
        if (bundlecontents != null) {
            p_150728_.getItem().set(DataComponents.BUNDLE_CONTENTS, BundleContents.EMPTY);
            ItemUtils.onContainerDestroyed(p_150728_, bundlecontents.itemsCopy());
        }
    }

    public static List<BundleItem> getAllBundleItemColors() {
        return Stream.of(Items.BUNDLE, Items.WHITE_BUNDLE, Items.ORANGE_BUNDLE, Items.MAGENTA_BUNDLE, Items.LIGHT_BLUE_BUNDLE, Items.YELLOW_BUNDLE, Items.LIME_BUNDLE, Items.PINK_BUNDLE, Items.GRAY_BUNDLE, Items.LIGHT_GRAY_BUNDLE, Items.CYAN_BUNDLE, Items.BLACK_BUNDLE, Items.BROWN_BUNDLE, Items.GREEN_BUNDLE, Items.RED_BUNDLE, Items.BLUE_BUNDLE, Items.PURPLE_BUNDLE).map(p_359381_ -> (BundleItem)p_359381_).toList();
    }

    public static Item getByColor(DyeColor p_369131_) {
        return switch (p_369131_) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Items.WHITE_BUNDLE;
            case DyeColor.ORANGE -> Items.ORANGE_BUNDLE;
            case DyeColor.MAGENTA -> Items.MAGENTA_BUNDLE;
            case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_BUNDLE;
            case DyeColor.YELLOW -> Items.YELLOW_BUNDLE;
            case DyeColor.LIME -> Items.LIME_BUNDLE;
            case DyeColor.PINK -> Items.PINK_BUNDLE;
            case DyeColor.GRAY -> Items.GRAY_BUNDLE;
            case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_BUNDLE;
            case DyeColor.CYAN -> Items.CYAN_BUNDLE;
            case DyeColor.BLUE -> Items.BLUE_BUNDLE;
            case DyeColor.BROWN -> Items.BROWN_BUNDLE;
            case DyeColor.GREEN -> Items.GREEN_BUNDLE;
            case DyeColor.RED -> Items.RED_BUNDLE;
            case DyeColor.BLACK -> Items.BLACK_BUNDLE;
            case DyeColor.PURPLE -> Items.PURPLE_BUNDLE;
        };
    }

    private static void playRemoveOneSound(Entity p_186343_) {
        p_186343_.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + p_186343_.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertSound(Entity p_186352_) {
        p_186352_.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + p_186352_.level().getRandom().nextFloat() * 0.4f);
    }

    private static void playInsertFailSound(Entity p_367200_) {
        p_367200_.playSound(SoundEvents.BUNDLE_INSERT_FAIL, 1.0f, 1.0f);
    }

    private static void playDropContentsSound(Level p_362376_, Entity p_186354_) {
        p_362376_.playSound(null, p_186354_.blockPosition(), SoundEvents.BUNDLE_DROP_CONTENTS, SoundSource.PLAYERS, 0.8f, 0.8f + p_186354_.level().getRandom().nextFloat() * 0.4f);
    }

    private void broadcastChangesOnContainerMenu(Player p_365714_) {
        AbstractContainerMenu abstractcontainermenu = p_365714_.containerMenu;
        if (abstractcontainermenu != null) {
            abstractcontainermenu.slotsChanged(p_365714_.getInventory());
        }
    }
}

