/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;

public record EitherHolder<T>(Optional<Holder<T>> holder, ResourceKey<T> key) {
    public EitherHolder(Holder<T> $$0) {
        this(Optional.of($$0), $$0.unwrapKey().orElseThrow());
    }

    public EitherHolder(ResourceKey<T> $$0) {
        this(Optional.empty(), $$0);
    }

    public static <T> Codec<EitherHolder<T>> codec(ResourceKey<Registry<T>> $$02, Codec<Holder<T>> $$1) {
        return Codec.either($$1, (Codec)ResourceKey.codec($$02).comapFlatMap($$0 -> DataResult.error(() -> "Cannot parse as key without registry"), Function.identity())).xmap(EitherHolder::fromEither, EitherHolder::asEither);
    }

    public static <T> StreamCodec<RegistryFriendlyByteBuf, EitherHolder<T>> streamCodec(ResourceKey<Registry<T>> $$0, StreamCodec<RegistryFriendlyByteBuf, Holder<T>> $$1) {
        return StreamCodec.composite(ByteBufCodecs.either($$1, ResourceKey.streamCodec($$0)), EitherHolder::asEither, EitherHolder::fromEither);
    }

    public Either<Holder<T>, ResourceKey<T>> asEither() {
        return this.holder.map(Either::left).orElseGet(() -> Either.right(this.key));
    }

    public static <T> EitherHolder<T> fromEither(Either<Holder<T>, ResourceKey<T>> $$0) {
        return (EitherHolder)$$0.map(EitherHolder::new, EitherHolder::new);
    }

    public Optional<T> unwrap(Registry<T> $$0) {
        return this.holder.map(Holder::value).or(() -> $$0.getOptional(this.key));
    }

    public Optional<Holder<T>> unwrap(HolderLookup.Provider $$0) {
        return this.holder.or(() -> $$0.lookupOrThrow(this.key.registryKey()).get(this.key));
    }
}

