/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class ParticleLeavesBlock
extends LeavesBlock {
    public static final MapCodec<ParticleLeavesBlock> CODEC = RecordCodecBuilder.mapCodec($$02 -> $$02.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("chance").forGetter($$0 -> $$0.chance), (App)ParticleTypes.CODEC.fieldOf("particle").forGetter($$0 -> $$0.particle), ParticleLeavesBlock.propertiesCodec()).apply((Applicative)$$02, ParticleLeavesBlock::new));
    private final ParticleOptions particle;
    private final int chance;

    public MapCodec<ParticleLeavesBlock> codec() {
        return CODEC;
    }

    public ParticleLeavesBlock(int $$0, ParticleOptions $$1, BlockBehaviour.Properties $$2) {
        super($$2);
        this.chance = $$0;
        this.particle = $$1;
    }

    @Override
    public void animateTick(BlockState $$0, Level $$1, BlockPos $$2, RandomSource $$3) {
        super.animateTick($$0, $$1, $$2, $$3);
        if ($$3.nextInt(this.chance) != 0) {
            return;
        }
        BlockPos $$4 = $$2.below();
        BlockState $$5 = $$1.getBlockState($$4);
        if (ParticleLeavesBlock.isFaceFull($$5.getCollisionShape($$1, $$4), Direction.UP)) {
            return;
        }
        ParticleUtils.spawnParticleBelow($$1, $$2, $$3, this.particle);
    }
}

