/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.scores;

import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.numbers.NumberFormat;
import net.minecraft.network.chat.numbers.NumberFormatTypes;
import net.minecraft.world.scores.ReadOnlyScoreInfo;

public class Score
implements ReadOnlyScoreInfo {
    private static final String TAG_SCORE = "Score";
    private static final String TAG_LOCKED = "Locked";
    private static final String TAG_DISPLAY = "display";
    private static final String TAG_FORMAT = "format";
    private int value;
    private boolean locked = true;
    @Nullable
    private Component display;
    @Nullable
    private NumberFormat numberFormat;

    @Override
    public int value() {
        return this.value;
    }

    public void value(int $$0) {
        this.value = $$0;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean $$0) {
        this.locked = $$0;
    }

    @Nullable
    public Component display() {
        return this.display;
    }

    public void display(@Nullable Component $$0) {
        this.display = $$0;
    }

    @Override
    @Nullable
    public NumberFormat numberFormat() {
        return this.numberFormat;
    }

    public void numberFormat(@Nullable NumberFormat $$0) {
        this.numberFormat = $$0;
    }

    public CompoundTag write(HolderLookup.Provider $$0) {
        CompoundTag $$12 = new CompoundTag();
        $$12.putInt(TAG_SCORE, this.value);
        $$12.putBoolean(TAG_LOCKED, this.locked);
        if (this.display != null) {
            $$12.putString(TAG_DISPLAY, Component.Serializer.toJson(this.display, $$0));
        }
        if (this.numberFormat != null) {
            NumberFormatTypes.CODEC.encodeStart($$0.createSerializationContext(NbtOps.INSTANCE), (Object)this.numberFormat).ifSuccess($$1 -> $$12.put(TAG_FORMAT, (Tag)$$1));
        }
        return $$12;
    }

    public static Score read(CompoundTag $$0, HolderLookup.Provider $$12) {
        Score $$2 = new Score();
        $$2.value = $$0.getInt(TAG_SCORE);
        $$2.locked = $$0.getBoolean(TAG_LOCKED);
        if ($$0.contains(TAG_DISPLAY, 8)) {
            $$2.display = Component.Serializer.fromJson($$0.getString(TAG_DISPLAY), $$12);
        }
        if ($$0.contains(TAG_FORMAT, 10)) {
            NumberFormatTypes.CODEC.parse($$12.createSerializationContext(NbtOps.INSTANCE), (Object)$$0.get(TAG_FORMAT)).ifSuccess($$1 -> {
                $$0.numberFormat = $$1;
            });
        }
        return $$2;
    }
}

