// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	monitoringv1 "github.com/prometheus-operator/prometheus-operator/pkg/apis/monitoring/v1"
)

// QueueConfigApplyConfiguration represents a declarative configuration of the QueueConfig type for use
// with apply.
type QueueConfigApplyConfiguration struct {
	Capacity          *int                   `json:"capacity,omitempty"`
	MinShards         *int                   `json:"minShards,omitempty"`
	MaxShards         *int                   `json:"maxShards,omitempty"`
	MaxSamplesPerSend *int                   `json:"maxSamplesPerSend,omitempty"`
	BatchSendDeadline *monitoringv1.Duration `json:"batchSendDeadline,omitempty"`
	MaxRetries        *int                   `json:"maxRetries,omitempty"`
	MinBackoff        *monitoringv1.Duration `json:"minBackoff,omitempty"`
	MaxBackoff        *monitoringv1.Duration `json:"maxBackoff,omitempty"`
	RetryOnRateLimit  *bool                  `json:"retryOnRateLimit,omitempty"`
	SampleAgeLimit    *monitoringv1.Duration `json:"sampleAgeLimit,omitempty"`
}

// QueueConfigApplyConfiguration constructs a declarative configuration of the QueueConfig type for use with
// apply.
func QueueConfig() *QueueConfigApplyConfiguration {
	return &QueueConfigApplyConfiguration{}
}

// WithCapacity sets the Capacity field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Capacity field is set to the value of the last call.
func (b *QueueConfigApplyConfiguration) WithCapacity(value int) *QueueConfigApplyConfiguration {
	b.Capacity = &value
	return b
}

// WithMinShards sets the MinShards field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinShards field is set to the value of the last call.
func (b *QueueConfigApplyConfiguration) WithMinShards(value int) *QueueConfigApplyConfiguration {
	b.MinShards = &value
	return b
}

// WithMaxShards sets the MaxShards field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxShards field is set to the value of the last call.
func (b *QueueConfigApplyConfiguration) WithMaxShards(value int) *QueueConfigApplyConfiguration {
	b.MaxShards = &value
	return b
}

// WithMaxSamplesPerSend sets the MaxSamplesPerSend field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxSamplesPerSend field is set to the value of the last call.
func (b *QueueConfigApplyConfiguration) WithMaxSamplesPerSend(value int) *QueueConfigApplyConfiguration {
	b.MaxSamplesPerSend = &value
	return b
}

// WithBatchSendDeadline sets the BatchSendDeadline field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the BatchSendDeadline field is set to the value of the last call.
func (b *QueueConfigApplyConfiguration) WithBatchSendDeadline(value monitoringv1.Duration) *QueueConfigApplyConfiguration {
	b.BatchSendDeadline = &value
	return b
}

// WithMaxRetries sets the MaxRetries field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxRetries field is set to the value of the last call.
func (b *QueueConfigApplyConfiguration) WithMaxRetries(value int) *QueueConfigApplyConfiguration {
	b.MaxRetries = &value
	return b
}

// WithMinBackoff sets the MinBackoff field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MinBackoff field is set to the value of the last call.
func (b *QueueConfigApplyConfiguration) WithMinBackoff(value monitoringv1.Duration) *QueueConfigApplyConfiguration {
	b.MinBackoff = &value
	return b
}

// WithMaxBackoff sets the MaxBackoff field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the MaxBackoff field is set to the value of the last call.
func (b *QueueConfigApplyConfiguration) WithMaxBackoff(value monitoringv1.Duration) *QueueConfigApplyConfiguration {
	b.MaxBackoff = &value
	return b
}

// WithRetryOnRateLimit sets the RetryOnRateLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RetryOnRateLimit field is set to the value of the last call.
func (b *QueueConfigApplyConfiguration) WithRetryOnRateLimit(value bool) *QueueConfigApplyConfiguration {
	b.RetryOnRateLimit = &value
	return b
}

// WithSampleAgeLimit sets the SampleAgeLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SampleAgeLimit field is set to the value of the last call.
func (b *QueueConfigApplyConfiguration) WithSampleAgeLimit(value monitoringv1.Duration) *QueueConfigApplyConfiguration {
	b.SampleAgeLimit = &value
	return b
}
