/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\u0007\u001a\u0015\u0010\u0017\u001a\u00020\u0018*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0086\u0002\u001a\u0015\u0010\u001a\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0001H\u0086\u0002\u001a\u0015\u0010\u001a\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u001b\u001a\u00020\tH\u0086\u0002\u001a\u0015\u0010\u001a\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0006H\u0086\u0002\u001a\u0015\u0010\u001a\u001a\u00020\u0006*\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0006H\u0086\u0002\u001a\n\u0010\u001c\u001a\u00020\t*\u00020\u0006\u001a\n\u0010\u001d\u001a\u00020\t*\u00020\u0006\u001a\n\u0010\u001e\u001a\u00020\t*\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\n\"\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\"\u0015\u0010\u000b\u001a\u00020\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\"\u0015\u0010\r\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\"\u0015\u0010\r\u001a\u00020\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\"\u0015\u0010\u000f\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\"\u0015\u0010\u000f\u001a\u00020\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\"\u0015\u0010\u0011\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\b\"\u0015\u0010\u0011\u001a\u00020\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\n\"\u0015\u0010\u0013\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\b\"\u0015\u0010\u0013\u001a\u00020\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\n\"\u0015\u0010\u0015\u001a\u00020\u0006*\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\b\"\u0015\u0010\u0015\u001a\u00020\u0006*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\n\u00a8\u0006\u001f"}, d2={"MICROS_PER_SECOND", "", "NANOS_PER_MICRO", "NANOS_PER_MILLI", "NANOS_PER_SECOND", "days", "Ljava/time/Duration;", "getDays", "(I)Ljava/time/Duration;", "", "(J)Ljava/time/Duration;", "hours", "getHours", "micros", "getMicros", "mins", "getMins", "ms", "getMs", "nanos", "getNanos", "secs", "getSecs", "div", "", "other", "times", "x", "toMicros", "toRoundedMicros", "toRoundedMillis", "jitsi-utils"})
public final class DurationKt {
    private static final int NANOS_PER_MICRO = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final int MICROS_PER_SECOND = 1000000;
    private static final int NANOS_PER_SECOND = 1000000000;

    @NotNull
    public static final Duration getNanos(int $this$nanos) {
        Duration duration = Duration.ofNanos($this$nanos);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMicros(int $this$micros) {
        Duration duration = Duration.of($this$micros, ChronoUnit.MICROS);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"of(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMs(int $this$ms) {
        Duration duration = Duration.ofMillis($this$ms);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }

    @NotNull
    public static final Duration getSecs(int $this$secs) {
        Duration duration = Duration.ofSeconds($this$secs);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        return duration;
    }

    @NotNull
    public static final Duration getHours(int $this$hours) {
        Duration duration = Duration.ofHours($this$hours);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofHours(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMins(int $this$mins) {
        Duration duration = Duration.ofMinutes($this$mins);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        return duration;
    }

    @NotNull
    public static final Duration getDays(int $this$days) {
        Duration duration = Duration.ofDays($this$days);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(...)");
        return duration;
    }

    @NotNull
    public static final Duration getNanos(long $this$nanos) {
        Duration duration = Duration.ofNanos($this$nanos);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofNanos(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMicros(long $this$micros) {
        Duration duration = Duration.of($this$micros, ChronoUnit.MICROS);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"of(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMs(long $this$ms) {
        Duration duration = Duration.ofMillis($this$ms);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        return duration;
    }

    @NotNull
    public static final Duration getSecs(long $this$secs) {
        Duration duration = Duration.ofSeconds($this$secs);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        return duration;
    }

    @NotNull
    public static final Duration getHours(long $this$hours) {
        Duration duration = Duration.ofHours($this$hours);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofHours(...)");
        return duration;
    }

    @NotNull
    public static final Duration getMins(long $this$mins) {
        Duration duration = Duration.ofMinutes($this$mins);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(...)");
        return duration;
    }

    @NotNull
    public static final Duration getDays(long $this$days) {
        Duration duration = Duration.ofDays($this$days);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(...)");
        return duration;
    }

    @NotNull
    public static final Duration times(@NotNull Duration $this$times, int x) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Duration duration = $this$times.multipliedBy(x);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"multipliedBy(...)");
        return duration;
    }

    @NotNull
    public static final Duration times(@NotNull Duration $this$times, long x) {
        Intrinsics.checkNotNullParameter((Object)$this$times, (String)"<this>");
        Duration duration = $this$times.multipliedBy(x);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"multipliedBy(...)");
        return duration;
    }

    @NotNull
    public static final Duration times(int $this$times, @NotNull Duration x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Duration duration = x.multipliedBy($this$times);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"multipliedBy(...)");
        return duration;
    }

    @NotNull
    public static final Duration times(long $this$times, @NotNull Duration x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Duration duration = x.multipliedBy($this$times);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"multipliedBy(...)");
        return duration;
    }

    public static final double div(@NotNull Duration $this$div, @NotNull Duration other) {
        Intrinsics.checkNotNullParameter((Object)$this$div, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return (double)$this$div.toNanos() / (double)other.toNanos();
    }

    public static final long toRoundedMillis(@NotNull Duration $this$toRoundedMillis) {
        Intrinsics.checkNotNullParameter((Object)$this$toRoundedMillis, (String)"<this>");
        long millis = $this$toRoundedMillis.toMillis();
        int remainder = $this$toRoundedMillis.getNano() % 1000000;
        if (remainder > 499999) {
            long l = millis;
            millis = l + 1L;
        }
        return millis;
    }

    public static final long toMicros(@NotNull Duration $this$toMicros) {
        Intrinsics.checkNotNullParameter((Object)$this$toMicros, (String)"<this>");
        long tempSeconds = $this$toMicros.getSeconds();
        long tempNanos = $this$toMicros.getNano();
        if (tempSeconds < 0L) {
            ++tempSeconds;
            tempNanos -= (long)1000000000;
        }
        long micros = Math.multiplyExact(tempSeconds, 1000000);
        micros = Math.addExact(micros, tempNanos / (long)1000);
        return micros;
    }

    public static final long toRoundedMicros(@NotNull Duration $this$toRoundedMicros) {
        Intrinsics.checkNotNullParameter((Object)$this$toRoundedMicros, (String)"<this>");
        long micros = DurationKt.toMicros($this$toRoundedMicros);
        int remainder = $this$toRoundedMicros.getNano() % 1000;
        if (remainder > 499) {
            long l = micros;
            micros = l + 1L;
        }
        return micros;
    }
}

