/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec.av1;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.codec.VideoCodecParser;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.nlj.rtp.codec.av1.Av1DdInfo;
import org.jitsi.nlj.rtp.codec.av1.TemplateHistory;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtension;
import org.jitsi.rtp.rtp.header_extensions.Av1TemplateDependencyStructure;
import org.jitsi.rtp.rtp.header_extensions.FrameInfo;
import org.jitsi.utils.LRUCache;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/nlj/rtp/codec/av1/Av1DDParser;", "Lorg/jitsi/nlj/rtp/codec/VideoCodecParser;", "source", "Lorg/jitsi/nlj/MediaSourceDesc;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "<init>", "(Lorg/jitsi/nlj/MediaSourceDesc;Lorg/jitsi/utils/logging2/Logger;Lorg/jitsi/utils/logging/DiagnosticContext;)V", "logger", "ddStateHistory", "Lorg/jitsi/utils/LRUCache;", "", "Lorg/jitsi/nlj/rtp/codec/av1/TemplateHistory;", "createFrom", "Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;", "packet", "Lorg/jitsi/rtp/rtp/RtpPacket;", "av1DdExtId", "", "parse", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nAv1DDParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Av1DDParser.kt\norg/jitsi/nlj/rtp/codec/av1/Av1DDParser\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,180:1\n381#2,7:181\n*S KotlinDebug\n*F\n+ 1 Av1DDParser.kt\norg/jitsi/nlj/rtp/codec/av1/Av1DDParser\n*L\n49#1:181,7\n*E\n"})
public final class Av1DDParser
extends VideoCodecParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Logger logger;
    @NotNull
    private final LRUCache<Long, TemplateHistory> ddStateHistory;
    public static final int STATE_HISTORY_SIZE = 500;
    public static final int TEMPLATE_HISTORY_SIZE = 500;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(Av1DDParser.class);

    public Av1DDParser(@NotNull MediaSourceDesc source, @NotNull Logger parentLogger, @NotNull DiagnosticContext diagnosticContext) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        super(source);
        this.diagnosticContext = diagnosticContext;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.ddStateHistory = new LRUCache(500, true);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Av1DDPacket createFrom(@NotNull RtpPacket packet, int av1DdExtId) {
        Av1TemplateDependencyStructure newStructure;
        TemplateHistory history;
        Map.Entry<Integer, Av1DdInfo> priorEntry;
        Object object;
        Object object2;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Map map = (Map)this.ddStateHistory;
        Long key$iv = packet.getSsrc();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            TemplateHistory answer$iv = new TemplateHistory(500);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object2 = answer$iv;
        } else {
            object2 = value$iv;
        }
        Av1TemplateDependencyStructure priorStructure = (object = (priorEntry = (history = (TemplateHistory)object2).get(packet.getSequenceNumber()))) != null && (object = object.getValue()) != null && (object = ((Av1DdInfo)object).getStructure()) != null ? object.clone() : null;
        Av1DDPacket av1Packet = new Av1DDPacket(packet, av1DdExtId, priorStructure, this.logger);
        Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension = av1Packet.getDescriptor();
        Object object3 = newStructure = av1DependencyDescriptorHeaderExtension != null ? av1DependencyDescriptorHeaderExtension.getNewTemplateDependencyStructure() : null;
        if (newStructure != null) {
            boolean structureChanged = !(priorStructure != null ? newStructure.getTemplateIdOffset() == priorStructure.getTemplateIdOffset() : false);
            history.insert(packet.getSequenceNumber(), new Av1DdInfo(newStructure.clone(), structureChanged));
            this.logger.debug(() -> Av1DDParser.createFrom$lambda$1(newStructure, packet, structureChanged));
        }
        if (timeSeriesLogger.isTraceEnabled()) {
            Av1TemplateDependencyStructure packetStructure;
            Map.Entry<Integer, Av1DdInfo> entry = priorEntry;
            FrameInfo frameInfo = av1Packet.getFrameInfo();
            Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension2 = av1Packet.getDescriptor();
            DiagnosticContext.TimeSeriesPoint point = this.diagnosticContext.makeTimeSeriesPoint("av1_parser").addField("rtp.ssrc", (Object)packet.getSsrc()).addField("rtp.seq", (Object)packet.getSequenceNumber()).addField("rtp.timestamp", (Object)packet.getTimestamp()).addField("av1_parser.key", (Object)(entry != null ? entry.getKey() : null)).addField("av1.startOfFrame", (Object)av1Packet.getStatelessDescriptor().getStartOfFrame()).addField("av1.endOfFrame", (Object)av1Packet.getStatelessDescriptor().getEndOfFrame()).addField("av1.templateId", (Object)av1Packet.getStatelessDescriptor().getFrameDependencyTemplateId()).addField("av1.frameNum", (Object)av1Packet.getStatelessDescriptor().getFrameNumber()).addField("av1.frameInfo", (Object)(frameInfo != null ? frameInfo.toString() : null)).addField("av1.structure", (Object)(newStructure != null ? 1 : 0)).addField("av1.activeTargets", (Object)(av1DependencyDescriptorHeaderExtension2 != null ? av1DependencyDescriptorHeaderExtension2.getActiveDecodeTargetsBitmask() : null));
            Av1DependencyDescriptorHeaderExtension av1DependencyDescriptorHeaderExtension3 = av1Packet.getDescriptor();
            Object object4 = packetStructure = av1DependencyDescriptorHeaderExtension3 != null ? av1DependencyDescriptorHeaderExtension3.getStructure() : null;
            if (packetStructure != null) {
                point.addField("av1.structureIdOffset", (Object)packetStructure.getTemplateIdOffset()).addField("av1.templateCount", (Object)packetStructure.getTemplateCount()).addField("av1.structureId", (Object)System.identityHashCode(packetStructure));
            }
            if (newStructure != null) {
                point.addField("av1.newStructureIdOffset", (Object)newStructure.getTemplateIdOffset()).addField("av1.newTemplateCount", (Object)newStructure.getTemplateCount()).addField("av1.newStructureId", (Object)System.identityHashCode(newStructure));
            }
            timeSeriesLogger.trace((Map)point);
        }
        return av1Packet;
    }

    @Override
    public void parse(@NotNull PacketInfo packetInfo) {
        block4: {
            boolean changed;
            Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
            Av1DDPacket av1Packet = (Av1DDPacket)((Object)packetInfo.packetAs());
            TemplateHistory history = (TemplateHistory)this.ddStateHistory.get((Object)av1Packet.getSsrc());
            if (history == null) {
                this.logger.warn((Object)("History for " + av1Packet.getSsrc() + " disappeared between createFrom and parse!"));
                return;
            }
            Integer activeDecodeTargets = av1Packet.getActiveDecodeTargets();
            if (activeDecodeTargets == null || !(changed = history.updateDecodeTargets(av1Packet.getSequenceNumber(), activeDecodeTargets))) break block4;
            packetInfo.setLayeringChanged(true);
            this.logger.debug(() -> Av1DDParser.parse$lambda$2(av1Packet, activeDecodeTargets));
            RtpEncodingDesc rtpEncodingDesc = this.findRtpEncodingDesc(av1Packet);
            if (rtpEncodingDesc != null) {
                RtpEncodingDesc enc = rtpEncodingDesc;
                boolean bl = false;
                RtpEncodingDesc rtpEncodingDesc2 = Av1DDPacket.getScalabilityStructure$default(av1Packet, enc.getEid(), 0.0, 2, null);
                if (rtpEncodingDesc2 != null) {
                    RtpEncodingDesc it = rtpEncodingDesc2;
                    boolean bl2 = false;
                    this.getSource().setEncodingLayers(it.getLayers$jitsi_media_transform(), av1Packet.getSsrc());
                }
                for (RtpEncodingDesc otherEnc : this.getSource().getRtpEncodings()) {
                    if (this.ddStateHistory.keySet().contains(otherEnc.getPrimarySSRC())) continue;
                    this.getSource().setEncodingLayers(new RtpLayerDesc[0], otherEnc.getPrimarySSRC());
                }
            }
        }
    }

    private static final String createFrom$lambda$1(Av1TemplateDependencyStructure $newStructure, RtpPacket $packet, boolean $structureChanged) {
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        return "Inserting new structure with templates " + $newStructure.getTemplateIdOffset() + " .. " + ($newStructure.getTemplateIdOffset() + $newStructure.getTemplateCount() - 1) % 64 + " for RTP packet ssrc " + $packet.getSsrc() + " seq " + $packet.getSequenceNumber() + ".  Changed from previous: " + $structureChanged + ".";
    }

    private static final String parse$lambda$2(Av1DDPacket $av1Packet, Integer $activeDecodeTargets) {
        Intrinsics.checkNotNullParameter((Object)((Object)$av1Packet), (String)"$av1Packet");
        return "Decode targets for " + $av1Packet.getSsrc() + " changed in seq " + $av1Packet.getSequenceNumber() + ": now 0x" + Integer.toHexString($activeDecodeTargets) + ".  Updating layering.";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jitsi/nlj/rtp/codec/av1/Av1DDParser$Companion;", "", "<init>", "()V", "STATE_HISTORY_SIZE", "", "TEMPLATE_HISTORY_SIZE", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

