/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.ConfigValueSupplier;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.util.BitrateTracker;
import org.jitsi.nlj.util.DataSizeKt;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.stats.RateTracker;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 *2\u00020\u0001:\u0001*B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0016\u0010$\u001a\u00020!2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020!0&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\n \u001a*\u0004\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006+"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/BitrateCalculator;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "name", "", "activePacketRateThreshold", "", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/lang/String;ILjava/time/Clock;)V", "getClock", "()Ljava/time/Clock;", "bitrateTracker", "Lorg/jitsi/nlj/util/BitrateTracker;", "packetRateTracker", "Lorg/jitsi/utils/stats/RateTracker;", "bitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "getBitrate-rlWvAKk", "()D", "packetRatePps", "", "getPacketRatePps", "()J", "start", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "Ljava/time/Instant;", "active", "", "getActive", "()Z", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getNodeStatsToAggregate", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nBitrateCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitrateCalculator.kt\norg/jitsi/nlj/transform/node/incoming/BitrateCalculator\n+ 2 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,159:1\n68#2,6:160\n68#2,6:166\n*S KotlinDebug\n*F\n+ 1 BitrateCalculator.kt\norg/jitsi/nlj/transform/node/incoming/BitrateCalculator\n*L\n144#1:160,6\n151#1:166,6\n*E\n"})
public class BitrateCalculator
extends ObserverNode {
    @NotNull
    public static final Companion Companion;
    private final int activePacketRateThreshold;
    @NotNull
    private final Clock clock;
    @NotNull
    private final BitrateTracker bitrateTracker;
    @NotNull
    private final RateTracker packetRateTracker;
    private final Instant start;
    @NotNull
    private static final Duration GRACE_PERIOD;
    @NotNull
    private static final ConfigDelegate<Duration> windowSize$delegate;
    @NotNull
    private static final ConfigDelegate<Duration> bucketSize$delegate;

    public BitrateCalculator(@NotNull String name, int activePacketRateThreshold, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(name);
        this.activePacketRateThreshold = activePacketRateThreshold;
        this.clock = clock;
        this.bitrateTracker = Companion.createBitrateTracker();
        this.packetRateTracker = Companion.createRateTracker();
        this.start = this.clock.instant();
    }

    public /* synthetic */ BitrateCalculator(String string, int n, Clock clock, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "Bitrate calculator";
        }
        if ((n2 & 2) != 0) {
            n = 5;
        }
        if ((n2 & 4) != 0) {
            clock = Clock.systemUTC();
        }
        this(string, n, clock);
    }

    @NotNull
    protected final Clock getClock() {
        return this.clock;
    }

    public final double getBitrate-rlWvAKk() {
        return this.bitrateTracker.getRate-rlWvAKk();
    }

    public final long getPacketRatePps() {
        return this.packetRateTracker.getRate();
    }

    public final boolean getActive() {
        return Duration.between(this.start, this.clock.instant()).compareTo(GRACE_PERIOD) <= 0 ? this.getBitrate-rlWvAKk() > 0.0 : this.getPacketRatePps() >= (long)this.activePacketRateThreshold;
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        long now = this.clock.millis();
        this.bitrateTracker.update(DataSizeKt.getBytes(packetInfo.getPacket().length), now);
        this.packetRateTracker.update(1L, now);
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke();
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStats_u24lambda_u240.addNumber("bitrate_bps", this.getBitrate-rlWvAKk());
        $this$getNodeStats_u24lambda_u240.addNumber("packet_rate_pps", this.getPacketRatePps());
        $this$getNodeStats_u24lambda_u240.addBoolean("active", this.getActive());
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    protected NodeStatsBlock getNodeStatsToAggregate() {
        return super.getNodeStats();
    }

    public BitrateCalculator() {
        this(null, 0, null, 7, null);
    }

    static {
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        GRACE_PERIOD = DurationKt.getSecs((int)10);
        boolean $i$f$config = false;
        SupplierBuilder $this$windowSize_delegate_u24lambda_u241 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl = false;
        $this$windowSize_delegate_u24lambda_u241.from("jmt.rtp.bitrate-calculator.window-size", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        windowSize$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$bucketSize_delegate_u24lambda_u242 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Duration.class));
        boolean bl2 = false;
        $this$bucketSize_delegate_u24lambda_u242.from("jmt.rtp.bitrate-calculator.bucket-size", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        bucketSize$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\b\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\t\u0010\u0007R\u001b\u0010\f\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000b\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/BitrateCalculator$Companion;", "", "<init>", "()V", "GRACE_PERIOD", "Ljava/time/Duration;", "getGRACE_PERIOD", "()Ljava/time/Duration;", "windowSize", "getWindowSize", "windowSize$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "bucketSize", "getBucketSize", "bucketSize$delegate", "createBitrateTracker", "Lorg/jitsi/nlj/util/BitrateTracker;", "createRateTracker", "Lorg/jitsi/utils/stats/RateTracker;", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        @NotNull
        public final Duration getGRACE_PERIOD() {
            return GRACE_PERIOD;
        }

        @NotNull
        public final Duration getWindowSize() {
            return (Duration)windowSize$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        @NotNull
        public final Duration getBucketSize() {
            return (Duration)bucketSize$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        @NotNull
        public final BitrateTracker createBitrateTracker() {
            return new BitrateTracker(this.getWindowSize(), this.getBucketSize(), null, 4, null);
        }

        @NotNull
        public final RateTracker createRateTracker() {
            return new RateTracker(this.getWindowSize(), this.getBucketSize(), null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "windowSize", "getWindowSize()Ljava/time/Duration;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "bucketSize", "getBucketSize()Ljava/time/Duration;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

