/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtcp.RetransmissionRequester;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.logging2.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0016\u0010\u0012\u001a\u00020\u00052\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/RetransmissionRequesterNode;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "rtcpSender", "Lkotlin/Function1;", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/concurrent/ScheduledExecutorService;Lorg/jitsi/utils/logging2/Logger;)V", "retransmissionRequester", "Lorg/jitsi/nlj/rtcp/RetransmissionRequester;", "observe", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "stop", "trace", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
public final class RetransmissionRequesterNode
extends ObserverNode {
    @NotNull
    private final RetransmissionRequester retransmissionRequester;

    public RetransmissionRequesterNode(@NotNull Function1<? super RtcpPacket, Unit> rtcpSender, @NotNull ScheduledExecutorService scheduler, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(rtcpSender, (String)"rtcpSender");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        super("Retransmission requester");
        this.retransmissionRequester = new RetransmissionRequester(rtcpSender, scheduler, parentLogger, null, 8, null);
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        RtpPacket rtpPacket = (RtpPacket)packetInfo.packetAs();
        this.retransmissionRequester.packetReceived(rtpPacket.getSsrc(), rtpPacket.getSequenceNumber());
    }

    @Override
    public void stop() {
        super.stop();
        this.retransmissionRequester.stop();
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke();
    }
}

