/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.outgoing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.transform.node.outgoing.OutgoingSsrcStats;
import org.jitsi.nlj.transform.node.outgoing.OutgoingStatisticsSnapshot;
import org.jitsi.rtp.rtp.RtpPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0014J\u0016\u0010\u0012\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "<init>", "()V", "ssrcStats", "", "", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingSsrcStats;", "numAudioPackets", "", "numVideoPackets", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "getNodeStatsToAggregate", "trace", "f", "Lkotlin/Function0;", "getSnapshot", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsSnapshot;", "getSsrcSnapshot", "Lorg/jitsi/nlj/transform/node/outgoing/OutgoingSsrcStats$Snapshot;", "ssrc", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nOutgoingStatisticsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutgoingStatisticsTracker.kt\norg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,130:1\n216#2,2:131\n126#2:133\n153#2,3:134\n*S KotlinDebug\n*F\n+ 1 OutgoingStatisticsTracker.kt\norg/jitsi/nlj/transform/node/outgoing/OutgoingStatisticsTracker\n*L\n52#1:131,2\n69#1:133\n69#1:134,3\n*E\n"})
public final class OutgoingStatisticsTracker
extends ObserverNode {
    @NotNull
    private final Map<Long, OutgoingSsrcStats> ssrcStats = new ConcurrentHashMap();
    private int numAudioPackets;
    private int numVideoPackets;

    public OutgoingStatisticsTracker() {
        super("Outgoing statistics tracker");
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        RtpPacket rtpPacket;
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        RtpPacket rtpPacket2 = rtpPacket = (RtpPacket)packetInfo.packetAs();
        if (rtpPacket2 instanceof AudioRtpPacket) {
            int n = this.numAudioPackets;
            this.numAudioPackets = n + 1;
        } else if (rtpPacket2 instanceof VideoRtpPacket) {
            int n = this.numVideoPackets;
            this.numVideoPackets = n + 1;
        }
        OutgoingSsrcStats outgoingSsrcStats = this.ssrcStats.computeIfAbsent(rtpPacket.getSsrc(), arg_0 -> OutgoingStatisticsTracker.observe$lambda$1(arg_0 -> OutgoingStatisticsTracker.observe$lambda$0(rtpPacket, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)outgoingSsrcStats, (String)"computeIfAbsent(...)");
        OutgoingSsrcStats stats = outgoingSsrcStats;
        stats.packetSent(rtpPacket.length, rtpPacket.getTimestamp());
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u243 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        OutgoingStatisticsSnapshot stats = this.getSnapshot();
        Map<Long, OutgoingSsrcStats.Snapshot> $this$forEach$iv = stats.getSsrcStats();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Long, OutgoingSsrcStats.Snapshot>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, OutgoingSsrcStats.Snapshot> element$iv;
            Map.Entry<Long, OutgoingSsrcStats.Snapshot> entry = element$iv = iterator.next();
            boolean bl2 = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            OutgoingSsrcStats.Snapshot streamStats = entry.getValue();
            $this$getNodeStats_u24lambda_u243.addJson(String.valueOf(ssrc), (Map)streamStats.toJson());
        }
        return nodeStatsBlock;
    }

    @Override
    @NotNull
    protected NodeStatsBlock getNodeStatsToAggregate() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStatsToAggregate_u24lambda_u244 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        $this$getNodeStatsToAggregate_u24lambda_u244.addNumber("num_audio_packets", this.numAudioPackets);
        $this$getNodeStatsToAggregate_u24lambda_u244.addNumber("num_video_packets", this.numVideoPackets);
        return nodeStatsBlock;
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final OutgoingStatisticsSnapshot getSnapshot() {
        void $this$mapTo$iv$iv;
        Map<Long, OutgoingSsrcStats> $this$map$iv = this.ssrcStats;
        boolean $i$f$map = false;
        Map<Long, OutgoingSsrcStats> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long ssrc = ((Number)entry.getKey()).longValue();
            OutgoingSsrcStats stats = (OutgoingSsrcStats)entry.getValue();
            collection.add(new Pair((Object)ssrc, (Object)stats.getSnapshot()));
        }
        Map map2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        return new OutgoingStatisticsSnapshot(map2);
    }

    @Nullable
    public final OutgoingSsrcStats.Snapshot getSsrcSnapshot(long ssrc) {
        OutgoingSsrcStats outgoingSsrcStats = this.ssrcStats.get(ssrc);
        return outgoingSsrcStats != null ? outgoingSsrcStats.getSnapshot() : null;
    }

    private static final OutgoingSsrcStats observe$lambda$0(RtpPacket $rtpPacket, Long it) {
        Intrinsics.checkNotNullParameter((Object)$rtpPacket, (String)"$rtpPacket");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new OutgoingSsrcStats($rtpPacket.getSsrc());
    }

    private static final OutgoingSsrcStats observe$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (OutgoingSsrcStats)$tmp0.invoke(p0);
    }
}

