/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.util;

import kotlin.Metadata;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/nlj/util/Rfc3711IndexTracker;", "", "<init>", "()V", "value", "", "roc", "getRoc", "()I", "highestSeqNumReceived", "update", "seqNum", "getIndex", "updateRoc", "", "interpret", "resetAt", "", "seq", "jitsi-media-transform"})
public final class Rfc3711IndexTracker {
    private int roc;
    private int highestSeqNumReceived = -1;

    public final int getRoc() {
        return this.roc;
    }

    public final int update(int seqNum) {
        return this.getIndex(seqNum, true);
    }

    private final int getIndex(int seqNum, boolean updateRoc) {
        int v;
        if (this.highestSeqNumReceived == -1) {
            if (updateRoc) {
                this.highestSeqNumReceived = seqNum;
            }
            return seqNum;
        }
        int n = RtpUtilsKt.rolledOverTo((int)seqNum, (int)this.highestSeqNumReceived) ? this.roc - 1 : (RtpUtilsKt.rolledOverTo((int)this.highestSeqNumReceived, (int)seqNum) ? (updateRoc ? ++this.roc : this.roc + 1) : (v = this.roc));
        if (updateRoc && RtpUtilsKt.isNewerThan((int)seqNum, (int)this.highestSeqNumReceived)) {
            this.highestSeqNumReceived = seqNum;
        }
        return 65536 * v + seqNum;
    }

    public final int interpret(int seqNum) {
        return this.getIndex(seqNum, false);
    }

    public final void resetAt(int seq) {
        int delta = RtpUtils.Companion.getSequenceNumberDelta(seq, this.highestSeqNumReceived);
        if (delta < 0) {
            int n = this.roc;
            this.roc = n + 1;
            this.highestSeqNumReceived = seq;
        }
        this.getIndex(seq, true);
    }
}

