/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.jitsi.utils.queue.ErrorHandler;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.MessageHandler;
import org.jitsi.videobridge.metrics.QueueMetrics;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.util.TaskPools;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 !2\u00020\u0001:\u0003\u001f !B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0017H\u0014J\u001a\u0010\u0016\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0019\u001a\u00020\u0017H\u0014J\b\u0010\u001a\u001a\u00020\u0010H\u0016R\u0014\u0010\u0006\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\""}, d2={"Lorg/jitsi/videobridge/AbstractEndpointMessageTransport;", "Lorg/jitsi/videobridge/message/MessageHandler;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;)V", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "isConnected", "", "()Z", "incomingMessageQueue", "Lorg/jitsi/utils/queue/PacketQueue;", "Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$MessageAndSource;", "notifyTransportChannelConnected", "", "onMessage", "src", "", "msg", "", "sendMessage", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "dst", "message", "close", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "EndpointMessageTransportEventHandler", "MessageAndSource", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nAbstractEndpointMessageTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractEndpointMessageTransport.kt\norg/jitsi/videobridge/AbstractEndpointMessageTransport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1#2:124\n*E\n"})
public abstract class AbstractEndpointMessageTransport
extends MessageHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final PacketQueue<MessageAndSource> incomingMessageQueue;
    @NotNull
    public static final String INCOMING_MESSAGE_QUEUE_ID = "bridge-channel-message-incoming-queue";
    @NotNull
    private static final CounterMetric droppedPacketsMetric = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"endpoint_receive_message_queue_dropped_packets", (String)"Number of packets dropped out of the Endpoint receive message queue.", (long)0L, null, (int)12, null);
    @NotNull
    private static final CounterMetric exceptionsMetric = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"endpoint_receive_message_queue_exceptions", (String)"Number of exceptions from the Endpoint receive message queue.", (long)0L, null, (int)12, null);
    @NotNull
    private static final CountingErrorHandler queueErrorCounter = new CountingErrorHandler(){

        public void packetDropped() {
            Unit unit;
            super.packetDropped();
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            CounterMetric.inc$default((CounterMetric)AbstractEndpointMessageTransport.access$getDroppedPacketsMetric$cp(), null, (int)1, null);
            CounterMetric.inc$default((CounterMetric)QueueMetrics.INSTANCE.getDroppedPackets(), null, (int)1, null);
        }

        public void packetHandlingFailed(Throwable t) {
            Unit unit;
            super.packetHandlingFailed(t);
            Unit it = unit = Unit.INSTANCE;
            boolean bl = false;
            CounterMetric.inc$default((CounterMetric)AbstractEndpointMessageTransport.access$getExceptionsMetric$cp(), null, (int)1, null);
            CounterMetric.inc$default((CounterMetric)QueueMetrics.INSTANCE.getExceptions(), null, (int)1, null);
        }
    };

    /*
     * WARNING - void declaration
     */
    public AbstractEndpointMessageTransport(@NotNull Logger parentLogger) {
        void $this$incomingMessageQueue_u24lambda_u242;
        PacketQueue packetQueue;
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Logger logger = parentLogger.createChildLogger(this.getClass().getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"createChildLogger(...)");
        this.logger = logger;
        PacketQueue packetQueue2 = packetQueue = new PacketQueue(50, Boolean.valueOf(true), INCOMING_MESSAGE_QUEUE_ID, arg_0 -> AbstractEndpointMessageTransport.incomingMessageQueue$lambda$1(this, arg_0), TaskPools.IO_POOL, Clock.systemUTC());
        AbstractEndpointMessageTransport abstractEndpointMessageTransport = this;
        boolean bl = false;
        $this$incomingMessageQueue_u24lambda_u242.setErrorHandler((ErrorHandler)queueErrorCounter);
        abstractEndpointMessageTransport.incomingMessageQueue = packetQueue;
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    public abstract boolean isConnected();

    protected void notifyTransportChannelConnected() {
    }

    public final void onMessage(@Nullable Object src, @NotNull String msg) {
        BridgeChannelMessage bridgeChannelMessage;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        try {
            bridgeChannelMessage = BridgeChannelMessage.Companion.parse(msg);
        }
        catch (IOException ioe) {
            this.logger.warn((Object)("Invalid message received (" + ioe.getMessage() + ": " + msg));
            return;
        }
        BridgeChannelMessage message = bridgeChannelMessage;
        this.logger.debug(() -> AbstractEndpointMessageTransport.onMessage$lambda$3(msg));
        this.incomingMessageQueue.add((Object)new MessageAndSource(message, src));
    }

    protected void sendMessage(@NotNull BridgeChannelMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
    }

    protected void sendMessage(@Nullable Object dst, @NotNull BridgeChannelMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logger.debug(() -> AbstractEndpointMessageTransport.sendMessage$lambda$4(message));
    }

    public void close() {
    }

    @NotNull
    public JSONObject getDebugState() {
        JSONObject jSONObject;
        JSONObject $this$_get_debugState__u24lambda_u245 = jSONObject = new JSONObject();
        boolean bl = false;
        ((Map)$this$_get_debugState__u24lambda_u245).put("received_counts", new JSONObject(this.getReceivedCounts()));
        return jSONObject;
    }

    private static final boolean incomingMessageQueue$lambda$1(AbstractEndpointMessageTransport this$0, MessageAndSource messageAndSource) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        try {
            BridgeChannelMessage bridgeChannelMessage = this$0.handleMessage(messageAndSource.getMessage());
            if (bridgeChannelMessage != null) {
                BridgeChannelMessage response = bridgeChannelMessage;
                boolean bl = false;
                this$0.sendMessage(messageAndSource.getSource(), response);
            }
        }
        catch (Exception e) {
            this$0.logger.warn((Object)"Failed to handle message: ", (Throwable)e);
        }
        return true;
    }

    private static final String onMessage$lambda$3(String $msg) {
        Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
        return "RECV: " + $msg;
    }

    private static final String sendMessage$lambda$4(BridgeChannelMessage $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        return "SENT: " + $message.toJson();
    }

    public static final /* synthetic */ CounterMetric access$getDroppedPacketsMetric$cp() {
        return droppedPacketsMetric;
    }

    public static final /* synthetic */ CounterMetric access$getExceptionsMetric$cp() {
        return exceptionsMetric;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$Companion;", "", "<init>", "()V", "INCOMING_MESSAGE_QUEUE_ID", "", "droppedPacketsMetric", "Lorg/jitsi/metrics/CounterMetric;", "exceptionsMetric", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "getQueueErrorCounter", "()Lorg/jitsi/utils/queue/CountingErrorHandler;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CountingErrorHandler getQueueErrorCounter() {
            return queueErrorCounter;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$EndpointMessageTransportEventHandler;", "", "endpointMessageTransportConnected", "", "endpoint", "Lorg/jitsi/videobridge/AbstractEndpoint;", "jitsi-videobridge"})
    public static interface EndpointMessageTransportEventHandler {
        public void endpointMessageTransportConnected(@NotNull AbstractEndpoint var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$MessageAndSource;", "", "message", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "source", "<init>", "(Lorg/jitsi/videobridge/message/BridgeChannelMessage;Ljava/lang/Object;)V", "getMessage", "()Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "getSource", "()Ljava/lang/Object;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-videobridge"})
    private static final class MessageAndSource {
        @NotNull
        private final BridgeChannelMessage message;
        @Nullable
        private final Object source;

        public MessageAndSource(@NotNull BridgeChannelMessage message, @Nullable Object source) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.message = message;
            this.source = source;
        }

        @NotNull
        public final BridgeChannelMessage getMessage() {
            return this.message;
        }

        @Nullable
        public final Object getSource() {
            return this.source;
        }

        @NotNull
        public final BridgeChannelMessage component1() {
            return this.message;
        }

        @Nullable
        public final Object component2() {
            return this.source;
        }

        @NotNull
        public final MessageAndSource copy(@NotNull BridgeChannelMessage message, @Nullable Object source) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new MessageAndSource(message, source);
        }

        public static /* synthetic */ MessageAndSource copy$default(MessageAndSource messageAndSource, BridgeChannelMessage bridgeChannelMessage, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                bridgeChannelMessage = messageAndSource.message;
            }
            if ((n & 2) != 0) {
                object = messageAndSource.source;
            }
            return messageAndSource.copy(bridgeChannelMessage, object);
        }

        @NotNull
        public String toString() {
            return "MessageAndSource(message=" + this.message + ", source=" + this.source + ")";
        }

        public int hashCode() {
            int result = this.message.hashCode();
            result = result * 31 + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MessageAndSource)) {
                return false;
            }
            MessageAndSource messageAndSource = (MessageAndSource)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)messageAndSource.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.source, (Object)messageAndSource.source);
        }
    }
}

