/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacketKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.Av1DependencyDescriptorHeaderExtension;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.videobridge.CodecDeltas;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/videobridge/Av1DDCodecDeltas;", "Lorg/jitsi/videobridge/CodecDeltas;", "frameNumDelta", "", "templateIdDelta", "<init>", "(II)V", "getFrameNumDelta", "()I", "getTemplateIdDelta", "rewritePacket", "", "packet", "Lorg/jitsi/rtp/rtp/RtpPacket;", "toString", "", "jitsi-videobridge"})
final class Av1DDCodecDeltas
implements CodecDeltas {
    private final int frameNumDelta;
    private final int templateIdDelta;

    public Av1DDCodecDeltas(int frameNumDelta, int templateIdDelta) {
        this.frameNumDelta = frameNumDelta;
        this.templateIdDelta = templateIdDelta;
    }

    public final int getFrameNumDelta() {
        return this.frameNumDelta;
    }

    public final int getTemplateIdDelta() {
        return this.templateIdDelta;
    }

    @Override
    public void rewritePacket(@NotNull RtpPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (!(packet instanceof Av1DDPacket)) {
            return;
        }
        Av1DependencyDescriptorHeaderExtension descriptor = ((Av1DDPacket)packet).getDescriptor();
        if (descriptor == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        descriptor.setFrameNumber(RtpUtils.Companion.applySequenceNumberDelta(descriptor.getFrameNumber(), this.frameNumDelta));
        descriptor.setFrameDependencyTemplateId(Av1DDPacketKt.applyTemplateIdDelta((int)descriptor.getFrameDependencyTemplateId(), (int)this.templateIdDelta));
        descriptor.getStructure().setTemplateIdOffset(Av1DDPacketKt.applyTemplateIdDelta((int)descriptor.getStructure().getTemplateIdOffset(), (int)this.templateIdDelta));
        ((Av1DDPacket)packet).reencodeDdExt();
    }

    @NotNull
    public String toString() {
        return "[AV1DD FrameNum]" + this.frameNumDelta + " [Av1DD templateId]" + this.templateIdDelta;
    }
}

