/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.ice4j.util.Buffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.dcsctp4j.DcSctpMessage;
import org.jitsi.dcsctp4j.ErrorKind;
import org.jitsi.dcsctp4j.SendPacketStatus;
import org.jitsi.dcsctp4j.SendStatus;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.ConfigValueSupplier;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.metrics.MetricsContainer;
import org.jitsi.nlj.Features;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketHandler;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.Transceiver;
import org.jitsi.nlj.TransceiverEventHandler;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.ParsedVideoPacket;
import org.jitsi.nlj.rtp.RtpExtension;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.rtp.VideoRtpPacket;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.nlj.stats.EndpointConnectionStats;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.stats.TransceiverStats;
import org.jitsi.nlj.transform.PipelineBuilder;
import org.jitsi.nlj.transform.PipelineDslKt;
import org.jitsi.nlj.transform.node.ConsumerNode;
import org.jitsi.nlj.transform.node.Node;
import org.jitsi.nlj.transform.node.ToggleablePcapWriter;
import org.jitsi.nlj.transform.node.incoming.IncomingSsrcStats;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.nlj.util.LocalSsrcAssociation;
import org.jitsi.nlj.util.PacketInfoQueue;
import org.jitsi.nlj.util.RemoteSsrcAssociation;
import org.jitsi.nlj.util.SsrcAssociation;
import org.jitsi.rtp.Packet;
import org.jitsi.rtp.UnparsedPacket;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbFirPacket;
import org.jitsi.rtp.rtcp.rtcpfb.payload_specific_fb.RtcpFbPliPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.concurrent.RecurringRunnable;
import org.jitsi.utils.concurrent.RecurringRunnableExecutor;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.queue.CountingErrorHandler;
import org.jitsi.utils.queue.ErrorHandler;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.AudioSsrcCache;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.CryptexConfig;
import org.jitsi.videobridge.EncodingsManager;
import org.jitsi.videobridge.EndpointMessageTransport;
import org.jitsi.videobridge.PotentialPacketHandler;
import org.jitsi.videobridge.SsrcCache;
import org.jitsi.videobridge.SsrcLimitConfig;
import org.jitsi.videobridge.SsrcRewriter;
import org.jitsi.videobridge.TransportConfig;
import org.jitsi.videobridge.VideoSsrcCache;
import org.jitsi.videobridge.VideobridgeExpireThreadConfig;
import org.jitsi.videobridge.cc.BandwidthProbing;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocation;
import org.jitsi.videobridge.cc.allocation.BitrateController;
import org.jitsi.videobridge.cc.allocation.BitrateControllerStatusSnapshot;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.datachannel.DataChannel;
import org.jitsi.videobridge.datachannel.DataChannelStack;
import org.jitsi.videobridge.datachannel.protocol.DataChannelPacket;
import org.jitsi.videobridge.dcsctp.DcSctpBaseCallbacks;
import org.jitsi.videobridge.dcsctp.DcSctpHandler;
import org.jitsi.videobridge.dcsctp.DcSctpTransport;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.ForwardedSourcesMessage;
import org.jitsi.videobridge.message.ReceiverVideoConstraintsMessage;
import org.jitsi.videobridge.message.SenderSourceConstraintsMessage;
import org.jitsi.videobridge.metrics.QueueMetrics;
import org.jitsi.videobridge.metrics.VideobridgeMetrics;
import org.jitsi.videobridge.metrics.VideobridgeMetricsContainer;
import org.jitsi.videobridge.relay.AudioSourceDesc;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.rest.root.debug.EndpointDebugFeatures;
import org.jitsi.videobridge.sctp.DataChannelHandler;
import org.jitsi.videobridge.sctp.SctpConfig;
import org.jitsi.videobridge.stats.PacketTransitStats;
import org.jitsi.videobridge.transport.dtls.DtlsTransport;
import org.jitsi.videobridge.transport.ice.IceTransport;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.PacketUtils;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.websocket.ColibriWebSocketService;
import org.jitsi.videobridge.websocket.ColibriWebSocketServiceSupplierKt;
import org.jitsi.xmpp.extensions.colibri.WebSocketPacketExtension;
import org.jitsi.xmpp.extensions.jingle.DtlsFingerprintPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0082\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00dd\u00012\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0006\u00dd\u0001\u00de\u0001\u00df\u0001BK\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0006\u0010D\u001a\u00020\fJ\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00010JJ\u0012\u0010Q\u001a\u0004\u0018\u00010R2\u0006\u0010S\u001a\u00020RH\u0002J\b\u0010q\u001a\u00020rH\u0002J\f\u0010s\u001a\b\u0012\u0004\u0012\u00020\u00060JJ\b\u0010t\u001a\u00020rH\u0002J\u0016\u0010u\u001a\u00020r2\u0006\u0010v\u001a\u00020\f2\u0006\u0010w\u001a\u00020\fJ\u0010\u0010x\u001a\u00020r2\u0006\u0010y\u001a\u00020zH\u0016J\u0010\u0010{\u001a\u00020r2\u0006\u0010|\u001a\u00020}H\u0016J\u0010\u0010~\u001a\u00020r2\u0006\u0010\u007f\u001a\u00020\fH\u0016J\u001a\u0010\u0080\u0001\u001a\u00020r2\u0007\u0010\u0081\u0001\u001a\u00020^2\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J.\u0010\u0084\u0001\u001a\u00020r2\u0007\u0010\u0085\u0001\u001a\u00020\u00062\u0007\u0010\u0086\u0001\u001a\u00020^2\u0007\u0010\u0087\u0001\u001a\u00020^2\b\u0010\u0088\u0001\u001a\u00030\u0089\u0001H\u0016J\u001a\u0010\u008a\u0001\u001a\u00020r2\b\u0010\u008b\u0001\u001a\u00030\u008c\u00012\u0007\u0010\u008d\u0001\u001a\u00020\fJ\u0011\u0010\u008e\u0001\u001a\u00020\f2\b\u0010\u008b\u0001\u001a\u00030\u008c\u0001J\u0011\u0010\u0091\u0001\u001a\u00020\f2\u0006\u0010S\u001a\u00020RH\u0002J\u0007\u0010\u0092\u0001\u001a\u00020rJ\u0013\u0010\u0093\u0001\u001a\u00020r2\b\u0010\u0094\u0001\u001a\u00030\u0095\u0001H\u0016J\u0007\u0010\u0096\u0001\u001a\u00020rJ\t\u0010\u0097\u0001\u001a\u00020rH\u0002J%\u0010\u0098\u0001\u001a\u00020r2\b\u0010\u0099\u0001\u001a\u00030\u009a\u00012\b\u0010\u009b\u0001\u001a\u00030\u009c\u00012\b\u0010\u009d\u0001\u001a\u00030\u009c\u0001JG\u0010\u009e\u0001\u001a\u00020r2\u001a\u0010\u009f\u0001\u001a\u0015\u0012\u0004\u0012\u00020b\u0012\u0005\u0012\u00030\u00a2\u00010\u00a1\u0001j\u0003`\u00a0\u00012\u001a\u0010\u00a3\u0001\u001a\u0015\u0012\u0004\u0012\u00020b\u0012\u0005\u0012\u00030\u00a2\u00010\u00a1\u0001j\u0003`\u00a0\u0001H\u0002\u00a2\u0006\u0003\u0010\u00a4\u0001J\u001c\u0010\u00a5\u0001\u001a\u00020r2\u0007\u0010\u00a6\u0001\u001a\u00020\u00062\b\u0010\u00a7\u0001\u001a\u00030\u00a2\u0001H\u0014J\u0007\u0010\u00a8\u0001\u001a\u00020rJ\u0007\u0010\u00a9\u0001\u001a\u00020rJ\u0010\u0010\u00aa\u0001\u001a\u00020\f2\u0007\u0010\u00ab\u0001\u001a\u00020\u0006J\u0017\u0010\u00ac\u0001\u001a\u00020r2\u000e\u0010\u00ad\u0001\u001a\t\u0012\u0004\u0012\u00020\u00060\u00ae\u0001J\u0011\u0010\u00af\u0001\u001a\u00020r2\b\u0010\u00b0\u0001\u001a\u00030\u00b1\u0001J\b\u0010\u00b2\u0001\u001a\u00030\u00b1\u0001J\u000f\u0010\u00b3\u0001\u001a\u00020r2\u0006\u0010S\u001a\u00020RJ\u0012\u0010\u00b4\u0001\u001a\u00020\f2\u0007\u0010\u0081\u0001\u001a\u00020^H\u0016J\u0007\u0010\u00b5\u0001\u001a\u00020\fJ\u0013\u0010\u00b6\u0001\u001a\u0004\u0018\u00010\u00062\b\u0010\u00b7\u0001\u001a\u00030\u00b8\u0001J\t\u0010\u00bf\u0001\u001a\u00020rH\u0016J\u0012\u0010\u00bf\u0001\u001a\u00020r2\u0007\u0010\u00c0\u0001\u001a\u00020^H\u0016J\u0007\u0010\u00c1\u0001\u001a\u00020\fJ\b\u0010\u00c2\u0001\u001a\u00030\u009c\u0001J\u0011\u0010\u00c3\u0001\u001a\u00020r2\b\u0010\u00c4\u0001\u001a\u00030\u00c5\u0001J\u0014\u0010\u00c6\u0001\u001a\u0004\u0018\u00010b2\u0007\u0010\u0081\u0001\u001a\u00020^H\u0016J\u0014\u0010\u00c7\u0001\u001a\u0004\u0018\u00010j2\u0007\u0010\u0081\u0001\u001a\u00020^H\u0016J\t\u0010\u00c8\u0001\u001a\u00020^H\u0016J\u0011\u0010\u00c9\u0001\u001a\u00020r2\u0006\u0010S\u001a\u00020RH\u0016J\t\u0010\u00ca\u0001\u001a\u00020\fH\u0016J\u0012\u0010\u00cb\u0001\u001a\u00020r2\u0007\u0010\u00cc\u0001\u001a\u00020\u0001H\u0016J\u0011\u0010\u00cd\u0001\u001a\u00020r2\b\u0010\u00ce\u0001\u001a\u00030\u009c\u0001J\t\u0010\u00cf\u0001\u001a\u00020\fH\u0002J\b\u0010\u00d0\u0001\u001a\u00030\u00d1\u0001J\u0011\u0010\u00d2\u0001\u001a\u00020\f2\u0006\u0010S\u001a\u00020RH\u0016J\u0010\u0010\u00d3\u0001\u001a\u00020\f2\u0007\u0010\u00d4\u0001\u001a\u00020\u0001J\t\u0010\u00d5\u0001\u001a\u00020rH\u0002J\t\u0010\u00da\u0001\u001a\u00020rH\u0016J\u0011\u0010\u00db\u0001\u001a\u00020r2\b\u0010\u00dc\u0001\u001a\u00030\u009c\u0001R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010&\u001a\u00060'R\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u00060'R\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00100\u001a\n \u0018*\u0004\u0018\u00010101X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00102R\u0018\u00103\u001a\n \u0018*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00104R\u001a\u00105\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0015\"\u0004\b7\u00108R\u001a\u00109\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010\u0015\"\u0004\b;\u00108R\u001a\u0010<\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010\u0015\"\u0004\b>\u00108R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00010CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010E\u001a\u00020FX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u000e\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010M\u001a\u00020N\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u000e\u0010T\u001a\u00020UX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010V\u001a\u00020WX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020YX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00060[X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\\\u001a\b\u0012\u0004\u0012\u00020^0]X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020^X\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010c\u001a\b\u0012\u0004\u0012\u00020b0a2\f\u0010`\u001a\b\u0012\u0004\u0012\u00020b0a8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bd\u0010e\"\u0004\bf\u0010gR,\u0010h\u001a\u0012\u0012\u0004\u0012\u00020j0kj\b\u0012\u0004\u0012\u00020j`iX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010p\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u0016\u0010\u008f\u0001\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u008f\u0001\u0010\u0015R\u0016\u0010\u0090\u0001\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0090\u0001\u0010\u0015R&\u0010\u00b9\u0001\u001a\u0011\u0012\f\u0012\n \u0018*\u0004\u0018\u00010^0^0\u00ba\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u00bb\u0001\u0010\u00bc\u0001R\u0016\u0010\u00bd\u0001\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0007\u001a\u0005\b\u00be\u0001\u0010\u001aR\u0018\u0010\u00d6\u0001\u001a\u00030\u00d7\u00018VX\u0096\u0004\u00a2\u0006\b\u001a\u0006\b\u00d8\u0001\u0010\u00d9\u0001\u00a8\u0006\u00e0\u0001"}, d2={"Lorg/jitsi/videobridge/Endpoint;", "Lorg/jitsi/videobridge/AbstractEndpoint;", "Lorg/jitsi/videobridge/PotentialPacketHandler;", "Lorg/jitsi/videobridge/EncodingsManager$EncodingsUpdateListener;", "Lorg/jitsi/videobridge/SsrcRewriter;", "id", "", "conference", "Lorg/jitsi/videobridge/Conference;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "iceControlling", "", "doSsrcRewriting", "visitor", "supportsPrivateAddresses", "clock", "Ljava/time/Clock;", "<init>", "(Ljava/lang/String;Lorg/jitsi/videobridge/Conference;Lorg/jitsi/utils/logging2/Logger;ZZZZLjava/time/Clock;)V", "getVisitor", "()Z", "creationTime", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getCreationTime", "()Ljava/time/Instant;", "Ljava/time/Instant;", "sctpHandler", "Lorg/jitsi/videobridge/dcsctp/DcSctpHandler;", "sctpTransport", "Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "dataChannelHandler", "Lorg/jitsi/videobridge/sctp/DataChannelHandler;", "dataChannelStack", "Lorg/jitsi/videobridge/datachannel/DataChannelStack;", "toggleablePcapWriter", "Lorg/jitsi/nlj/transform/node/ToggleablePcapWriter;", "sctpRecvPcap", "Lorg/jitsi/nlj/transform/node/ToggleablePcapWriter$PcapWriterNode;", "sctpSendPcap", "sctpPipeline", "Lorg/jitsi/nlj/transform/node/Node;", "iceTransport", "Lorg/jitsi/videobridge/transport/ice/IceTransport;", "dtlsTransport", "Lorg/jitsi/videobridge/transport/dtls/DtlsTransport;", "cryptex", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "Lorg/jitsi/utils/logging/DiagnosticContext;", "timelineLogger", "Lorg/jitsi/utils/logging2/Logger;", "acceptAudio", "getAcceptAudio", "setAcceptAudio", "(Z)V", "acceptVideo", "getAcceptVideo", "setAcceptVideo", "initialReceiverConstraintsReceived", "getInitialReceiverConstraintsReceived", "setInitialReceiverConstraintsReceived", "outgoingSrtpPacketQueue", "Lorg/jitsi/nlj/util/PacketInfoQueue;", "incomingDataChannelMessagesQueue", "bitrateController", "Lorg/jitsi/videobridge/cc/allocation/BitrateController;", "hasSuspendedSources", "messageTransport", "Lorg/jitsi/videobridge/EndpointMessageTransport;", "getMessageTransport", "()Lorg/jitsi/videobridge/EndpointMessageTransport;", "getOrderedEndpoints", "", "rttListener", "Lorg/jitsi/nlj/stats/EndpointConnectionStats$EndpointConnectionStatsListener;", "transceiver", "Lorg/jitsi/nlj/Transceiver;", "getTransceiver", "()Lorg/jitsi/nlj/Transceiver;", "preProcess", "Lorg/jitsi/nlj/PacketInfo;", "packetInfo", "bandwidthProbing", "Lorg/jitsi/videobridge/cc/BandwidthProbing;", "videoSsrcs", "Lorg/jitsi/videobridge/VideoSsrcCache;", "audioSsrcs", "Lorg/jitsi/videobridge/AudioSsrcCache;", "activeSources", "", "sendSsrcs", "", "", "nextSendSsrc", "value", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "mediaSources", "getMediaSources", "()[Lorg/jitsi/nlj/MediaSourceDesc;", "setMediaSources", "([Lorg/jitsi/nlj/MediaSourceDesc;)V", "audioSources", "Lkotlin/collections/ArrayList;", "Lorg/jitsi/videobridge/relay/AudioSourceDesc;", "Ljava/util/ArrayList;", "getAudioSources", "()Ljava/util/ArrayList;", "setAudioSources", "(Ljava/util/ArrayList;)V", "Ljava/util/ArrayList;", "setupIceTransport", "", "getOnStageSources", "setupDtlsTransport", "updateForceMute", "audioForceMuted", "videoForceMuted", "addPayloadType", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "addRtpExtension", "rtpExtension", "Lorg/jitsi/nlj/rtp/RtpExtension;", "setExtmapAllowMixed", "allow", "addReceiveSsrc", "ssrc", "mediaType", "Lorg/jitsi/utils/MediaType;", "onNewSsrcAssociation", "endpointId", "primarySsrc", "secondarySsrc", "type", "Lorg/jitsi/nlj/rtp/SsrcAssociationType;", "setFeature", "feature", "Lorg/jitsi/videobridge/rest/root/debug/EndpointDebugFeatures;", "enabled", "isFeatureEnabled", "isSendingAudio", "isSendingVideo", "doSendSrtp", "lastNEndpointsChanged", "sendMessage", "msg", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "endpointMessageTransportConnected", "sendAllVideoConstraints", "dtlsAppPacketReceived", "data", "", "off", "", "len", "effectiveVideoConstraintsChanged", "oldEffectiveConstraints", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "newEffectiveConstraints", "(Ljava/util/Map;Ljava/util/Map;)V", "sendVideoConstraints", "sourceName", "maxVideoConstraints", "createSctpConnection", "scheduleEndpointMessageTransportTimeout", "acceptWebSocket", "password", "sendForwardedSourcesMessage", "forwardedSources", "", "setTransportInfo", "transportInfo", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "describeTransport", "handleIncomingPacket", "receivesSsrc", "doesSsrcRewriting", "unmapRtcpFbSsrc", "packet", "Lorg/jitsi/rtp/rtcp/rtcpfb/RtcpFbPacket;", "ssrcs", "Ljava/util/HashSet;", "getSsrcs", "()Ljava/util/HashSet;", "lastIncomingActivity", "getLastIncomingActivity", "requestKeyframe", "mediaSsrc", "isOversending", "numForwardedSources", "setBandwidthAllocationSettings", "message", "Lorg/jitsi/videobridge/message/ReceiverVideoConstraintsMessage;", "findVideoSourceProps", "findAudioSourceProps", "getNextSendSsrc", "send", "shouldExpire", "otherEndpointExpired", "expired", "setLastN", "lastN", "isTransportConnected", "getRtt", "", "wants", "wantsStatsFrom", "ep", "updateStatsOnExpire", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "expire", "setInitialLastN", "initialLastN", "Companion", "SctpCallbacks", "TransceiverEventHandlerImpl", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Endpoint.kt\norg/jitsi/videobridge/Endpoint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,1191:1\n1#2:1192\n819#3:1193\n847#3,2:1194\n819#3:1202\n847#3,2:1203\n1549#3:1205\n1620#3,3:1206\n1855#3,2:1209\n766#3:1213\n857#3,2:1214\n1549#3:1216\n1620#3,3:1217\n1549#3:1220\n1620#3,3:1221\n1855#3:1232\n1856#3:1240\n1855#3,2:1241\n766#3:1251\n857#3,2:1252\n63#4,4:1196\n63#4,4:1224\n63#4,4:1228\n63#4,4:1243\n63#4,4:1254\n63#4,4:1258\n63#4,4:1262\n63#4,4:1266\n215#5,2:1200\n215#5,2:1211\n372#6,7:1233\n13309#7,2:1247\n12474#7,2:1249\n13309#7,2:1270\n68#8,6:1272\n68#8,6:1278\n*S KotlinDebug\n*F\n+ 1 Endpoint.kt\norg/jitsi/videobridge/Endpoint\n*L\n246#1:1193\n246#1:1194,2\n572#1:1202\n572#1:1203,2\n575#1:1205\n575#1:1206,3\n575#1:1209,2\n587#1:1213\n587#1:1214,2\n589#1:1216\n589#1:1217,3\n590#1:1220\n590#1:1221,3\n692#1:1232\n692#1:1240\n720#1:1241,2\n959#1:1251\n959#1:1252,2\n475#1:1196,4\n608#1:1224,4\n620#1:1228,4\n726#1:1243,4\n1000#1:1254,4\n1001#1:1258,4\n1002#1:1262,4\n1003#1:1266,4\n555#1:1200,2\n581#1:1211,2\n694#1:1233,7\n780#1:1247,2\n933#1:1249,2\n921#1:1270,2\n1075#1:1272,6\n1085#1:1278,6\n*E\n"})
public final class Endpoint
extends AbstractEndpoint
implements PotentialPacketHandler,
EncodingsManager.EncodingsUpdateListener,
SsrcRewriter {
    @NotNull
    public static final Companion Companion;
    private final boolean doSsrcRewriting;
    private final boolean visitor;
    @NotNull
    private final Clock clock;
    private final Instant creationTime;
    @Nullable
    private final DcSctpHandler sctpHandler;
    @Nullable
    private DcSctpTransport sctpTransport;
    @NotNull
    private final DataChannelHandler dataChannelHandler;
    @Nullable
    private DataChannelStack dataChannelStack;
    @NotNull
    private final ToggleablePcapWriter toggleablePcapWriter;
    @NotNull
    private final ToggleablePcapWriter.PcapWriterNode sctpRecvPcap;
    @NotNull
    private final ToggleablePcapWriter.PcapWriterNode sctpSendPcap;
    @NotNull
    private final Node sctpPipeline;
    @NotNull
    private final IceTransport iceTransport;
    @NotNull
    private final DtlsTransport dtlsTransport;
    private boolean cryptex;
    private final DiagnosticContext diagnosticContext;
    private final Logger timelineLogger;
    private boolean acceptAudio;
    private boolean acceptVideo;
    private boolean initialReceiverConstraintsReceived;
    @NotNull
    private final PacketInfoQueue outgoingSrtpPacketQueue;
    @NotNull
    private final PacketInfoQueue incomingDataChannelMessagesQueue;
    @NotNull
    private final BitrateController<AbstractEndpoint> bitrateController;
    @NotNull
    private final EndpointMessageTransport messageTransport;
    @NotNull
    private final EndpointConnectionStats.EndpointConnectionStatsListener rttListener;
    @NotNull
    private final Transceiver transceiver;
    @NotNull
    private final BandwidthProbing bandwidthProbing;
    @NotNull
    private final VideoSsrcCache videoSsrcs;
    @NotNull
    private final AudioSsrcCache audioSsrcs;
    @NotNull
    private Set<String> activeSources;
    @NotNull
    private final Set<Long> sendSsrcs;
    private long nextSendSsrc;
    @NotNull
    private ArrayList<AudioSourceDesc> audioSources;
    @NotNull
    private static final CounterMetric droppedPacketsMetric;
    @NotNull
    private static final CounterMetric exceptionsMetric;
    @JvmField
    @NotNull
    public static final CountingErrorHandler queueErrorCounter;
    @NotNull
    private static final RecurringRunnableExecutor recurringRunnableExecutor;
    @NotNull
    private static final Duration epTimeout;
    @NotNull
    private static final AtomicLong timelineCounter;
    @NotNull
    private static final ConfigDelegate<Long> timelineFraction$delegate;
    @NotNull
    private static final String SRTP_QUEUE_ENTRY_EVENT = "Entered Endpoint SRTP sender outgoing queue";
    @NotNull
    private static final String SRTP_QUEUE_EXIT_EVENT = "Exited Endpoint SRTP sender outgoing queue";
    @NotNull
    private static final String SENT_OVER_ICE_TRANSPORT_EVENT = "Sent over the ICE transport";
    @NotNull
    private static final ConfigDelegate<Integer> statsFilterThreshold$delegate;
    private static final boolean useRandomSendSsrcs;
    @NotNull
    private static final SecureRandom random;

    @JvmOverloads
    public Endpoint(@NotNull String id, @NotNull Conference conference, @NotNull Logger parentLogger, boolean iceControlling, boolean doSsrcRewriting, boolean visitor, boolean supportsPrivateAddresses, @NotNull Clock clock) {
        Object $this$bandwidthProbing_u24lambda_u2411;
        Object $this$transceiver_u24lambda_u249;
        DtlsTransport $this$outgoingSrtpPacketQueue_u24lambda_u244;
        DtlsTransport $this$diagnosticContext_u24lambda_u243;
        DtlsTransport it;
        Object object;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        super(conference, id, parentLogger);
        this.doSsrcRewriting = doSsrcRewriting;
        this.visitor = visitor;
        this.clock = clock;
        this.creationTime = this.clock.instant();
        this.sctpHandler = SctpConfig.config.getEnabled() ? new DcSctpHandler() : null;
        this.dataChannelHandler = new DataChannelHandler();
        this.toggleablePcapWriter = new ToggleablePcapWriter(this.getLogger(), id + "-sctp");
        this.sctpRecvPcap = this.toggleablePcapWriter.newObserverNode(false);
        this.sctpSendPcap = this.toggleablePcapWriter.newObserverNode(true);
        this.sctpPipeline = PipelineDslKt.pipeline(arg_0 -> Endpoint.sctpPipeline$lambda$1(this, arg_0));
        this.iceTransport = new IceTransport(id, iceControlling, false, supportsPrivateAddresses, this.getLogger(), null, 32, null);
        DtlsTransport dtlsTransport = object = new DtlsTransport(this.getLogger(), id);
        Endpoint endpoint = this;
        boolean bl = false;
        it.setCryptex(CryptexConfig.Companion.getEndpoint());
        endpoint.dtlsTransport = object;
        this.cryptex = CryptexConfig.Companion.getEndpoint();
        it = object = conference.newDiagnosticContext();
        endpoint = this;
        boolean bl2 = false;
        $this$diagnosticContext_u24lambda_u243.put("endpoint_id", id);
        endpoint.diagnosticContext = object;
        this.timelineLogger = this.getLogger().createChildLogger("timeline." + this.getClass().getName());
        String string = this.getClass().getSimpleName() + "-outgoing-packet-queue";
        ExecutorService executorService = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"IO_POOL");
        $this$diagnosticContext_u24lambda_u243 = object = new PacketInfoQueue(string, executorService, (Function1)new Function1<PacketInfo, Boolean>((Object)this){

            public final Boolean invoke(PacketInfo p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Endpoint.access$doSendSrtp((Endpoint)this.receiver, p0);
            }
        }, TransportConfig.Companion.getQueueSize());
        endpoint = this;
        boolean bl3 = false;
        $this$outgoingSrtpPacketQueue_u24lambda_u244.setErrorHandler((ErrorHandler)queueErrorCounter);
        endpoint.outgoingSrtpPacketQueue = object;
        String string2 = this.getClass().getSimpleName() + "-incoming-data-channel-queue";
        ExecutorService executorService2 = TaskPools.IO_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)executorService2, (String)"IO_POOL");
        this.incomingDataChannelMessagesQueue = new PacketInfoQueue(string2, executorService2, arg_0 -> Endpoint.incomingDataChannelMessagesQueue$lambda$5(this, arg_0), TransportConfig.Companion.getQueueSize());
        BitrateController.EventHandler eventHandler = new BitrateController.EventHandler(this, conference){
            final /* synthetic */ Endpoint this$0;
            final /* synthetic */ Conference $conference;
            {
                this.this$0 = $receiver;
                this.$conference = $conference;
            }

            public void allocationChanged(BandwidthAllocation allocation) {
                Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
            }

            public void forwardedSourcesChanged(Set<String> forwardedSources) {
                Intrinsics.checkNotNullParameter(forwardedSources, (String)"forwardedSources");
                this.this$0.sendForwardedSourcesMessage((Collection<String>)forwardedSources);
            }

            public void effectiveVideoConstraintsChanged(Map<MediaSourceDesc, VideoConstraints> oldEffectiveConstraints, Map<MediaSourceDesc, VideoConstraints> newEffectiveConstraints) {
                Intrinsics.checkNotNullParameter(oldEffectiveConstraints, (String)"oldEffectiveConstraints");
                Intrinsics.checkNotNullParameter(newEffectiveConstraints, (String)"newEffectiveConstraints");
                Endpoint.access$effectiveVideoConstraintsChanged(this.this$0, oldEffectiveConstraints, newEffectiveConstraints);
            }

            public void keyframeNeeded(String endpointId, long ssrc) {
                this.$conference.requestKeyframe(endpointId, ssrc);
            }
        };
        Supplier<List> supplier = () -> Endpoint.bitrateController$lambda$6(this);
        DiagnosticContext diagnosticContext = this.diagnosticContext;
        Intrinsics.checkNotNullExpressionValue((Object)diagnosticContext, (String)"diagnosticContext");
        this.bitrateController = new BitrateController(eventHandler, supplier, diagnosticContext, this.getLogger(), null, 16, null);
        this.messageTransport = new EndpointMessageTransport(this, conference, this.getLogger());
        this.rttListener = new EndpointConnectionStats.EndpointConnectionStatsListener(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void onRttUpdate(double newRttMs) {
                if (newRttMs > 0.0) {
                    this.this$0.getTransceiver().removeEndpointConnectionStatsListener((EndpointConnectionStats.EndpointConnectionStatsListener)this);
                    Endpoint.access$getIceTransport$p(this.this$0).updateStatsOnInitialRtt(newRttMs);
                }
            }
        };
        ExecutorService executorService3 = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)executorService3, (String)"CPU_POOL");
        ExecutorService executorService4 = TaskPools.CPU_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)executorService4, (String)"CPU_POOL");
        ScheduledExecutorService scheduledExecutorService = TaskPools.SCHEDULED_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"SCHEDULED_POOL");
        DiagnosticContext diagnosticContext2 = this.diagnosticContext;
        Intrinsics.checkNotNullExpressionValue((Object)diagnosticContext2, (String)"diagnosticContext");
        $this$outgoingSrtpPacketQueue_u24lambda_u244 = object = new Transceiver(id, executorService3, executorService4, scheduledExecutorService, diagnosticContext2, this.getLogger(), (TransceiverEventHandler)new TransceiverEventHandlerImpl(), this.clock);
        endpoint = this;
        boolean bl4 = false;
        $this$transceiver_u24lambda_u249.setIncomingPacketHandler((PacketHandler)new ConsumerNode(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
                super("receiver chain handler");
            }

            protected void consume(PacketInfo packetInfo) {
                Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
                this.this$0.handleIncomingPacket(packetInfo);
            }

            public void trace(Function0<Unit> f) {
                Intrinsics.checkNotNullParameter(f, (String)"f");
                f.invoke();
            }
        });
        $this$transceiver_u24lambda_u249.addEndpointConnectionStatsListener(this.rttListener);
        $this$transceiver_u24lambda_u249.setLocalSsrc(MediaType.AUDIO, conference.getLocalAudioSsrc());
        $this$transceiver_u24lambda_u249.setLocalSsrc(MediaType.VIDEO, conference.getLocalVideoSsrc());
        $this$transceiver_u24lambda_u249.getRtpSender().setPreProcesor(arg_0 -> Endpoint.transceiver$lambda$9$lambda$8(this, arg_0));
        endpoint.transceiver = object;
        $this$transceiver_u24lambda_u249 = object = new BandwidthProbing(new BandwidthProbing.ProbingDataSender(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public int sendProbing(Collection<Long> mediaSsrcs, int numBytes) {
                Intrinsics.checkNotNullParameter(mediaSsrcs, (String)"mediaSsrcs");
                return this.this$0.getTransceiver().sendProbing(mediaSsrcs, numBytes);
            }
        }, () -> Endpoint.bandwidthProbing$lambda$10(this));
        endpoint = this;
        boolean bl5 = false;
        ((BandwidthProbing)((Object)$this$bandwidthProbing_u24lambda_u2411)).setDiagnosticsContext(this.diagnosticContext);
        ((BandwidthProbing)((Object)$this$bandwidthProbing_u24lambda_u2411)).setEnabled(true);
        $this$bandwidthProbing_u24lambda_u2411 = object;
        boolean bl6 = false;
        recurringRunnableExecutor.registerRecurringRunnable((RecurringRunnable)it);
        endpoint.bandwidthProbing = object;
        this.videoSsrcs = new VideoSsrcCache(SsrcLimitConfig.config.getMaxVideoSsrcs(), this, this.getLogger());
        this.audioSsrcs = new AudioSsrcCache(SsrcLimitConfig.config.getMaxAudioSsrcs(), this, this.getLogger());
        this.activeSources = SetsKt.emptySet();
        this.sendSsrcs = new LinkedHashSet();
        this.nextSendSsrc = 777000001L;
        conference.getEncodingsManager().subscribe(this);
        this.setupIceTransport();
        this.setupDtlsTransport();
        CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.totalEndpoints, null, (int)1, null);
        if (this.getVisitor()) {
            CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.totalVisitors, null, (int)1, null);
        }
        this.getLogger().info((Object)("Created new endpoint, iceControlling=" + iceControlling));
        this.audioSources = new ArrayList();
    }

    public /* synthetic */ Endpoint(String string, Conference conference, Logger logger, boolean bl, boolean bl2, boolean bl3, boolean bl4, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            clock = Clock.systemUTC();
        }
        this(string, conference, logger, bl, bl2, bl3, bl4, clock);
    }

    @Override
    public boolean getVisitor() {
        return this.visitor;
    }

    public final Instant getCreationTime() {
        return this.creationTime;
    }

    public final boolean getAcceptAudio() {
        return this.acceptAudio;
    }

    public final void setAcceptAudio(boolean bl) {
        this.acceptAudio = bl;
    }

    public final boolean getAcceptVideo() {
        return this.acceptVideo;
    }

    public final void setAcceptVideo(boolean bl) {
        this.acceptVideo = bl;
    }

    public final boolean getInitialReceiverConstraintsReceived() {
        return this.initialReceiverConstraintsReceived;
    }

    public final void setInitialReceiverConstraintsReceived(boolean bl) {
        this.initialReceiverConstraintsReceived = bl;
    }

    public final boolean hasSuspendedSources() {
        return this.bitrateController.hasSuspendedSources();
    }

    @Override
    @NotNull
    public EndpointMessageTransport getMessageTransport() {
        return this.messageTransport;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AbstractEndpoint> getOrderedEndpoints() {
        void $this$filterNotTo$iv$iv;
        List<AbstractEndpoint> list = this.getConference().getOrderedEndpoints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getOrderedEndpoints(...)");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            AbstractEndpoint it = (AbstractEndpoint)element$iv$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)it, (Object)this)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Transceiver getTransceiver() {
        return this.transceiver;
    }

    private final PacketInfo preProcess(PacketInfo packetInfo) {
        Packet packet = packetInfo.getPacket();
        if (packet instanceof VideoRtpPacket) {
            if (!this.bitrateController.transformRtp(packetInfo)) {
                this.getLogger().warn((Object)("Dropping a packet which was supposed to be accepted:" + packet));
                return null;
            }
            if (this.doSsrcRewriting) {
                boolean start2;
                boolean bl = start2 = !(packet instanceof ParsedVideoPacket) || ((ParsedVideoPacket)packet).isKeyframe() && ((ParsedVideoPacket)packet).isStartOfFrame();
                if (!this.videoSsrcs.rewriteRtp((RtpPacket)packet, start2)) {
                    return null;
                }
            }
        } else if (packet instanceof AudioRtpPacket) {
            if (this.doSsrcRewriting) {
                SsrcCache.rewriteRtp$default(this.audioSsrcs, (RtpPacket)packet, false, 2, null);
            }
        } else if (packet instanceof RtcpSrPacket) {
            this.bitrateController.transformRtcp((RtcpSrPacket)packet);
            if (this.doSsrcRewriting && !this.videoSsrcs.rewriteRtcp((RtcpPacket)packet) && !this.audioSsrcs.rewriteRtcp((RtcpPacket)packet)) {
                return null;
            }
        }
        return packetInfo;
    }

    @Override
    @NotNull
    public MediaSourceDesc[] getMediaSources() {
        return this.transceiver.getMediaSources();
    }

    public void setMediaSources(@NotNull MediaSourceDesc[] value) {
        boolean wasEmpty;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.applyVideoTypeCache(value);
        boolean bl = wasEmpty = this.transceiver.getMediaSources().length == 0;
        if (this.transceiver.setMediaSources(value)) {
            this.getEventEmitter().fireEvent(Endpoint::_set_mediaSources_$lambda$13);
        }
        if (wasEmpty) {
            this.sendAllVideoConstraints();
        }
    }

    @NotNull
    public final ArrayList<AudioSourceDesc> getAudioSources() {
        return this.audioSources;
    }

    public final void setAudioSources(@NotNull ArrayList<AudioSourceDesc> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.audioSources = arrayList;
    }

    private final void setupIceTransport() {
        this.iceTransport.incomingDataHandler = new IceTransport.IncomingDataHandler(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataReceived(Buffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                if (PacketUtils.looksLikeDtls(buffer.getBuffer(), buffer.getOffset(), buffer.getLength())) {
                    Endpoint.access$getDtlsTransport$p(this.this$0).enqueueBuffer(buffer);
                } else {
                    PacketInfo packetInfo;
                    PacketInfo $this$dataReceived_u24lambda_u240 = packetInfo = new PacketInfo((Packet)new UnparsedPacket(buffer.getBuffer(), buffer.getOffset(), buffer.getLength()), 0, null, 6, null);
                    boolean bl = false;
                    $this$dataReceived_u24lambda_u240.setReceivedTime(buffer.getReceivedTime());
                    PacketInfo pktInfo = packetInfo;
                    this.this$0.getTransceiver().handleIncomingPacket(pktInfo);
                }
            }
        };
        this.iceTransport.eventHandler = new IceTransport.EventHandler(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void writeable() {
                this.this$0.getLogger().info((Object)"ICE connected");
                this.this$0.getTransceiver().setOutgoingPacketHandler(new PacketHandler(this.this$0){
                    final /* synthetic */ Endpoint this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public void processPacket(PacketInfo packetInfo) {
                        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
                        packetInfo.addEvent("Entered Endpoint SRTP sender outgoing queue");
                        Endpoint.access$getOutgoingSrtpPacketQueue$p(this.this$0).add((Object)packetInfo);
                    }
                });
                TaskPools.IO_POOL.execute(Endpoint.access$getDtlsTransport$p(this.this$0)::startDtlsHandshake);
            }

            public void connected() {
            }

            public void failed() {
            }

            public void consentUpdated(Instant time) {
                Intrinsics.checkNotNullParameter((Object)time, (String)"time");
                this.this$0.getTransceiver().getPacketIOActivity().setLastIceActivityInstant(time);
            }
        };
    }

    @NotNull
    public final List<String> getOnStageSources() {
        return CollectionsKt.plus((Collection)this.bitrateController.getAllocationSettings().getOnStageEndpoints(), (Iterable)this.bitrateController.getAllocationSettings().getOnStageSources());
    }

    private final void setupDtlsTransport() {
        this.dtlsTransport.incomingDataHandler = new DtlsTransport.IncomingDataHandler(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void dtlsAppDataReceived(byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                this.this$0.dtlsAppPacketReceived(buf, off, len);
            }
        };
        this.dtlsTransport.outgoingDataHandler = new DtlsTransport.OutgoingDataHandler(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void sendData(byte[] buf, int off, int len) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Endpoint.access$getIceTransport$p(this.this$0).send(buf, off, len);
            }
        };
        this.dtlsTransport.eventHandler = new DtlsTransport.EventHandler(this){
            final /* synthetic */ Endpoint this$0;
            {
                this.this$0 = $receiver;
            }

            public void handshakeComplete(int chosenSrtpProtectionProfile, TlsRole tlsRole, byte[] keyingMaterial) {
                Intrinsics.checkNotNullParameter((Object)tlsRole, (String)"tlsRole");
                Intrinsics.checkNotNullParameter((Object)keyingMaterial, (String)"keyingMaterial");
                this.this$0.getLogger().info((Object)"DTLS handshake complete");
                this.this$0.getTransceiver().setSrtpInformation(chosenSrtpProtectionProfile, tlsRole, keyingMaterial, Endpoint.access$getCryptex$p(this.this$0));
                this.this$0.scheduleEndpointMessageTransportTimeout();
            }
        };
    }

    public final void updateForceMute(boolean audioForceMuted, boolean videoForceMuted) {
        this.transceiver.forceMuteAudio(audioForceMuted);
        this.transceiver.forceMuteVideo(videoForceMuted);
    }

    @Override
    public void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter((Object)payloadType, (String)"payloadType");
        this.transceiver.addPayloadType(payloadType);
        this.bitrateController.addPayloadType(payloadType);
    }

    @Override
    public void addRtpExtension(@NotNull RtpExtension rtpExtension) {
        Intrinsics.checkNotNullParameter((Object)rtpExtension, (String)"rtpExtension");
        this.transceiver.addRtpExtension(rtpExtension);
    }

    @Override
    public void setExtmapAllowMixed(boolean allow) {
        this.transceiver.setExtmapAllowMixed(allow);
    }

    public final void addReceiveSsrc(long ssrc, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        Logger $this$cdebug$iv = this.getLogger();
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)("Adding receive ssrc " + ssrc + " of type " + mediaType));
        }
        this.transceiver.addReceiveSsrc(ssrc, mediaType);
        this.getConference().addEndpointSsrc(this, ssrc);
    }

    @Override
    public void onNewSsrcAssociation(@NotNull String endpointId, long primarySsrc, long secondarySsrc, @NotNull SsrcAssociationType type) {
        Intrinsics.checkNotNullParameter((Object)endpointId, (String)"endpointId");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (StringsKt.equals((String)endpointId, (String)this.getId(), (boolean)true)) {
            this.transceiver.addSsrcAssociation((SsrcAssociation)new LocalSsrcAssociation(primarySsrc, secondarySsrc, type));
        } else {
            this.transceiver.addSsrcAssociation((SsrcAssociation)new RemoteSsrcAssociation(primarySsrc, secondarySsrc, type));
        }
    }

    public final void setFeature(@NotNull EndpointDebugFeatures feature, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        switch (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()]) {
            case 1: {
                this.transceiver.setFeature(Features.TRANSCEIVER_PCAP_DUMP, enabled);
                break;
            }
            case 2: {
                if (enabled) {
                    this.toggleablePcapWriter.enable();
                    break;
                }
                this.toggleablePcapWriter.disable();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final boolean isFeatureEnabled(@NotNull EndpointDebugFeatures feature) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        switch (WhenMappings.$EnumSwitchMapping$0[feature.ordinal()]) {
            case 1: {
                bl = this.transceiver.isFeatureEnabled(Features.TRANSCEIVER_PCAP_DUMP);
                break;
            }
            case 2: {
                bl = this.toggleablePcapWriter.isEnabled();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Override
    public boolean isSendingAudio() {
        return this.transceiver.isReceivingAudio();
    }

    @Override
    public boolean isSendingVideo() {
        return this.transceiver.isReceivingVideo();
    }

    private final boolean doSendSrtp(PacketInfo packetInfo) {
        packetInfo.addEvent(SRTP_QUEUE_EXIT_EVENT);
        Intrinsics.checkNotNullExpressionValue((Object)packetInfo.getPacket().buffer, (String)"buffer");
        this.iceTransport.send(packetInfo.getPacket().buffer, packetInfo.getPacket().offset, packetInfo.getPacket().length);
        packetInfo.addEvent(SENT_OVER_ICE_TRANSPORT_EVENT);
        PacketTransitStats.packetSent(packetInfo);
        ByteBufferPool.returnBuffer(packetInfo.getPacket().buffer);
        packetInfo.sent();
        if (this.timelineLogger.isTraceEnabled() && Companion.logTimeline()) {
            this.timelineLogger.trace(() -> Endpoint.doSendSrtp$lambda$15(packetInfo));
        }
        return true;
    }

    public final void lastNEndpointsChanged() {
        this.bitrateController.endpointOrderingChanged();
    }

    @Override
    public void sendMessage(@NotNull BridgeChannelMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.getMessageTransport().sendMessage(msg);
    }

    public final void endpointMessageTransportConnected() {
        this.sendAllVideoConstraints();
        this.sendForwardedSourcesMessage((Collection<String>)this.bitrateController.getForwardedSources());
        this.videoSsrcs.sendAllMappings();
        this.audioSsrcs.sendAllMappings();
    }

    private final void sendAllVideoConstraints() {
        Map<String, VideoConstraints> $this$forEach$iv = this.getMaxReceiverVideoConstraints();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, VideoConstraints>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, VideoConstraints> element$iv;
            Map.Entry<String, VideoConstraints> entry = element$iv = iterator.next();
            boolean bl = false;
            String sourceName = entry.getKey();
            VideoConstraints constraints = entry.getValue();
            this.sendVideoConstraints(sourceName, constraints);
        }
    }

    public final void dtlsAppPacketReceived(@NotNull byte[] data, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.sctpPipeline.processPacket(new PacketInfo((Packet)new UnparsedPacket(data, off, len), 0, null, 6, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void effectiveVideoConstraintsChanged(Map<MediaSourceDesc, VideoConstraints> oldEffectiveConstraints, Map<MediaSourceDesc, VideoConstraints> newEffectiveConstraints) {
        Object element$iv;
        Map<MediaSourceDesc, VideoConstraints> $this$forEach$iv;
        Collection collection;
        Iterator<Object> $this$mapTo$iv$iv;
        MediaSourceDesc it;
        Iterable $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = oldEffectiveConstraints.keySet();
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (MediaSourceDesc)element$iv$iv;
            boolean bl = false;
            if (newEffectiveConstraints.keySet().contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List removedSources = (List)destination$iv$iv;
        Iterable $this$map$iv = removedSources;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            it = (MediaSourceDesc)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSourceName());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$mapTo$iv$iv = $this$forEach$iv.iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            element$iv = $this$mapTo$iv$iv.next();
            String removedSourceName = (String)element$iv;
            boolean bl = false;
            AbstractEndpoint abstractEndpoint = this.getConference().findSourceOwner(removedSourceName);
            if (abstractEndpoint == null) continue;
            abstractEndpoint.removeSourceReceiver(removedSourceName, this.getId());
        }
        $this$forEach$iv = newEffectiveConstraints;
        $i$f$forEach = false;
        $this$mapTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$mapTo$iv$iv.hasNext()) {
            Object removedSourceName = element$iv = (Map.Entry)$this$mapTo$iv$iv.next();
            boolean bl = false;
            MediaSourceDesc source = (MediaSourceDesc)removedSourceName.getKey();
            VideoConstraints effectiveConstraints = (VideoConstraints)removedSourceName.getValue();
            AbstractEndpoint abstractEndpoint = this.getConference().findSourceOwner(source.getSourceName());
            if (abstractEndpoint == null) continue;
            abstractEndpoint.addReceiver(this.getId(), source.getSourceName(), effectiveConstraints);
        }
        if (this.doSsrcRewriting) {
            void $this$mapTo$iv$iv2;
            void $this$mapTo$iv$iv3;
            void $this$map$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = newEffectiveConstraints.entrySet();
            boolean $i$f$filter = false;
            element$iv = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it2 = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(!((VideoConstraints)it2.getValue()).isDisabled() && ((MediaSourceDesc)it2.getKey()).getVideoType().isEnabled())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map2 = false;
            $this$filterTo$iv$iv = $this$map$iv2;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                Map.Entry it2 = (Map.Entry)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add((MediaSourceDesc)it2.getKey());
            }
            List newActiveSources = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
            Iterable $this$map$iv3 = newActiveSources;
            boolean $i$f$map3 = false;
            destination$iv$iv2 = $this$map$iv3;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
            boolean $i$f$mapTo3 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it3;
                MediaSourceDesc bl = (MediaSourceDesc)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(it3.getSourceName());
            }
            Set newActiveSourceNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv3));
            if (!Intrinsics.areEqual(this.activeSources, (Object)newActiveSourceNames)) {
                this.activeSources = newActiveSourceNames;
                this.videoSsrcs.activate(newActiveSources);
            }
        }
    }

    @Override
    protected void sendVideoConstraints(@NotNull String sourceName, @NotNull VideoConstraints maxVideoConstraints) {
        Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
        Intrinsics.checkNotNullParameter((Object)maxVideoConstraints, (String)"maxVideoConstraints");
        if (this.findMediaSourceDesc(sourceName) == null) {
            this.getLogger().warn(() -> Endpoint.sendVideoConstraints$lambda$24(sourceName));
        } else {
            SenderSourceConstraintsMessage senderSourceConstraintsMessage = new SenderSourceConstraintsMessage(sourceName, maxVideoConstraints.getMaxHeight());
            Logger $this$cdebug$iv = this.getLogger();
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)("Sender constraints changed: " + senderSourceConstraintsMessage.toJson()));
            }
            this.sendMessage(senderSourceConstraintsMessage);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void createSctpConnection() {
        if (SctpConfig.config.getEnabled()) {
            void it;
            DcSctpTransport dcSctpTransport;
            Object object;
            Logger $this$cdebug$iv = this.getLogger();
            boolean $i$f$cdebug22 = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                object = $this$cdebug$iv;
                boolean bl = false;
                object.debug((Object)"Creating SCTP transport");
            }
            DcSctpTransport $i$f$cdebug22 = dcSctpTransport = new DcSctpTransport(this.getId(), this.getLogger());
            object = this;
            boolean bl = false;
            DcSctpTransport.start$default((DcSctpTransport)it, new SctpCallbacks((DcSctpTransport)it), null, 2, null);
            DcSctpHandler dcSctpHandler = this.sctpHandler;
            if (dcSctpHandler != null) {
                dcSctpHandler.setSctpTransport((DcSctpTransport)it);
            }
            object.sctpTransport = dcSctpTransport;
        } else {
            this.getLogger().error((Object)"Not creating SCTP connection, SCTP is disabled in configuration.");
        }
    }

    public final void scheduleEndpointMessageTransportTimeout() {
        TaskPools.SCHEDULED_POOL.schedule(() -> Endpoint.scheduleEndpointMessageTransportTimeout$lambda$28(this), 30L, TimeUnit.SECONDS);
    }

    public final boolean acceptWebSocket(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        if (!Intrinsics.areEqual((Object)this.iceTransport.getIcePassword(), (Object)password)) {
            this.getLogger().warn((Object)("Incoming web socket request with an invalid password. Expected: " + this.iceTransport.getIcePassword() + " received " + password));
            return false;
        }
        return true;
    }

    public final void sendForwardedSourcesMessage(@NotNull Collection<String> forwardedSources) {
        Intrinsics.checkNotNullParameter(forwardedSources, (String)"forwardedSources");
        ForwardedSourcesMessage msg = new ForwardedSourcesMessage(forwardedSources);
        TaskPools.IO_POOL.execute(() -> Endpoint.sendForwardedSourcesMessage$lambda$29(this, msg));
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransportInfo(@NotNull IceUdpTransportPacketExtension transportInfo) {
        Intrinsics.checkNotNullParameter((Object)transportInfo, (String)"transportInfo");
        Map remoteFingerprints = new LinkedHashMap();
        List fingerprintExtensions = transportInfo.getChildExtensionsOfType(DtlsFingerprintPacketExtension.class);
        Intrinsics.checkNotNull((Object)fingerprintExtensions);
        Iterable $this$forEach$iv = fingerprintExtensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DtlsFingerprintPacketExtension fingerprintExtension = (DtlsFingerprintPacketExtension)element$iv;
            boolean bl = false;
            if (fingerprintExtension.getHash() != null && fingerprintExtension.getFingerprint() != null) {
                Object object;
                void key$iv;
                void $this$getOrPut$iv;
                Map map = remoteFingerprints;
                String string = fingerprintExtension.getHash();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHash(...)");
                Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl2 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List list = (List)object;
                String string2 = fingerprintExtension.getFingerprint();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFingerprint(...)");
                list.add(string2);
            } else {
                this.getLogger().info((Object)("Ignoring empty DtlsFingerprint extension: " + XmlStringBuilderUtil.Companion.toStringOpt((ExtensionElement)transportInfo)));
            }
            if (!CryptexConfig.Companion.getEndpoint()) continue;
            this.cryptex = this.cryptex && fingerprintExtension.getCryptex();
        }
        this.dtlsTransport.setRemoteFingerprints(remoteFingerprints);
        if (!((Collection)fingerprintExtensions).isEmpty()) {
            String setup = ((DtlsFingerprintPacketExtension)CollectionsKt.first((List)fingerprintExtensions)).getSetup();
            this.dtlsTransport.setSetupAttribute(setup);
        }
        this.iceTransport.startConnectivityEstablishment(transportInfo);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IceUdpTransportPacketExtension describeTransport() {
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = new IceUdpTransportPacketExtension();
        this.iceTransport.describe(iceUdpTransportPacketExtension);
        this.dtlsTransport.describe(iceUdpTransportPacketExtension);
        ColibriWebSocketService colibriWebSocketService = ColibriWebSocketServiceSupplierKt.getColibriWebSocketServiceSupplier().get();
        if (colibriWebSocketService != null) {
            void $this$forEach$iv;
            ColibriWebSocketService colibriWebsocketService = colibriWebSocketService;
            boolean bl = false;
            String string = this.getConference().getID();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
            Iterable iterable = colibriWebsocketService.getColibriWebSocketUrls(string, this.getId(), this.iceTransport.getIcePassword());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String wsUrl = (String)element$iv;
                boolean bl2 = false;
                WebSocketPacketExtension wsPacketExtension = new WebSocketPacketExtension(wsUrl);
                iceUdpTransportPacketExtension.addChildExtension((ExtensionElement)wsPacketExtension);
            }
        }
        Logger $this$cdebug$iv = this.getLogger();
        boolean $i$f$cdebug = false;
        if ($this$cdebug$iv.isDebugEnabled()) {
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)("Transport description:\n" + XmlStringBuilderUtil.Companion.toStringOpt((ExtensionElement)iceUdpTransportPacketExtension)));
        }
        return iceUdpTransportPacketExtension;
    }

    public final void handleIncomingPacket(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        if (this.getVisitor()) {
            ByteBufferPool.returnBuffer(packetInfo.getPacket().buffer);
            return;
        }
        packetInfo.setEndpointId(this.getId());
        this.getConference().handleIncomingPacket(packetInfo);
    }

    @Override
    public boolean receivesSsrc(long ssrc) {
        return this.transceiver.receivesSsrc(ssrc);
    }

    public final boolean doesSsrcRewriting() {
        return this.doSsrcRewriting;
    }

    @Nullable
    public final String unmapRtcpFbSsrc(@NotNull RtcpFbPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        return this.videoSsrcs.unmapRtcpFbSsrc(packet);
    }

    @NotNull
    public HashSet<Long> getSsrcs() {
        return new HashSet<Long>(this.transceiver.getReceiveSsrcs());
    }

    @Override
    @NotNull
    public Instant getLastIncomingActivity() {
        return this.transceiver.getPacketIOActivity().getLastIncomingActivityInstant();
    }

    @Override
    public void requestKeyframe() {
        Transceiver.requestKeyFrame$default((Transceiver)this.transceiver, null, (int)1, null);
    }

    @Override
    public void requestKeyframe(long mediaSsrc) {
        this.transceiver.requestKeyFrame(Long.valueOf(mediaSsrc));
    }

    public final boolean isOversending() {
        return this.bitrateController.isOversending();
    }

    public final int numForwardedSources() {
        return this.bitrateController.numForwardedSources();
    }

    public final void setBandwidthAllocationSettings(@NotNull ReceiverVideoConstraintsMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.initialReceiverConstraintsReceived = true;
        this.bitrateController.setBandwidthAllocationSettings(message);
    }

    @Override
    @Nullable
    public MediaSourceDesc findVideoSourceProps(long ssrc) {
        AbstractEndpoint abstractEndpoint = this.getConference().getEndpointBySsrc(ssrc);
        if (abstractEndpoint != null) {
            AbstractEndpoint ep = abstractEndpoint;
            boolean bl = false;
            MediaSourceDesc[] $this$forEach$iv = ep.getMediaSources();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv;
                MediaSourceDesc s = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                if (s.findRtpEncodingDesc(ssrc) == null) continue;
                return s;
            }
        }
        this.getLogger().error(() -> Endpoint.findVideoSourceProps$lambda$37(ssrc));
        return null;
    }

    @Override
    @Nullable
    public AudioSourceDesc findAudioSourceProps(long ssrc) {
        AbstractEndpoint abstractEndpoint = this.getConference().getEndpointBySsrc(ssrc);
        if (abstractEndpoint != null) {
            Object v0;
            block2: {
                AbstractEndpoint ep = abstractEndpoint;
                boolean bl = false;
                AbstractEndpoint abstractEndpoint2 = ep;
                Iterable iterable = abstractEndpoint2 instanceof Endpoint ? (List<AudioSourceDesc>)((Endpoint)ep).audioSources : (abstractEndpoint2 instanceof RelayedEndpoint ? ((RelayedEndpoint)ep).getAudioSources() : CollectionsKt.emptyList());
                for (Object t : iterable) {
                    AudioSourceDesc it = (AudioSourceDesc)t;
                    boolean bl2 = false;
                    if (!(it.getSsrc() == ssrc)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            return v0;
        }
        this.getLogger().error(() -> Endpoint.findAudioSourceProps$lambda$40(ssrc));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNextSendSsrc() {
        Set<Long> set = this.sendSsrcs;
        synchronized (set) {
            long l;
            long ssrc;
            boolean bl = false;
            do {
                if (useRandomSendSsrcs) {
                    l = random.nextLong() & 0xFFFFFFFFL;
                    continue;
                }
                long l2 = this.nextSendSsrc;
                this.nextSendSsrc = l2 + 1L;
                l = l2;
            } while (!this.sendSsrcs.add(ssrc = l));
            long l3 = ssrc;
            return l3;
        }
    }

    @Override
    public void send(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        this.transceiver.sendPacket(packetInfo);
    }

    @Override
    public boolean shouldExpire() {
        if (this.iceTransport.hasFailed()) {
            this.getLogger().warn((Object)"Allowing to expire because ICE failed.");
            return true;
        }
        Instant lastActivity = this.getLastIncomingActivity();
        Instant now = this.clock.instant();
        if (Intrinsics.areEqual((Object)lastActivity, (Object)ClockUtils.NEVER)) {
            Duration timeSinceCreation = Duration.between(this.creationTime, now);
            if (timeSinceCreation.compareTo(epTimeout) > 0) {
                this.getLogger().info((Object)("Endpoint's ICE connection has neither failed nor connected after " + timeSinceCreation + " expiring"));
                return true;
            }
            return false;
        }
        Duration expireTimeout = VideobridgeExpireThreadConfig.config.getInactivityTimeout();
        if (Duration.between(lastActivity, now).compareTo(expireTimeout) > 0) {
            this.getLogger().info((Object)("Allowing to expire because of no activity in over " + expireTimeout));
            return true;
        }
        return false;
    }

    @Override
    public void otherEndpointExpired(@NotNull AbstractEndpoint expired) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)expired, (String)"expired");
        super.otherEndpointExpired(expired);
        Unit it = unit = Unit.INSTANCE;
        boolean bl = false;
        if (this.doSsrcRewriting) {
            this.audioSsrcs.removeByOwner(expired.getId());
            this.videoSsrcs.removeByOwner(expired.getId());
        }
    }

    public final void setLastN(int lastN) {
        this.bitrateController.setLastN(lastN);
    }

    private final boolean isTransportConnected() {
        return this.iceTransport.isConnected() && this.dtlsTransport.isConnected();
    }

    public final double getRtt() {
        return this.transceiver.getTransceiverStats().getEndpointConnectionStats().getRtt();
    }

    @Override
    public boolean wants(@NotNull PacketInfo packetInfo) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        if (!this.isTransportConnected()) {
            return false;
        }
        Packet packet = packetInfo.getPacket();
        if (packet instanceof VideoRtpPacket) {
            bl = this.acceptVideo && this.bitrateController.accept(packetInfo);
        } else if (packet instanceof AudioRtpPacket) {
            bl = this.acceptAudio;
        } else if (packet instanceof RtcpSrPacket) {
            bl = this.bitrateController.accept((RtcpSrPacket)packet);
        } else if (packet instanceof RtcpFbPliPacket || packet instanceof RtcpFbFirPacket) {
            bl = true;
        } else {
            this.getLogger().warn((Object)("Ignoring an unknown packet type:" + packet.getClass().getSimpleName()));
            bl = false;
        }
        return bl;
    }

    public final boolean wantsStatsFrom(@NotNull AbstractEndpoint ep) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)ep, (String)"ep");
            if (this.getConference().getEndpointCount() <= Endpoint.Companion.getStatsFilterThreshold()) {
                return true;
            }
            this.getLogger().debug(() -> Endpoint.wantsStatsFrom$lambda$45(ep, this));
            if (this.getConference().getSpeechActivity().isRecentSpeaker(ep) || this.getConference().isRankedSpeaker(ep)) {
                return true;
            }
            MediaSourceDesc[] $this$any$iv = ep.getMediaSources();
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                MediaSourceDesc element$iv;
                MediaSourceDesc source = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(this.bitrateController.isOnStageOrSelected(source) || this.bitrateController.hasNonZeroEffectiveConstraints(source))) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateStatsOnExpire() {
        void $this$filterTo$iv$iv;
        TransceiverStats transceiverStats = this.transceiver.getTransceiverStats();
        PacketStreamStats.Snapshot incomingStats = transceiverStats.getRtpReceiverStats().getPacketStreamStats();
        PacketStreamStats.Snapshot outgoingStats = transceiverStats.getOutgoingPacketStreamStats();
        CounterMetric.add$default((CounterMetric)VideobridgeMetrics.totalBytesReceived, (long)incomingStats.getBytes(), null, (int)2, null);
        CounterMetric.add$default((CounterMetric)VideobridgeMetrics.totalBytesSent, (long)outgoingStats.getBytes(), null, (int)2, null);
        CounterMetric.addAndGet$default((CounterMetric)VideobridgeMetrics.packetsReceived, (long)incomingStats.getPackets(), null, (int)2, null);
        CounterMetric.addAndGet$default((CounterMetric)VideobridgeMetrics.packetsSent, (long)outgoingStats.getPackets(), null, (int)2, null);
        CounterMetric.addAndGet$default((CounterMetric)VideobridgeMetrics.keyframesReceived, (long)transceiverStats.getRtpReceiverStats().getVideoParserStats().getNumKeyframes(), null, (int)2, null);
        CounterMetric.addAndGet$default((CounterMetric)VideobridgeMetrics.layeringChangesReceived, (long)transceiverStats.getRtpReceiverStats().getVideoParserStats().getNumLayeringChanges(), null, (int)2, null);
        Iterable $this$filter$iv = transceiverStats.getRtpReceiverStats().getIncomingStats().getSsrcStats().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IncomingSsrcStats.Snapshot it = (IncomingSsrcStats.Snapshot)element$iv$iv;
            boolean bl = false;
            if (!(it.getMediaType() == MediaType.VIDEO)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Duration durationActiveVideo = ClockUtils.sumOf((Iterable)((List)destination$iv$iv), Endpoint::updateStatsOnExpire$lambda$48);
        CounterMetric.add$default((CounterMetric)VideobridgeMetrics.totalVideoStreamMillisecondsReceived, (long)durationActiveVideo.toMillis(), null, (int)2, null);
        if (this.iceTransport.isConnected() && !this.dtlsTransport.isConnected()) {
            this.getLogger().info((Object)"Expiring an endpoint with ICE connected, but not DTLS.");
            CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.endpointsDtlsFailed, null, (int)1, null);
        }
    }

    @Override
    @NotNull
    public JSONObject getDebugState() {
        JSONObject jSONObject;
        block1: {
            JSONObject $this$_get_debugState__u24lambda_u2450 = jSONObject = super.getDebugState();
            boolean bl = false;
            $this$_get_debugState__u24lambda_u2450.put((Object)"bitrateController", (Object)this.bitrateController.getDebugState());
            $this$_get_debugState__u24lambda_u2450.put((Object)"bandwidthProbing", (Object)this.bandwidthProbing.getDebugState());
            $this$_get_debugState__u24lambda_u2450.put((Object)"iceTransport", (Object)this.iceTransport.getDebugState());
            $this$_get_debugState__u24lambda_u2450.put((Object)"dtlsTransport", (Object)this.dtlsTransport.getDebugState());
            $this$_get_debugState__u24lambda_u2450.put((Object)"transceiver", (Object)this.transceiver.getNodeStats().toJson());
            $this$_get_debugState__u24lambda_u2450.put((Object)"acceptAudio", (Object)this.acceptAudio);
            $this$_get_debugState__u24lambda_u2450.put((Object)"acceptVideo", (Object)this.acceptVideo);
            $this$_get_debugState__u24lambda_u2450.put((Object)"visitor", (Object)this.getVisitor());
            $this$_get_debugState__u24lambda_u2450.put((Object)"messageTransport", (Object)this.getMessageTransport().getDebugState());
            if (this.doSsrcRewriting) {
                $this$_get_debugState__u24lambda_u2450.put((Object)"audioSsrcs", (Object)this.audioSsrcs.getDebugState());
                $this$_get_debugState__u24lambda_u2450.put((Object)"videoSsrcs", (Object)this.videoSsrcs.getDebugState());
            }
            DcSctpTransport dcSctpTransport = this.sctpTransport;
            if (dcSctpTransport == null) break block1;
            DcSctpTransport it = dcSctpTransport;
            boolean bl2 = false;
            $this$_get_debugState__u24lambda_u2450.put((Object)"sctp", (Object)it.getDebugState());
        }
        return jSONObject;
    }

    @Override
    public void expire() {
        if (super.isExpired()) {
            return;
        }
        super.expire();
        try {
            Logger logger;
            this.bitrateController.expire();
            this.updateStatsOnExpire();
            this.transceiver.stop();
            Logger $this$cdebug$iv = this.getLogger();
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)this.transceiver.getNodeStats().prettyPrint(0));
            }
            $this$cdebug$iv = this.getLogger();
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                String string = this.bitrateController.getDebugState().toJSONString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJSONString(...)");
                logger.debug((Object)string);
            }
            $this$cdebug$iv = this.getLogger();
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)this.iceTransport.getDebugState().toJSONString());
            }
            $this$cdebug$iv = this.getLogger();
            $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)this.dtlsTransport.getDebugState().toJSONString());
            }
            this.getLogger().info((Object)("Spent " + this.bitrateController.getTotalOversendingTime().getSeconds() + " seconds oversending"));
            this.transceiver.teardown();
            this.getMessageTransport().close();
            DcSctpHandler dcSctpHandler = this.sctpHandler;
            if (dcSctpHandler != null) {
                dcSctpHandler.stop();
            }
            DcSctpTransport dcSctpTransport = this.sctpTransport;
            if (dcSctpTransport != null) {
                dcSctpTransport.stop();
            }
        }
        catch (Throwable t) {
            this.getLogger().error((Object)"Exception while expiring: ", t);
        }
        this.bandwidthProbing.setEnabled(false);
        recurringRunnableExecutor.deRegisterRecurringRunnable((RecurringRunnable)this.bandwidthProbing);
        this.getConference().getEncodingsManager().unsubscribe(this);
        this.dtlsTransport.stop();
        this.iceTransport.stop();
        this.outgoingSrtpPacketQueue.close();
        this.getLogger().info((Object)"Expired.");
    }

    public final void setInitialLastN(int initialLastN) {
        if (this.initialReceiverConstraintsReceived) {
            this.getLogger().info((Object)"Ignoring initialLastN, message transport already connected.");
        } else {
            this.getLogger().info((Object)("Setting initialLastN = " + initialLastN));
            this.bitrateController.setLastN(initialLastN);
        }
    }

    @JvmOverloads
    public Endpoint(@NotNull String id, @NotNull Conference conference, @NotNull Logger parentLogger, boolean iceControlling, boolean doSsrcRewriting, boolean visitor, boolean supportsPrivateAddresses) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)conference, (String)"conference");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this(id, conference, parentLogger, iceControlling, doSsrcRewriting, visitor, supportsPrivateAddresses, null, 128, null);
    }

    private static final Unit sctpPipeline$lambda$1(Endpoint this$0, PipelineBuilder $this$pipeline) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$this$pipeline, (String)"$this$pipeline");
            PipelineBuilder.node$default((PipelineBuilder)$this$pipeline, (Node)((Node)this$0.sctpRecvPcap), null, (int)2, null);
            DcSctpHandler dcSctpHandler = this$0.sctpHandler;
            if (dcSctpHandler == null) break block0;
            DcSctpHandler it = dcSctpHandler;
            boolean bl = false;
            PipelineBuilder.node$default((PipelineBuilder)$this$pipeline, (Node)((Node)it), null, (int)2, null);
        }
        return Unit.INSTANCE;
    }

    private static final boolean incomingDataChannelMessagesQueue$lambda$5(Endpoint this$0, PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        this$0.dataChannelHandler.consume(packetInfo);
        return true;
    }

    private static final List bitrateController$lambda$6(Endpoint this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getOrderedEndpoints();
    }

    private static final PacketInfo transceiver$lambda$9$lambda$8(Endpoint this$0, PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        return this$0.preProcess(packetInfo);
    }

    private static final BitrateControllerStatusSnapshot bandwidthProbing$lambda$10(Endpoint this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.bitrateController.getStatusSnapshot();
    }

    private static final Unit _set_mediaSources_$lambda$13(AbstractEndpoint.EventHandler $this$fireEvent) {
        Intrinsics.checkNotNullParameter((Object)$this$fireEvent, (String)"$this$fireEvent");
        $this$fireEvent.sourcesChanged();
        return Unit.INSTANCE;
    }

    private static final String doSendSrtp$lambda$15(PacketInfo $packetInfo) {
        Intrinsics.checkNotNullParameter((Object)$packetInfo, (String)"$packetInfo");
        return String.valueOf($packetInfo.getTimeline());
    }

    private static final String sendVideoConstraints$lambda$24(String $sourceName) {
        Intrinsics.checkNotNullParameter((Object)$sourceName, (String)"$sourceName");
        return "Suppressing sending a SenderVideoConstraints message, endpoint has no such source: " + $sourceName;
    }

    private static final void scheduleEndpointMessageTransportTimeout$lambda$28(Endpoint this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (!this$0.isExpired() && !this$0.getMessageTransport().isConnected()) {
            this$0.getLogger().error((Object)"EndpointMessageTransport still not connected.");
            CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.numEndpointsNoMessageTransportAfterDelay, null, (int)1, null);
        }
    }

    private static final void sendForwardedSourcesMessage$lambda$29(Endpoint this$0, ForwardedSourcesMessage $msg) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$msg, (String)"$msg");
        try {
            this$0.sendMessage($msg);
        }
        catch (Throwable t) {
            this$0.getLogger().warn((Object)"Failed to send message:", t);
        }
    }

    private static final String findVideoSourceProps$lambda$37(long $ssrc) {
        return "No properties found for SSRC " + $ssrc + ".";
    }

    private static final String findAudioSourceProps$lambda$40(long $ssrc) {
        return "No properties found for SSRC " + $ssrc + ".";
    }

    private static final String wantsStatsFrom$lambda$45(AbstractEndpoint $ep, Endpoint this$0) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$ep, (String)"$ep");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        StringBuilder $this$wantsStatsFrom_u24lambda_u2445_u24lambda_u2444 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$wantsStatsFrom_u24lambda_u2445_u24lambda_u2444.append("wantsStatsFrom(" + $ep.getId() + "): isRecentSpeaker=" + this$0.getConference().getSpeechActivity().isRecentSpeaker($ep) + " ");
        $this$wantsStatsFrom_u24lambda_u2445_u24lambda_u2444.append("isRankedSpeaker=" + this$0.getConference().isRankedSpeaker($ep) + " ");
        if ($ep.getMediaSources().length == 0) {
            $this$wantsStatsFrom_u24lambda_u2445_u24lambda_u2444.append("(no media sources)");
        }
        MediaSourceDesc[] $this$forEach$iv = $ep.getMediaSources();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            MediaSourceDesc element$iv;
            MediaSourceDesc source = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            String name = source.getSourceName();
            $this$wantsStatsFrom_u24lambda_u2445_u24lambda_u2444.append("isOnStageOrSelected(" + name + ")=" + this$0.bitrateController.isOnStageOrSelected(source) + " ");
            $this$wantsStatsFrom_u24lambda_u2445_u24lambda_u2444.append("hasNonZeroEffectiveConstraints(" + name + ")=");
            $this$wantsStatsFrom_u24lambda_u2445_u24lambda_u2444.append(this$0.bitrateController.hasNonZeroEffectiveConstraints(source) + " ");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final Duration updateStatsOnExpire$lambda$48(IncomingSsrcStats.Snapshot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getDurationActive();
    }

    public static final /* synthetic */ PacketInfoQueue access$getOutgoingSrtpPacketQueue$p(Endpoint $this) {
        return $this.outgoingSrtpPacketQueue;
    }

    public static final /* synthetic */ IceTransport access$getIceTransport$p(Endpoint $this) {
        return $this.iceTransport;
    }

    public static final /* synthetic */ boolean access$getCryptex$p(Endpoint $this) {
        return $this.cryptex;
    }

    public static final /* synthetic */ boolean access$doSendSrtp(Endpoint $this, PacketInfo packetInfo) {
        return $this.doSendSrtp(packetInfo);
    }

    public static final /* synthetic */ void access$effectiveVideoConstraintsChanged(Endpoint $this, Map oldEffectiveConstraints, Map newEffectiveConstraints) {
        $this.effectiveVideoConstraintsChanged(oldEffectiveConstraints, newEffectiveConstraints);
    }

    public static final /* synthetic */ CounterMetric access$getDroppedPacketsMetric$cp() {
        return droppedPacketsMetric;
    }

    public static final /* synthetic */ CounterMetric access$getExceptionsMetric$cp() {
        return exceptionsMetric;
    }

    static {
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        droppedPacketsMetric = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"srtp_send_queue_dropped_packets", (String)"Number of packets dropped out of the Endpoint SRTP send queue.", (long)0L, null, (int)12, null);
        exceptionsMetric = MetricsContainer.registerCounter$default((MetricsContainer)VideobridgeMetricsContainer.Companion.getInstance(), (String)"srtp_send_queue_exceptions", (String)"Number of exceptions from the Endpoint SRTP send queue.", (long)0L, null, (int)12, null);
        queueErrorCounter = new CountingErrorHandler(){

            public void packetDropped() {
                Unit unit;
                super.packetDropped();
                Unit it = unit = Unit.INSTANCE;
                boolean bl = false;
                CounterMetric.inc$default((CounterMetric)Endpoint.access$getDroppedPacketsMetric$cp(), null, (int)1, null);
                CounterMetric.inc$default((CounterMetric)QueueMetrics.INSTANCE.getDroppedPackets(), null, (int)1, null);
            }

            public void packetHandlingFailed(Throwable t) {
                Unit unit;
                super.packetHandlingFailed(t);
                Unit it = unit = Unit.INSTANCE;
                boolean bl = false;
                CounterMetric.inc$default((CounterMetric)Endpoint.access$getExceptionsMetric$cp(), null, (int)1, null);
                CounterMetric.inc$default((CounterMetric)QueueMetrics.INSTANCE.getExceptions(), null, (int)1, null);
            }
        };
        recurringRunnableExecutor = new RecurringRunnableExecutor(Endpoint.class.getSimpleName());
        epTimeout = DurationKt.getMins((int)2);
        timelineCounter = new AtomicLong();
        boolean $i$f$config = false;
        SupplierBuilder $this$timelineFraction_delegate_u24lambda_u2455 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Long.TYPE));
        boolean bl = false;
        $this$timelineFraction_delegate_u24lambda_u2455.from("jmt.debug.packet-timeline.log-fraction", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        timelineFraction$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$statsFilterThreshold_delegate_u24lambda_u2456 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Integer.TYPE));
        boolean bl2 = false;
        $this$statsFilterThreshold_delegate_u24lambda_u2456.from("videobridge.stats-filter-threshold", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        statsFilterThreshold$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        useRandomSendSsrcs = true;
        random = new SecureRandom();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0014\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010 \u001a\u00020\u0016X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jitsi/videobridge/Endpoint$Companion;", "", "<init>", "()V", "droppedPacketsMetric", "Lorg/jitsi/metrics/CounterMetric;", "exceptionsMetric", "queueErrorCounter", "Lorg/jitsi/utils/queue/CountingErrorHandler;", "recurringRunnableExecutor", "Lorg/jitsi/utils/concurrent/RecurringRunnableExecutor;", "epTimeout", "Ljava/time/Duration;", "timelineCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "timelineFraction", "", "getTimelineFraction", "()J", "timelineFraction$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "logTimeline", "", "SRTP_QUEUE_ENTRY_EVENT", "", "SRTP_QUEUE_EXIT_EVENT", "SENT_OVER_ICE_TRANSPORT_EVENT", "statsFilterThreshold", "", "getStatsFilterThreshold", "()I", "statsFilterThreshold$delegate", "useRandomSendSsrcs", "random", "Ljava/security/SecureRandom;", "jitsi-videobridge"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final long getTimelineFraction() {
            return ((Number)timelineFraction$delegate.getValue((Object)this, $$delegatedProperties[0])).longValue();
        }

        public final boolean logTimeline() {
            return timelineCounter.getAndIncrement() % this.getTimelineFraction() == 0L;
        }

        private final int getStatsFilterThreshold() {
            return ((Number)statsFilterThreshold$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "timelineFraction", "getTimelineFraction()J", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "statsFilterThreshold", "getStatsFilterThreshold()I", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/videobridge/Endpoint$SctpCallbacks;", "Lorg/jitsi/videobridge/dcsctp/DcSctpBaseCallbacks;", "transport", "Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;", "<init>", "(Lorg/jitsi/videobridge/Endpoint;Lorg/jitsi/videobridge/dcsctp/DcSctpTransport;)V", "sendPacketWithStatus", "Lorg/jitsi/dcsctp4j/SendPacketStatus;", "packet", "", "OnMessageReceived", "", "message", "Lorg/jitsi/dcsctp4j/DcSctpMessage;", "OnError", "error", "Lorg/jitsi/dcsctp4j/ErrorKind;", "", "OnAborted", "OnConnected", "OnClosed", "jitsi-videobridge"})
    private final class SctpCallbacks
    extends DcSctpBaseCallbacks {
        public SctpCallbacks(DcSctpTransport transport) {
            Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
            super(transport, null, 2, null);
        }

        @NotNull
        public SendPacketStatus sendPacketWithStatus(@NotNull byte[] packet) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            try {
                byte[] newBuf = ByteBufferPool.getBuffer(packet.length);
                System.arraycopy(packet, 0, newBuf, 0, packet.length);
                ToggleablePcapWriter.PcapWriterNode pcapWriterNode = Endpoint.this.sctpSendPcap;
                Intrinsics.checkNotNull((Object)newBuf);
                pcapWriterNode.observe(newBuf, 0, packet.length);
                Endpoint.this.dtlsTransport.sendDtlsData(newBuf, 0, packet.length);
                return SendPacketStatus.kSuccess;
            }
            catch (Throwable e) {
                Endpoint.this.getLogger().warn((Object)"Exception sending SCTP packet", e);
                return SendPacketStatus.kError;
            }
        }

        public void OnMessageReceived(@NotNull DcSctpMessage message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            try {
                DataChannelPacket dataChannelPacket = new DataChannelPacket(message);
                Endpoint.this.incomingDataChannelMessagesQueue.add((Object)new PacketInfo((Packet)dataChannelPacket, 0, null, 6, null));
            }
            catch (Throwable e) {
                Endpoint.this.getLogger().warn((Object)"Exception processing SCTP message", e);
            }
        }

        public void OnError(@NotNull ErrorKind error, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Endpoint.this.getLogger().warn((Object)("SCTP error " + error + ": " + message));
        }

        public void OnAborted(@NotNull ErrorKind error, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Endpoint.this.getLogger().info((Object)("SCTP aborted with error " + error + ": " + message));
        }

        public void OnConnected() {
            try {
                Endpoint.this.getLogger().info((Object)"SCTP connection is ready, creating the Data channel stack");
                DataChannelStack dataChannelStack = new DataChannelStack((arg_0, arg_1, arg_2) -> SctpCallbacks.OnConnected$lambda$0(Endpoint.this, arg_0, arg_1, arg_2), Endpoint.this.getLogger());
                Endpoint.this.dataChannelStack = dataChannelStack;
                dataChannelStack.onDataChannelStackEvents(arg_0 -> SctpCallbacks.OnConnected$lambda$1(Endpoint.this, arg_0));
                Endpoint.this.dataChannelHandler.setDataChannelStack(dataChannelStack);
                Endpoint.this.getLogger().info((Object)"Will wait for the remote side to open the data channel.");
            }
            catch (Throwable e) {
                Endpoint.this.getLogger().warn((Object)"Exception processing SCTP connected event", e);
            }
        }

        public void OnClosed() {
            Endpoint.this.getLogger().info((Object)"SCTP connection closed");
        }

        private static final int OnConnected$lambda$0(Endpoint this$0, ByteBuffer data, int sid, int ppid) {
            int n;
            SendStatus status;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            DcSctpMessage message = new DcSctpMessage((short)sid, ppid, data.array());
            DcSctpTransport dcSctpTransport = this$0.sctpTransport;
            SendStatus sendStatus = status = dcSctpTransport != null ? dcSctpTransport.send(message, DcSctpTransport.Companion.getDEFAULT_SEND_OPTIONS()) : null;
            if (status == SendStatus.kSuccess) {
                n = 0;
            } else {
                this$0.getLogger().error((Object)("Error sending to SCTP: " + status));
                n = -1;
            }
            return n;
        }

        private static final void OnConnected$lambda$1(Endpoint this$0, DataChannel dataChannel) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.getLogger().info((Object)"Remote side opened a data channel.");
            this$0.getMessageTransport().setDataChannel(dataChannel);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0017\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/videobridge/Endpoint$TransceiverEventHandlerImpl;", "Lorg/jitsi/nlj/TransceiverEventHandler;", "<init>", "(Lorg/jitsi/videobridge/Endpoint;)V", "audioLevelReceived", "", "sourceSsrc", "", "level", "bandwidthEstimationChanged", "", "newValue", "Lorg/jitsi/nlj/util/Bandwidth;", "bandwidthEstimationChanged-_2icLw0", "(D)V", "jitsi-videobridge"})
    @SourceDebugExtension(value={"SMAP\nEndpoint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Endpoint.kt\norg/jitsi/videobridge/Endpoint$TransceiverEventHandlerImpl\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,1191:1\n63#2,4:1192\n*S KotlinDebug\n*F\n+ 1 Endpoint.kt\norg/jitsi/videobridge/Endpoint$TransceiverEventHandlerImpl\n*L\n1185#1:1192,4\n*E\n"})
    private final class TransceiverEventHandlerImpl
    implements TransceiverEventHandler {
        public boolean audioLevelReceived(long sourceSsrc, long level) {
            return Endpoint.this.getConference().levelChanged(Endpoint.this, level);
        }

        public void bandwidthEstimationChanged-_2icLw0(double newValue) {
            Logger $this$cdebug$iv = Endpoint.this.getLogger();
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)("Estimated bandwidth is now " + Bandwidth.toString-impl((double)newValue)));
            }
            Endpoint.this.bitrateController.bandwidthChanged((long)newValue);
            Endpoint.this.bandwidthProbing.bandwidthEstimationChanged-_2icLw0(newValue);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EndpointDebugFeatures.values().length];
            try {
                nArray[EndpointDebugFeatures.PCAP_DUMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EndpointDebugFeatures.SCTP_PCAP_DUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

