/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import jakarta.servlet.Servlet;
import java.time.Clock;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.ice4j.ice.harvest.AbstractUdpListener;
import org.ice4j.ice.harvest.MappingCandidateHarvesters;
import org.ice4j.util.Buffer;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigException;
import org.jitsi.metaconfig.MetaconfigLogger;
import org.jitsi.metaconfig.MetaconfigSettings;
import org.jitsi.nlj.dtls.DtlsConfig;
import org.jitsi.rest.JettyBundleActivatorConfig;
import org.jitsi.rest.JettyHelpers;
import org.jitsi.rtp.util.BufferPool;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.shutdown.ShutdownServiceImpl;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.utils.queue.PacketQueue;
import org.jitsi.videobridge.MainKt;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.VideobridgeExpireThread;
import org.jitsi.videobridge.health.JvbHealthChecker;
import org.jitsi.videobridge.ice.Harvesters;
import org.jitsi.videobridge.metrics.Metrics;
import org.jitsi.videobridge.metrics.VideobridgePeriodicMetrics;
import org.jitsi.videobridge.rest.root.Application;
import org.jitsi.videobridge.stats.MucPublisher;
import org.jitsi.videobridge.util.ByteBufferPool;
import org.jitsi.videobridge.util.TaskPools;
import org.jitsi.videobridge.util.UlimitCheck;
import org.jitsi.videobridge.version.JvbVersionService;
import org.jitsi.videobridge.websocket.ColibriWebSocketService;
import org.jitsi.videobridge.websocket.ColibriWebSocketServiceSupplierKt;
import org.jitsi.videobridge.xmpp.Smack;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.videobridge.xmpp.config.XmppClientConnectionConfig;
import sun.misc.Signal;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0003\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\b\u0010\b\u001a\u00020\u0001H\u0002\u001a\b\u0010\t\u001a\u00020\u0001H\u0002\u00a8\u0006\n"}, d2={"main", "", "setupMetaconfigLogger", "setSystemPropertyDefaults", "getSystemPropertyDefaults", "", "", "startIce4j", "stopIce4j", "setupBufferPools", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\norg/jitsi/videobridge/MainKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,275:1\n1#2:276\n1855#3,2:277\n1855#3,2:281\n215#4,2:279\n*S KotlinDebug\n*F\n+ 1 Main.kt\norg/jitsi/videobridge/MainKt\n*L\n170#1:277,2\n235#1:281,2\n222#1:279,2\n*E\n"})
public final class MainKt {
    public static final void main() {
        Server server;
        Server server2;
        VideobridgeExpireThread videobridgeExpireThread;
        LoggerImpl logger = new LoggerImpl("org.jitsi.videobridge.Main");
        Thread.setDefaultUncaughtExceptionHandler((arg_0, arg_1) -> MainKt.main$lambda$0(logger, arg_0, arg_1));
        MainKt.setupMetaconfigLogger();
        MainKt.setSystemPropertyDefaults();
        System.setProperty("org.eclipse.jetty.util.log.class", "org.eclipse.jetty.util.log.JavaUtilLog");
        Metrics.INSTANCE.start();
        JitsiConfig.Companion.reloadNewConfig();
        logger.info((Object)("Starting jitsi-videobridge version " + JvbVersionService.Companion.getInstance().getCurrentVersion()));
        UlimitCheck.printUlimits();
        MainKt.startIce4j();
        MainKt.setupBufferPools();
        Harvesters.Companion.init();
        Smack.INSTANCE.initialize();
        PacketQueue.setEnableStatisticsDefault((boolean)true);
        try {
            DtlsConfig.Companion.getConfig().getCipherSuites();
        }
        catch (ConfigException ce) {
            logger.error((Object)("Dtls configuration error: " + ce));
            System.exit(78);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        XmppConnection $this$main_u24lambda_u241 = ce = new XmppConnection();
        boolean bl = false;
        $this$main_u24lambda_u241.start();
        XmppConnection xmppConnection = ce;
        ShutdownServiceImpl shutdownService = new ShutdownServiceImpl();
        Videobridge videobridge = new Videobridge(xmppConnection, shutdownService, JvbVersionService.Companion.getInstance().getCurrentVersion(), Clock.systemUTC());
        VideobridgeExpireThread $this$main_u24lambda_u242 = videobridgeExpireThread = new VideobridgeExpireThread(videobridge);
        boolean bl2 = false;
        $this$main_u24lambda_u242.start();
        VideobridgeExpireThread videobridgeExpireThread2 = videobridgeExpireThread;
        Metrics.INSTANCE.getMetricsUpdater().addUpdateTask(() -> MainKt.main$lambda$3(videobridge));
        JvbHealthChecker jvbHealthChecker = videobridge.getJvbHealthChecker();
        Intrinsics.checkNotNullExpressionValue((Object)jvbHealthChecker, (String)"getJvbHealthChecker(...)");
        JvbHealthChecker healthChecker2 = jvbHealthChecker;
        ScheduledExecutorService scheduledExecutorService = TaskPools.SCHEDULED_POOL;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"SCHEDULED_POOL");
        MucPublisher $this$main_u24lambda_u244 = bl2 = new MucPublisher(scheduledExecutorService, XmppClientConnectionConfig.config.getPresenceInterval(), xmppConnection);
        boolean bl3 = false;
        $this$main_u24lambda_u244.start();
        MucPublisher presencePublisher = bl2;
        JettyBundleActivatorConfig publicServerConfig = new JettyBundleActivatorConfig("org.jitsi.videobridge.rest", "videobridge.http-servers.public");
        if (JettyHelpers.isEnabled((JettyBundleActivatorConfig)publicServerConfig)) {
            Server server3;
            logger.info((Object)"Starting public http server");
            ColibriWebSocketService websocketService = new ColibriWebSocketService(publicServerConfig.isTls());
            ColibriWebSocketServiceSupplierKt.singleton().setColibriWebSocketService(websocketService);
            Server it = server3 = JettyHelpers.createServer((JettyBundleActivatorConfig)publicServerConfig);
            boolean bl4 = false;
            websocketService.registerServlet(JettyHelpers.getServletContextHandler((Server)it), videobridge);
            it.start();
            server2 = server3;
        } else {
            logger.info((Object)"Not starting public http server");
            server2 = null;
        }
        Server publicHttpServer = server2;
        JettyBundleActivatorConfig privateServerConfig = new JettyBundleActivatorConfig("org.jitsi.videobridge.rest.private", "videobridge.http-servers.private");
        if (JettyHelpers.isEnabled((JettyBundleActivatorConfig)privateServerConfig)) {
            Server bl4;
            logger.info((Object)"Starting private http server");
            Application restApp = new Application(videobridge, xmppConnection, JvbVersionService.Companion.getInstance().getCurrentVersion(), healthChecker2);
            Server it = bl4 = JettyHelpers.createServer((JettyBundleActivatorConfig)privateServerConfig);
            boolean bl5 = false;
            JettyHelpers.getServletContextHandler((Server)it).addServlet(new ServletHolder((Servlet)new ServletContainer((ResourceConfig)restApp)), "/*");
            JettyHelpers.enableCors$default((ServletContextHandler)JettyHelpers.getServletContextHandler((Server)it), null, (int)1, null);
            it.start();
            server = bl4;
        } else {
            logger.info((Object)"Not starting private http server");
            server = null;
        }
        Server privateHttpServer = server;
        Ref.IntRef exitStatus = new Ref.IntRef();
        Object[] bl4 = new String[]{"TERM", "HUP", "INT"};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])bl4);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String signalName = (String)element$iv;
            boolean bl6 = false;
            try {
                Signal.handle(new Signal(signalName), arg_0 -> MainKt.main$lambda$8$lambda$7(exitStatus, logger, shutdownService, arg_0));
            }
            catch (IllegalArgumentException e) {
                logger.warn((Object)("Unable to register signal '" + signalName + "'"), (Throwable)e);
            }
        }
        shutdownService.waitForShutdown();
        logger.info((Object)"Bridge shutting down");
        healthChecker2.stop();
        presencePublisher.stop();
        xmppConnection.stop();
        try {
            Server server4 = publicHttpServer;
            if (server4 != null) {
                server4.stop();
            }
            Server server5 = privateHttpServer;
            if (server5 != null) {
                server5.stop();
            }
        }
        catch (Throwable t) {
            logger.error((Object)"Error shutting down http servers", t);
        }
        videobridgeExpireThread2.stop();
        videobridge.stop();
        MainKt.stopIce4j();
        Metrics.INSTANCE.stop();
        TaskPools.SCHEDULED_POOL.shutdownNow();
        TaskPools.CPU_POOL.shutdownNow();
        TaskPools.IO_POOL.shutdownNow();
        System.exit(exitStatus.element);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void setupMetaconfigLogger() {
        LoggerImpl configLogger = new LoggerImpl("org.jitsi.config");
        MetaconfigSettings.Companion.setLogger(new MetaconfigLogger(configLogger){
            final /* synthetic */ LoggerImpl $configLogger;
            {
                this.$configLogger = $configLogger;
            }

            public void warn(Function0<String> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                this.$configLogger.warn(() -> setupMetaconfigLogger.1.warn$lambda$0(block));
            }

            public void error(Function0<String> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                this.$configLogger.error(() -> setupMetaconfigLogger.1.error$lambda$1(block));
            }

            public void debug(Function0<String> block) {
                Intrinsics.checkNotNullParameter(block, (String)"block");
                this.$configLogger.debug(() -> setupMetaconfigLogger.1.debug$lambda$2(block));
            }

            private static final String warn$lambda$0(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke();
            }

            private static final String error$lambda$1(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke();
            }

            private static final String debug$lambda$2(Function0 $tmp0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke();
            }
        });
    }

    private static final void setSystemPropertyDefaults() {
        Map<String, String> defaults;
        Map<String, String> $this$forEach$iv = defaults = MainKt.getSystemPropertyDefaults();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl = false;
            String key = entry.getKey();
            String value = entry.getValue();
            if (System.getProperty(key) != null) continue;
            System.setProperty(key, value);
        }
    }

    private static final Map<String, String> getSystemPropertyDefaults() {
        Map defaults;
        block1: {
            List ice4jPropNames;
            defaults = new LinkedHashMap();
            ConfigurationService cfg = JitsiConfig.Companion.getSipCommunicatorProps();
            List list = ice4jPropNames = cfg.getPropertyNamesByPrefix("org.ice4j", false);
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String value;
                String key = (String)element$iv;
                boolean bl = false;
                if (cfg.getString(key) == null) continue;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)key);
                defaults.put(key, value);
            }
        }
        return defaults;
    }

    private static final void startIce4j() {
        AbstractUdpListener.USE_PUSH_API = true;
        ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, MainKt::startIce4j$lambda$12, (int)30, null);
    }

    private static final void stopIce4j() {
        Harvesters.Companion.close();
    }

    private static final void setupBufferPools() {
        BufferPool.Companion.setGetArray(MainKt::setupBufferPools$lambda$13);
        BufferPool.Companion.setReturnArray(MainKt::setupBufferPools$lambda$14);
        org.jitsi.nlj.util.BufferPool.Companion.setGetBuffer(MainKt::setupBufferPools$lambda$15);
        org.jitsi.nlj.util.BufferPool.Companion.setReturnBuffer(MainKt::setupBufferPools$lambda$16);
        org.ice4j.util.BufferPool.getBuffer = MainKt::setupBufferPools$lambda$17;
        org.ice4j.util.BufferPool.returnBuffer = MainKt::setupBufferPools$lambda$18;
        AbstractUdpListener.BYTES_TO_LEAVE_AT_START_OF_PACKET = 10;
        AbstractUdpListener.BYTES_TO_LEAVE_AT_END_OF_PACKET = 20;
    }

    public static /* synthetic */ void main(String[] args) {
        MainKt.main();
    }

    private static final void main$lambda$0(LoggerImpl $logger, Thread thread, Throwable exception) {
        Intrinsics.checkNotNullParameter((Object)$logger, (String)"$logger");
        $logger.error((Object)("An uncaught exception occurred in thread=" + thread), exception);
    }

    private static final Unit main$lambda$3(Videobridge $videobridge) {
        Intrinsics.checkNotNullParameter((Object)$videobridge, (String)"$videobridge");
        VideobridgePeriodicMetrics.INSTANCE.update($videobridge);
        return Unit.INSTANCE;
    }

    private static final void main$lambda$8$lambda$7(Ref.IntRef $exitStatus, LoggerImpl $logger, ShutdownServiceImpl $shutdownService, Signal signal) {
        Intrinsics.checkNotNullParameter((Object)$exitStatus, (String)"$exitStatus");
        Intrinsics.checkNotNullParameter((Object)$logger, (String)"$logger");
        Intrinsics.checkNotNullParameter((Object)$shutdownService, (String)"$shutdownService");
        $exitStatus.element = signal.getNumber() + 128;
        $logger.info((Object)("Caught signal " + signal + ", shutting down."));
        $shutdownService.beginShutdown();
    }

    private static final Unit startIce4j$lambda$12() {
        MappingCandidateHarvesters.initialize();
        return Unit.INSTANCE;
    }

    private static final byte[] setupBufferPools$lambda$13(int it) {
        return ByteBufferPool.getBuffer(it);
    }

    private static final Unit setupBufferPools$lambda$14(byte[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ByteBufferPool.returnBuffer(it);
        return Unit.INSTANCE;
    }

    private static final byte[] setupBufferPools$lambda$15(int it) {
        return ByteBufferPool.getBuffer(it);
    }

    private static final Unit setupBufferPools$lambda$16(byte[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ByteBufferPool.returnBuffer(it);
        return Unit.INSTANCE;
    }

    private static final Buffer setupBufferPools$lambda$17(int len) {
        byte[] b = ByteBufferPool.getBuffer(len);
        Intrinsics.checkNotNull((Object)b);
        return new Buffer(b, 0, b.length, null, null, null, 56, null);
    }

    private static final Unit setupBufferPools$lambda$18(Buffer it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ByteBufferPool.returnBuffer(it.getBuffer());
        return Unit.INSTANCE;
    }
}

