/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.rtcpfb.RtcpFbPacket;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.utils.LRUCache;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.ReceiveSsrc;
import org.jitsi.videobridge.SendSource;
import org.jitsi.videobridge.SourceDesc;
import org.jitsi.videobridge.SsrcRewriter;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u0015H$J\u0016\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00190%H$J4\u0010&\u001a\u0004\u0018\u00010\u00192\u0006\u0010!\u001a\u00020\u00152\u0006\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u001b2\u0010\b\u0002\u0010)\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010*H\u0002J\u000e\u0010+\u001a\u00020#2\u0006\u0010,\u001a\u00020\tJ\u0014\u0010-\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020.0%J\u0006\u0010/\u001a\u00020#J\u0018\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u0002022\b\b\u0002\u00103\u001a\u00020\u001bJ\u000e\u00104\u001a\u00020\u001b2\u0006\u00101\u001a\u000205J\u0010\u00106\u001a\u0004\u0018\u00010\t2\u0006\u00101\u001a\u000207J\u0006\u00108\u001a\u000209J\b\u0010:\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/jitsi/videobridge/SsrcCache;", "", "size", "", "ep", "Lorg/jitsi/videobridge/SsrcRewriter;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "label", "", "<init>", "(ILorg/jitsi/videobridge/SsrcRewriter;Lorg/jitsi/utils/logging2/Logger;Ljava/lang/String;)V", "getSize", "()I", "getEp", "()Lorg/jitsi/videobridge/SsrcRewriter;", "getParentLogger", "()Lorg/jitsi/utils/logging2/Logger;", "logger", "receivedSsrcs", "Ljava/util/HashMap;", "", "Lorg/jitsi/videobridge/ReceiveSsrc;", "sendSources", "Lorg/jitsi/utils/LRUCache;", "Lorg/jitsi/videobridge/SendSource;", "allowCreateOnPacket", "", "getAllowCreateOnPacket", "()Z", "remapCount", "findSourceProps", "Lorg/jitsi/videobridge/SourceDesc;", "ssrc", "notifyMappings", "", "sources", "", "getSendSource", "props", "allowCreate", "remappings", "", "removeByOwner", "owner", "activate", "Lorg/jitsi/nlj/MediaSourceDesc;", "sendAllMappings", "rewriteRtp", "packet", "Lorg/jitsi/rtp/rtp/RtpPacket;", "start", "rewriteRtcp", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "unmapRtcpFbSsrc", "Lorg/jitsi/rtp/rtcp/rtcpfb/RtcpFbPacket;", "getDebugState", "Lorg/json/simple/JSONObject;", "toString", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nSsrcCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SsrcCache.kt\norg/jitsi/videobridge/SsrcCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,751:1\n1#2:752\n766#3:753\n857#3,2:754\n1855#3,2:756\n*S KotlinDebug\n*F\n+ 1 SsrcCache.kt\norg/jitsi/videobridge/SsrcCache\n*L\n383#1:753\n383#1:754,2\n385#1:756,2\n*E\n"})
public abstract class SsrcCache {
    private final int size;
    @NotNull
    private final SsrcRewriter ep;
    @NotNull
    private final Logger parentLogger;
    @NotNull
    private final Logger logger;
    @NotNull
    private final HashMap<Long, ReceiveSsrc> receivedSsrcs;
    @NotNull
    private final LRUCache<Long, SendSource> sendSources;
    private int remapCount;

    /*
     * WARNING - void declaration
     */
    public SsrcCache(int size, @NotNull SsrcRewriter ep, @NotNull Logger parentLogger, @NotNull String label) {
        void $this$logger_u24lambda_u240;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)ep, (String)"ep");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.size = size;
        this.ep = ep;
        this.parentLogger = parentLogger;
        Logger logger2 = logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)this.parentLogger, null, (int)2, null);
        SsrcCache ssrcCache = this;
        boolean bl = false;
        $this$logger_u24lambda_u240.addContext("type", label);
        ssrcCache.logger = logger;
        this.receivedSsrcs = new HashMap();
        this.sendSources = new LRUCache(this.size, true);
    }

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final SsrcRewriter getEp() {
        return this.ep;
    }

    @NotNull
    public final Logger getParentLogger() {
        return this.parentLogger;
    }

    protected abstract boolean getAllowCreateOnPacket();

    @Nullable
    protected abstract SourceDesc findSourceProps(long var1);

    protected abstract void notifyMappings(@NotNull List<SendSource> var1);

    private final SendSource getSendSource(long ssrc, SourceDesc props, boolean allowCreate, List<SendSource> remappings) {
        Ref.ObjectRef sendSource;
        block7: {
            sendSource = new Ref.ObjectRef();
            sendSource.element = this.sendSources.get((Object)ssrc);
            if (sendSource.element != null) break block7;
            if (!allowCreate) {
                return null;
            }
            if (this.sendSources.size() == this.size) {
                Map.Entry eldest = this.sendSources.eldest();
                sendSource.element = new SendSource(props, ((SendSource)eldest.getValue()).getSend1(), ((SendSource)eldest.getValue()).getSend2());
                this.logger.debug(() -> SsrcCache.getSendSource$lambda$1(props, sendSource, eldest));
                ReceiveSsrc receiveSsrc = this.receivedSsrcs.get(props.getSsrc1());
                if (receiveSsrc != null) {
                    receiveSsrc.setHasDeltas(false);
                }
                if (props.getSsrc2() != -1L) {
                    ReceiveSsrc receiveSsrc2 = this.receivedSsrcs.get(props.getSsrc2());
                    if (receiveSsrc2 != null) {
                        receiveSsrc2.setHasDeltas(false);
                    }
                }
                ++this.remapCount;
            } else {
                long ssrc1 = this.ep.getNextSendSsrc();
                long ssrc2 = this.ep.getNextSendSsrc();
                sendSource.element = new SendSource(props, ssrc1, ssrc2);
                this.logger.debug(() -> SsrcCache.getSendSource$lambda$2(props, sendSource));
            }
            Long l = ssrc;
            ((Map)this.sendSources).put(l, sendSource.element);
            List<SendSource> list = remappings;
            if (list != null) {
                list.add((SendSource)sendSource.element);
            }
        }
        return (SendSource)sendSource.element;
    }

    static /* synthetic */ SendSource getSendSource$default(SsrcCache ssrcCache, long l, SourceDesc sourceDesc, boolean bl, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getSendSource");
        }
        if ((n & 8) != 0) {
            list = null;
        }
        return ssrcCache.getSendSource(l, sourceDesc, bl, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeByOwner(@NotNull String owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            boolean bl = false;
            boolean bl2 = this.sendSources.values().removeIf(arg_0 -> SsrcCache.removeByOwner$lambda$5$lambda$4(arg_0 -> SsrcCache.removeByOwner$lambda$5$lambda$3(owner, arg_0), arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void activate(@NotNull List<MediaSourceDesc> sources) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        List remappings = new ArrayList();
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = sources;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MediaSourceDesc source = (MediaSourceDesc)element$iv$iv;
                boolean bl2 = false;
                if (!(this.sendSources.get((Object)source.getPrimarySSRC()) == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MediaSourceDesc source = (MediaSourceDesc)element$iv;
                boolean bl3 = false;
                this.getSendSource(source.getPrimarySSRC(), new SourceDesc(source), true, remappings);
            }
            this.logger.debug(() -> SsrcCache.activate$lambda$9$lambda$8(this));
            Unit unit = Unit.INSTANCE;
        }
        if (!((Collection)remappings).isEmpty()) {
            this.notifyMappings(remappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sendAllMappings() {
        List remappings = null;
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            boolean bl = false;
            Collection collection = this.sendSources.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
            remappings = CollectionsKt.toList((Iterable)collection);
            Unit unit = Unit.INSTANCE;
        }
        if (!((Collection)remappings).isEmpty()) {
            this.notifyMappings(remappings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean rewriteRtp(@NotNull RtpPacket packet, boolean start2) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        List remappings = new ArrayList();
        boolean send = false;
        try {
            LRUCache<Long, SendSource> lRUCache = this.sendSources;
            synchronized (lRUCache) {
                SendSource ss;
                boolean bl = false;
                ReceiveSsrc rs = this.receivedSsrcs.get(packet.getSsrc());
                if (rs == null) {
                    SourceDesc sourceDesc = this.findSourceProps(packet.getSsrc());
                    if (sourceDesc == null) {
                        return false;
                    }
                    SourceDesc props = sourceDesc;
                    rs = new ReceiveSsrc(props);
                    ((Map)this.receivedSsrcs).put(packet.getSsrc(), rs);
                    this.logger.debug(() -> SsrcCache.rewriteRtp$lambda$12$lambda$11(packet));
                }
                if ((ss = this.getSendSource(rs.getProps().getSsrc1(), rs.getProps(), this.getAllowCreateOnPacket(), remappings)) != null) {
                    send = ss.rewriteRtp(packet, start2, rs);
                }
                Unit unit = Unit.INSTANCE;
            }
            if (!(!((Collection)remappings).isEmpty())) return send;
            this.notifyMappings(remappings);
            return send;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error rewriting SSRC, packet " + packet), (Throwable)e);
            return false;
        }
    }

    public static /* synthetic */ boolean rewriteRtp$default(SsrcCache ssrcCache, RtpPacket rtpPacket, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: rewriteRtp");
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        return ssrcCache.rewriteRtp(rtpPacket, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean rewriteRtcp(@NotNull RtcpPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            SendSource sendSource;
            block6: {
                ReceiveSsrc receiveSsrc;
                block5: {
                    boolean bl = false;
                    if (this.receivedSsrcs.get(packet.getSenderSsrc()) != null) break block5;
                    boolean bl2 = false;
                    return bl2;
                }
                ReceiveSsrc rs = receiveSsrc;
                if (SsrcCache.getSendSource$default(this, rs.getProps().getSsrc1(), rs.getProps(), false, null, 8, null) != null) break block6;
                boolean bl = false;
                return bl;
            }
            SendSource ss = sendSource;
            ss.rewriteRtcp(packet);
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String unmapRtcpFbSsrc(@NotNull RtcpFbPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        long mediaSsrc = packet.getMediaSourceSsrc();
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            block10: {
                Object v2;
                block9: {
                    boolean bl = false;
                    Collection collection = this.sendSources.values();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"<get-values>(...)");
                    Iterable iterable = collection;
                    for (Object t : iterable) {
                        boolean bl2;
                        SendSource sendSource = (SendSource)t;
                        boolean bl3 = false;
                        if (mediaSsrc == sendSource.getSend1().getSsrc()) {
                            packet.setMediaSourceSsrc(sendSource.getProps().getSsrc1());
                            bl2 = true;
                        } else if (mediaSsrc == sendSource.getSend2().getSsrc()) {
                            packet.setMediaSourceSsrc(sendSource.getProps().getSsrc2());
                            bl2 = true;
                        } else {
                            bl2 = false;
                        }
                        if (!bl2) continue;
                        v2 = t;
                        break block9;
                    }
                    v2 = null;
                }
                SendSource ss = v2;
                if (ss == null) break block10;
                this.logger.debug(() -> SsrcCache.unmapRtcpFbSsrc$lambda$17$lambda$15(mediaSsrc, packet, ss));
                String string = ss.getProps().getOwner();
                return string;
            }
            this.logger.debug(() -> SsrcCache.unmapRtcpFbSsrc$lambda$17$lambda$16(mediaSsrc));
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final JSONObject getDebugState() {
        LRUCache<Long, SendSource> lRUCache = this.sendSources;
        synchronized (lRUCache) {
            JSONObject jSONObject;
            boolean bl = false;
            JSONObject $this$getDebugState_u24lambda_u2419_u24lambda_u2418 = jSONObject = new JSONObject();
            boolean bl2 = false;
            $this$getDebugState_u24lambda_u2419_u24lambda_u2418.put((Object)"max", (Object)this.size);
            $this$getDebugState_u24lambda_u2419_u24lambda_u2418.put((Object)"received", (Object)this.receivedSsrcs.size());
            $this$getDebugState_u24lambda_u2419_u24lambda_u2418.put((Object)"sent", (Object)this.sendSources.size());
            $this$getDebugState_u24lambda_u2419_u24lambda_u2418.put((Object)"remappings", (Object)this.remapCount);
            JSONObject jSONObject2 = jSONObject;
            return jSONObject2;
        }
    }

    @NotNull
    public String toString() {
        Set<Map.Entry<Long, ReceiveSsrc>> set = this.receivedSsrcs.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-entries>(...)");
        String string = CollectionsKt.joinToString$default((Iterable)set, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, SsrcCache::toString$lambda$20, (int)24, null);
        Set set2 = this.sendSources.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-entries>(...)");
        return "SSRCs: received=" + string + " mappings=" + CollectionsKt.joinToString$default((Iterable)set2, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, SsrcCache::toString$lambda$21, (int)24, null);
    }

    private static final String getSendSource$lambda$1(SourceDesc $props, Ref.ObjectRef $sendSource, Map.Entry $eldest) {
        Intrinsics.checkNotNullParameter((Object)$props, (String)"$props");
        Intrinsics.checkNotNullParameter((Object)$sendSource, (String)"$sendSource");
        return "Remapping SSRC: " + $props.getSsrc1() + "->" + $sendSource.element + ". " + $eldest.getKey() + "->inactive";
    }

    private static final String getSendSource$lambda$2(SourceDesc $props, Ref.ObjectRef $sendSource) {
        Intrinsics.checkNotNullParameter((Object)$props, (String)"$props");
        Intrinsics.checkNotNullParameter((Object)$sendSource, (String)"$sendSource");
        return "Added send SSRC: " + $props.getSsrc1() + "->" + $sendSource.element;
    }

    private static final boolean removeByOwner$lambda$5$lambda$3(String $owner, SendSource sendSource) {
        Intrinsics.checkNotNullParameter((Object)$owner, (String)"$owner");
        return Intrinsics.areEqual((Object)sendSource.getProps().getOwner(), (Object)$owner);
    }

    private static final boolean removeByOwner$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String activate$lambda$9$lambda$8(SsrcCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.toString();
    }

    private static final String rewriteRtp$lambda$12$lambda$11(RtpPacket $packet) {
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        return "Added receive SSRC: " + $packet.getSsrc();
    }

    private static final String unmapRtcpFbSsrc$lambda$17$lambda$15(long $mediaSsrc, RtcpFbPacket $packet, SendSource $ss) {
        Intrinsics.checkNotNullParameter((Object)$packet, (String)"$packet");
        return "Received RTCP FB packet. Translated send SSRC " + $mediaSsrc + " to receive SSRC " + $packet.getMediaSourceSsrc() + ". Owner = " + $ss.getProps().getOwner() + ".";
    }

    private static final String unmapRtcpFbSsrc$lambda$17$lambda$16(long $mediaSsrc) {
        return "Received RTCP FB packet for SSRC " + $mediaSsrc + ". Not active.";
    }

    private static final CharSequence toString$lambda$20(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "(" + it.getKey() + "->" + it.getValue() + ")";
    }

    private static final CharSequence toString$lambda$21(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "(" + it.getKey() + "->" + it.getValue() + ")";
    }
}

