/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.VideoType;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocator;
import org.jitsi.videobridge.cc.allocation.LayerSnapshot;
import org.jitsi.videobridge.cc.allocation.Layers;
import org.jitsi.videobridge.cc.allocation.LayersKt;
import org.jitsi.videobridge.cc.allocation.SingleAllocation;
import org.jitsi.videobridge.cc.allocation.SingleSourceAllocationKt;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.cc.config.BitrateControllerConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u0000 G2\u00020\u0001:\u0001GBA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010%\u001a\u00020\tJ\u0006\u0010&\u001a\u00020\tJ\u0016\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020\tJ\b\u0010@\u001a\u00020\u0003H\u0016J&\u0010A\u001a\u00020\u001c2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002010B2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010C\u001a\u00020\u001c2\u0006\u0010D\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010E\u001a\u00020(H\u0002J\u001e\u0010F\u001a\u00020\u001c2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002010B2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0011\u0010+\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0016\u00100\u001a\u0004\u0018\u0001018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b5\u0010/R\u0013\u00106\u001a\u0004\u0018\u0001078F\u00a2\u0006\u0006\u001a\u0004\b8\u00109R\u0013\u0010:\u001a\u0004\u0018\u0001078F\u00a2\u0006\u0006\u001a\u0004\b;\u00109R\u0011\u0010<\u001a\u00020=8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006H"}, d2={"Lorg/jitsi/videobridge/cc/allocation/SingleSourceAllocation;", "", "endpointId", "", "mediaSource", "Lorg/jitsi/nlj/MediaSourceDesc;", "constraints", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "onStage", "", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "clock", "Ljava/time/Clock;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Ljava/lang/String;Lorg/jitsi/nlj/MediaSourceDesc;Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;ZLorg/jitsi/utils/logging/DiagnosticContext;Ljava/time/Clock;Lorg/jitsi/utils/logging2/Logger;)V", "getEndpointId", "()Ljava/lang/String;", "getMediaSource", "()Lorg/jitsi/nlj/MediaSourceDesc;", "getConstraints", "()Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "logger", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "layers", "Lorg/jitsi/videobridge/cc/allocation/Layers;", "getLayers", "()Lorg/jitsi/videobridge/cc/allocation/Layers;", "targetIdx", "", "getTargetIdx", "()I", "setTargetIdx", "(I)V", "isOnStage", "hasReachedPreferred", "improve", "", "remainingBps", "allowOversending", "isSuspended", "()Z", "targetBitrate", "getTargetBitrate", "()J", "targetLayer", "Lorg/jitsi/videobridge/cc/allocation/LayerSnapshot;", "getTargetLayer", "()Lorg/jitsi/videobridge/cc/allocation/LayerSnapshot;", "idealBitrate", "getIdealBitrate", "preferredLayer", "Lorg/jitsi/nlj/RtpLayerDesc;", "getPreferredLayer", "()Lorg/jitsi/nlj/RtpLayerDesc;", "oversendLayer", "getOversendLayer", "result", "Lorg/jitsi/videobridge/cc/allocation/SingleAllocation;", "getResult", "()Lorg/jitsi/videobridge/cc/allocation/SingleAllocation;", "toString", "selectLayersForScreensharing", "", "selectLayers", "source", "nowMs", "selectLayersForCamera", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nSingleSourceAllocation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleSourceAllocation.kt\norg/jitsi/videobridge/cc/allocation/SingleSourceAllocation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,373:1\n766#2:374\n857#2,2:375\n766#2:377\n857#2,2:378\n766#2:381\n857#2,2:382\n766#2:384\n857#2,2:385\n2333#2,14:387\n1549#2:401\n1620#2,3:402\n2624#2,3:405\n1#3:380\n*S KotlinDebug\n*F\n+ 1 SingleSourceAllocation.kt\norg/jitsi/videobridge/cc/allocation/SingleSourceAllocation\n*L\n220#1:374\n220#1:375,2\n230#1:377\n230#1:378,2\n235#1:381\n235#1:382,2\n249#1:384\n249#1:385,2\n249#1:387,14\n278#1:401\n278#1:402,3\n305#1:405,3\n*E\n"})
public final class SingleSourceAllocation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String endpointId;
    @NotNull
    private final MediaSourceDesc mediaSource;
    @NotNull
    private final VideoConstraints constraints;
    private final boolean onStage;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Layers layers;
    private int targetIdx;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(BandwidthAllocator.class);

    /*
     * WARNING - void declaration
     */
    public SingleSourceAllocation(@NotNull String endpointId, @NotNull MediaSourceDesc mediaSource, @NotNull VideoConstraints constraints, boolean onStage, @NotNull DiagnosticContext diagnosticContext, @NotNull Clock clock, @NotNull Logger parentLogger) {
        void $this$logger_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)endpointId, (String)"endpointId");
        Intrinsics.checkNotNullParameter((Object)mediaSource, (String)"mediaSource");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this.endpointId = endpointId;
        this.mediaSource = mediaSource;
        this.constraints = constraints;
        this.onStage = onStage;
        Logger logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        Logger logger2 = logger;
        SingleSourceAllocation singleSourceAllocation = this;
        boolean bl = false;
        $this$logger_u24lambda_u240.addContext(MapsKt.mapOf((Pair)TuplesKt.to((Object)"remote_endpoint_id", (Object)this.endpointId)));
        singleSourceAllocation.logger = logger;
        this.layers = this.selectLayers(this.mediaSource, this.onStage, this.constraints, clock.instant().toEpochMilli());
        this.targetIdx = -1;
        if (timeSeriesLogger.isTraceEnabled()) {
            DiagnosticContext.TimeSeriesPoint ratesTimeSeriesPoint = diagnosticContext.makeTimeSeriesPoint("layers_considered").addField("remote_endpoint_id", (Object)this.endpointId);
            for (LayerSnapshot layerSnapshot : this.layers.getLayers()) {
                RtpLayerDesc l = layerSnapshot.component1();
                double bitrate = layerSnapshot.component2();
                ratesTimeSeriesPoint.addField(l.indexString() + "_" + l.getHeight() + "p_" + l.getFrameRate() + "fps_bps", (Object)bitrate);
            }
            timeSeriesLogger.trace((Map)ratesTimeSeriesPoint);
        }
    }

    public /* synthetic */ SingleSourceAllocation(String string, MediaSourceDesc mediaSourceDesc, VideoConstraints videoConstraints, boolean bl, DiagnosticContext diagnosticContext, Clock clock, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            logger = (Logger)new LoggerImpl(Reflection.getOrCreateKotlinClass(SingleSourceAllocation.class).getQualifiedName());
        }
        this(string, mediaSourceDesc, videoConstraints, bl, diagnosticContext, clock, logger);
    }

    @NotNull
    public final String getEndpointId() {
        return this.endpointId;
    }

    @NotNull
    public final MediaSourceDesc getMediaSource() {
        return this.mediaSource;
    }

    @NotNull
    public final VideoConstraints getConstraints() {
        return this.constraints;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Layers getLayers() {
        return this.layers;
    }

    public final int getTargetIdx() {
        return this.targetIdx;
    }

    public final void setTargetIdx(int n) {
        this.targetIdx = n;
    }

    public final boolean isOnStage() {
        return this.onStage;
    }

    public final boolean hasReachedPreferred() {
        return this.targetIdx >= this.layers.getPreferredIndex();
    }

    public final long improve(long remainingBps, boolean allowOversending) {
        int n;
        int i;
        long initialTargetBitrate = this.getTargetBitrate();
        long maxBps = remainingBps + initialTargetBitrate;
        if (this.layers.isEmpty()) {
            return 0L;
        }
        if (this.targetIdx == -1 && this.layers.getPreferredIndex() > -1 && this.onStage) {
            i = 0;
            n = ((Collection)this.layers).size();
            while (i < n && i <= this.layers.getPreferredIndex() && !((double)maxBps < this.layers.get(i).getBitrate())) {
                this.targetIdx = i++;
            }
        } else if (this.targetIdx + 1 < this.layers.size() && this.layers.get(this.targetIdx + 1).getBitrate() < (double)maxBps) {
            i = this.targetIdx;
            this.targetIdx = i + 1;
        }
        if (this.targetIdx > -1 && (n = this.targetIdx + 1) <= (i = this.layers.size() - 1)) {
            while (true) {
                if (this.layers.get(i).getBitrate() <= this.layers.get(this.targetIdx).getBitrate()) {
                    this.targetIdx = i;
                }
                if (i == n) break;
                --i;
            }
        }
        if (allowOversending && this.layers.getOversendIndex() >= 0 && this.targetIdx < this.layers.getOversendIndex() && (n = this.targetIdx + 1) <= (i = this.layers.getOversendIndex())) {
            while (true) {
                if (this.layers.get(i).getBitrate() <= (double)maxBps + BitrateControllerConfig.config.getMaxOversendBitrate-rlWvAKk()) {
                    this.targetIdx = i;
                }
                if (i == n) break;
                --i;
            }
        }
        if (allowOversending && this.targetIdx < 0 && this.layers.getOversendIndex() >= 0 && LayersKt.hasOnlyOneLayer(this.layers)) {
            this.logger.warn((Object)("Oversending above maxOversendBitrate, layer bitrate " + this.layers.getLayers().get(this.layers.getOversendIndex()).getBitrate() + " bps"));
            this.targetIdx = this.layers.getOversendIndex();
        }
        long resultingTargetBitrate = this.getTargetBitrate();
        return resultingTargetBitrate - initialTargetBitrate;
    }

    public final boolean isSuspended() {
        return this.targetIdx == -1 && !((Collection)this.layers).isEmpty() && this.layers.get(0).getBitrate() > 0.0;
    }

    public final long getTargetBitrate() {
        LayerSnapshot layerSnapshot = this.getTargetLayer();
        return layerSnapshot != null ? (long)layerSnapshot.getBitrate() : 0L;
    }

    private final LayerSnapshot getTargetLayer() {
        return (LayerSnapshot)CollectionsKt.getOrNull((List)this.layers, (int)this.targetIdx);
    }

    public final long getIdealBitrate() {
        LayerSnapshot layerSnapshot = this.layers.getIdealLayer();
        return layerSnapshot != null ? (long)layerSnapshot.getBitrate() : 0L;
    }

    @Nullable
    public final RtpLayerDesc getPreferredLayer() {
        LayerSnapshot layerSnapshot = this.layers.getPreferredLayer();
        return layerSnapshot != null ? layerSnapshot.getLayer() : null;
    }

    @Nullable
    public final RtpLayerDesc getOversendLayer() {
        LayerSnapshot layerSnapshot = this.layers.getOversendLayer();
        return layerSnapshot != null ? layerSnapshot.getLayer() : null;
    }

    @NotNull
    public final SingleAllocation getResult() {
        LayerSnapshot layerSnapshot = this.getTargetLayer();
        LayerSnapshot layerSnapshot2 = this.layers.getIdealLayer();
        return new SingleAllocation(this.endpointId, this.mediaSource, (RtpLayerDesc)(layerSnapshot != null ? layerSnapshot.getLayer() : null), (RtpLayerDesc)(layerSnapshot2 != null ? layerSnapshot2.getLayer() : null));
    }

    @NotNull
    public String toString() {
        return "[id=" + this.endpointId + " constraints=" + this.constraints + " ratedPreferredIdx=" + this.layers.getPreferredIndex() + " ratedTargetIdx=" + this.targetIdx;
    }

    /*
     * WARNING - void declaration
     */
    private final Layers selectLayersForScreensharing(List<LayerSnapshot> layers, VideoConstraints constraints, boolean onStage) {
        int n;
        Iterator destination$iv$iv;
        List list;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = layers;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (LayerSnapshot)element$iv$iv;
            boolean bl = false;
            if (!(((LayerSnapshot)it).getBitrate() > 0.0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List activeLayers = (List)destination$iv$iv2;
        if (activeLayers.isEmpty()) {
            activeLayers = layers;
        }
        if (!constraints.heightIsLimited()) {
            list = activeLayers;
        } else {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv2 = activeLayers;
            boolean $i$f$filter2 = false;
            destination$iv$iv2 = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                LayerSnapshot it2 = (LayerSnapshot)element$iv$iv;
                boolean bl = false;
                if (!(it2.getLayer().getHeight() <= constraints.getMaxHeight())) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            list = (List)destination$iv$iv3;
        }
        List selectedLayers = list;
        if (selectedLayers.isEmpty()) {
            void $this$filterTo$iv$iv3;
            Object object;
            Iterator destination$iv$iv3 = ((Iterable)activeLayers).iterator();
            if (!destination$iv$iv3.hasNext()) {
                object = null;
            } else {
                Object it3 = (LayerSnapshot)destination$iv$iv3.next();
                boolean bl = false;
                it3 = ((LayerSnapshot)it3).getLayer().getHeight();
                while (destination$iv$iv3.hasNext()) {
                    Object it4 = (LayerSnapshot)destination$iv$iv3.next();
                    $i$a$-minOfOrNull-SingleSourceAllocation$selectLayersForScreensharing$minHeight$1 = false;
                    if (it3.compareTo(it4 = (Comparable)Integer.valueOf(((LayerSnapshot)it4).getLayer().getHeight())) <= 0) continue;
                    it3 = it4;
                }
                object = it3;
            }
            Integer n2 = (Integer)object;
            if (n2 == null) {
                return Layers.Companion.getNoLayers();
            }
            int minHeight = n2;
            Iterable $this$filter$iv3 = activeLayers;
            boolean $i$f$filter3 = false;
            destination$iv$iv3 = $this$filter$iv3;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                LayerSnapshot it5 = (LayerSnapshot)element$iv$iv;
                boolean bl = false;
                if (!(it5.getLayer().getHeight() == minHeight)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            selectedLayers = (List)((Object)destination$iv$iv);
            if (!onStage && !((Collection)selectedLayers).isEmpty() && ((LayerSnapshot)selectedLayers.get(0)).getLayer().getFrameRate() < 0.0) {
                selectedLayers = CollectionsKt.listOf(selectedLayers.get(0));
            }
        }
        if (onStage && BitrateControllerConfig.config.getAllowOversendOnStage()) {
            Object v5;
            void $this$filterTo$iv$iv4;
            Object object;
            destination$iv$iv = ((Iterable)selectedLayers).iterator();
            if (!destination$iv$iv.hasNext()) {
                object = null;
            } else {
                Object it6 = (LayerSnapshot)destination$iv$iv.next();
                boolean bl = false;
                it6 = ((LayerSnapshot)it6).getLayer().getHeight();
                while (destination$iv$iv.hasNext()) {
                    Object it7 = (LayerSnapshot)destination$iv$iv.next();
                    $i$a$-maxOfOrNull-SingleSourceAllocation$selectLayersForScreensharing$oversendIdx$maxHeight$1 = false;
                    if (it6.compareTo(it7 = (Comparable)Integer.valueOf(((LayerSnapshot)it7).getLayer().getHeight())) >= 0) continue;
                    it6 = it7;
                }
                object = it6;
            }
            Integer n3 = (Integer)object;
            if (n3 == null) {
                return Layers.Companion.getNoLayers();
            }
            int maxHeight = n3;
            Iterable $this$filter$iv4 = selectedLayers;
            boolean $i$f$filter4 = false;
            it = $this$filter$iv4;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo4 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv4) {
                LayerSnapshot it8 = (LayerSnapshot)element$iv$iv;
                boolean bl = false;
                if (!(it8.getLayer().getHeight() == maxHeight)) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            Iterable $this$minByOrNull$iv = (List)destination$iv$iv4;
            boolean $i$f$minByOrNull = false;
            Iterator iterator$iv = $this$minByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v5 = null;
            } else {
                Object minElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v5 = minElem$iv;
                } else {
                    LayerSnapshot it9 = (LayerSnapshot)minElem$iv;
                    boolean bl = false;
                    double minValue$iv = it9.getBitrate();
                    do {
                        Object e$iv = iterator$iv.next();
                        LayerSnapshot it10 = (LayerSnapshot)e$iv;
                        $i$a$-minByOrNull-SingleSourceAllocation$selectLayersForScreensharing$oversendIdx$lowestBitrateLayer$2 = false;
                        double v$iv = it10.getBitrate();
                        if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                        minElem$iv = e$iv;
                        minValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v5 = minElem$iv;
                }
            }
            LayerSnapshot layerSnapshot = v5;
            if (layerSnapshot == null) {
                return Layers.Companion.getNoLayers();
            }
            LayerSnapshot lowestBitrateLayer = layerSnapshot;
            n = selectedLayers.indexOf(lowestBitrateLayer);
        } else {
            n = -1;
        }
        int oversendIdx = n;
        return new Layers(selectedLayers, selectedLayers.size() - 1, oversendIdx);
    }

    /*
     * WARNING - void declaration
     */
    private final Layers selectLayers(MediaSourceDesc source, boolean onStage, VideoConstraints constraints, long nowMs) {
        Layers layers;
        void $this$mapTo$iv$iv;
        if (constraints.getMaxHeight() == 0 || !source.hasRtpLayers()) {
            return Layers.Companion.getNoLayers();
        }
        Iterable $this$map$iv = source.getRtpLayers();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            double d;
            void it;
            RtpLayerDesc rtpLayerDesc = (RtpLayerDesc)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (BitrateControllerConfig.config.getUseVlaTargetBitrate()) {
                Bandwidth bandwidth = it.getTargetBitrate-4yB3KFE();
                d = bandwidth != null ? bandwidth.unbox-impl() : it.getBitrate-WElJv5I(nowMs);
            } else {
                d = it.getBitrate-WElJv5I(nowMs);
            }
            collection.add(new LayerSnapshot((RtpLayerDesc)it, d));
        }
        List layers2 = (List)destination$iv$iv;
        switch (WhenMappings.$EnumSwitchMapping$0[source.getVideoType().ordinal()]) {
            case 1: {
                layers = this.selectLayersForCamera(layers2, constraints);
                break;
            }
            case 2: 
            case 3: {
                layers = this.selectLayersForScreensharing(layers2, constraints, onStage);
                break;
            }
            default: {
                layers = Layers.Companion.getNoLayers();
            }
        }
        return layers;
    }

    private final Layers selectLayersForCamera(List<LayerSnapshot> layers, VideoConstraints constraints) {
        boolean bl;
        double maxFps;
        int minHeight;
        block12: {
            Double d;
            Object object;
            Iterator iterator = ((Iterable)layers).iterator();
            if (!iterator.hasNext()) {
                object = null;
            } else {
                Object it = (LayerSnapshot)iterator.next();
                boolean bl2 = false;
                it = ((LayerSnapshot)it).getLayer().getHeight();
                while (iterator.hasNext()) {
                    Object it2 = (LayerSnapshot)iterator.next();
                    $i$a$-minOfOrNull-SingleSourceAllocation$selectLayersForCamera$minHeight$1 = false;
                    if (it.compareTo(it2 = (Comparable)Integer.valueOf(((LayerSnapshot)it2).getLayer().getHeight())) <= 0) continue;
                    it = it2;
                }
                object = it;
            }
            Integer n = (Integer)object;
            if (n == null) {
                return Layers.Companion.getNoLayers();
            }
            minHeight = n;
            Iterator it2 = ((Iterable)layers).iterator();
            if (!it2.hasNext()) {
                d = null;
            } else {
                LayerSnapshot it = (LayerSnapshot)it2.next();
                boolean bl3 = false;
                double d2 = it.getLayer().getFrameRate();
                while (it2.hasNext()) {
                    LayerSnapshot it3 = (LayerSnapshot)it2.next();
                    $i$a$-maxOfOrNull-SingleSourceAllocation$selectLayersForCamera$maxFps$1 = false;
                    double d3 = it3.getLayer().getFrameRate();
                    d2 = Math.max(d2, d3);
                }
                d = d2;
            }
            if (d == null) {
                return Layers.Companion.getNoLayers();
            }
            maxFps = d;
            Iterable $this$none$iv = layers;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    LayerSnapshot layerSnapshot = (LayerSnapshot)element$iv;
                    boolean bl4 = false;
                    double bitrate = layerSnapshot.component2();
                    if (!(bitrate > 0.0)) continue;
                    bl = false;
                    break block12;
                }
                bl = true;
            }
        }
        boolean noActiveLayers = bl;
        VideoConstraints videoConstraints = SingleSourceAllocationKt.access$getPreferred(constraints);
        int preferredHeight = videoConstraints.component1();
        double preferredFps = videoConstraints.component2();
        double effectivePreferredFps = maxFps > 0.0 ? Math.min(maxFps, preferredFps) : preferredFps;
        List ratesList = new ArrayList();
        for (LayerSnapshot layerSnapshot : layers) {
            boolean atLeastPreferredFps;
            RtpLayerDesc layer = layerSnapshot.getLayer();
            boolean lessThanPreferredHeight = layer.getHeight() < preferredHeight;
            boolean lessThanOrEqualMaxHeight = layer.getHeight() <= constraints.getMaxHeight() || !constraints.heightIsLimited();
            boolean bl5 = atLeastPreferredFps = layer.getFrameRate() < 0.0 || layer.getFrameRate() >= effectivePreferredFps;
            if (!lessThanPreferredHeight && (!lessThanOrEqualMaxHeight || !atLeastPreferredFps) && layer.getHeight() != minHeight || !noActiveLayers && !(layerSnapshot.getBitrate() > 0.0)) continue;
            ratesList.add(layerSnapshot);
        }
        int effectivePreferredHeight = Integer.max(preferredHeight, minHeight);
        int preferredIndex = SingleSourceAllocationKt.access$lastIndexWhich(ratesList, arg_0 -> SingleSourceAllocation.selectLayersForCamera$lambda$12(effectivePreferredHeight, arg_0));
        this.logger.trace(() -> SingleSourceAllocation.selectLayersForCamera$lambda$13(ratesList, preferredIndex, layers, constraints));
        return new Layers(ratesList, preferredIndex, -1);
    }

    private static final boolean selectLayersForCamera$lambda$12(int $effectivePreferredHeight, LayerSnapshot it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getLayer().getHeight() <= $effectivePreferredHeight;
    }

    private static final String selectLayersForCamera$lambda$13(List $ratesList, int $preferredIndex, List $layers, VideoConstraints $constraints) {
        Intrinsics.checkNotNullParameter((Object)$ratesList, (String)"$ratesList");
        Intrinsics.checkNotNullParameter((Object)$layers, (String)"$layers");
        Intrinsics.checkNotNullParameter((Object)$constraints, (String)"$constraints");
        return "Selected rates list " + $ratesList + ", preferred index " + $preferredIndex + " from layers " + $layers + " with constraints " + $constraints;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/cc/allocation/SingleSourceAllocation$Companion;", "", "<init>", "()V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VideoType.values().length];
            try {
                nArray[VideoType.CAMERA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoType.DESKTOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VideoType.DESKTOP_HIGH_FPS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

