/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.av1;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtp.codec.av1.Av1DDPacket;
import org.jitsi.nlj.util.ArrayCache;
import org.jitsi.nlj.util.Rfc3711IndexTracker;
import org.jitsi.videobridge.cc.av1.Av1DDFrame;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\u0004H\u0086\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002H\u0014J$\u0010#\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001c0%J$\u0010&\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001d\u001a\u00020\u00022\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001c0%J6\u0010'\u001a\u0004\u0018\u00010\u00022\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u001c0%2\u0006\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0002R\u001a\u0010\u0007\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0006R\u001a\u0010\u000b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u0006R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006+"}, d2={"Lorg/jitsi/videobridge/cc/av1/FrameHistory;", "Lorg/jitsi/nlj/util/ArrayCache;", "Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "size", "", "<init>", "(I)V", "numCached", "getNumCached", "()I", "setNumCached", "firstIndex", "getFirstIndex", "setFirstIndex", "indexTracker", "Lorg/jitsi/nlj/util/Rfc3711IndexTracker;", "getIndexTracker", "()Lorg/jitsi/nlj/util/Rfc3711IndexTracker;", "setIndexTracker", "(Lorg/jitsi/nlj/util/Rfc3711IndexTracker;)V", "get", "frameNumber", "getIndex", "index", "latestFrame", "getLatestFrame", "()Lorg/jitsi/videobridge/cc/av1/Av1DDFrame;", "insert", "", "frame", "packet", "Lorg/jitsi/nlj/rtp/codec/av1/Av1DDPacket;", "discardItem", "", "item", "findBefore", "pred", "Lkotlin/Function1;", "findAfter", "doFind", "startIndex", "endIndex", "increment", "jitsi-videobridge"})
public final class FrameHistory
extends ArrayCache<Av1DDFrame> {
    private int numCached;
    private int firstIndex = -1;
    @NotNull
    private Rfc3711IndexTracker indexTracker = new Rfc3711IndexTracker();

    public FrameHistory(int size) {
        super(size, FrameHistory::_init_$lambda$0, false, null, 8, null);
    }

    public final int getNumCached() {
        return this.numCached;
    }

    public final void setNumCached(int n) {
        this.numCached = n;
    }

    public final int getFirstIndex() {
        return this.firstIndex;
    }

    public final void setFirstIndex(int n) {
        this.firstIndex = n;
    }

    @NotNull
    public final Rfc3711IndexTracker getIndexTracker() {
        return this.indexTracker;
    }

    public final void setIndexTracker(@NotNull Rfc3711IndexTracker rfc3711IndexTracker) {
        Intrinsics.checkNotNullParameter((Object)rfc3711IndexTracker, (String)"<set-?>");
        this.indexTracker = rfc3711IndexTracker;
    }

    @Nullable
    public final Av1DDFrame get(int frameNumber) {
        int index = this.indexTracker.interpret(frameNumber);
        return this.getIndex(index);
    }

    @Nullable
    public final Av1DDFrame getIndex(int index) {
        if (index <= this.getLastIndex() - this.getSize()) {
            return null;
        }
        ArrayCache.Container container = ArrayCache.getContainer$default((ArrayCache)this, (int)index, (boolean)false, (int)2, null);
        if (container == null) {
            return null;
        }
        ArrayCache.Container c = container;
        return (Av1DDFrame)c.getItem();
    }

    @Nullable
    public final Av1DDFrame getLatestFrame() {
        return this.getIndex(this.getLastIndex());
    }

    public final boolean insert(@NotNull Av1DDFrame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        boolean ret = super.insertItem((Object)frame, frame.getIndex());
        if (ret) {
            int n = this.numCached;
            this.numCached = n + 1;
            if (this.firstIndex == -1 || frame.getIndex() < this.firstIndex) {
                this.firstIndex = frame.getIndex();
            }
        }
        return ret;
    }

    @Nullable
    public final Av1DDFrame insert(@NotNull Av1DDPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        int index = this.indexTracker.update(packet.getFrameNumber());
        Av1DDFrame frame = new Av1DDFrame(packet, index);
        return this.insert(frame) ? frame : null;
    }

    protected void discardItem(@NotNull Av1DDFrame item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int n = this.numCached;
        this.numCached = n + -1;
    }

    @Nullable
    public final Av1DDFrame findBefore(@NotNull Av1DDFrame frame, @NotNull Function1<? super Av1DDFrame, Boolean> pred) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter(pred, (String)"pred");
        int lastIndex = this.getLastIndex();
        if (lastIndex == -1) {
            return null;
        }
        int index = frame.getIndex();
        int searchStartIndex = Integer.min(index - 1, lastIndex);
        int searchEndIndex = Integer.max(lastIndex - this.getSize(), this.firstIndex - 1);
        return this.doFind(pred, searchStartIndex, searchEndIndex, -1);
    }

    @Nullable
    public final Av1DDFrame findAfter(@NotNull Av1DDFrame frame, @NotNull Function1<? super Av1DDFrame, Boolean> pred) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter(pred, (String)"pred");
        int lastIndex = this.getLastIndex();
        if (lastIndex == -1) {
            return null;
        }
        int index = frame.getIndex();
        if (index >= lastIndex) {
            return null;
        }
        int searchStartIndex = Integer.max(index + 1, Integer.max(lastIndex - this.getSize() + 1, this.firstIndex));
        return this.doFind(pred, searchStartIndex, lastIndex + 1, 1);
    }

    private final Av1DDFrame doFind(Function1<? super Av1DDFrame, Boolean> pred, int startIndex, int endIndex, int increment) {
        for (int index = startIndex; index != endIndex; index += increment) {
            Av1DDFrame frame = this.getIndex(index);
            if (frame == null || !((Boolean)pred.invoke((Object)frame)).booleanValue()) continue;
            return frame;
        }
        return null;
    }

    private static final Av1DDFrame _init_$lambda$0(Av1DDFrame k) {
        Intrinsics.checkNotNullParameter((Object)k, (String)"k");
        return k;
    }
}

