/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.load_management;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.ConfigSource;
import org.jitsi.metaconfig.Deprecation;
import org.jitsi.metaconfig.DeprecationKt;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.ConfigSourceSupplier;
import org.jitsi.metaconfig.supplier.ConfigValueSupplier;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.util.ClockUtils;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.JvbLastNKt;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.load_management.CpuMeasurement;
import org.jitsi.videobridge.load_management.CpuUsageLoadManager;
import org.jitsi.videobridge.load_management.JvbLoadMeasurement;
import org.jitsi.videobridge.load_management.JvbLoadReducer;
import org.jitsi.videobridge.load_management.LastNReducer;
import org.jitsi.videobridge.load_management.PacketRateLoadManager;
import org.jitsi.videobridge.load_management.PacketRateMeasurement;
import org.jitsi.videobridge.util.TaskPools;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u0000 (*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002'(B-\b\u0007\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0006\u0010\u001c\u001a\u00020\u0019J\u0013\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020#J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012H\u0002R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u0005\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jitsi/videobridge/load_management/JvbLoadManager;", "T", "Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;", "", "jvbLoadThreshold", "jvbRecoveryThreshold", "loadReducer", "Lorg/jitsi/videobridge/load_management/JvbLoadReducer;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;Lorg/jitsi/videobridge/load_management/JvbLoadReducer;Ljava/time/Clock;)V", "Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "lastReducerTime", "Ljava/time/Instant;", "state", "Lorg/jitsi/videobridge/load_management/JvbLoadManager$State;", "mostRecentLoadMeasurement", "loadSamplerTask", "Ljava/util/concurrent/ScheduledFuture;", "startSampler", "", "sampler", "Ljava/lang/Runnable;", "stop", "loadUpdate", "loadMeasurement", "(Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;)V", "getCurrentStressLevel", "", "getStats", "Lorg/jitsi/utils/OrderedJsonObject;", "canRunReducer", "", "now", "State", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nJvbLoadManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvbLoadManager.kt\norg/jitsi/videobridge/load_management/JvbLoadManager\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n+ 4 SupplierBuilder.kt\norg/jitsi/metaconfig/SupplierBuilderKt\n*L\n1#1,201:1\n63#2,4:202\n63#2,4:206\n63#2,4:210\n68#3,6:214\n68#3,6:220\n59#3:227\n127#4:226\n*S KotlinDebug\n*F\n+ 1 JvbLoadManager.kt\norg/jitsi/videobridge/load_management/JvbLoadManager\n*L\n63#1:202,4\n93#1:206,4\n96#1:210,4\n131#1:214,6\n135#1:220,6\n139#1:227\n139#1:226\n*E\n"})
public class JvbLoadManager<T extends JvbLoadMeasurement> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final T jvbLoadThreshold;
    @NotNull
    private final T jvbRecoveryThreshold;
    @Nullable
    private final JvbLoadReducer loadReducer;
    @NotNull
    private final Clock clock;
    @NotNull
    private final Logger logger;
    @NotNull
    private Instant lastReducerTime;
    @NotNull
    private State state;
    @Nullable
    private T mostRecentLoadMeasurement;
    @Nullable
    private ScheduledFuture<?> loadSamplerTask;
    @NotNull
    private static final ConfigDelegate<Double> averageParticipantStress$delegate;
    @NotNull
    private static final ConfigDelegate<String> loadMeasurement$delegate;
    @NotNull
    private static final ConfigDelegate<Boolean> reducerEnabled$delegate;
    @NotNull
    public static final String PACKET_RATE_MEASUREMENT = "packet-rate";
    @NotNull
    public static final String CPU_USAGE_MEASUREMENT = "cpu-usage";

    @JvmOverloads
    public JvbLoadManager(@NotNull T jvbLoadThreshold, @NotNull T jvbRecoveryThreshold, @Nullable JvbLoadReducer loadReducer, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(jvbLoadThreshold, (String)"jvbLoadThreshold");
        Intrinsics.checkNotNullParameter(jvbRecoveryThreshold, (String)"jvbRecoveryThreshold");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.jvbLoadThreshold = jvbLoadThreshold;
        this.jvbRecoveryThreshold = jvbRecoveryThreshold;
        this.loadReducer = loadReducer;
        this.clock = clock;
        Level level = Level.ALL;
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"ALL");
        this.logger = LoggerExtensionsKt.createLogger$default((Object)this, (Level)level, null, (int)2, null);
        this.lastReducerTime = ClockUtils.NEVER;
        this.state = State.NOT_OVERLOADED;
    }

    public /* synthetic */ JvbLoadManager(JvbLoadMeasurement jvbLoadMeasurement, JvbLoadMeasurement jvbLoadMeasurement2, JvbLoadReducer jvbLoadReducer, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            clock = Clock.systemUTC();
        }
        this(jvbLoadMeasurement, jvbLoadMeasurement2, jvbLoadReducer, clock);
    }

    @NotNull
    protected final Logger getLogger() {
        return this.logger;
    }

    protected final void startSampler(@NotNull Runnable sampler) {
        Intrinsics.checkNotNullParameter((Object)sampler, (String)"sampler");
        this.loadSamplerTask = TaskPools.SCHEDULED_POOL.scheduleAtFixedRate(sampler, 0L, 10L, TimeUnit.SECONDS);
    }

    public final void stop() {
        ScheduledFuture<?> scheduledFuture = this.loadSamplerTask;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.loadSamplerTask = null;
    }

    public final void loadUpdate(@NotNull T loadMeasurement) {
        block4: {
            JvbLoadReducer it;
            block5: {
                block6: {
                    Instant now;
                    block3: {
                        Intrinsics.checkNotNullParameter(loadMeasurement, (String)"loadMeasurement");
                        Logger $this$cdebug$iv = this.logger;
                        boolean $i$f$cdebug = false;
                        if ($this$cdebug$iv.isDebugEnabled()) {
                            Logger logger = $this$cdebug$iv;
                            boolean bl = false;
                            logger.debug((Object)("Got a load measurement of " + loadMeasurement));
                        }
                        this.mostRecentLoadMeasurement = loadMeasurement;
                        now = this.clock.instant();
                        if (!(loadMeasurement.getLoad() >= this.jvbLoadThreshold.getLoad())) break block3;
                        this.state = State.OVERLOADED;
                        JvbLoadReducer jvbLoadReducer = this.loadReducer;
                        if (jvbLoadReducer == null) break block4;
                        JvbLoadReducer it2 = jvbLoadReducer;
                        boolean bl = false;
                        this.logger.info((Object)("Load measurement " + loadMeasurement + " is above threshold of " + this.jvbLoadThreshold));
                        Intrinsics.checkNotNull((Object)now);
                        if (this.canRunReducer(now)) {
                            this.logger.info((Object)"Running load reducer");
                            it2.reduceLoad();
                            this.lastReducerTime = now;
                        } else {
                            this.logger.info((Object)("Load reducer ran at " + this.lastReducerTime + ", which is within " + it2.impactTime() + " of now, not running reduce"));
                        }
                        break block4;
                    }
                    this.state = State.NOT_OVERLOADED;
                    JvbLoadReducer jvbLoadReducer = this.loadReducer;
                    if (jvbLoadReducer == null) break block4;
                    it = jvbLoadReducer;
                    boolean bl = false;
                    if (!(loadMeasurement.getLoad() < this.jvbRecoveryThreshold.getLoad())) break block4;
                    Intrinsics.checkNotNull((Object)now);
                    if (!this.canRunReducer(now)) break block5;
                    if (!it.recover()) break block6;
                    this.logger.info((Object)("Recovery ran after a load measurement of " + loadMeasurement + " (which was below threshold of " + this.jvbRecoveryThreshold + ") was received"));
                    this.lastReducerTime = now;
                    break block4;
                }
                Logger $this$cdebug$iv = this.logger;
                boolean $i$f$cdebug = false;
                if (!$this$cdebug$iv.isDebugEnabled()) break block4;
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug((Object)"Recovery had no work to do");
                break block4;
            }
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if (!$this$cdebug$iv.isDebugEnabled()) break block4;
            Logger logger = $this$cdebug$iv;
            boolean bl = false;
            logger.debug((Object)("Load measurement " + loadMeasurement + " is below recovery threshold, but load reducer ran at " + this.lastReducerTime + ", which is within " + it.impactTime() + " of now, not running recover"));
        }
    }

    public final double getCurrentStressLevel() {
        T t = this.mostRecentLoadMeasurement;
        return t != null ? t.div((JvbLoadMeasurement)this.jvbLoadThreshold) : 0.0;
    }

    @NotNull
    public final OrderedJsonObject getStats() {
        OrderedJsonObject orderedJsonObject;
        block0: {
            OrderedJsonObject $this$getStats_u24lambda_u246 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$getStats_u24lambda_u246.put((Object)"state", (Object)this.state.toString());
            $this$getStats_u24lambda_u246.put((Object)"stress", (Object)String.valueOf(this.getCurrentStressLevel()));
            $this$getStats_u24lambda_u246.put((Object)"reducer_enabled", (Object)String.valueOf(Companion.getReducerEnabled()));
            JvbLoadReducer jvbLoadReducer = this.loadReducer;
            if (jvbLoadReducer == null) break block0;
            JvbLoadReducer it = jvbLoadReducer;
            boolean bl2 = false;
            $this$getStats_u24lambda_u246.put((Object)"reducer", (Object)it.getStats());
        }
        return orderedJsonObject;
    }

    private final boolean canRunReducer(Instant now) {
        JvbLoadReducer jvbLoadReducer = this.loadReducer;
        if (jvbLoadReducer != null) {
            JvbLoadReducer it = jvbLoadReducer;
            boolean bl = false;
            return Duration.between(this.lastReducerTime, now).compareTo(it.impactTime()) >= 0;
        }
        return false;
    }

    @JvmOverloads
    public JvbLoadManager(@NotNull T jvbLoadThreshold, @NotNull T jvbRecoveryThreshold, @Nullable JvbLoadReducer loadReducer) {
        Intrinsics.checkNotNullParameter(jvbLoadThreshold, (String)"jvbLoadThreshold");
        Intrinsics.checkNotNullParameter(jvbRecoveryThreshold, (String)"jvbRecoveryThreshold");
        this((JvbLoadMeasurement)jvbLoadThreshold, (JvbLoadMeasurement)jvbRecoveryThreshold, loadReducer, null, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final JvbLoadManager<?> create(@NotNull Videobridge videobridge) {
        return Companion.create(videobridge);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$from$iv;
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        boolean $i$f$config = false;
        SupplierBuilder $this$averageParticipantStress_delegate_u24lambda_u248 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Double.TYPE));
        boolean bl = false;
        $this$averageParticipantStress_delegate_u24lambda_u248.from("videobridge.load-management.average-participant-stress", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        averageParticipantStress$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$loadMeasurement_delegate_u24lambda_u249 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(String.class));
        boolean bl2 = false;
        $this$loadMeasurement_delegate_u24lambda_u249.from("videobridge.load-management.load-measurements.load-measurement", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        loadMeasurement$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate((ConfigValueSupplier)CollectionsKt.first((List)supplierBuilder$iv.getSuppliers())) : new ConfigDelegate((ConfigValueSupplier)new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        String $i$f$config2 = "videobridge.load-management.reducer-enabled";
        ConfigSource configSource$iv = JitsiConfig.Companion.getNewConfig();
        boolean $i$f$from = false;
        ConfigSourceSupplier supplier$iv = new ConfigSourceSupplier((String)$this$from$iv, configSource$iv, Reflection.typeOf(Boolean.TYPE), (Deprecation)DeprecationKt.noDeprecation());
        boolean $i$f$config3 = false;
        reducerEnabled$delegate = new ConfigDelegate((ConfigValueSupplier)supplier$iv);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0014\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/videobridge/load_management/JvbLoadManager$Companion;", "", "<init>", "()V", "averageParticipantStress", "", "getAverageParticipantStress", "()D", "averageParticipantStress$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "loadMeasurement", "", "getLoadMeasurement", "()Ljava/lang/String;", "loadMeasurement$delegate", "reducerEnabled", "", "getReducerEnabled", "()Z", "reducerEnabled$delegate", "PACKET_RATE_MEASUREMENT", "CPU_USAGE_MEASUREMENT", "create", "Lorg/jitsi/videobridge/load_management/JvbLoadManager;", "videobridge", "Lorg/jitsi/videobridge/Videobridge;", "jitsi-videobridge"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        public final double getAverageParticipantStress() {
            return ((Number)averageParticipantStress$delegate.getValue((Object)this, $$delegatedProperties[0])).doubleValue();
        }

        @NotNull
        public final String getLoadMeasurement() {
            return (String)loadMeasurement$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public final boolean getReducerEnabled() {
            return (Boolean)reducerEnabled$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        @JvmStatic
        @NotNull
        public final JvbLoadManager<?> create(@NotNull Videobridge videobridge) {
            JvbLoadManager jvbLoadManager;
            Intrinsics.checkNotNullParameter((Object)videobridge, (String)"videobridge");
            LastNReducer reducer = this.getReducerEnabled() ? new LastNReducer(() -> Companion.create$lambda$0(videobridge), JvbLastNKt.jvbLastNSingleton) : null;
            String string = this.getLoadMeasurement();
            if (Intrinsics.areEqual((Object)string, (Object)JvbLoadManager.PACKET_RATE_MEASUREMENT)) {
                jvbLoadManager = new PacketRateLoadManager(PacketRateMeasurement.Companion.getLoadedThreshold(), PacketRateMeasurement.Companion.getRecoveryThreshold(), (JvbLoadReducer)reducer, videobridge);
            } else if (Intrinsics.areEqual((Object)string, (Object)JvbLoadManager.CPU_USAGE_MEASUREMENT)) {
                jvbLoadManager = new CpuUsageLoadManager(CpuMeasurement.Companion.getLoadThreshold(), CpuMeasurement.Companion.getRecoverThreshold(), (JvbLoadReducer)reducer, videobridge);
            } else {
                throw new IllegalArgumentException("Invalid configuration for load measurement type: " + this.getLoadMeasurement());
            }
            return jvbLoadManager;
        }

        private static final Collection create$lambda$0(Videobridge $videobridge) {
            Intrinsics.checkNotNullParameter((Object)$videobridge, (String)"$videobridge");
            return $videobridge.getConferences();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "averageParticipantStress", "getAverageParticipantStress()D", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "loadMeasurement", "getLoadMeasurement()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "reducerEnabled", "getReducerEnabled()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/videobridge/load_management/JvbLoadManager$State;", "", "<init>", "(Ljava/lang/String;I)V", "OVERLOADED", "NOT_OVERLOADED", "jitsi-videobridge"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State OVERLOADED = new State();
        public static final /* enum */ State NOT_OVERLOADED = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.OVERLOADED, State.NOT_OVERLOADED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

