/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.relay;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.metrics.CounterMetric;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.AbstractEndpointMessageTransport;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.EncodingsManager;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.VersionConfig;
import org.jitsi.videobridge.datachannel.DataChannel;
import org.jitsi.videobridge.datachannel.DataChannelStack;
import org.jitsi.videobridge.datachannel.protocol.DataChannelMessage;
import org.jitsi.videobridge.datachannel.protocol.DataChannelStringMessage;
import org.jitsi.videobridge.message.AddReceiverMessage;
import org.jitsi.videobridge.message.BridgeChannelMessage;
import org.jitsi.videobridge.message.ClientHelloMessage;
import org.jitsi.videobridge.message.EndpointConnectionStatusMessage;
import org.jitsi.videobridge.message.EndpointMessage;
import org.jitsi.videobridge.message.EndpointStats;
import org.jitsi.videobridge.message.ServerHelloMessage;
import org.jitsi.videobridge.message.SourceVideoTypeMessage;
import org.jitsi.videobridge.message.VideoTypeMessage;
import org.jitsi.videobridge.metrics.VideobridgeMetrics;
import org.jitsi.videobridge.relay.Relay;
import org.jitsi.videobridge.relay.RelayedEndpoint;
import org.jitsi.videobridge.websocket.ColibriWebSocket;
import org.jitsi.videobridge.websocket.config.WebsocketServiceConfig;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 N2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001NB\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u001e\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u001dH\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020%H\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020)H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020!H\u0016J\u001a\u0010-\u001a\u00020\u001d2\b\u0010.\u001a\u0004\u0018\u00010\u00112\u0006\u0010\"\u001a\u00020!H\u0014J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020!H\u0002J\u0018\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\r2\u0006\u0010\"\u001a\u00020!H\u0002J\u0012\u0010/\u001a\u00020\u001d2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0010\u0010-\u001a\u00020\u001d2\u0006\u00102\u001a\u00020!H\u0016J\n\u00103\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u00107\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\rH\u0016J\b\u00109\u001a\u00020%H\u0002J \u0010:\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\r2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u000fH\u0016J\u0018\u0010>\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\r2\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020\u001dH\u0016J\u0018\u0010B\u001a\u00020\u001d2\u0006\u00108\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u000fH\u0016J\u000e\u0010C\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u0016J\u0012\u0010H\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020IH\u0016J\u0012\u0010J\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020KH\u0016J\u0012\u0010L\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020MH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b6\u00105R\u0014\u0010D\u001a\u00020E8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010G\u00a8\u0006O"}, d2={"Lorg/jitsi/videobridge/relay/RelayMessageTransport;", "Lorg/jitsi/videobridge/AbstractEndpointMessageTransport;", "Lorg/jitsi/videobridge/websocket/ColibriWebSocket$EventHandler;", "Lorg/jitsi/videobridge/datachannel/DataChannelStack$DataChannelMessageListener;", "relay", "Lorg/jitsi/videobridge/relay/Relay;", "eventHandler", "Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$EndpointMessageTransportEventHandler;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/videobridge/relay/Relay;Lorg/jitsi/videobridge/AbstractEndpointMessageTransport$EndpointMessageTransportEventHandler;Lorg/jitsi/utils/logging2/Logger;)V", "webSocket", "Lorg/jitsi/videobridge/websocket/ColibriWebSocket;", "url", "", "webSocketSyncRoot", "", "webSocketLastActive", "", "dataChannel", "Ljava/lang/ref/WeakReference;", "Lorg/jitsi/videobridge/datachannel/DataChannel;", "numOutgoingMessagesDropped", "Ljava/util/concurrent/atomic/AtomicInteger;", "sentMessagesCounts", "", "Ljava/util/concurrent/atomic/AtomicLong;", "connectToWebsocket", "", "doConnect", "notifyTransportChannelConnected", "clientHello", "Lorg/jitsi/videobridge/message/BridgeChannelMessage;", "message", "Lorg/jitsi/videobridge/message/ClientHelloMessage;", "serverHello", "Lorg/jitsi/videobridge/message/ServerHelloMessage;", "addReceiver", "Lorg/jitsi/videobridge/message/AddReceiverMessage;", "videoType", "Lorg/jitsi/videobridge/message/VideoTypeMessage;", "sourceVideoType", "Lorg/jitsi/videobridge/message/SourceVideoTypeMessage;", "unhandledMessage", "sendMessage", "dst", "onDataChannelMessage", "dataChannelMessage", "Lorg/jitsi/videobridge/datachannel/protocol/DataChannelMessage;", "msg", "getActiveTransportChannel", "isConnected", "()Z", "isActive", "webSocketConnected", "ws", "createServerHello", "webSocketClosed", "statusCode", "", "reason", "webSocketError", "cause", "", "close", "webSocketTextReceived", "setDataChannel", "debugState", "Lorg/json/simple/JSONObject;", "getDebugState", "()Lorg/json/simple/JSONObject;", "endpointMessage", "Lorg/jitsi/videobridge/message/EndpointMessage;", "endpointStats", "Lorg/jitsi/videobridge/message/EndpointStats;", "endpointConnectionStatus", "Lorg/jitsi/videobridge/message/EndpointConnectionStatusMessage;", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nRelayMessageTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RelayMessageTransport.kt\norg/jitsi/videobridge/relay/RelayMessageTransport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,514:1\n766#2:515\n857#2,2:516\n1855#2,2:518\n766#2:520\n857#2,2:521\n1855#2,2:523\n*S KotlinDebug\n*F\n+ 1 RelayMessageTransport.kt\norg/jitsi/videobridge/relay/RelayMessageTransport\n*L\n484#1:515\n484#1:516,2\n484#1:518,2\n485#1:520\n485#1:521,2\n485#1:523,2\n*E\n"})
public final class RelayMessageTransport
extends AbstractEndpointMessageTransport
implements ColibriWebSocket.EventHandler,
DataChannelStack.DataChannelMessageListener {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Relay relay;
    @NotNull
    private final AbstractEndpointMessageTransport.EndpointMessageTransportEventHandler eventHandler;
    @Nullable
    private ColibriWebSocket webSocket;
    @Nullable
    private String url;
    @NotNull
    private final Object webSocketSyncRoot;
    private boolean webSocketLastActive;
    @NotNull
    private WeakReference<DataChannel> dataChannel;
    @NotNull
    private final AtomicInteger numOutgoingMessagesDropped;
    @NotNull
    private final Map<String, AtomicLong> sentMessagesCounts;
    @NotNull
    private static final WebSocketClient webSocketClient;
    @NotNull
    public static final String RELAY_CLOSED = "relay_closed";

    public RelayMessageTransport(@NotNull Relay relay, @NotNull AbstractEndpointMessageTransport.EndpointMessageTransportEventHandler eventHandler, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)relay, (String)"relay");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        super(parentLogger);
        this.relay = relay;
        this.eventHandler = eventHandler;
        this.webSocketSyncRoot = new Object();
        this.dataChannel = new WeakReference<Object>(null);
        this.numOutgoingMessagesDropped = new AtomicInteger(0);
        this.sentMessagesCounts = new ConcurrentHashMap();
    }

    public final void connectToWebsocket(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.url != null && Intrinsics.areEqual((Object)this.url, (Object)url)) {
            return;
        }
        this.url = url;
        this.doConnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doConnect() {
        ColibriWebSocket colibriWebSocket;
        String string = this.url;
        if (string == null) {
            throw new IllegalStateException("Cannot connect Relay transport when no URL set");
        }
        String url = string;
        ColibriWebSocket colibriWebSocket2 = this.webSocket;
        if (colibriWebSocket2 != null) {
            ColibriWebSocket it = colibriWebSocket2;
            boolean bl = false;
            this.getLogger().warn((Object)"Re-connecting while webSocket != null, possible leak.");
            this.webSocket = null;
        }
        ColibriWebSocket it = colibriWebSocket = new ColibriWebSocket(this.relay.getId(), this);
        boolean bl = false;
        webSocketClient.connect((Object)it, new URI(url), new ClientUpgradeRequest());
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            boolean bl2 = false;
            this.webSocket = it;
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    protected void notifyTransportChannelConnected() {
        this.relay.relayMessageTransportConnected();
    }

    @Override
    @Nullable
    public BridgeChannelMessage clientHello(@NotNull ClientHelloMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return this.createServerHello();
    }

    @Override
    @Nullable
    public BridgeChannelMessage serverHello(@NotNull ServerHelloMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = message.getVersion();
        if (!(string != null ? string.equals(this.relay.getConference().getVideobridge().getVersion().toString()) : false)) {
            this.getLogger().warn(() -> RelayMessageTransport.serverHello$lambda$3(message, this));
        } else {
            this.getLogger().info(() -> RelayMessageTransport.serverHello$lambda$4(message));
        }
        return null;
    }

    @Override
    @Nullable
    public BridgeChannelMessage addReceiver(@NotNull AddReceiverMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = message.getSourceName();
        if (string == null) {
            RelayMessageTransport $this$addReceiver_u24lambda_u245 = this;
            boolean bl = false;
            $this$addReceiver_u24lambda_u245.getLogger().error((Object)"Received AddReceiverMessage for with sourceName = null");
            return null;
        }
        String sourceName = string;
        AbstractEndpoint abstractEndpoint = this.relay.getConference().findSourceOwner(sourceName);
        if (abstractEndpoint == null) {
            RelayMessageTransport $this$addReceiver_u24lambda_u246 = this;
            boolean bl = false;
            $this$addReceiver_u24lambda_u246.getLogger().warn((Object)("Received AddReceiverMessage for unknown or non-local: " + sourceName));
            return null;
        }
        AbstractEndpoint ep = abstractEndpoint;
        ep.addReceiver(this.relay.getId(), sourceName, message.getVideoConstraints());
        return null;
    }

    @Override
    @Nullable
    public BridgeChannelMessage videoType(@NotNull VideoTypeMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLogger().error((Object)("Relay: unexpected video type message: " + message.toJson()));
        return null;
    }

    @Override
    @Nullable
    public BridgeChannelMessage sourceVideoType(@NotNull SourceVideoTypeMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String epId = message.getEndpointId();
        if (epId == null) {
            this.getLogger().warn((Object)"Received SourceVideoTypeMessage over relay channel with no endpoint ID");
            return null;
        }
        RelayedEndpoint ep = this.relay.getEndpoint(epId);
        if (ep == null) {
            this.getLogger().warn((Object)("Received SourceVideoTypeMessage for unknown epId " + epId));
            return null;
        }
        ep.setVideoType(message.getSourceName(), message.getVideoType());
        this.relay.getConference().sendMessageFromRelay(message, false, this.relay.getMeshId());
        return null;
    }

    @Override
    public void unhandledMessage(@NotNull BridgeChannelMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLogger().warn((Object)("Received a message with an unexpected type: " + message.getClass().getSimpleName()));
    }

    @Override
    protected void sendMessage(@Nullable Object dst, @NotNull BridgeChannelMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        super.sendMessage(dst, message);
        if (dst instanceof ColibriWebSocket) {
            this.sendMessage((ColibriWebSocket)((Object)dst), message);
        } else if (dst instanceof DataChannel) {
            this.sendMessage((DataChannel)dst, message);
        } else {
            throw new IllegalArgumentException("unknown transport:" + dst);
        }
    }

    private final void sendMessage(DataChannel dst, BridgeChannelMessage message) {
        dst.sendString(message.toJson());
        CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.dataChannelMessagesSent, null, (int)1, null);
    }

    private final void sendMessage(ColibriWebSocket dst, BridgeChannelMessage message) {
        dst.sendString(message.toJson());
        CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.colibriWebSocketMessagesSent, null, (int)1, null);
    }

    @Override
    public void onDataChannelMessage(@Nullable DataChannelMessage dataChannelMessage) {
        this.webSocketLastActive = false;
        CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.dataChannelMessagesReceived, null, (int)1, null);
        if (dataChannelMessage instanceof DataChannelStringMessage) {
            Object t = this.dataChannel.get();
            String string = ((DataChannelStringMessage)dataChannelMessage).data;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data");
            this.onMessage(t, string);
        }
    }

    @Override
    public void sendMessage(@NotNull BridgeChannelMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Object dst = this.getActiveTransportChannel();
        if (dst == null) {
            this.getLogger().debug((Object)"No available transport channel, can't send a message");
            this.numOutgoingMessagesDropped.incrementAndGet();
        } else {
            this.sentMessagesCounts.computeIfAbsent(msg.getClass().getSimpleName(), arg_0 -> RelayMessageTransport.sendMessage$lambda$8(RelayMessageTransport::sendMessage$lambda$7, arg_0)).incrementAndGet();
            this.sendMessage(dst, msg);
        }
    }

    private final Object getActiveTransportChannel() {
        DataChannel dataChannel = (DataChannel)this.dataChannel.get();
        ColibriWebSocket webSocket = this.webSocket;
        Object dst = null;
        if (this.webSocketLastActive) {
            dst = webSocket;
        }
        if (dst == null && dataChannel != null && dataChannel.isReady()) {
            dst = dataChannel;
        }
        if (dst == null && webSocket != null) {
            dst = webSocket;
        }
        return dst;
    }

    @Override
    public boolean isConnected() {
        return this.getActiveTransportChannel() != null;
    }

    public final boolean isActive() {
        return this.url != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void webSocketConnected(@NotNull ColibriWebSocket ws) {
        Intrinsics.checkNotNullParameter((Object)((Object)ws), (String)"ws");
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((Object)ws), (Object)((Object)this.webSocket))) {
                if (this.webSocket != null) {
                    this.getLogger().info((Object)"Replacing an existing websocket.");
                    ColibriWebSocket colibriWebSocket = this.webSocket;
                    if (colibriWebSocket != null && (colibriWebSocket = colibriWebSocket.getSession()) != null) {
                        colibriWebSocket.close(1000, "replaced");
                    }
                }
                this.webSocketLastActive = true;
                this.webSocket = ws;
                this.sendMessage(ws, (BridgeChannelMessage)this.createServerHello());
            } else {
                this.getLogger().warn((Object)"Websocket already connected.");
            }
            Unit unit = Unit.INSTANCE;
        }
        try {
            this.notifyTransportChannelConnected();
        }
        catch (Exception e) {
            this.getLogger().warn((Object)"Caught an exception in notifyTransportConnected", (Throwable)e);
        }
    }

    private final ServerHelloMessage createServerHello() {
        return VersionConfig.config.announceVersion() ? new ServerHelloMessage(this.relay.getConference().getVideobridge().getVersion().toString()) : new ServerHelloMessage(null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void webSocketClosed(@NotNull ColibriWebSocket ws, int statusCode, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)ws), (String)"ws");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            boolean bl = false;
            if (Intrinsics.areEqual((Object)((Object)ws), (Object)((Object)this.webSocket))) {
                this.webSocket = null;
                this.webSocketLastActive = false;
                this.getLogger().debug(() -> RelayMessageTransport.webSocketClosed$lambda$11$lambda$10(statusCode, reason));
                switch (statusCode) {
                    case 1000: 
                    case 1001: 
                    case 1005: {
                        CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.colibriWebSocketCloseNormal, null, (int)1, null);
                        break;
                    }
                    default: {
                        CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.colibriWebSocketCloseAbnormal, null, (int)1, null);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        if (statusCode != 1001 || !Intrinsics.areEqual((Object)reason, (Object)RELAY_CLOSED)) {
            this.doConnect();
        }
    }

    @Override
    public void webSocketError(@NotNull ColibriWebSocket ws, @NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)((Object)ws), (String)"ws");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.getLogger().error((Object)("Colibri websocket error: " + cause.getMessage()));
        CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.colibriWebSocketErrors, null, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.webSocketSyncRoot;
        synchronized (object) {
            boolean bl = false;
            if (this.webSocket != null) {
                ColibriWebSocket colibriWebSocket = this.webSocket;
                if (colibriWebSocket != null && (colibriWebSocket = colibriWebSocket.getSession()) != null) {
                    colibriWebSocket.close(1001, RELAY_CLOSED);
                }
                this.webSocket = null;
                this.getLogger().debug(RelayMessageTransport::close$lambda$13$lambda$12);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void webSocketTextReceived(@NotNull ColibriWebSocket ws, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)((Object)ws), (String)"ws");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (!Intrinsics.areEqual((Object)((Object)ws), (Object)((Object)this.webSocket))) {
            this.getLogger().warn((Object)"Received text from an unknown web socket.");
            return;
        }
        CounterMetric.inc$default((CounterMetric)VideobridgeMetrics.colibriWebSocketMessagesReceived, null, (int)1, null);
        this.webSocketLastActive = true;
        this.onMessage((Object)ws, message);
    }

    public final void setDataChannel(@NotNull DataChannel dataChannel) {
        Intrinsics.checkNotNullParameter((Object)dataChannel, (String)"dataChannel");
        DataChannel prevDataChannel = (DataChannel)this.dataChannel.get();
        if (prevDataChannel == null) {
            this.dataChannel = new WeakReference<DataChannel>(dataChannel);
            dataChannel.onDataChannelEvents(() -> RelayMessageTransport.setDataChannel$lambda$14(this));
            if (dataChannel.isReady()) {
                this.notifyTransportChannelConnected();
            }
        } else {
            if (prevDataChannel == dataChannel) {
                throw new Error("Re-setting the same data channel");
            }
            throw new Error("Overwriting a previous data channel!");
        }
        dataChannel.onDataChannelMessage(this);
    }

    @Override
    @NotNull
    public JSONObject getDebugState() {
        JSONObject debugState = super.getDebugState();
        ((Map)debugState).put("numOutgoingMessagesDropped", this.numOutgoingMessagesDropped.get());
        JSONObject sentCounts = new JSONObject();
        sentCounts.putAll(this.sentMessagesCounts);
        ((Map)debugState).put("sent_counts", sentCounts);
        return debugState;
    }

    @Override
    @Nullable
    public BridgeChannelMessage endpointMessage(@NotNull EndpointMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Conference conference = this.relay.getConference();
        if (conference.isExpired()) {
            this.getLogger().warn((Object)"Unable to send EndpointMessage, conference is expired");
            return null;
        }
        if (message.isBroadcast()) {
            conference.sendMessageFromRelay(message, true, this.relay.getMeshId());
        } else {
            String to = message.getTo();
            Endpoint targetEndpoint = conference.getLocalEndpoint(to);
            if (targetEndpoint == null) {
                this.getLogger().warn((Object)("Unable to find endpoint to send EndpointMessage to: " + to));
                return null;
            }
            conference.sendMessage(message, CollectionsKt.listOf((Object)targetEndpoint), false);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public BridgeChannelMessage endpointStats(@NotNull EndpointStats message) {
        void $this$forEach$iv;
        EncodingsManager.EncodingsUpdateListener it;
        Object element$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Conference conference = this.relay.getConference();
        if (conference.isExpired()) {
            this.getLogger().warn((Object)"Unable to send EndpointStats, conference is null or expired");
            return null;
        }
        if (message.getFrom() == null) {
            this.getLogger().warn((Object)"Unable to send EndpointStats, missing from");
            return null;
        }
        String string = message.getFrom();
        Intrinsics.checkNotNull((Object)string);
        AbstractEndpoint from = conference.getEndpoint(string);
        if (from == null) {
            this.getLogger().warn((Object)("Unable to send EndpointStats, unknown endpoint " + message.getFrom()));
            return null;
        }
        List<Endpoint> list = conference.getLocalEndpoints();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getLocalEndpoints(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (Endpoint)element$iv$iv;
            boolean bl = false;
            if (!((Endpoint)it).wantsStatsFrom(from)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Endpoint it2 = (Endpoint)element$iv;
            boolean bl = false;
            it2.sendMessage(message);
        }
        List<Relay> list2 = conference.getRelays();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getRelays(...)");
        $this$filter$iv = list2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        Iterator bl = $this$filterTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (Relay)element$iv$iv;
            boolean bl2 = false;
            if (!(!Intrinsics.areEqual((Object)((Relay)it).getMeshId(), (Object)this.relay.getMeshId()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Relay it3 = (Relay)element$iv;
            boolean bl3 = false;
            it3.sendMessage(message);
        }
        return null;
    }

    @Override
    @Nullable
    public BridgeChannelMessage endpointConnectionStatus(@NotNull EndpointConnectionStatusMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Conference conference = this.relay.getConference();
        if (conference.isExpired()) {
            this.getLogger().warn((Object)"Unable to send EndpointConnectionStatusMessage, conference is expired");
            return null;
        }
        conference.sendMessageFromRelay(message, true, this.relay.getMeshId());
        return null;
    }

    private static final String serverHello$lambda$3(ServerHelloMessage $message, RelayMessageTransport this$0) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return "Received ServerHelloMessage with version " + $message.getVersion() + ", but this server is version " + this$0.relay.getConference().getVideobridge().getVersion();
    }

    private static final String serverHello$lambda$4(ServerHelloMessage $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        return "Received ServerHelloMessage, version " + $message.getVersion();
    }

    private static final AtomicLong sendMessage$lambda$7(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new AtomicLong();
    }

    private static final AtomicLong sendMessage$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (AtomicLong)$tmp0.invoke(p0);
    }

    private static final String webSocketClosed$lambda$11$lambda$10(int $statusCode, String $reason) {
        Intrinsics.checkNotNullParameter((Object)$reason, (String)"$reason");
        return "Web socket closed, statusCode " + $statusCode + " ( " + $reason + ").";
    }

    private static final String close$lambda$13$lambda$12() {
        return "Relay expired, closed colibri web-socket.";
    }

    private static final void setDataChannel$lambda$14(RelayMessageTransport this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.notifyTransportChannelConnected();
    }

    static {
        WebSocketClient webSocketClient;
        Companion = new Companion(null);
        WebSocketClient $this$webSocketClient_u24lambda_u2419 = webSocketClient = new WebSocketClient();
        boolean bl = false;
        $this$webSocketClient_u24lambda_u2419.setIdleTimeout(WebsocketServiceConfig.config.getIdleTimeout());
        $this$webSocketClient_u24lambda_u2419.start();
        RelayMessageTransport.webSocketClient = webSocketClient;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jitsi/videobridge/relay/RelayMessageTransport$Companion;", "", "<init>", "()V", "webSocketClient", "Lorg/eclipse/jetty/websocket/client/WebSocketClient;", "getWebSocketClient", "()Lorg/eclipse/jetty/websocket/client/WebSocketClient;", "RELAY_CLOSED", "", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final WebSocketClient getWebSocketClient() {
            return webSocketClient;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

