/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.stats.VideobridgeStatisticsShim;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.videobridge.xmpp.config.XmppClientConnectionConfig;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;
import org.jivesoftware.smack.packet.ExtensionElement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\b\u0010\u001d\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/jitsi/videobridge/stats/MucPublisher;", "", "executor", "Ljava/util/concurrent/ScheduledExecutorService;", "interval", "Ljava/time/Duration;", "xmppConnection", "Lorg/jitsi/videobridge/xmpp/XmppConnection;", "<init>", "(Ljava/util/concurrent/ScheduledExecutorService;Ljava/time/Duration;Lorg/jitsi/videobridge/xmpp/XmppConnection;)V", "getExecutor", "()Ljava/util/concurrent/ScheduledExecutorService;", "getInterval", "()Ljava/time/Duration;", "getXmppConnection", "()Lorg/jitsi/videobridge/xmpp/XmppConnection;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "task", "Ljava/util/concurrent/ScheduledFuture;", "getTask", "()Ljava/util/concurrent/ScheduledFuture;", "setTask", "(Ljava/util/concurrent/ScheduledFuture;)V", "start", "", "stop", "publishPresence", "jitsi-videobridge"})
public final class MucPublisher {
    @NotNull
    private final ScheduledExecutorService executor;
    @NotNull
    private final Duration interval;
    @NotNull
    private final XmppConnection xmppConnection;
    @NotNull
    private final Logger logger;
    @Nullable
    private ScheduledFuture<?> task;

    public MucPublisher(@NotNull ScheduledExecutorService executor, @NotNull Duration interval2, @NotNull XmppConnection xmppConnection) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)interval2, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)xmppConnection, (String)"xmppConnection");
        this.executor = executor;
        this.interval = interval2;
        this.xmppConnection = xmppConnection;
        this.logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
    }

    @NotNull
    public final ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    @NotNull
    public final Duration getInterval() {
        return this.interval;
    }

    @NotNull
    public final XmppConnection getXmppConnection() {
        return this.xmppConnection;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final ScheduledFuture<?> getTask() {
        return this.task;
    }

    public final void setTask(@Nullable ScheduledFuture<?> scheduledFuture) {
        this.task = scheduledFuture;
    }

    public final void start() {
        this.logger.info((Object)("Starting with interval " + this.interval + "."));
        this.task = this.executor.scheduleAtFixedRate(() -> MucPublisher.start$lambda$0(this), 0L, this.interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public final void stop() {
        ScheduledFuture<?> scheduledFuture = this.task;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.task = null;
    }

    private final void publishPresence() {
        ColibriStatsExtension statsExt = XmppClientConnectionConfig.config.getStatsFilterEnabled() ? VideobridgeStatisticsShim.INSTANCE.getColibriStatsExtension(XmppClientConnectionConfig.config.getStatsWhitelist()) : VideobridgeStatisticsShim.INSTANCE.getColibriStatsExtension();
        this.logger.debug(() -> MucPublisher.publishPresence$lambda$1(statsExt));
        this.xmppConnection.setPresenceExtension((ExtensionElement)statsExt);
    }

    private static final void start$lambda$0(MucPublisher this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.publishPresence();
    }

    private static final String publishPresence$lambda$1(ColibriStatsExtension $statsExt) {
        Intrinsics.checkNotNullParameter((Object)$statsExt, (String)"$statsExt");
        return "Publishing statistics in presence: " + $statsExt;
    }
}

