/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.stats;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.metrics.InfoMetric;
import org.jitsi.nlj.rtcp.RembHandler;
import org.jitsi.videobridge.EndpointConnectionStatusMonitor;
import org.jitsi.videobridge.VersionConfig;
import org.jitsi.videobridge.health.JvbHealthChecker;
import org.jitsi.videobridge.load_management.JvbLoadManager;
import org.jitsi.videobridge.metrics.JvmMetrics;
import org.jitsi.videobridge.metrics.Metrics;
import org.jitsi.videobridge.metrics.VideobridgeMetrics;
import org.jitsi.videobridge.metrics.VideobridgePeriodicMetrics;
import org.jitsi.videobridge.relay.RelayConfig;
import org.jitsi.videobridge.transport.ice.IceTransport;
import org.jitsi.videobridge.version.JvbVersionService;
import org.jitsi.videobridge.xmpp.XmppConnection;
import org.jitsi.xmpp.extensions.colibri.ColibriStatsExtension;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u000eH\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/videobridge/stats/VideobridgeStatisticsShim;", "", "<init>", "()V", "getStatsJson", "Lorg/json/simple/JSONObject;", "getColibriStatsExtension", "Lorg/jitsi/xmpp/extensions/colibri/ColibriStatsExtension;", "whitelist", "", "", "timestampFormat", "Ljava/text/SimpleDateFormat;", "getStats", "", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nVideobridgeStatisticsShim.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideobridgeStatisticsShim.kt\norg/jitsi/videobridge/stats/VideobridgeStatisticsShim\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n215#2,2:238\n215#2,2:240\n1855#3,2:242\n*S KotlinDebug\n*F\n+ 1 VideobridgeStatisticsShim.kt\norg/jitsi/videobridge/stats/VideobridgeStatisticsShim\n*L\n92#1:238,2\n103#1:240,2\n116#1:242,2\n*E\n"})
public final class VideobridgeStatisticsShim {
    @NotNull
    public static final VideobridgeStatisticsShim INSTANCE;
    @NotNull
    private static final SimpleDateFormat timestampFormat;

    private VideobridgeStatisticsShim() {
    }

    @NotNull
    public final JSONObject getStatsJson() {
        JSONObject jSONObject;
        JSONObject $this$getStatsJson_u24lambda_u241 = jSONObject = new JSONObject();
        boolean bl = false;
        Map<String, Object> $this$forEach$iv = INSTANCE.getStats();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String k = entry.getKey();
            Object v = entry.getValue();
            ((Map)$this$getStatsJson_u24lambda_u241).put(k, v);
        }
        return jSONObject;
    }

    @NotNull
    public final ColibriStatsExtension getColibriStatsExtension() {
        ColibriStatsExtension colibriStatsExtension;
        ColibriStatsExtension $this$getColibriStatsExtension_u24lambda_u243 = colibriStatsExtension = new ColibriStatsExtension();
        boolean bl = false;
        Map<String, Object> $this$forEach$iv = INSTANCE.getStats();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> element$iv;
            Map.Entry<String, Object> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = entry.getKey();
            Object value = entry.getValue();
            $this$getColibriStatsExtension_u24lambda_u243.addStat(new ColibriStatsExtension.Stat(key, value));
        }
        return colibriStatsExtension;
    }

    @NotNull
    public final ColibriStatsExtension getColibriStatsExtension(@NotNull List<String> whitelist) {
        ColibriStatsExtension colibriStatsExtension;
        Intrinsics.checkNotNullParameter(whitelist, (String)"whitelist");
        ColibriStatsExtension $this$getColibriStatsExtension_u24lambda_u245 = colibriStatsExtension = new ColibriStatsExtension();
        boolean bl = false;
        Map<String, Object> allStats = INSTANCE.getStats();
        Iterable $this$forEach$iv = whitelist;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String whitelistedKey = (String)element$iv;
            boolean bl2 = false;
            Object value = allStats.get(whitelistedKey);
            if (value == null) continue;
            $this$getColibriStatsExtension_u24lambda_u245.addStat(new ColibriStatsExtension.Stat(whitelistedKey, value));
        }
        return colibriStatsExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Object> getStats() {
        Object object = Metrics.INSTANCE.getLock();
        synchronized (object) {
            String it;
            Map map;
            boolean bl = false;
            Map $this$getStats_u24lambda_u2411_u24lambda_u2410 = map = MapsKt.createMapBuilder();
            boolean bl2 = false;
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("incoming_loss", VideobridgePeriodicMetrics.INSTANCE.getIncomingLoss().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("outgoing_loss", VideobridgePeriodicMetrics.INSTANCE.getOutgoingLoss().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("overall_loss", VideobridgePeriodicMetrics.INSTANCE.getLoss().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("endpoints_with_high_outgoing_loss", VideobridgePeriodicMetrics.INSTANCE.getEndpointsWithHighOutgoingLoss().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("local_active_endpoints", VideobridgePeriodicMetrics.INSTANCE.getActiveEndpoints().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("bit_rate_download", VideobridgePeriodicMetrics.INSTANCE.getIncomingBitrate().get() / (long)1000);
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("bit_rate_upload", VideobridgePeriodicMetrics.INSTANCE.getOutgoingBitrate().get() / (long)1000);
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("packet_rate_download", VideobridgePeriodicMetrics.INSTANCE.getIncomingPacketRate().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("packet_rate_upload", VideobridgePeriodicMetrics.INSTANCE.getOutgoingPacketRate().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("rtt_aggregate", VideobridgePeriodicMetrics.INSTANCE.getAverageRtt().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("num_eps_oversending", VideobridgePeriodicMetrics.INSTANCE.getEndpointsOversending().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("octo_conferences", VideobridgePeriodicMetrics.INSTANCE.getConferencesWithRelay().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("inactive_conferences", VideobridgePeriodicMetrics.INSTANCE.getConferencesInactive().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("p2p_conferences", VideobridgePeriodicMetrics.INSTANCE.getConferencesP2p().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("endpoints", VideobridgePeriodicMetrics.INSTANCE.getEndpoints().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("participants", VideobridgePeriodicMetrics.INSTANCE.getEndpoints().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("receive_only_endpoints", VideobridgePeriodicMetrics.INSTANCE.getEndpointsReceiveOnly().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("inactive_endpoints", VideobridgePeriodicMetrics.INSTANCE.getEndpointsInactive().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("octo_endpoints", VideobridgePeriodicMetrics.INSTANCE.getEndpointsRelayed().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("endpoints_sending_audio", VideobridgePeriodicMetrics.INSTANCE.getEndpointsSendingAudio().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("endpoints_sending_video", VideobridgePeriodicMetrics.INSTANCE.getEndpointsSendingVideo().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("largest_conference", VideobridgePeriodicMetrics.INSTANCE.getLargestConference().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("octo_receive_bitrate", VideobridgePeriodicMetrics.INSTANCE.getRelayIncomingBitrate().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("octo_receive_packet_rate", VideobridgePeriodicMetrics.INSTANCE.getRelayIncomingPacketRate().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("octo_send_bitrate", VideobridgePeriodicMetrics.INSTANCE.getRelayOutgoingBitrate().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("octo_send_packet_rate", VideobridgePeriodicMetrics.INSTANCE.getRelayOutgoingPacketRate().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("endpoints_with_suspended_sources", VideobridgePeriodicMetrics.INSTANCE.getEndpointsWithSuspendedSources().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_conferences_created", VideobridgeMetrics.conferencesCreated.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_conferences_completed", VideobridgeMetrics.conferencesCompleted.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_conference_seconds", VideobridgeMetrics.totalConferenceSeconds.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_participants", VideobridgeMetrics.totalEndpoints.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_visitors", VideobridgeMetrics.totalVisitors.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("num_eps_no_msg_transport_after_delay", VideobridgeMetrics.numEndpointsNoMessageTransportAfterDelay.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_relays", VideobridgeMetrics.totalRelays.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("num_relays_no_msg_transport_after_delay", VideobridgeMetrics.numRelaysNoMessageTransportAfterDelay.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_keyframes_received", VideobridgeMetrics.keyframesReceived.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_layering_changes_received", VideobridgeMetrics.layeringChangesReceived.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_video_stream_milliseconds_received", VideobridgeMetrics.totalVideoStreamMillisecondsReceived.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("stress_level", VideobridgeMetrics.stressLevel.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("conferences", VideobridgeMetrics.currentConferences.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("visitors", VideobridgeMetrics.currentVisitors.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("local_endpoints", VideobridgeMetrics.currentLocalEndpoints.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_data_channel_messages_received", VideobridgeMetrics.dataChannelMessagesReceived.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_data_channel_messages_sent", VideobridgeMetrics.dataChannelMessagesSent.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_colibri_web_socket_messages_received", VideobridgeMetrics.colibriWebSocketMessagesReceived.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_colibri_web_socket_messages_sent", VideobridgeMetrics.colibriWebSocketMessagesSent.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_bytes_received", VideobridgeMetrics.totalBytesReceived.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("dtls_failed_endpoints", VideobridgeMetrics.endpointsDtlsFailed.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_bytes_sent", VideobridgeMetrics.totalBytesSent.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_packets_received", VideobridgeMetrics.packetsReceived.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_packets_sent", VideobridgeMetrics.packetsSent.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_bytes_received_octo", VideobridgeMetrics.totalRelayBytesReceived.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_bytes_sent_octo", VideobridgeMetrics.totalRelayBytesSent.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_packets_received_octo", VideobridgeMetrics.relayPacketsReceived.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_packets_sent_octo", VideobridgeMetrics.relayPacketsSent.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_dominant_speaker_changes", VideobridgeMetrics.dominantSpeakerChanges.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("preemptive_kfr_sent", VideobridgeMetrics.preemptiveKeyframeRequestsSent.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("preemptive_kfr_suppressed", VideobridgeMetrics.preemptiveKeyframeRequestsSuppressed.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_ice_failed", IceTransport.Companion.getIceFailed().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_ice_succeeded", IceTransport.Companion.getIceSucceeded().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("total_ice_succeeded_relayed", IceTransport.Companion.getIceSucceededRelayed().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("average_participant_stress", JvbLoadManager.Companion.getAverageParticipantStress());
            JvmMetrics jvmMetrics = JvmMetrics.Companion.getINSTANCE();
            if (jvmMetrics != null && (jvmMetrics = jvmMetrics.getThreadCount()) != null) {
                JvmMetrics it2 = jvmMetrics;
                boolean bl3 = false;
                $this$getStats_u24lambda_u2411_u24lambda_u2410.put("threads", it2.get());
            }
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("graceful_shutdown", VideobridgeMetrics.INSTANCE.getGracefulShutdown().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("shutting_down", VideobridgeMetrics.INSTANCE.getShuttingDown().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("drain", VideobridgeMetrics.INSTANCE.getDrainMode().get());
            String string = timestampFormat.format(new Date());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("current_timestamp", string);
            if (RelayConfig.config.getEnabled()) {
                $this$getStats_u24lambda_u2411_u24lambda_u2410.put("relay_id", RelayConfig.config.getRelayId());
            }
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("muc_clients_configured", XmppConnection.Companion.getMucClientsConfigured().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("muc_clients_connected", XmppConnection.Companion.getMucClientsConnected().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("mucs_configured", XmppConnection.Companion.getMucsConfigured().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("mucs_joined", XmppConnection.Companion.getMucsJoined().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("endpoints_with_spurious_remb", RembHandler.Companion.endpointsWithSpuriousRemb());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("healthy", JvbHealthChecker.Companion.getHealthyMetric().get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("endpoints_disconnected", EndpointConnectionStatusMonitor.endpointsDisconnected.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("endpoints_reconnected", EndpointConnectionStatusMonitor.endpointsReconnected.get());
            $this$getStats_u24lambda_u2411_u24lambda_u2410.put("version", JvbVersionService.Companion.getInstance().getCurrentVersion().toString());
            String string2 = VersionConfig.config.getRelease();
            if (string2 != null) {
                it = string2;
                boolean bl4 = false;
                $this$getStats_u24lambda_u2411_u24lambda_u2410.put("release", it);
            }
            InfoMetric infoMetric = VideobridgeMetrics.INSTANCE.getRegionInfo();
            if (infoMetric != null) {
                it = infoMetric;
                boolean bl5 = false;
                $this$getStats_u24lambda_u2411_u24lambda_u2410.put("region", it.get());
            }
            Map map2 = MapsKt.build((Map)map);
            return map2;
        }
    }

    static {
        SimpleDateFormat simpleDateFormat;
        INSTANCE = new VideobridgeStatisticsShim();
        SimpleDateFormat $this$timestampFormat_u24lambda_u246 = simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        boolean bl = false;
        $this$timestampFormat_u24lambda_u246.setTimeZone(TimeZone.getTimeZone("UTC"));
        timestampFormat = simpleDateFormat;
    }
}

