/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.transport.ice;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.DoubleAdder;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.stats.BucketStats;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceStatistics;", "", "<init>", "()V", "combinedStats", "Lorg/jitsi/videobridge/transport/ice/IceStatistics$Stats;", "statsByHarvesterName", "Ljava/util/concurrent/ConcurrentHashMap;", "", "add", "", "harvesterName", "rttMs", "", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "Companion", "Stats", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nIceStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IceStatistics.kt\norg/jitsi/videobridge/transport/ice/IceStatistics\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,69:1\n215#2,2:70\n*S KotlinDebug\n*F\n+ 1 IceStatistics.kt\norg/jitsi/videobridge/transport/ice/IceStatistics\n*L\n42#1:70,2\n*E\n"})
public final class IceStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Stats combinedStats = new Stats();
    @NotNull
    private final ConcurrentHashMap<String, Stats> statsByHarvesterName = new ConcurrentHashMap();
    @NotNull
    private static final IceStatistics stats = new IceStatistics();

    public final void add(@NotNull String harvesterName, double rttMs) {
        Intrinsics.checkNotNullParameter((Object)harvesterName, (String)"harvesterName");
        this.combinedStats.add(rttMs);
        this.statsByHarvesterName.computeIfAbsent(harvesterName, arg_0 -> IceStatistics.add$lambda$1(IceStatistics::add$lambda$0, arg_0)).add(rttMs);
    }

    @NotNull
    public final OrderedJsonObject toJson() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$toJson_u24lambda_u243 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u243.put((Object)"all", (Object)this.combinedStats.toJson());
        Map $this$forEach$iv = this.statsByHarvesterName;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            String harvesterName = (String)entry.getKey();
            Stats stats = (Stats)entry.getValue();
            $this$toJson_u24lambda_u243.put((Object)harvesterName, (Object)stats.toJson());
        }
        return orderedJsonObject;
    }

    private static final Stats add$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Stats();
    }

    private static final Stats add$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Stats)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceStatistics$Companion;", "", "<init>", "()V", "stats", "Lorg/jitsi/videobridge/transport/ice/IceStatistics;", "getStats", "()Lorg/jitsi/videobridge/transport/ice/IceStatistics;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IceStatistics getStats() {
            return stats;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lorg/jitsi/videobridge/transport/ice/IceStatistics$Stats;", "", "<init>", "()V", "buckets", "Lorg/jitsi/utils/stats/BucketStats;", "getBuckets", "()Lorg/jitsi/utils/stats/BucketStats;", "sum", "Ljava/util/concurrent/atomic/DoubleAdder;", "getSum", "()Ljava/util/concurrent/atomic/DoubleAdder;", "setSum", "(Ljava/util/concurrent/atomic/DoubleAdder;)V", "count", "Ljava/util/concurrent/atomic/AtomicInteger;", "getCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setCount", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "add", "", "rttMs", "", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "jitsi-videobridge"})
    private static final class Stats {
        @NotNull
        private final BucketStats buckets;
        @NotNull
        private DoubleAdder sum;
        @NotNull
        private AtomicInteger count;

        public Stats() {
            Object[] objectArray = new Long[]{0L, 10L, 20L, 40L, 60L, 80L, 100L, 150L, 200L, 250L, 300L, 500L, 1000L, Long.MAX_VALUE};
            this.buckets = new BucketStats(CollectionsKt.listOf((Object[])objectArray), null, null, 6, null);
            this.sum = new DoubleAdder();
            this.count = new AtomicInteger();
        }

        @NotNull
        public final BucketStats getBuckets() {
            return this.buckets;
        }

        @NotNull
        public final DoubleAdder getSum() {
            return this.sum;
        }

        public final void setSum(@NotNull DoubleAdder doubleAdder) {
            Intrinsics.checkNotNullParameter((Object)doubleAdder, (String)"<set-?>");
            this.sum = doubleAdder;
        }

        @NotNull
        public final AtomicInteger getCount() {
            return this.count;
        }

        public final void setCount(@NotNull AtomicInteger atomicInteger) {
            Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
            this.count = atomicInteger;
        }

        public final void add(double rttMs) {
            this.sum.add(rttMs);
            this.count.incrementAndGet();
            this.buckets.addValue((long)(rttMs + 0.5));
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u240.put((Object)"average", (Object)(this.sum.sum() / this.count.doubleValue()));
            $this$toJson_u24lambda_u240.put((Object)"buckets", (Object)BucketStats.toJson$default((BucketStats)this.buckets, null, (int)1, null));
            return orderedJsonObject;
        }
    }
}

