/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.xmpp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.VideoType;
import org.jitsi.nlj.rtp.SsrcAssociationType;
import org.jitsi.nlj.rtp.codec.vpx.VpxRtpLayerDesc;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.colibri.SourcePacketExtension;
import org.jitsi.xmpp.extensions.jingle.SourceGroupPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.SSRCInfoPacketExtension;
import org.jitsi.xmpp.util.XmlStringBuilderUtil;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.util.XmppStringUtils;

public class MediaSourceFactory {
    private static final Logger logger = new LoggerImpl(MediaSourceFactory.class.getName());
    private static final int VP8_SIMULCAST_BASE_LAYER_HEIGHT = 180;
    private static Map<String, SsrcAssociationType> secondarySsrcTypeMap = null;
    private static final VpxRtpLayerDesc[] noDependencies = new VpxRtpLayerDesc[0];

    private static synchronized Map<String, SsrcAssociationType> getSecondarySsrcTypeMap() {
        if (secondarySsrcTypeMap == null) {
            secondarySsrcTypeMap = new HashMap<String, SsrcAssociationType>();
            secondarySsrcTypeMap.put("FID", SsrcAssociationType.RTX);
        }
        return secondarySsrcTypeMap;
    }

    private static RtpLayerDesc[] createRTPLayerDescs(int spatialLen, int temporalLen, int encodingIdx, int height) {
        VpxRtpLayerDesc[] rtpLayers = new VpxRtpLayerDesc[spatialLen * temporalLen];
        for (int spatialIdx = 0; spatialIdx < spatialLen; ++spatialIdx) {
            double frameRate = 30.0 / (double)(1 << temporalLen - 1);
            for (int temporalIdx = 0; temporalIdx < temporalLen; ++temporalIdx) {
                int idx = MediaSourceFactory.idx(spatialIdx, temporalIdx, temporalLen);
                VpxRtpLayerDesc[] dependencies = spatialIdx > 0 && temporalIdx > 0 ? new VpxRtpLayerDesc[]{rtpLayers[MediaSourceFactory.idx(spatialIdx, temporalIdx - 1, temporalLen)], rtpLayers[MediaSourceFactory.idx(spatialIdx - 1, temporalIdx, temporalLen)]} : (spatialIdx > 0 ? new VpxRtpLayerDesc[]{rtpLayers[MediaSourceFactory.idx(spatialIdx - 1, temporalIdx, temporalLen)]} : (temporalIdx > 0 ? new VpxRtpLayerDesc[]{rtpLayers[MediaSourceFactory.idx(spatialIdx, temporalIdx - 1, temporalLen)]} : noDependencies));
                int temporalId = temporalLen > 1 ? temporalIdx : -1;
                int spatialId = spatialLen > 1 ? spatialIdx : -1;
                rtpLayers[idx] = new VpxRtpLayerDesc(encodingIdx, temporalId, spatialId, height, frameRate, dependencies);
                frameRate *= 2.0;
            }
        }
        return rtpLayers;
    }

    private static RtpEncodingDesc createRtpEncodingDesc(Long primarySsrc, int spatialLen, int temporalLen, SecondarySsrcs secondarySsrcs, int encodingIdx, int height) {
        RtpLayerDesc[] layers = MediaSourceFactory.createRTPLayerDescs(spatialLen, temporalLen, encodingIdx, height);
        RtpEncodingDesc enc = new RtpEncodingDesc(primarySsrc.longValue(), layers, encodingIdx);
        if (secondarySsrcs != null) {
            secondarySsrcs.forEach(ssrcSecondarySsrc -> {
                SsrcAssociationType type = MediaSourceFactory.getSecondarySsrcTypeMap().get(ssrcSecondarySsrc.type);
                if (type == null) {
                    logger.error((Object)("Unable to find a mapping for secondary ssrc type " + ssrcSecondarySsrc.type + " will NOT included this secondary ssrc as an encoding"));
                } else {
                    enc.addSecondarySsrc(ssrcSecondarySsrc.ssrc, type);
                }
            });
        }
        return enc;
    }

    private static List<SecondarySsrc> getSecondarySsrcs(long ssrc, Collection<SourceGroupPacketExtension> sourceGroups) {
        ArrayList<SecondarySsrc> secondarySsrcs = new ArrayList<SecondarySsrc>();
        for (SourceGroupPacketExtension sourceGroup : sourceGroups) {
            if (sourceGroup.getSemantics().equalsIgnoreCase("SIM")) continue;
            long groupPrimarySsrc = ((SourcePacketExtension)sourceGroup.getSources().get(0)).getSSRC();
            long groupSecondarySsrc = ((SourcePacketExtension)sourceGroup.getSources().get(1)).getSSRC();
            if (groupPrimarySsrc != ssrc) continue;
            secondarySsrcs.add(new SecondarySsrc(groupSecondarySsrc, sourceGroup.getSemantics()));
        }
        return secondarySsrcs;
    }

    private static Map<Long, SecondarySsrcs> getAllSecondarySsrcs(SourceSsrcs ssrcs, Collection<SourceGroupPacketExtension> sourceGroups) {
        HashMap<Long, SecondarySsrcs> allSecondarySsrcs = new HashMap<Long, SecondarySsrcs>();
        for (long ssrc : ssrcs) {
            List<SecondarySsrc> secondarySsrcs = MediaSourceFactory.getSecondarySsrcs(ssrc, sourceGroups);
            allSecondarySsrcs.put(ssrc, new SecondarySsrcs(secondarySsrcs));
        }
        return allSecondarySsrcs;
    }

    private static List<SourceGroupPacketExtension> getGroups(String semantics, List<SourceGroupPacketExtension> groups) {
        return groups.stream().filter(sg -> sg.getSemantics().equalsIgnoreCase(semantics)).collect(Collectors.toList());
    }

    private static void removeReferences(SourceSsrcs sourceSsrcs, List<SourcePacketExtension> sources, List<SourceGroupPacketExtension> sourceGroups) {
        List<SourceGroupPacketExtension> groupsToRemove = sourceGroups.stream().filter(group -> group.getSources().stream().anyMatch(source -> sourceSsrcs.contains(source.getSSRC()))).collect(Collectors.toList());
        sourceGroups.removeAll(groupsToRemove);
        Set<Long> ssrcsToRemove = MediaSourceFactory.extractSsrcs(groupsToRemove);
        sources.removeIf(source -> sourceSsrcs.contains(source.getSSRC()) || ssrcsToRemove.contains(source.getSSRC()));
    }

    private static Set<Long> extractSsrcs(List<SourceGroupPacketExtension> groups) {
        HashSet<Long> ssrcs = new HashSet<Long>();
        groups.forEach(group -> group.getSources().forEach(source -> ssrcs.add(source.getSSRC())));
        return ssrcs;
    }

    private static List<SourceSsrcs> getSourceSsrcs(Collection<SourcePacketExtension> sources, Collection<SourceGroupPacketExtension> sourceGroups) {
        ArrayList<SourceSsrcs> sourceSsrcsList = new ArrayList<SourceSsrcs>();
        ArrayList<SourcePacketExtension> sourcesCopy = new ArrayList<SourcePacketExtension>(sources);
        ArrayList<SourceGroupPacketExtension> sourceGroupsCopy = new ArrayList<SourceGroupPacketExtension>(sourceGroups);
        Arrays.asList("SIM", "FID", "FEC-FR").forEach(groupSem -> {
            List<SourceGroupPacketExtension> groups = MediaSourceFactory.getGroups(groupSem, sourceGroupsCopy);
            groups.forEach(group -> {
                if (group.getSources() == null || group.getSources().isEmpty()) {
                    if (groups.size() > 1) {
                        logger.warn((Object)"Received empty group, which is a signal to clear all groups, but there were other groups present, which shouldn't happen");
                    }
                    return;
                }
                List<Long> ssrcs = groupSem.equalsIgnoreCase("SIM") ? group.getSources().stream().map(SourcePacketExtension::getSSRC).collect(Collectors.toList()) : Arrays.asList(((SourcePacketExtension)group.getSources().get(0)).getSSRC());
                SourceSsrcs sourceSsrcs = new SourceSsrcs(ssrcs);
                MediaSourceFactory.removeReferences(sourceSsrcs, sourcesCopy, sourceGroupsCopy);
                sourceSsrcsList.add(sourceSsrcs);
            });
        });
        if (!sourceGroupsCopy.isEmpty()) {
            logger.warn((Object)("Unprocessed source groups: " + sourceGroupsCopy.stream().map(XmlStringBuilderUtil::toStringOpt).reduce(String::concat)));
        }
        sourcesCopy.forEach(source -> {
            if (source.getSSRC() != -1L) {
                sourceSsrcsList.add(new SourceSsrcs(source.getSSRC()));
            } else if (sourcesCopy.size() > 1) {
                logger.warn((Object)"Received an empty source, which is a signal to clear all sources, but there were other sources present, which shouldn't happen");
            }
        });
        MediaSourceFactory.setOwnersAndNames(sources, sourceSsrcsList);
        return sourceSsrcsList;
    }

    private static void setOwnersAndNames(Collection<SourcePacketExtension> sources, Collection<SourceSsrcs> sourceSsrcsList) {
        for (SourceSsrcs sourceSsrcs : sourceSsrcsList) {
            long primarySsrc = sourceSsrcs.get(0);
            SourcePacketExtension sourceSource = sources.stream().filter(source -> source.getSSRC() == primarySsrc).findAny().orElse(null);
            sourceSsrcs.owner = MediaSourceFactory.getOwner(sourceSource);
            sourceSsrcs.name = sourceSource != null ? sourceSource.getName() : null;
        }
    }

    public static String getOwner(SourcePacketExtension source) {
        String ownerAttr;
        SSRCInfoPacketExtension ssrcInfoPacketExtension;
        SSRCInfoPacketExtension sSRCInfoPacketExtension = ssrcInfoPacketExtension = source == null ? null : (SSRCInfoPacketExtension)source.getFirstChildOfType(SSRCInfoPacketExtension.class);
        if (ssrcInfoPacketExtension != null && (ownerAttr = ssrcInfoPacketExtension.getAttributeAsString("owner")) != null) {
            return MediaSourceFactory.getResourceFromJid(ownerAttr);
        }
        return null;
    }

    private static String getResourceFromJid(String jid) {
        String unpreppedResource = XmppStringUtils.parseResource((String)jid);
        if (unpreppedResource.isEmpty()) {
            return Resourcepart.EMPTY.toString();
        }
        return Resourcepart.fromOrThrowUnchecked((CharSequence)unpreppedResource).toString();
    }

    @Deprecated
    public static MediaSourceDesc[] createMediaSources(Collection<SourcePacketExtension> sources, Collection<SourceGroupPacketExtension> sourceGroups) {
        ArrayList<SourceGroupPacketExtension> finalSourceGroups = sourceGroups == null ? new ArrayList<SourceGroupPacketExtension>() : sourceGroups;
        ArrayList<SourcePacketExtension> finalSources = sources == null ? new ArrayList<SourcePacketExtension>() : sources;
        List<SourceSsrcs> sourceSsrcsList = MediaSourceFactory.getSourceSsrcs(finalSources, finalSourceGroups);
        ArrayList mediaSources = new ArrayList();
        sourceSsrcsList.forEach(sourceSsrcs -> {
            int numSpatialLayersPerStream = 1;
            int numTemporalLayersPerStream = 3;
            Map<Long, SecondarySsrcs> secondarySsrcs = MediaSourceFactory.getAllSecondarySsrcs(sourceSsrcs, finalSourceGroups);
            MediaSourceDesc mediaSource = MediaSourceFactory.createSource(sourceSsrcs, numSpatialLayersPerStream, 3, secondarySsrcs, sourceSsrcs.owner, sourceSsrcs.name, MediaSourceFactory.getVideoType(finalSources));
            mediaSources.add(mediaSource);
        });
        return mediaSources.toArray(new MediaSourceDesc[0]);
    }

    public static MediaSourceDesc createMediaSource(Collection<SourcePacketExtension> sources, Collection<SourceGroupPacketExtension> sourceGroups, String owner, String name) {
        ArrayList<SourceGroupPacketExtension> finalSourceGroups;
        Objects.requireNonNull(owner, "owner is required");
        Objects.requireNonNull(name, "name is required");
        ArrayList<SourceGroupPacketExtension> arrayList = finalSourceGroups = sourceGroups == null ? new ArrayList<SourceGroupPacketExtension>() : sourceGroups;
        if (sources == null) {
            return null;
        }
        List<SourceSsrcs> sourceSsrcsList = MediaSourceFactory.getSourceSsrcs(sources, finalSourceGroups);
        if (sourceSsrcsList.size() != 1) {
            logger.warn((Object)("sourceSsrcsList.size() != 1 for: " + sources + " groups: " + finalSourceGroups));
        }
        if (sourceSsrcsList.size() > 0) {
            SourceSsrcs sourceSsrcs = sourceSsrcsList.get(0);
            int numSpatialLayersPerStream = 1;
            int numTemporalLayersPerStream = 3;
            Map<Long, SecondarySsrcs> secondarySsrcs = MediaSourceFactory.getAllSecondarySsrcs(sourceSsrcs, finalSourceGroups);
            return MediaSourceFactory.createSource(sourceSsrcs, numSpatialLayersPerStream, 3, secondarySsrcs, owner, name, MediaSourceFactory.getVideoType(sources));
        }
        return null;
    }

    private static int idx(int spatialIdx, int temporalIdx, int temporalLen) {
        return spatialIdx * temporalLen + temporalIdx;
    }

    private static MediaSourceDesc createSource(SourceSsrcs primarySsrcs, int numSpatialLayersPerStream, int numTemporalLayersPerStream, Map<Long, SecondarySsrcs> allSecondarySsrcs, String owner, String name, VideoType videoType) {
        RtpEncodingDesc[] encodings = new RtpEncodingDesc[primarySsrcs.size()];
        int height = 180;
        for (int encodingIdx = 0; encodingIdx < primarySsrcs.size(); ++encodingIdx) {
            Long primarySsrc = primarySsrcs.get(encodingIdx);
            SecondarySsrcs ssrcSecondarySsrcs = allSecondarySsrcs.get(primarySsrc);
            encodings[encodingIdx] = MediaSourceFactory.createRtpEncodingDesc(primarySsrc, numSpatialLayersPerStream, numTemporalLayersPerStream, ssrcSecondarySsrcs, encodingIdx, height);
            height *= 2;
        }
        if (name == null) {
            throw new IllegalArgumentException("The 'name' is missing in the source description");
        }
        if (owner == null) {
            throw new IllegalArgumentException("The 'owner' is missing in the source description");
        }
        return new MediaSourceDesc(encodings, owner, name, videoType);
    }

    private static VideoType getVideoType(@NotNull Collection<SourcePacketExtension> sources) {
        for (SourcePacketExtension source : sources) {
            if (source.getVideoType() == null) continue;
            return VideoType.valueOf((String)source.getVideoType().toUpperCase());
        }
        return VideoType.CAMERA;
    }

    private static class SourceSsrcs
    implements Iterable<Long> {
        private String name;
        private List<Long> sourceSsrcs;
        private String owner;

        private SourceSsrcs(Long ssrc) {
            this(Collections.singletonList(ssrc));
        }

        public SourceSsrcs(List<Long> sourceSsrcs) {
            this.sourceSsrcs = sourceSsrcs;
        }

        public boolean contains(Long ssrc) {
            return this.sourceSsrcs.contains(ssrc);
        }

        public int size() {
            return this.sourceSsrcs.size();
        }

        public Long get(int index) {
            return this.sourceSsrcs.get(index);
        }

        @Override
        public Iterator<Long> iterator() {
            return this.sourceSsrcs.iterator();
        }
    }

    private static class SecondarySsrcs
    implements Iterable<SecondarySsrc> {
        public List<SecondarySsrc> secondarySsrcs;

        public SecondarySsrcs(List<SecondarySsrc> secondarySsrcs) {
            this.secondarySsrcs = secondarySsrcs;
        }

        @Override
        public Iterator<SecondarySsrc> iterator() {
            return this.secondarySsrcs.iterator();
        }
    }

    private static class SecondarySsrc {
        public long ssrc;
        public String type;

        public SecondarySsrc(long ssrc, String type) {
            this.ssrc = ssrc;
            this.type = type;
        }
    }
}

