/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.bytearray.ByteArrayExtensionsKt;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.PrimaryBlockHeader;
import org.jitsi.rtp.rtp.RedundancyBlockHeader;
import org.jitsi.rtp.util.FieldParsersKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/rtp/rtp/BlockHeader;", "", "pt", "", "<init>", "(B)V", "getPt", "()B", "headerLength", "", "getHeaderLength", "()I", "write", "buffer", "", "offset", "Companion", "Lorg/jitsi/rtp/rtp/PrimaryBlockHeader;", "Lorg/jitsi/rtp/rtp/RedundancyBlockHeader;", "rtp"})
public abstract class BlockHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final byte pt;

    private BlockHeader(byte pt) {
        this.pt = pt;
    }

    public final byte getPt() {
        return this.pt;
    }

    public abstract int getHeaderLength();

    public abstract int write(@NotNull byte[] var1, int var2);

    public /* synthetic */ BlockHeader(byte pt, DefaultConstructorMarker $constructor_marker) {
        this(pt);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lorg/jitsi/rtp/rtp/BlockHeader$Companion;", "", "<init>", "()V", "parse", "Lorg/jitsi/rtp/rtp/BlockHeader;", "buffer", "", "offset", "", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BlockHeader parse(@NotNull byte[] buffer, int offset) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            boolean follow = ByteArrayExtensionsKt.getBitAsBool(buffer, offset, 0);
            byte pt = (byte)FieldParsersKt.getBitsAsInt(buffer, offset, 1, 7);
            if (!follow) {
                return new PrimaryBlockHeader(pt);
            }
            int timestampOffset = (UnsignedKt.toPositiveInt(buffer[offset + 1]) << 6) + FieldParsersKt.getBitsAsInt(buffer, offset + 2, 0, 6);
            int blockLength = (FieldParsersKt.getBitsAsInt(buffer, offset + 2, 6, 2) << 8) + UnsignedKt.toPositiveInt(buffer[offset + 3]);
            return new RedundancyBlockHeader(pt, timestampOffset, blockLength);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

