/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.rtp.BlockHeader;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jitsi/rtp/rtp/RedundancyBlockHeader;", "Lorg/jitsi/rtp/rtp/BlockHeader;", "pt", "", "timestampOffset", "", "length", "<init>", "(BII)V", "getTimestampOffset", "()I", "getLength", "headerLength", "getHeaderLength", "write", "buffer", "", "offset", "Companion", "rtp"})
@SourceDebugExtension(value={"SMAP\nRedPacketParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedPacketParser.kt\norg/jitsi/rtp/rtp/RedundancyBlockHeader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,295:1\n1#2:296\n*E\n"})
public final class RedundancyBlockHeader
extends BlockHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int timestampOffset;
    private final int length;
    private final int headerLength;
    public static final int MAX_TIMESTAMP_OFFSET = 16383;

    public RedundancyBlockHeader(byte pt, int timestampOffset, int length) {
        super(pt, null);
        this.timestampOffset = timestampOffset;
        this.length = length;
        if (!(this.timestampOffset <= 16383)) {
            boolean bl = false;
            String string = "Invalid timestampOffset: " + this.timestampOffset;
            throw new IllegalArgumentException(string.toString());
        }
        this.headerLength = 4;
    }

    public final int getTimestampOffset() {
        return this.timestampOffset;
    }

    public final int getLength() {
        return this.length;
    }

    @Override
    public int getHeaderLength() {
        return this.headerLength;
    }

    @Override
    public int write(@NotNull byte[] buffer, int offset) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer[offset] = (byte)(this.getPt() | 0xFFFFFF80);
        buffer[offset + 1] = (byte)(this.timestampOffset >> 6);
        buffer[offset + 2] = (byte)((byte)((this.timestampOffset & 0x3F) << 2) | (byte)((byte)(this.length >> 8) & 3));
        buffer[offset + 3] = (byte)(this.length & 0xFF);
        return 4;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/rtp/rtp/RedundancyBlockHeader$Companion;", "", "<init>", "()V", "MAX_TIMESTAMP_OFFSET", "", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

